#include "colors.inc"
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

background { colour White }

camera {
	location <0, 12, -9.0>
	look_at <0, 3.5, 0>
}

#declare Ball = union {
	cylinder { <0, 0, 0>, <0, 1, 0>, 10 }
	torus { 9, 1
		translate y*1
	}
	difference {
		cylinder { <0, 1, 0>, <0, 3.5, 0>, 9 }
		torus { 9, 0.5
			scale <1, 0.5, 1>
			translate y*2.25
		}
	}
	torus { 9, 0.5
		translate y*3
	}
	difference {
		sphere { <0, 8.5, 0>, sqrt( 106 ) }
		sphere { <0, 8.5, 0>, sqrt( 106 ) - 0.25 }
		plane { y, 3.5 }
		texture { T_Glass3 }
		interior { I_Glass }
	}
	texture { pigment { P_WoodGrain4A colour_map { M_Wood16A } } }
	texture { pigment { P_WoodGrain4B colour_map { M_Wood16B } } }
}

#declare C_Holder = union {
	// built from bottom up
	cylinder { <0, 0, 0>, <0, 0.2, 0>, 7.2 }
	torus { 7.0, 0.2
		scale <1, 0.5, 1>
		translate <0, 0.2, 0>
	}
	cone { <0, 0.3, 0>, 7.0, <0, 1.0, 0>, 3.5 }
	difference {
		cylinder { <0, 1.0, 0>, <0, 6.0, 0>, 3.0 }
		cylinder { <0, 1.0, 0>, <0, 6.1, 0>, 2.5 }
	}
	torus { 2.9, 0.1
		translate <0, 6, 0>
	}
	torus { 2.6, 0.1
		translate <0, 6, 0>
	}
	difference {
		cylinder { <0, 6.0, 0>, <0, 6.1, 0>, 2.9 }
		cylinder { <0, 5.9, 0>, <0, 6.2, 0>, 2.6 }
	}
	texture { T_Brass_3B }
}

#declare C_Holder = union {
	// built from bottom up
	cylinder { <0, 0, 0>, <0, 0.2, 0>, 7.2 }
	torus { 7.0, 0.2
		scale <1, 0.5, 1>
		translate <0, 0.2, 0>
	}
	cone { <0, 0.3, 0>, 7.0, <0, 1.0, 0>, 3.5 }
	difference {
		cylinder { <0, 1.0, 0>, <0, 6.0, 0>, 3.0 }
		cylinder { <0, 1.0, 0>, <0, 6.1, 0>, 2.5 }
	}
	torus { 2.9, 0.1
		translate <0, 6, 0>
	}
	torus { 2.6, 0.1
		translate <0, 6, 0>
	}
	difference {
		cylinder { <0, 6.0, 0>, <0, 6.1, 0>, 2.9 }
		cylinder { <0, 5.9, 0>, <0, 6.2, 0>, 2.6 }
	}
	texture { T_Brass_3B }
}

#declare Candle = union {
	// candle body
	difference {
		cylinder { <0, 0, 0>, <0, 25, 0>, 2.5 }
		sphere { <0, 0, 0>, 2.4
			scale <1.0, 0.5, 1.0>
			translate <0, 25, 0>
		}
	}
	intersection {
		torus { 2.5, 0.1
			translate <0, 25, 0>
		}
		cylinder { <0, 24.99, 0>, <0, 25.11, 0>, 2.5 }
	}
	// wax drips
	blob {
		threshold 0.5
		cylinder { <0, 16, 0>, <0, 24.8, 0>, 0.75, 1
			scale <0.5, 1, 1>
			translate x*2.48
		}
		sphere { <2.48, 15.8, 0>, 0.65, 0.3 }
		rotate y*30
	}
	blob {
		threshold 0.5
		cylinder { <0, 19, 0>, <0, 24.8, 0>, 0.75, 1
			scale <0.5, 1, 1>
			translate x*2.48
		}
		sphere { <2.48, 18.8, 0>, 1, 0.3
			pigment { colour rgbf <1.0, 1.0, 0.9, 0.7> }
			finish { Shiny ambient 1.0 }
		}
		rotate y*180
	}
	blob {
		threshold 0.5
		cylinder { <0, 21, 0>, <0, 24.8, 0>, 0.75, 1
			scale <0.5, 1, 1>
			translate x*2.48
		}
		sphere { <2.48, 20.8, 0>, 0.65, 0.3 }
		rotate y*85
	}
	// wick
	cylinder { <0, 24, 0>, <0, 26, 0>, 0.2
		pigment { colour rgb <0.2, 0.2, 0.2> }
	}
	// candle texture
	pigment { colour rgb <1.0, 1.0, 0.9> }
	normal {
		spotted -0.05
		turbulence 0.5
		scale <0.2, 1, 0.2>
	}
	finish { Dull ambient 0.4 }
}

// candle flame macro, use with same scaling and translation as a Candle object
#macro C_Flame ( scaling, translation )
	#ifndef ( CFRand )
		#local CFRand = seed (39857);
	#end
	merge {
		sphere { <0, 27.0, 0>, 2.0 }
		difference {
			sphere { <0, 0, 0>, 2.0 
				scale <1, 2, 1>
				translate <0, 27.0, 0>
			}
			plane { y, 27.0 }
		}
		hollow
		pigment { rgbt <1, 1, 1, 1> }
		interior {
			media {
				emission 1
				intervals 50
				density {
					spherical
					turbulence 0.2
					colour_map {
						[0.00 Clear ]
						[0.10 Clear ]
						[0.30 Orange*0.5/scaling ]
						[0.50 Orange*0.8/scaling ]
						[0.80 Orange/scaling ]
						[0.90 Orange*1.5/scaling ]
						[1.00 Yellow/scaling ]
					}
					scale <2.0, 4, 2.0>
					translate <0, 26.5, 0> + <4, 0, 0> * int(rand(CFRand))*100
				}
			}
		}
		scale scaling
		translate translation
	}
#end

// non-media flame object for when media breaks down (too small)
// Blood_Stained texture
#declare Blood_Stained = texture {
   pigment {
      bozo
      turbulence 1.5
      colour_map {
         [ 0.00 colour rgbt <0.28, 0.07, 0.10, 0.05> ]
         [ 0.05 colour rgbt <0.40, 0.10, 0.12, 0.10> ]
         [ 0.10 colour rgbt <0.50, 0.12, 0.18, 0.20> ]
         [ 0.20 colour rgbt <1.00, 1.00, 1.00, 1.00> ]
         [ 1.00 colour rgbt <1.00, 1.00, 1.00, 1.00> ]
      }
   }
}

// knife Blade
#declare Blade = union {
	// body (stained part)
	prism {
		linear_sweep
		linear_spline
		5.5, 17,
		7,
		<0, 2.0>, <0.1, 0.9>, <0.1, -0.9>, <0, -2.0>, <-0.1, -0.9>, <-0.1, 0.9>, <0, 2.0>
		rotate z*90
	}
	// body (unstained part)
	prism {
		linear_sweep
		linear_spline
		0, 5.5,
		7,
		<0, 2.0>, <0.1, 0.9>, <0.1, -0.9>, <0, -2.0>, <-0.1, -0.9>, <-0.1, 0.9>, <0, 2.0>
		rotate z*90
		texture { T_Silver_3B }
	}
	// tip
	difference {
		lathe {
			linear_spline
			5,
			<0, -0.1>, <0.9, -0.1>, <2.0, 0>, <0.9, 0.1>, <0, 0.1>
		}
		plane { -x, 0 }
		scale <3, 1, 1>
		translate <-17, 0, 0>
	}
	texture { T_Silver_3B }
	texture { Blood_Stained
		translate x*-7.5
	}
}

// part of decoration on guard
#declare Decor_Piece = union {
	cylinder { <-0.2, 1.5, 0>, <0, 1.5, 0>, 0.1 }
	intersection {
		torus { 0.3, 0.1
			translate <-0.2, 1.5, 0.3>
		}
		box { <-0.7, 1.5, -0.2>, <-0.2, 1.6, 0.3> }
	}
	sphere { <-0.5, 1.5, 0.3>, 0.1 }
}

#declare Decor_Squigle = union {
	cylinder { <0, 0.0, -0.5>, <0, 0.0, 0.5>, 0.1 }
	intersection {
		torus { 0.5, 0.1
			translate <0.5, 0.0, 0.5>
		}
		box { <-0.1, -0.1, 0.5>, <0.5, 0.1, 1.1> }
	}
	sphere { <0.5, 0.0, 1.0>, 0.1 }
	intersection {
		torus { 0.5, 0.1
			translate <-0.5, 0.0, -0.5>
		}
		box { <-0.5, -0.1, -0.5>, <0.1, 0.1, -1.1> }
	}
	sphere { <-0.5, 0.0, -1.0>, 0.1 }
}

// knife hilt
#declare Hilt = union {
	// guard
	difference {
		union {
			// main body of guard
			difference {
				cylinder { <0, -1.5, 0>, <0, 1.5, 0>, 6.5 }
				cylinder { <0, -1.6, 0>, <0, 1.6, 0>, 4.5 }
			}
			// sticks out a bit in the middle for rounding
			difference {
				cylinder { <0, -1.3, 0>, <0, 1.3, 0>, 6.7 }
				cylinder { <0, -1.4, 0>, <0, 1.4, 0>, 4.3 }
			}
			// torii round off the guard
			torus { 6.5, 0.2
				translate y*1.3
			}
			torus { 6.5, 0.2
				translate y*-1.3
			}
			torus { 4.5, 0.2
				translate y*1.3
			}
			torus { 4.5, 0.2
				translate y*-1.3
			}
		}
		plane { -z, 0
			rotate y*-55
		}
		plane { z, 0
			rotate y*55
		}
		translate x*-5.5
	}
	// decoration on guard
	union {
		difference {
			cylinder { <0, 1.5, 0>, <0, 1.6, 0>, 0.85 }
			cylinder { <0, 1.4, 0>, <0, 1.7, 0>, 0.80 }
		}
		torus { 0.85, 0.1
			translate y*1.5
		}
		torus { 0.80, 0.1
			translate y*1.5
		}
		object { Decor_Piece }
		object { Decor_Piece
			rotate y*120
		}
		object { Decor_Piece
			rotate y*240
		}
	}
	// more decoration (sides)
	object { Decor_Squigle
		translate x*5.5
		rotate y*35
		translate <-5.5, 1.5, 0>
	}
   object { Decor_Squigle
   	rotate z*180
		translate x*5.5
		rotate y*-35
		translate <-5.5, 1.5, 0>
   }	
	// smooth off ends of guard
	union {
		box { <4.5, -1.3, 0>, <6.5, 1.3, 0.2> }
		sphere { <4.5, -1.3, 0>, 0.2 }
		cylinder { <4.5, -1.3, 0>, <6.5, -1.3, 0>, 0.2 }
		sphere { <6.5, -1.3, 0>, 0.2 }
		cylinder { <6.5, -1.3, 0>, <6.5, 1.3, 0>, 0.2 }
		sphere { <6.5, 1.3, 0>, 0.2 }
		cylinder { <6.5, 1.3, 0>, <4.5, 1.3, 0>, 0.2 }
		sphere { <4.5, 1.3, 0>, 0.2 }
		cylinder { <4.5, 1.3, 0>, <4.5, -1.3, 0>, 0.2 }
		rotate y*-55
		translate x*-5.5
	}
	union {
		box { <4.5, -1.3, 0>, <6.5, 0.8, -0.2> }
		sphere { <4.5, -1.3, 0>, 0.2 }
		cylinder { <4.5, -1.3, 0>, <6.5, -1.3, 0>, 0.2 }
		sphere { <6.5, -1.3, 0>, 0.2 }
		cylinder { <6.5, -1.3, 0>, <6.5, 1.3, 0>, 0.2 }
		sphere { <6.5, 1.3, 0>, 0.2 }
		cylinder { <6.5, 1.3, 0>, <4.5, 1.3, 0>, 0.2 }
		sphere { <4.5, 1.3, 0>, 0.2 }
		cylinder { <4.5, 1.3, 0>, <4.5, -1.3, 0>, 0.2 }
		rotate y*55
		translate x*-5.5
	}
	// hilt
	#declare i = 0.45;
	#while ( i <= 6.75 )
		cylinder { <i, 0, 0>, <i+0.5, 0, 0>, 1.3 }
		torus { 1.3, 0.2
			rotate z*90
			scale <1.25, 1, 1>
			translate x*(i+0.25)
		}
		#declare i = i + 0.45;
	#end
	difference {
		sphere { <6.75 + sqrt( 3.15 ), 0, 0>, 2.2 }
		plane { x, sqrt( 3.15 ) }
	}
	texture { T_Gold_5B }
}

#declare Knife = union {			
	object { Blade }
	object { Hilt }
}

#declare Simple_Gold_Piece = union {
	// body of coin
	cylinder { <0, 0.05, 0>, <0, 0.35, 0>, 1.3 }
	difference {
		cylinder { <0, 0, 0>, <0, 0.4, 0>, 1.4 }
		cylinder { <0, -0.1, 0>, <0, 0.5, 0>, 1.3 }
	}
	scale 1.25
	texture { T_Gold_4B }
}

#declare Basic_Gold_Piece = union {
	object { Simple_Gold_Piece }
	union {
		// text on coin
		text { ttf "c:\windows\fonts\blackcha.ttf" "20" 0.05, 0
			rotate x*90
			scale 2
			translate <-0.9, 0.4, -0.60>
		}
		text { ttf "c:\windows\fonts\blackcha.ttf" "PC" 0.05, 0
			rotate x*90
			scale 1.25
			rotate z*180
			translate <1.02, 0.0, -0.35>
		}
		scale 1.25
		texture { T_Gold_4B }
	}
}
	
#declare Blank_Gold_Piece = union {
	object { Simple_Gold_Piece }
	union {
		// edge of coin
		#local i = 0;
		#while ( i < 360 )
			cylinder { <0, 0, 1.4>, <0, 0.4, 1.4>, 0.15
				scale <0.7, 1, 1>
				rotate y*i
			}
			#local i = i + 6;
		#end
		scale 1.25
		texture { T_Gold_4B }
	}
}


#declare Gold_Piece = union {
	object { Blank_Gold_Piece }
	union {
		// text on coin
		text { ttf "c:\windows\fonts\blackcha.ttf" "20" 0.05, 0
			rotate x*90
			scale 2
			translate <-0.9, 0.4, -0.60>
		}
		text { ttf "c:\windows\fonts\blackcha.ttf" "PC" 0.05, 0
			rotate x*90
			scale 1.25
			rotate z*180
			translate <1.02, 0.0, -0.35>
		}
		// studs
		#local i = 0;
		#while ( i < 360 )
			sphere { <0, 0.33, 1.2>, 0.05
				rotate y*i	
			}
			sphere { <0, 0.07, 1.2>, 0.05
				rotate y*i
			}     
			#local i = i + 8;
		#end
		scale 1.25
		texture { T_Gold_4B }
	}
}

#declare Simple_Silver_Piece = union {
	// body of coin
	cylinder { <0, 0.04, 0>, <0, 0.28, 0>, 1.1 }
	difference {
		cylinder { <0, 0, 0>, <0, 0.32, 0>, 1.2 }
		cylinder { <0, -0.1, 0>, <0, 0.4, 0>, 1.1 }
	}
	scale 1.25
	texture { T_Silver_4C }
}

#declare Basic_Silver_Piece = union {
	object { Simple_Silver_Piece }
	union {
		// text on coin
		text { ttf "c:\windows\fonts\blackcha.ttf" "10" 0.04, 0
			rotate x*90
			scale 2
			translate <-0.72, 0.32, -0.60>
		}
		text { ttf "c:\windows\fonts\blackcha.ttf" "PC" 0.04, 0
			rotate x*90
			scale 1.0
			rotate z*180
			translate <0.8, 0.0, -0.25>
		}
		scale 1.25
		texture { T_Silver_4C }
	}
}	

#declare Blank_Silver_Piece = union {
	object { Simple_Silver_Piece }
	union {
		// edge of coin
		#local i = 0;
		#while ( i < 360 )
			cylinder { <0, 0, 1.2>, <0, 0.32, 1.2>, 0.12
				scale <0.65, 1, 1>
				rotate y*i
			}
			#local i = i + 6;
		#end
		scale 1.25
		texture { T_Silver_4C }
	}
}


#declare Silver_Piece = union {
	object { Blank_Silver_Piece }
	union {
		// text on coin
		text { ttf "c:\windows\fonts\blackcha.ttf" "10" 0.04, 0
			rotate x*90
			scale 2
			translate <-0.72, 0.32, -0.60>
		}
		text { ttf "c:\windows\fonts\blackcha.ttf" "PC" 0.04, 0
			rotate x*90
			scale 1.0
			rotate z*180
			translate <0.8, 0.0, -0.25>
		}
		// studs
		#local i = 0;
		#while ( i < 360 )
			sphere { <0, 0.27, 1.0>, 0.04
				rotate y*i	
			}
			sphere { <0, 0.05, 1.0>, 0.04
				rotate y*i
			}
			#local i = i + 8;
		#end
		scale 1.25
		texture { T_Silver_4C }
	}
}
// Object is the coin object, should "lie" on y=0
// coin_height is unscaled object height
// deviation is the maximum offset for a coin
#macro Coin_Stack ( Object, Coin, coin_height, coins, deviation, scaling, rotation, translation )
	#ifndef ( CS_Seed )
		#local CS_Seed = seed(32859);
	#end
	#local i = 0;
	union {
		#while ( i < (coins - 1) )
			object { Object
				translate z*deviation*rand(CS_Seed)		// translate the coin off centre a bit
				rotate y*rand(CS_Seed)*360		// this one "randomizes" the translation direction
				translate y*i*coin_height		// move it up in the stack
			}
			#local i = i + 1;
		#end
		object { Coin
			#if ( rand(CS_Seed) < 0.5 )	// flips coin half the time
				rotate z*180
				translate y*coin_height
			#end
			rotate y*rand(CS_Seed)*360		// this one spins the coin
			translate z*deviation*rand(CS_Seed)		// translate the coin off centre a bit
			rotate y*rand(CS_Seed)*360		// this one "randomizes" the translation direction
			translate y*i*coin_height
		}
		scale scaling
		rotate rotation
		translate translation
	}
#end

#declare PC_Ruby = material {
	texture {
		finish {
			ambient 0.1
			diffuse 0.1
			reflection .25
			specular 1
			roughness 0.001
		}
		pigment { color rgbf <1.0, 0.1, 0.2, 0.65> }
	}
	interior { ior 2.1 }
}

#declare PC_Emerald = material {
	texture {
		finish {
			ambient 0.2
			diffuse 0.1
			reflection 0.15
			specular 1
			roughness 0.001
		}                              
		pigment { colour rgbf <0.2, 1.0, 0.2, 0.75> }
	}
	interior { ior 1.8 }
}

#declare Ring = difference {
	union {
		torus { 0.45, 0.05
			translate y*0.05
		}		
		difference {
			cylinder { <0, 0.05, 0>, <0, 0.2, 0>, 0.5 }
			cylinder { <0, 0, 0>, <0, 0.3, 0>, 0.4 }
		}
		torus { 0.45, 0.05
			translate y*0.2
		}
		sphere { <0, 0, 0>, 1
			scale <0.15, 0.25, 0.1>
			translate <0, 0.125, -0.5>
		}
	}
	sphere { <0, 0, 0>, 1
		scale <0.11, 0.21, 0.08>
		translate <0, 0.125, -0.55>
	}
	texture { T_Gold_5C }
}

#declare Ruby_Ring = union {
	object { Ring }
	sphere { <0, 0, 0>, 1
		scale <0.11, 0.21, 0.08>
		translate <0, 0.125, -0.55>
		material { PC_Ruby }
	}
	// This puts the ring so it "sits" on the xz plane, with the centre a the origin (approximately)
	translate z*-0.45
	rotate x*atan2(0.125, 0.95)*180/pi
	translate z*0.45	
}

#declare Emerald_Ring = union {
	object { Ring }
	sphere { <0, 0, 0>, 1
		scale <0.11, 0.21, 0.08>
		translate <0, 0.125, -0.55>
		material { PC_Emerald }
	}
	// This puts the ring so it "sits" on the xz plane, with the centre a the origin (approximately)
	translate z*-0.45
	rotate x*atan2(0.125, 0.95)*180/pi
	translate z*0.45	
}

#macro Iteration ( scale_factor, height )
	object { Ball
		scale <1, 1, 1>*scale_factor
		translate <0, height, 0>
	}
	object { C_Holder
		scale <1, 1, 1>*scale_factor
		translate <-16, 0, 16>*scale_factor + <0, height, 0>
	}
	object { Candle
		scale <1, 1, 1>*scale_factor
		translate <-16, 1, 16>*scale_factor + <0, height, 0>
	}
	object { C_Holder
		scale <1, 1, 1>*scale_factor
		translate <16, 0, -16>*scale_factor + <0, height, 0>
	}
	object { Candle
		scale <1, 1, 1>*scale_factor
		translate <16, 1, -16>*scale_factor + <0, height, 0>
	}
	#local CFRand = seed(283597);
	C_Flame ( scale_factor, <-16, 1, 16>*scale_factor + <0, height, 0> )
	C_Flame ( scale_factor, <16, 1, -16>*scale_factor + <0, height, 0> )
	light_source {
		<16, 29, -16>*scale_factor + <0, height, 0>
		colour Orange
		fade_distance 16*scale_factor
		fade_power 2
	}	
	light_source {
		<-16, 29, 16>*scale_factor + <0, height, 0>
		colour Orange
		fade_distance 16*scale_factor
		fade_power 2
	}
	#if ( scale_factor <= 1 )
		object { Knife
			scale <1, 1, 1>*scale_factor
			rotate y*40
			translate <-13, 1.5, -14>*scale_factor + <0, height, 0>
		}
		#local CS_Seed = seed(19834);
		#if ( scale_factor > 1/16 )
			Coin_Stack ( Blank_Gold_Piece,   Gold_Piece,   0.5, 11, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <0, 0, 17>*scale_factor + <0, height, 0> )	
			Coin_Stack ( Blank_Silver_Piece, Silver_Piece, 0.4, 15, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <1.5, 0, 23>*scale_factor + <0, height, 0> )
			Coin_Stack ( Blank_Gold_Piece,   Gold_Piece,   0.5, 17, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <4, 0, 19>*scale_factor + <0, height, 0> )
			Coin_Stack ( Blank_Gold_Piece,   Gold_Piece,   0.5, 7, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <7, 0, 12>*scale_factor + <0, height, 0> )	
			Coin_Stack ( Blank_Silver_Piece, Silver_Piece, 0.4, 13, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <8, 0, 16>*scale_factor + <0, height, 0> )
			Coin_Stack ( Blank_Gold_Piece,   Gold_Piece,   0.5, 19, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <13, 0, 14>*scale_factor + <0, height, 0> )
			Coin_Stack ( Blank_Silver_Piece, Silver_Piece, 0.4, 17, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <16, 0, 10>*scale_factor + <0, height, 0> )
			Coin_Stack ( Blank_Gold_Piece,   Gold_Piece,   0.5, 10, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <20, 0, 8>*scale_factor + <0, height, 0> )
		#else
			Coin_Stack ( Simple_Gold_Piece,   Basic_Gold_Piece,   0.5, 11, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <0, 0, 17>*scale_factor + <0, height, 0> )	
			Coin_Stack ( Simple_Silver_Piece, Basic_Silver_Piece, 0.4, 15, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <1.5, 0, 23>*scale_factor + <0, height, 0> )
			Coin_Stack ( Simple_Gold_Piece,   Basic_Gold_Piece,   0.5, 17, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <4, 0, 19>*scale_factor + <0, height, 0> )
			Coin_Stack ( Simple_Gold_Piece,   Basic_Gold_Piece,   0.5, 7, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <7, 0, 12>*scale_factor + <0, height, 0> )	
			Coin_Stack ( Simple_Silver_Piece, Basic_Silver_Piece, 0.4, 13, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <8, 0, 16>*scale_factor + <0, height, 0> )
			Coin_Stack ( Simple_Gold_Piece,   Basic_Gold_Piece,   0.5, 19, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <13, 0, 14>*scale_factor + <0, height, 0> )
			Coin_Stack ( Simple_Silver_Piece, Basic_Silver_Piece, 0.4, 17, 0.15, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <16, 0, 10>*scale_factor + <0, height, 0> )
			Coin_Stack ( Simple_Gold_Piece,   Basic_Gold_Piece,   0.5, 10, 0.20, <1.2, 1.2, 1.2>*scale_factor, <0, 0, 0>, <20, 0, 8>*scale_factor + <0, height, 0> )
		#end
		object { Ruby_Ring
			scale <3, 3, 3>*scale_factor
			rotate y*25
			translate <16, 0, -2>*scale_factor + <0, height, 0>
		}
		object { Emerald_Ring
			scale <2.5, 2.5, 2.5>*scale_factor
			rotate y*-20
			translate <14, 0, 3>*scale_factor + <0, height, 0>
		}
	#end
#end

// minimum signifies largest iteration, maximum smallest
#macro Place ( minimum, maximum )
	#local trans = 0;
	#local i = minimum;
	// find initial height
	#if ( i < 0 )
		#while ( i < 0 )
			#local trans = trans - 3.5 * pow(4, -i);
			#local i = i + 1;
		#end
	#end
	#if ( i > 0 )
		#while ( i > 0 )
			#local trans = trans + 3.5 * pow(4, -i + 1);
			#local i = i - 1;
		#end
	#end 
	#local j = minimum;
	#while ( j <= maximum )
		Iteration ( pow(4, -j), trans )
		#local trans = trans + 3.5 * pow(4, -j);
		#local j = j + 1;
	#end
#end

Place ( -2, 3 )
// (-2, 3 ) is a good final render setting?