/* povme.pov - IRTC still entry, "Worlds Within Worlds"
Created:     2002.02.01.20.00
Last edited: 2002.02.29.01.20 (EST)
By:          William de Beaumont
*/

//warning: the following code may cause headache or blindness :)

#include "colors.inc"
#include "wire.inc"

camera
{
 location <-5,4,-5> //final
 look_at <0,-1,0>
/* location <3,0,-5> //tri corner
 look_at <6,-2,0>*/
/* location <11,-2.7,-5> //bezel
 look_at <11,-2.7,0>*/
/* location <-3.5,0,-1> //look at keyboard logo
 look_at <-3.5,-3.5,-1>*/
/* location <0,3,-1> //look down on keyboard
 look_at <0,-4,-1>*/
/* location <0,0,-8> //sitting positon
 look_at <0,-2,0>*/
/* location <-1,0,-2.5> //closeup of keys
 look_at <.5,-2.8,-1.5>*/
}
//light_source {<0,5,-10> color rgb<1,.98,.85>} //incandescent
light_source {<0,10,-10> color rgb<1,.98,.85>} //incandescent

#declare BeigeBox=
 texture
 {
  normal {bumps .1 scale .01}
  pigment {color White}
 }

union //monitor=======================================================
{
intersection
{
 box {<-4,-4,0>,<4,3,8>} //main monitor box
 cylinder {<0,15,-10>,<0,15,10>,18.4} //clip the bottom to a cylinder
 box {<-3.4,-2.3,-1>,<3.4,2.3,1> inverse} //cut out the middle
 intersection //cut out the edges for rounding
 {
  sphere {<0,0,40>,39.9 inverse}
  box {<-3.5,-2.4,-1>,<3.5,2.4,1>}
  inverse
 }
 sphere {<0,0,40>,40} //clip the front to a sphere
 cylinder {<2.5,-2.9,-5>,<2.5,-2.9,5>,.16 inverse} //cut out the power button hole
 box {<-3.7,2.7,-2>,<-3,2.5,2> inverse} //cut out the box the logo will be in
 texture {BeigeBox}
 no_shadow
}

intersection //edges
{
 box {<-3.5,-2.4,-1>,<3.5,2.4,1>}
 union
 {
  torus
  { 39.7461947864,.1
    rotate z*90
    translate <-3.5,0,40>
  }
  torus
  { 39.7461947864,.1
    rotate z*90
    translate <3.5,0,40>
  }
  torus
  { 39.8277541421,.1
    translate <0,-2.4,40>
  }
  torus
  { 39.8277541421,.1
    translate <0,2.4,40>
  }
 }
 texture {BeigeBox}
 no_shadow
}
intersection //envision logo
{
 box {<-3.7,2.7,-2>,<-3,2.5,2>}
 sphere {<0,0,40>,40} //clip the front to a sphere
 texture
 {
  pigment
  { image_map {png "envision_w.png"}
    scale <.7,.2,1>
    translate <-3.7,2.7,0>
  }
 }
}
intersection //the power button
{
 cylinder {<2.5,-2.9,-5>,<2.5,-2.9,5>,.155}
 sphere {<2.5,-2.9,.4>,.3}
 texture {BeigeBox}
}

sphere //power indicator
{ <2.2,-2.9,.12>,.02
  texture
  {
   finish {ambient 1}
   pigment {color Green}
  }
}

union //control buttons
{
 sphere
 { <0,0,0>,.05
   scale <4,1,.1>
   translate <0,-2.9,0>
 }
 sphere
 { <.4,-2.9,0>,.05
   scale <1,1,.1>
 }
 sphere
 { <-.4,-2.9,0>,.05
   scale <1,1,.1>
 }
 translate z*.07
 texture {BeigeBox}
}

intersection //screen
{
 box {<-3.4,-2.3,-1>,<3.4,2.3,1>}
 sphere {<0,0,30>,29.9}
 texture
 {
  finish {reflection .1 phong .1}
  pigment {color rgbt <1,1,1,1>}
 }
}

intersection //screen image
{
 box {<-3.4,-2.3,-1>,<3.4,2.3,1>}
 sphere {<0,0,30>,29.88}
 texture
 {
  finish {ambient .5}
  pigment
  { image_map {tga "povnest2.tga"}
    translate <-.5,-.5,0>
    scale <6.8,4.6,1>
  }
 }
}

rotate x*5
translate z*.3
}

union //box==============================================================
{
 difference
 {
  box {<6,-3.9,-.9>,<13,-1.5,6>}
  union
  {
   box {<6.1,-1.6,-10>,<0,0,10>} //bevel cutout
   box {<6.01,-3.8,0>,<10,-1.6,5>}
   #declare xhole=0;
   #while (xhole<11)
    #declare yhole=0;
    #while (yhole<9)
     box {<5,yhole*.15-3,xhole*.5>,<7,yhole*.15-3.05,xhole*.5+.3>}
     #declare yhole=yhole+1;
    #end
    #declare xhole=xhole+1;
   #end
  }
 }
 cylinder {<6.1,-1.6,-.9>,<6.1,-1.6,6>,.1} //bevel
 union //front bezel
 {
  intersection
  {
   box {<6,-3.9,-1.5>,<13,-1.5,-.95>}
   union
   {
    cylinder {<5,-2.7,3.2>,<8,-2.7,3.2>,4.5}
    difference
    {
     cylinder {<6.3,-2.7,3.2>,<15,-2.7,3.2>,4.55}
     union
     {
      box {<6,-2.65,-2>,<8,-2.75,0>}
      box {<8,-3.7,-1.5>,<12.5,-1.7,-.9>}
     }
    }
   }
   box {<6.1,-1.6,-10>,<0,0,0> inverse}
  }
  intersection
  {
   cylinder {<6.1,-1.6,-1.3>,<6.1,-1.6,-.95>,.1} //bevel
   cylinder {<5,-2.7,3.2>,<15,-2.7,3.2>,4.5}
  }
  //filler bezels
  box {<9.575,-3.68,-1.22>,<9.8,-1.72,-.9>} //midbar
  box {<8.02,-2.19,-1.22>,<9.555,-2.64,-.9>}//extra 3.5
  difference//drive lights/reset
  {
   box {<8.02,-2.66,-1.22>,<9.555,-3.68,-.9>}
   union
   {
    cone {<9.1,-3,-1.23>,.1,<9.1,-3,-1.1>,0}
    cone {<8.42,-3,-1.23>,.04,<8.42,-3,-1.1>,0}
    cone {<8.72,-3,-1.23>,.04,<8.72,-3,-1.1>,0}
   }
  }
  cylinder {<9.1,-3,-1.2>,<9.1,-3,-1.1>,.06}
  

  box {<9.82,-3.68,-1.22>,<12.48,-3.04,-.9>}//extra 5.25
  box {<9.82,-3.02,-1.22>,<12.48,-2.38,-.9>}//extra 5.25

  translate <0,1.5,.95> //it doesn't quite fit :P
  rotate x*2
  translate <0,-1.5,-.92>
 }
 difference//3.5 floppy drive
 {
  box {<8.02,-2.17,-1.15>,<9.555,-1.72,-.9>}
  union
  {
   box {<8.06, -1.9,-2>,<9.515,-1.76,-.9>}
   cylinder {<8.5,0,-1.15>,<9.075,0,-1.15>,.05 scale <1,4,1> translate y*-1.945}
  }
 }
 box {<9.15,-2,-1>,<9.4,-2.1,-1.18>}//eject button

 box {<9.82,-1.72,-1.15>,<12.48,-2.38,-.9>}//5.25 cdrom drive
 intersection
 {
  sphere {<0,0,0>,1 scale <4,.5,.2> translate <11.15,-1.9,-.97>}
  box {<9.9,-1.72,-1.5>,<12.4,-2.38,-.9>}
 }
 sphere {<0,0,0>,.03 scale <3,1,1> translate <12,-2.25,-1.14>}
 sphere {<0,0,0>,.03 scale <3,1,1> translate <12.25,-2.25,-1.14>}
 intersection
 {
  sphere {<0,0,0>,.1 scale <4,1,.3> translate <10.3,-2.25,-1.14>}
  box {<9,0,-.9>,<12,-4,-1.16>}
 }
 cylinder {<10.3,-2.23,-1.08>,<10.3,-2.27,-1.08>,.12}
 translate z*-.6
 texture {BeigeBox}
}
cylinder
{ <8.42,-3,-1.23>,<8.42,-3,-1.1>,.03
  texture
  {
   finish {ambient .5}
   pigment {color rgb <.3,.2,0>}
  }
  translate <0,1.5,.95> //it doesn't quite fit :P
  rotate x*2
  translate <0,-1.5,-.92>
 translate z*-.6
}
cylinder
{ <8.72,-3,-1.23>,<8.72,-3,-1.1>,.03
  texture
  {
   finish {ambient .5}
   pigment {color Green}
  }
  translate <0,1.5,.95> //it doesn't quite fit :P
  rotate x*2
  translate <0,-1.5,-.92>
 translate z*-.6
}
cylinder
{ <10.1,-2.25,-1>,<10.1,-2.25,-1.17>,.06
  pigment {color Black}
 translate z*-.6
}  
cylinder
{ <10.55,-2.25,-1>,<10.55,-2.25,-1.17>,.03
  texture
  {
   finish {ambient .8}
   pigment {color rgb <.8,.7,0>}
  }
 translate z*-.6
}  

#macro Disk(cl)
 union
 {
  difference
  {
   box {<0,0,0>,<1.55,.05,1.575>}
   union
   {
    box {<.04,1,.12>,<.12,.03,.18>}
    box {<1.51,1,.12>,<1.43,-1,.18>}
    box {<-.08,-1,-1>,<1,1,1> rotate y*-45 translate <1.55,.05,1.575>}
   }
   texture
   {
    normal {bumps 1 scale .003}
    finish {phong 1}
    pigment {color Gray20}
   }
  }
  box
  { <.16,.05,.02>,<1.39,.051,.9>
    pigment
    {
#if (cl=1)
      image_map {tga "disklabel.tga"}
#else
      image_map {tga "disklabel2.tga"}
#end
      rotate x*-90
      rotate z*180
      scale <1.23,1,.88>
      translate <.16,0,.02>
    }
  }
  difference
  {
   box {<.4,-.01,1.0>,<1.15,.06,1.576>}
   box {<.85,-1,1.03>,<1.05,1,1.5>}
   texture
   {
    normal {bumps 1 scale .003}
    finish {phong 1}
    pigment {color Gray70}
   }
  }
  translate <-.775,0,-.7875>
 }
#end

box //desk===================================================
{ <-5,-4,8>,<14,-5,-3.4>
  pigment
  { wood
    turbulence .1
    color_map
    {
     [0.0 rgb <.2,.1,0>]
     [0.1 rgb <.4,.4,.1>]
     [1.0 rgb <.6,.5,.1>]
    }
    rotate y*90
    rotate z*5
    scale .2
    translate z*3
  }
}

#declare Key=
difference //box{<0,0,0>,<1,1,1>} contains it
{
 union
 {
  cylinder {<.1,0,.1>,<.3,1,.3>,.1} //beveled and sloped corners
  cylinder {<.1,0,.9>,<.3,1,.7>,.1}
  cylinder {<.9,0,.1>,<.7,1,.3>,.1}
  cylinder {<.9,0,.9>,<.7,1,.7>,.1}
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-45
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*45
    translate z
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*135
    translate <1,0,1>
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-135
    translate x
  }
 }
 cylinder {<.5,2.5,0>,<.5,2.5,1>,1.6}
}

#macro WideKey(wide)
difference //box{<0,0,0>,<wide,1,1>} contains it
{
 union
 {
  cylinder {<.1,0,.1>,<.3,1,.3>,.1} //beveled and sloped corners
  cylinder {<.1,0,.9>,<.3,1,.7>,.1}
  cylinder {<wide-.1,0,.1>,<wide-.3,1,.3>,.1}
  cylinder {<wide-.1,0,.9>,<wide-.3,1,.7>,.1}
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-45
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*45
    translate z
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*135
    translate <wide,0,1>
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-135
    translate x*wide
  }
  box
  { <.5,0,0>,<wide-.5,1.5,.5>
    rotate x*10.54529059
  }
  box
  { <.5,0,-.5>,<wide-.5,1.5,0>
    rotate x*-10.54529059
    translate z
  }
 }
 cylinder {<.5,2.5,0>,<.5,2.5,1>,1.6 scale <wide,1,1>}
}
#end


#declare kw=.34; //keywidth

union //keyboard=========================================================
{
 cylinder {<-4,-3.5,-.4>,<4,-3.5,-.4>,.2} //edges
 cylinder {<-4,-3.5,-3.4>,<4,-3.5,-3.4>,.2}
 difference //for cutting out key wells
 {
  union
  {
   cylinder {<-4.4,-3.5,-.8>,<-4.4,-3.5,-3>,.2}
   cylinder {<4.4,-3.5,-.8>,<4.4,-3.5,-3>,.2}
   torus {.4,.2 translate <4,-3.5,-.8>} //corners
   cylinder {<4,-3.3,-.8>,<4,-3.7,-.8>,.4}
   torus {.4,.2 translate <-4,-3.5,-.8>}
   cylinder {<-4,-3.3,-.8>,<-4,-3.7,-.8>,.4}
   torus {.4,.2 translate <4,-3.5,-3>}
   cylinder {<4,-3.3,-3>,<4,-3.7,-3>,.4}
   torus {.4,.2 translate <-4,-3.5,-3>}
   cylinder {<-4,-3.3,-3>,<-4,-3.7,-3>,.4}
   box {<-4,-3.3,-.4>,<4,-3.7,-.8>} //main plane
   box {<-4.4,-3.3,-.8>,<4.4,-3.7,-3>}
   box {<-4,-3.3,-3>,<4,-3.7,-3.4>}
  }
  union
  {
   box {<-5,-3.2,-1>,<5,-3.35,-.85>}
   box {<-4.3+18*kw,-3,-.85>,<-4.3+22.5*kw,-3.4,-.85+kw>} //light label hole
   difference
   {
    box {<-4.3,-3,-3.3>,<-4.3+25.5*kw,-3.5,-3.3+6.5*kw>}
    union
    {
     box {<-4.4,-3,-3.3+5*kw>,<4.4,-3.5,-3.3+5.5*kw>}
     box {<-4.3+2*kw,-3,-3.4>,<-4.3+2.5*kw,-3.5,0>}
     box {<-4.3+17.5*kw,-3,-3.4>,<-4.3+18*kw,-3.5,0>}
     box {<-4.3+21*kw,-3,-3.4>,<-4.3+21.5*kw,-3.5,0>}
     box {<-4.3+3.5*kw,-3,-3.3+5.5*kw>,<-4.3+4.5*kw,-3.5,0>}
     box {<-4.3+8.5*kw,-3,-3.3+5.5*kw>,<-4.3+9*kw,-3.5,0>}
     box {<-4.3+13*kw,-3,-3.3+5.5*kw>,<-4.3+13.5*kw,-3.5,0>}
    }
   }
  }
 }
 cylinder {<-4.4,-3.35,-1>,<4.4,-3.35,-1>,.05}
 cylinder {<-4.4,-3.35,-.85>,<4.4,-3.35,-.85>,.05}
 intersection
 {
  union
  {
   cylinder {<-5,-3.35,-1>,<5,-3.35,-1>,.05}
   cylinder {<-5,-3.35,-.85>,<5,-3.35,-.85>,.05}
  }
  union
  {
   cylinder {<-4.4,-3.5,-.8>,<-4.4,-3.5,-3>,.2}
   cylinder {<4.4,-3.5,-.8>,<4.4,-3.5,-3>,.2}
  }
 }
 cylinder {<-4.3+.34*2.5,-3.3,-1.02>,<-4.3+.34*17.5,-3.3,-1.02>,.02}
 height_field //gateway "G" logo
 { tga "gatewayg.tga"
   scale <.3,.0225,.375>
   translate <-4.15,-3.31,-.85>
   pigment {color Yellow}
 }
 height_field //gateway2000 logo
 { tga "gw2000.tga"
   scale <1.275,.0225,.186>
   translate <-3.8,-3.31,-.8>
   pigment {color Gray50}
 }

union
{
#declare keycount=0;
#while (keycount<5)
 object //side Fn keys----------------
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+1*kw,-3.4,-3.3+keycount*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3,-3.4,-3.3+keycount*kw>
 }
 object //cursor movement
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+18*kw,-3.4,-3.3+keycount*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+19*kw,-3.4,-3.3+keycount*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+20*kw,-3.4,-3.3+keycount*kw>
 }
 
 #declare keycount=keycount+1;
#end
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+1*kw,-3.4,-3.3+5.5*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3,-3.4,-3.3+5.5*kw>
 }
 object // ESC----------
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+2.5*kw,-3.4,-3.3+5.5*kw>
 }
#declare keycount=0; //top Fn keys----------------
#while (keycount<4)
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(4.5+keycount)*kw,-3.4,-3.3+5.5*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+(9+keycount)*kw,-3.4,-3.3+5.5*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(13.5+keycount)*kw,-3.4,-3.3+5.5*kw>
 }
 object //macro programming keys
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+(21.5+keycount)*kw,-3.4,-3.3+5.5*kw>
 }
#declare keycount=keycount+1;
#end
 object //prnscr
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+18*kw,-3.4,-3.3+5.5*kw>
 }
 object //scrlck
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+19*kw,-3.4,-3.3+5.5*kw>
 }
 object //pausebrk
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+20*kw,-3.4,-3.3+5.5*kw>
 }

 object //numlck
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+21.5*kw,-3.4,-3.3+4*kw>
 }
 object // /
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+22.5*kw,-3.4,-3.3+4*kw>
 }
 object // *
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+23.5*kw,-3.4,-3.3+4*kw>
 }
 object // -
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment{color Gray85}}
   translate <-4.3+24.5*kw,-3.4,-3.3+4*kw>
 }

#declare keycount=1; //numpad----------------
#while (keycount<4)
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+21.5*kw,-3.4,-3.3+keycount*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+22.5*kw,-3.4,-3.3+keycount*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate z*-.2 rotate x*(4-keycount)*3 translate z*.2
   translate <-4.3+23.5*kw,-3.4,-3.3+keycount*kw>
 }
#declare keycount=keycount+1;
#end
object // .
{ Key scale <kw,.2,kw> //texture {BeigeBox}
  translate z*-.2 rotate x*12 translate z*.2
  translate <-4.3+23.5*kw,-3.4,-3.3>
}
object // 0
{ WideKey(2) scale <kw,.2,kw> //texture {BeigeBox}
  translate z*-.2 rotate x*12 translate z*.2
  translate <-4.3+21.5*kw,-3.4,-3.3>
}

object // enter
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3>
}
object // enter
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3+kw/2>
}
object // enter
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3+kw>
}
object // +
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3+kw*2>
}
object // +
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3+kw*2.5>
}
object // +
{ Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+24.5*kw,-3.4,-3.3+kw*3>
}

//union
//{
#declare keycount=0; //main key area----------------
#while (keycount<10)
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(3.5+keycount)*kw,-3.4,-3.3+4*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(4+keycount)*kw,-3.4,-3.3+3*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(4.2+keycount)*kw,-3.4,-3.3+2*kw>
 }
 object
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+(4.7+keycount)*kw,-3.4,-3.3+1*kw>
 }
#declare keycount=keycount+1;
#end
//keys missed by last bit...
 object // `
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+2.5*kw,-3.4,-3.3+4*kw>
 }
 object // -
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+13.5*kw,-3.4,-3.3+4*kw>
 }
 object // =
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+14.5*kw,-3.4,-3.3+4*kw>
 }
 object // \
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+15.5*kw,-3.4,-3.3+4*kw>
 }

 object // [
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+14*kw,-3.4,-3.3+3*kw>
 }
 object // ]
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+15*kw,-3.4,-3.3+3*kw>
 }

 object // '
 { Key scale <kw,.2,kw> //texture {BeigeBox}
   translate <-4.3+14.2*kw,-3.4,-3.3+2*kw>
 }
 
 object // bs
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
   translate <-4.3+16.5*kw,-3.4,-3.3+4*kw>
 }
 object // *
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
   translate <-4.3+4*kw,-3.4,-3.3>
 }
 object // \
 { Key scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
   translate <-4.3+15*kw,-3.4,-3.3>
 }
  
object // tab
{ WideKey(1.5) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+2.5*kw,-3.4,-3.3+3*kw>
}
object // capslock
{ WideKey(1.7) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+2.5*kw,-3.4,-3.3+2*kw>
}
object // l-shift
{ WideKey(2.2) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+2.5*kw,-3.4,-3.3+kw>
}
object // l-ctrl
{ WideKey(1.5) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+2.5*kw,-3.4,-3.3>
}
object // l-alt
{ WideKey(1.5) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+5*kw,-3.4,-3.3>
}
object // r-shift
{ WideKey(2.8) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+14.7*kw,-3.4,-3.3+kw>
}
object // r-ctrl
{ WideKey(1.5) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+13.5*kw,-3.4,-3.3>
}
object // r-alt
{ WideKey(1.5) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
  translate <-4.3+16*kw,-3.4,-3.3>
}

#declare spwide=7;
intersection // SPACE
{
 union
 {
  cylinder {<.1,0,.1>,<.3,1,.3>,.1} //beveled and sloped corners
  cylinder {<.1,0,.9>,<.3,1,.7>,.1}
  cylinder {<spwide-.1,0,.1>,<spwide-.3,1,.3>,.1}
  cylinder {<spwide-.1,0,.9>,<spwide-.3,1,.7>,.1}
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-45
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*45
    translate z
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*135
    translate <spwide,0,1>
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-135
    translate x*spwide
  }
  box
  { <.5,0,0>,<spwide-.5,1.5,.5>
    rotate x*10.54529059
  }
  box
  { <.5,0,-.5>,<spwide-.5,1.5,0>
    rotate x*-10.54529059
    translate z
  }
 }
 cylinder {<0,-.3,.5>,<spwide,-.3,.5>,1.3}

 scale <kw,.2,kw> //texture {BeigeBox}
 translate <-4.3+6.5*kw,-3.4,-3.3>
}

 object //enter
 { WideKey(2.3) scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
   translate <-4.3+15.2*kw,-3.4,-3.3+2*kw>
 }
difference
{
 union
 {
  cylinder {<.1,0,.1>,<.3,1,.3>,.1} //beveled and sloped corners
  cylinder {<.1,0,.9>,<.3,1,.7>,.1}
  cylinder {<1.4,0,.1>,<1.2,1,.3>,.1}
  cylinder {<1.4,0,.9>,<1.2,1,.7>,.1}
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-45
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*45
    translate z*1.5
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*135
    translate <1.5,0,1.5>
  }
  difference
  { box {<0,0,0>,<.5,1.5,.5>} box {<-1,-1,-1>,<.1,2,.1>}
    rotate y*45
    rotate z*-15
    rotate y*-135
    translate x*1.5
  }
  box
  { <.5,0,0>,<1,1.5,.5>
    rotate x*10.54529059
  }
  box
  { <.5,0,-.5>,<1,1.5,0>
    rotate x*-10.54529059
    translate z*1.5
  }
  box
  { <0,0,.5>,<.5,1.5,1>
    rotate z*-10.54529059
  }
  box
  { <-.5,0,.5>,<0,1.5,1>
    rotate z*10.54529059
    translate x*1.5
  }
  //grrr, another little gap...
  box {<.5,0,.5>,<1,1.5,1>}
 }
 cylinder {<.35,2.5,0>,<.35,2.5,1.5>,1.6 scale <2.3,1,1>}

 scale <kw,.2,kw> //texture {BeigeBox pigment {color Gray85}}
 translate <-4.3+16*kw,-3.4,-3.3+2.5*kw>
}
  texture
  { BeigeBox
    pigment
    { image_map {tga "keyboard2.tga"}
      rotate x*90
      scale <25.5*kw,.201,6.5*kw>
      translate <-4.3,-3.4,-3.3>
    }
  }
} 
 rotate x*-5
 rotate y*3
 translate x*.2
 pigment {color White}
}
box
{ <-4.3+18.4*kw,-3.4,-.9>,<-4.3+18.6*kw,-3.32,-.95>
 texture
 {
  finish {ambient 1}
  pigment {color Green}
 }
 rotate x*-5
 rotate y*3
 translate x*.2
}
box
{ <-4.3+19.4*kw,-3.4,-.9>,<-4.3+19.6*kw,-3.32,-.95>
 pigment {color Black}
 rotate x*-5
 rotate y*3
 translate x*.2
}
box
{ <-4.3+20.4*kw,-3.4,-.9>,<-4.3+20.6*kw,-3.32,-.95>
 pigment {color Black}
 rotate x*-5
 rotate y*3
 translate x*.2
}
box
{ <-4.3+21.9*kw,-3.4,-.9>,<-4.3+22.1*kw,-3.32,-.95>
 texture
 {
  finish {ambient 1}
  pigment {color Green}
 }
 rotate x*-5
 rotate y*3
 translate x*.2
}
box //light labels
{ <-4.3+18*kw,-3.3,-.85>,<-4.3+22.5*kw,-3.4,-.85+kw>
  texture
  { BeigeBox
    pigment
    { image_map {tga "lightlabels.tga"}
      rotate x*90
      scale <4.5*kw,1,kw>
      translate <-4.3+18*kw,0,-.85>
    }
  }
 rotate x*-5
 rotate y*3
 translate x*.2
}

//clutter=============================================================
#declare r1=seed(828346);
#declare wpoints=array[40]
union
{//wires flat on desk
 RandWire(wpoints,<5.4,-3.6,-3>,<0,0,.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 RandWire(wpoints,<5.8,-3.7,-3>,<0,0,.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 RandWire(wpoints,<5.6,-3.7,-3>,<0,0,.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 cylinder {<5.4,-3.6,-3>,<5.4,-4,-3.5>,.05} //rounding the bend
 cylinder {<5.8,-3.7,-3>,<5.8,-4,-3.5>,.05}
 cylinder {<5.6,-3.7,-3>,<5.6,-4,-3.5>,.05}
 pigment {color White}
}

#declare wpoints=array[30]
union //wires going down
{
 RandWire(wpoints,<5.4,0,0>,<0,0,-.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 RandWire(wpoints,<5.8,0,0>,<0,0,-.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 RandWire(wpoints,<5.6,0,0>,<0,0,-.4>,.3,.03,r1)
 object {Wire(wpoints,.05)}
 rotate x*-80
 translate <0,-4,-3.5>
 pigment {color White}
}

//disks
#declare diskcount=0;
#while (diskcount<5)
 object
 { Disk(int(rand(r1)+1.5))
   rotate y*(rand(r1)*360+90)
   translate <7+rand(r1)*.1,-1.5+diskcount*.05,rand(r1)*.1-.5>
 }
 #declare diskcount=diskcount+1;
#end
#declare diskcount=0;
#while (diskcount<9)
 object
 { Disk(int(rand(r1)+1.5))
   rotate y*(rand(r1)*360)
   translate <9+rand(r1)*.1,-1.5+diskcount*.05,rand(r1)*.1-.5>
 }
 #declare diskcount=diskcount+1;
#end
