// Persistence of Vision Ray Tracer Scene Description File
// File: sevenday.pov
// Vers: Pov-Ray3.5  Beta 11
// Desc: IRtc Worlds Within Worlds, soft-boiled egg .. Earth ..universe ..ggs
// Date: february  2002
// Auth: Martial Rameaux   
// Web : http://cathemline.org           
//
// Special Thank to Eric LeSeigneur for the spoon !
// Tool use : SpilinEditor  by Allessandro Falappa  for the egg cup
//                    http://www.flashnet.it/users/fn027571/spil/index.html   
// render time with  +w577 +h768  +a0.01 +am2 +r2 :         
// earth map http://www.radcyberzine.com/xglobe/index.html#maps    
//           http://www.evildrganymede.demon.co.uk/render/render_f.htm
//**************************************
// +w120 +h160
// +w240 +h320 
// +w384 +h512
// +w480 +h640
// +w577 +h768 
// Final command line  :
// +w577 +h768  +a0.01 +am2 +r2 
//*************************************  
//Switch Work
#declare  OeufSwitch   = 1;
#declare  inOeufSwitch = 1;
#declare  LathSwitch   = 1;
#declare  MapSwitch    = 1;  
#declare  inOeufSwitch = 1;
#declare  SpoonSwitch  = 1;
//**** Standard POV-Ray Includes ******
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
//*************************************
//  POINT OF VIEW 
//*************************************   
#declare xRat=x*image_width/image_height;
#declare Camloc= <5,12,-10> ;
#declare CamloK= <.5,1,0> ;
camera{location Camloc right xRat look_at CamloK angle 25}    
//*********************************
// LIGHT_SOURCE
//*********************************

#declare Lum=<1,.9,.8>;
light_source {<100,100,-10>, Lum*.6  spotlight radius 1 falloff 5 tightness 30  point_at y*2  } 
light_source {0, Lum*.01 translate < 30, 90,- 80> shadowless photons {refraction  off  reflection  off}} 
light_source {0, Lum*.01 translate <-30,200,-100> shadowless photons {refraction  off  reflection  off}}   
light_source {<-100,100,100>, Lum*1 spotlight radius 1 falloff 5 tightness 30 point_at 0  photons {refraction  off  reflection  off}}   

//*********************************
// SKY_SPHERE and NAPPE  and sous de plat
//*********************************   
//tableNappe
#include "incs\t_nappe.inc"
#declare T_Resto=MatNappe(<0.196078,.6,.8>,<1,.6,.5>,no)
box {<-20,-4,-10><20,-4.1,50>  material { T_Resto rotate y*-45 scale 2}} 

//Sous de plat 
#declare Scl=<400/403,1,1>*1.25;
#declare T_Carreau=material {
                  texture { 
                        pigment {//rgb .8}
                        image_map {jpeg "map\p07" } scale Scl }
                        normal {bump_map{jpeg "map\p07" bump_size -10  }  scale Scl }   
                        finish{brilliance 5 specular 1 roughness 0.01 diffuse .6 ambient .5  reflection {.2,.5 fresnel}}   
                  }  
                  scale 4
}  

#macro T_Bord(rot) 
      texture {pigment {rgb <0.196078,.6,.8>}
          finish{specular 10 roughness 0.01 diffuse .6 ambient .3 }   
          rotate rot*90 
          scale .8
      }  
#end

#declare Bord=
      difference {
            cylinder {<-2.2,0,0><2.2,0,0>.2}
            plane { z,0 rotate y* 45 translate x*-2}
            plane { z,0 rotate y*-45 translate x* 2} 
            T_Bord(x)  
    }     
              
#declare ct=2.01;
#declare Sous_de_Plat=
union {   
      box{<-2,0,-2><2,.2,2> material {T_Carreau rotate x*90} }  
      object {Bord  translate z*2}
      object {Bord  rotate y*180 translate z*-2} 
      object {Bord  rotate y*-90 translate x*-2}     
      object {Bord  rotate y* 90 translate x* 2}     
}   
object {Sous_de_Plat scale 2 rotate y*15 translate <-10,-4,10>}

//Ciel
sky_sphere{ pigment { gradient y  color_map{[0 White ][1 White*2]}}}    

//*************************************
// JAUNE ET BLANC_D'OEUF
//*************************************

#declare JauneOeuf=union {
 union {   //le Jaune
   sphere {0,1.8
                 pigment { bozo 
                           color_map{[0 rgb <1,.65,.0>][1 rgb <1,.8,.0>]}
                             turbulence 1
                               scale 2
                 }
                 finish  {ambient .6 diffuse .6}  
                 hollow
   } 
 //le gluant de l'oeuf  
  difference {
         light_group {
             sphere {0,2.208}   
            light_source { <-1,8,1>*100 1}
            global_lights on
         }
         box {-2.5,<2.5,0,2.5>}
    
      pigment {rgbt <1,.98,.8,.8>}   
      finish  {ambient .3 diffuse 0.3  specular 1 roughness 0.0025 conserve_energy}
      photons {
         target 1
         reflection on
         refraction on
         collect off
            }
               hollow       
 }    
   
scale <1,.9,1> 
 }        
 //---  
//BLANC_D'OEUF 
#declare iso=isosurface { //
      function { f_sphere(x, y, z, 1.6)-f_noise3d(x*5, y*5, z*5)*0.5 }
                 contained_by { sphere { 0, 2 }}     
                 max_gradient 1.1
                 accuracy .0001
            }
 
difference {             
      isosurface {
          function { f_torus(x, y, z, 1.4, 0.8)+f_noise3d(x,y,z)*.3}
           contained_by { box { -2.5, 2.5 } }     
           max_gradient 1.1
           accuracy .0001
      }
      object {iso scale .7 }
              pigment {bozo 
                  color_map {[0 rgbt <1,1,1,.1>][1 rgbt <.98,.98,.98,.1> ]}
                  turbulence .9 scale .2 
                  }
              finish{ambient .4 diffuse .6 specular  0.1 roughness 0.02 conserve_energy}
             // interior  {ior 1.05}
              translate y*1.1   
      }   
interior  {ior 2.5 dispersion 8    }   
hollow
}
//FIN_BLANC_JAUNE_OEUF ---------
       

#declare T_Terre=texture {
      pigment{
        #if(MapSwitch) image_map {jpeg "map\earthmap4k" map_type 1}}
           #else rgb <.2,.5,.9>}
        #end
            finish{ambient .3 diffuse 1 conserve_energy}
            normal {bump_map {jpeg "map\earthbump4k"  map_type 1 bump_size 10}}
}  


#declare Monde2 =sphere {0,1.6 texture {T_Terre} no_image } 

#declare Jaune  =object {JauneOeuf scale .75 no_reflection} 

#declare LightG_Monde=light_group{
                             light_source {0,3 translate <1,5,-5> shadowless}
                             object {Monde2}
                        }
//*********************************
// Texture_Oeuf
//*********************************
#declare PigCoq0=pigment {leopard color_map{[0 Yellow][1 Red]}sine_wave  scale .05}
#declare PigCoq1=pigment {bozo color_map{[0 Orange][.5 Wheat][1 White]}triangle_wave scale .02}
#declare PigCoq2=pigment {bozo pigment_map{[0 PigCoq0][1 PigCoq1]} turbulence <.5,.6,.1> scale -8}

#declare N_Oeuf= normal {pigment_pattern {PigCoq2} .06}

#declare T_Oeuf01=texture {
                  pigment {leopard  
                        color_map {
                                    [.7 Tan+White*.5 ]
                                    [.8 color rgb <0.935,0.643,0.490> ]
                                    [.9 color rgb <0.992,0.765,0.404> ] 
                        } 
                        turbulence .5 omega 0.6 lambda 2
                        scale .08 
                        frequency .8
                  }        
           normal {N_Oeuf}   
           finish {ambient .2 diffuse .6 specular 10 roughness 0.01 } 
      }               
      
#declare T_Oeuf02=texture {
                    pigment {leopard 
                              color_map {
                                         [.8 rgb 1 ]
                                         [.8 color rgb <0.935,0.643,0.490> ]
                                         } 
                              turbulence .2 scale .07 frequency .6
                              }                             
                              
                           }

#declare T_Oeuf=material{ 
                  texture{
                        leopard
                         texture_map { [0.0 T_Oeuf01]
                                       [0.7 T_Oeuf01]   
                                       [0.8 T_Oeuf02]
                                       [1.0 T_Oeuf02]
                                       }   
                        }
 }        
 
 #declare T_Oeuf_int=texture {//pigment {rgbf <1,1,.98,.1>}  
                              pigment {bumps 
                                         color_map {[0 rgb <1,1,.98>*2][1 rgb <.98,.98,.98>*2 ]}
                                         scale .0001 } 
                              finish{ ambient 0.4 diffuse .6 specular .3 roughness 0.01}  
                              normal {bumps .001 scale .01}
                              } 

//*********************************
// OEUF_COQUE
//*********************************

#declare Oeuf=
blob {
     threshold .6
     sphere {0,1,.6}
     sphere {<0,.55,0>.8,1 scale <.7,1,.7>}
scale 5
}   

#declare Oeuf_int=object {Oeuf texture{T_Oeuf_int}}
#declare Oeuf    =object {Oeuf material {T_Oeuf}}
//------------------------------------
// Decoupe OEUF
#declare f_HF=
   height_field {
      function 50,50 {
         pattern { wrinkles 
                         noise_generator 1
                         poly_wave  
                         turbulence 1e8 
                         frequency .5
                         omega 1.2  
                         lambda 3 
                }      
      }
      translate -0.5   
   }  
#declare HF =object{f_HF scale <8,-.7,8> }   
#declare HF2=object{f_HF scale <8, .7,8> } 
//------------------------------------ 
#declare TransHF=3.7;  

#declare Oeuf_Coque=
difference {
      object {Oeuf }
      object {Oeuf_int scale .99}
      object {HF pigment {White*2} translate y*TransHF}      
//no_shadow
}

#declare Oeuf_Coque=union{
object {Oeuf_Coque}       
      #if(inOeufSwitch)        
            object {LightG_Monde translate y*1.8} // Monde2          
            object {Jaune  translate y*2.1 }   
      #end 
      scale .98    
 }       
   
#declare Oeuf_Coque=light_group{
    object {Oeuf_Coque}     
         light_source {0, .8 translate <0,8,0> shadowless}  
         global_lights on   
   } 
          
// la Decoupe Coquille d'oeuf
#declare Coquil_Oeuf=difference{
      object {Oeuf}
      object {Oeuf_int scale .99}
      object {HF2 pigment {White*2} translate y*TransHF}  
      translate -y*TransHF  
      rotate x*180 
}  
// FIN OEUF COQUE 
//*********************************
// COQUETIER
//*********************************  

#declare Cote=.15;  
#declare  Trans= <0,1.05,-.43>;
#declare  Rot=<45,45,0>;
     
#macro Bris(Cote,Rot,Trans)
     box{-Cote,Cote 
            pigment {rgb 2}  
            finish {ambient .3 diffuse .6} 
            normal {bumps .3 scale 0.001 } 
            scale <.8,1,1>
            rotate Rot translate Trans
      }   
#end            
//for placement 
//Bris(Cote,Rot,Trans)
            
         
#declare M_Coquetier=
material{
     texture {
           pigment {checker SkyBlue, White*1.2  scale <.05,2,.05> }
           finish {specular 1 roughness 0.1 ambient .4 diffuse .6}  
      }     
}    
   
#include "incs\coquetier.inc"   
#declare Coquetier= 
      difference {
            object {coquetier  
                 uv_mapping
                 material{M_Coquetier}
                 rotate y*-90
            }
        Bris (Cote,Rot,Trans)  
        scale <5.61,5.6,5.61> 
      }   
      
//*************************************
//     CUILLIERE
//*************************************
#if(SpoonSwitch)

#declare T_Cuil=material{   
texture{
      pigment {rgb .739567 } //0.739567
       finish
         {
            ambient 0.1
            phong 0.007167
            specular 0.4676
            roughness 0.022533
            reflection 0.438833
         }   
       //  normal {gradient z 1 scale 0.001 turbulence .5 rotate x*-45} 
      }
      }   
      
#declare T_manche=texture{
      pigment{ color <0.090,0.710,0.925>}
      finish {specular 10 roughness 0.0015}
}
//--Macro_cuillere by Eric Le_seigneur-------
#declare L = 1.5 ;
#declare E = .03 ;


#include "incs\pt_cuillere.inc"//by Eric Le_seigneur
#declare Cuiller_els=
object{Cuiller(T_manche ,T_Cuil) material {T_Cuil} 
    scale 1.0
    rotate y*180
    rotate x*30
    rotate y*-20
    rotate z*10
    translate <.3,4.0,1.0>  
     photons {
         target 
         reflection on
         refraction on
         collect off
   }
 }

#end//IF_SWITCH_CUIL  
//*************************************
//  ENVIRONEMENT
//*************************************
fog{distance 100 rgbt .8}
//*********************************
// AFFICHE
//*********************************
union {
      #if(OeufSwitch)
            object {Oeuf_Coque}          
            object {Coquil_Oeuf rotate <30,45,0> translate <2.2,-1.9,1.3>}     
      #end 
      
      #if(LathSwitch) 
            object {Coquetier translate y*-3.2}
      #end 
      
      #if(SpoonSwitch) 
            object {Cuiller_els} 
      #end

      translate y*-1
}
//*************************************
// GLOBAL_SETTINGS
//*************************************
#default {finish{ambient 0 diffuse 1}}
global_settings {  
      assumed_gamma 1.8 
      ambient_light 1 
      max_trace_level 25 
      photons {
            spacing 0.1  
            gather 20,100   
            save_file "photon.ph"
            //load_file "photon.ph"
       }    
}
//*********************************
//-------- END_OF_FILE ------------
//*********************************
