#include "colors.inc"
#include "textures.inc"  

background { color rgb <0.22,0.69,0.87> }

// =======================================================================    
//                       Switches:
//                           1 = on
//                           0 = off
// =======================================================================

#declare chimps_On = 1;
#declare hair_On = 1;
#declare sky_On = 1;
#declare trees_On = 1;
#declare grass_On = 1;
#declare city_On = 1; 
#declare fog_On = 1;  

#declare pointer_On = 0;   

#declare f_Blur_On = 0;
/* 
global_settings {


  radiosity
  { count 500
    distance_maximum 1
    error_bound .2
    minimum_reuse .001
  }


}
  */
 
// =======================================================================
//                         Focal blur camera.
// =======================================================================

#if (f_Blur_On) 
#warning "Begin f_blur_On\n"
camera {
        location <-1,8, -16>
        look_at  <270,0,900>
        focal_point <4,6,15>
        aperture 0.05
        //aperture 0.1       // too much blur
        //aperture 0.05      // almost everything is in focus
        //aperture 1.5       // way too much blur
        //blur_samples 4     // fewer samples, faster to render
        blur_samples 20    // more samples, higher quality image
        }
             
#else 
   
camera {location <-1,8, -16> look_at <270,0,900>} // <------------------ PRODUCTION!!!    
//camera {location <5,25,17> look_at <5,5,17>}

#end

// =======================================================================
//                            Lighting.
// =======================================================================



light_source { < 20, 90, -31 > color White*2}     // <------------------ PRODUCTION!!!  
      
light_source { <-3,9,-16> color White*.5 shadowless} // <---------------area light in the woods
        
light_source {  
        <-4,9,-18.3>
        color White
        spotlight
        radius 35
        falloff 20
        tightness 100 
        area_light <1, 0, 0>, <0, 1, 0>, 2, 2
        adaptive 1
        jitter
        point_at <3,6.5,-11.8>
        }
        
light_source {
        <1.9,8,-15>
        color White
        spotlight
        radius 35
        falloff 20
        tightness 100
        area_light <1, 0, 0>, <0, 1, 0>, 2, 2
        adaptive 1
        jitter
        point_at <-2.3,7.6,-14.5>
        }                   
         
//light_source {<0,19,-10.1> color White}   
//light_source { < 90, 90,-50 > color White shadowless}  
//light_source { < 20, 1950, -20 > color White}
//light_source { < -5, 50, -19 > color White shadowless}   
//light_source { < 90, -190,-50 > color White*.6 shadowless}         

// =======================================================================
//        Ground - High ground is plain if !grass_On else grass.
// =======================================================================

#if (grass_On)
#warning "Begin grass_On\n"
        #include "Grass.inc"
        object{Highground_Grass rotate -15*y translate <-3,0,0> texture{txtGrass scale 40}}
        superellipsoid { <.25, .3> scale <18,1,70> rotate -20*y translate <-1,-1,0> texture{pigment {color DarkBrown}}finish {ambient 0 diffuse .3}}   
#else
        superellipsoid { <.25, .1> scale <18,1,70> rotate -20*y translate <-1,-1,0> texture{pigment {color DarkBrown}}finish {ambient 0 diffuse .3}}   
#end
                
#declare Lowground =     
height_field {
        tga "Lowground.tga"
        smooth
        
        scale <3000,300,2000>
        translate <-600,-150,-50>
        texture {
                pigment {
                        spotted
                        turbulence .2
                        color_map {
                                [0.0 Tan]   
                                [0.5 Tan]  
                                [0.65 Goldenrod]
                                //[0.7 DarkGreen]
                                //[1.0 DarkGreen]
                                [0.7 Gray]
                                [1.0 Gray]
                                }
                        scale <1.2,4,1.2> 
                        }
                }
        normal {bumps .2 scale<1,5,1>}
        finish {ambient 0 diffuse .3}
        }
                
#declare Forest =
difference {   
        height_field {
                tga "Forest.tga"
                smooth
                
                scale <1200,25,750>
                translate <500,-150,600>
                texture {
                        pigment {
                                spotted
                                turbulence .2
                                color_map {
                                        [0.0 rgb<0.5,0.3,0.1>]   
                                        [0.2 rgb<0.4,0.5,0.2>]  
                                        [0.35 rgb<0.5,0.5,0>]
                                        [0.65 rgb<.3,0.5,0.3>]
                                        [1.0 DarkGreen]
                                        }
                                scale .8 
                                }
                        }
                finish {ambient .1 diffuse .4}
                }
        box {<-3000,-155,-3000><3000,-149.5,3000>}
        }
                  
object {Lowground}
object {Forest}
box {<-3,-151,50><3,-149,-1000> pigment {color Black} rotate -40*y translate <400,0,1000>}

#if (fog_On)
        fog {
                distance 100
                color rgbt<0.858824,0.576471,0.439216, .5>
                fog_type 2
                fog_offset -145
                fog_alt 15
                turbulence 0.5
                turb_depth 0.5
        }   
#end        

// =======================================================================
//                         Chimps.
// =======================================================================

#if (chimps_On)
#warning "Begin chimps_On\n"
#include "Chimps.inc"

object {Chimp1 rotate <-10,54,0> translate <3,7.8,-11.8>}
object {Chimp2 rotate <.1,13,0> translate <-2.3,7.6,-14.5>}
object {Chimp3 rotate 185*y translate <5,5,17>}
#end  
 
// =======================================================================
//                          Trees.
// ======================================================================= 
     
#if (trees_On)
#warning "Begin trees_On\n"
#include "Tree1.inc" 
#include "TOMTREE.inc"

object {TREE scale 25 translate <5,1.5,-10>}
object {TREE scale 25 rotate 120*y translate <8,2.5,-18>}

#end

// =======================================================================
//                    Sky - clouds if sky_On.
// =======================================================================

#if (sky_On)
#warning "Begin sky_On\n"
#include "Clouds2.inc" 
object {Cloud_Cover hollow rotate 0*y rotate 4*x}
#end    
 
// ======================================================================= 
//                         City on horizon.
// =======================================================================
                      
#if (city_On)
#warning "Begin city_On\n"                      
#include "City.inc"  
object {city scale 7 rotate -40*y translate <200,-150,1200> rotate 6*y} 
#end                                

// =======================================================================
//                    An object for orientation.                                                                          
//                       Not for production.
// =======================================================================

#if (pointer_On)
#warning "Begin pointer_On\n"                                                                          
#declare pointer =
union {
        cylinder {<0,-10,0>,<0,10,0>.25 pigment {color Red}} 
        cylinder {<0,0,4>,<0,0,-4>.25 pigment {color Yellow}}  
        cylinder {<-4,0,0>,<4,0,0>.25 pigment {color Yellow}} 
        }


//sphere {< 20, 90, -31 >.5 pigment{color White}}        
//object {pointer scale 1 translate <-1,8, -16>}        // <-------------- The Camera      
object {pointer scale 1 translate <3,7.8,-11.8>}        //Chimp1
object {pointer scale 1 translate <5,5,17>}             //chimp3
object {pointer scale 1 translate <-2.3,7.6,-14.5>}     //chimp2
//cylinder {<5,5,17>,< 20, 90, -31 >.25 pigment {color White}}  
//cylinder {<-2.3,7.6,-14.5>,< 20, 90, -31 >.25 pigment {color White}}
sphere {<0,0,0>.5 pigment{color White}}

#end

#warning "\nBegin Rendering...\n"