// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#ifndef(Main_Scene)
  #include "colors.inc"
  #include "finish.inc"
  #include "furtex.inc"
#end

#declare M_Wood6A = 
color_map { 
    [0.0, 0.3 color rgb <0.25, 0.10, 0.10>*0.5
              color rgb <0.25, 0.10, 0.10>*0.5]
    [0.3, 0.6 color rgb <0.25, 0.10, 0.10>*0.5
              color rgb <0.60, 0.15, 0.10>*0.5]
    [0.6, 1.0 color rgb <0.60, 0.15, 0.10>*0.5
              color rgb <0.25, 0.10, 0.10>*0.5]
}
#declare M_Wood6B = 
color_map { 
    [0.0, 0.3 color rgbt <0.25, 0.10, 0.10, 0.00>*0.75 
              color rgbt <0.25, 0.10, 0.10, 0.40>*0.75]
    [0.3, 0.5 color rgbt <0.25, 0.10, 0.10, 0.40>*0.75
              color rgbt <0.60, 0.15, 0.10, 1.00>*0.75]
    [0.5, 0.7 color rgbt <0.60, 0.15, 0.10, 1.00>*0.75
              color rgbt <0.25, 0.10, 0.10, 0.40>*0.75]
    [0.7, 1.0 color rgbt <0.60, 0.15, 0.10, 0.40>*0.75
              color rgbt <0.25, 0.10, 0.10, 0.00>*0.75]
}
#declare P_WoodGrain6A =
pigment {
    wood 
    turbulence <0.05, 0.08, 1>
    octaves 4
    scale <0.15, .15, 1>
    translate -x*100
}

#declare P_WoodGrain6B =
pigment {
    wood  
    turbulence <0.05, 0.05, 0>
    octaves 4
    omega 0.95
    scale <0.20, 0.20, 1>             
    rotate x*20
}
#declare T_Wood6   =         
    texture { pigment { P_WoodGrain6A  color_map { M_Wood6A }}}
    texture { pigment { P_WoodGrain6B  color_map { M_Wood6B }}}


#declare CTex1 =
  texture{
    T_Wood6 scale 1/10
    finish{specular 1 roughness 0.01 reflection 0.025 metallic 0.75}
    normal{bozo 1}
  }


#declare C1 =
  box{0,<3,3,1> texture{CTex1}} // main box

#declare C2 =
  cylinder{0,z*0.98, 0.8   texture{CTex1} translate<1.5,3,0.01>} // main arch

#declare C3 = 
  box{0,<2.8,2.8,0.8> translate<0.1,0.1,0.1>} // diff interior box

#declare C4 =
  cylinder{0,z*0.9,0.7 translate<1.5,3,-0.2>} // interior/hole arch

#declare C5 =
  box{0,<1.6,4,0.16> translate<0.7,0.0,-0.05>} // diff hole door

#declare C6 =
difference{
  union{  // door
    box{0,<1.65,3,0.1>}
    cylinder{z*0.001, z*0.099, 0.825 translate <0.825,3,0>}
  }
  box{ // mirror
    0,<1,2.5,0.05>
    translate<0.325,0.325,-0.04>
    texture{pigment{White} finish{ambient 0 diffuse 0 reflection 0.9}}
    photons{
      target 1.0          // spacing multiplier for photons hitting the object
      refraction off
      reflection on
      //collect off       // ignore photons
      //pass_through      // do not influence photons
    }
  }
  rotate y*27
  texture{CTex1}
  translate<0.675,0,-0.06>
}

#declare C7 = // corner pillar
union{
  cylinder{0, y*3.25, 0.075}
  torus{0.05,0.035 translate y*3.275}
  torus{0.05,0.035 translate y*3.31}
  sphere{0,0.075 translate y*3.38}
  torus{0.05,0.05 translate y*0.04}
  torus{0.05,0.05 translate y*0.09}
  texture{CTex1}
  translate y*-0.2
}

#declare Cupboard =
union{
  difference{
    union{
      object{C1}
      object{C2}
    }
    object{C3}
    object{C4}
    object{C5}
  }
  object{C6}
  object{C7}
  object{C7 translate x*3}
  object{C7 translate z*1}
  object{C7 translate<3,0,1>}

  object{C7 translate x*0.6}
  object{C7 translate x*2.4}
  object{C7 translate <0.6,0,1>}
  object{C7 translate <2.4,0,1>}
  
  union{
    sphere{0, 1.3 scale<0.2,1,0.2> translate<1.5, 1.7, 0.5>}
    sphere{0, 1.3 scale<0.2,1,0.2> translate<1.0, 1.7, 0.5>}
    sphere{0, 1.3 scale<0.2,1,0.2> translate<2.0, 1.7, 0.5>}
    FurTex(DarkBrown, 5)
  }
  translate y*0.2
  texture{CTex1}
}  


#ifndef(Main_Scene)
    
  global_settings {
    assumed_gamma 1.0
  }
  
  
  camera {
    location  <0.0, 1.5,  0.0>
    look_at   <0.0, 1.5,  5.0>
  }
  
  sky_sphere {
    pigment {
      wrinkles
      color_map {
        [0.0 rgb <0.6,0.7,1.0>]
        [0.7 rgb <0.0,0.1,0.8>]
      }
    }
  }
  
  light_source {
    <0, 0, 0>            // light's position (translated below)
    color rgb <1, 1, 1>  // light's color
    translate <30, 30, -30>
  }
  
  // ----------------------------------------
  
  plane {
    y, 0
    pigment { color rgb <0.7,0.5,0.3> }
  }
  
  
  object{Cupboard translate <-1.5,0,6>}
#end  



