#include "transforms.inc"

#declare IceTex=
texture{
  pigment{rgbf 0.75}
  finish{reflection 0.25}
}

// tree height, branch start, random seed, bark text., fol. text.
#macro MakeTree(TH,BS,TRS,BTex,FTex)

  #declare BArr = array[2000]
  #declare BArrC = 0;
  #declare MeshArray = array[20000]
  #declare MArrC = 0;
  #declare TRand1 = seed(TRS);

  #local BC = 0;
  #local BTot = (TH - BS)*(7+rand(TRand1)*2);
  #while(BC < BTot)
    #declare BH = rand(TRand1)*(TH-BS) + BS;
    #local BC = BC + 1;
    MakeBranch(BH,TH,TH/3)
  #end
  #declare Trunk =
    cone{0,TH*0.02,y*TH,TH*0.005 texture{BTex}}

  #local BC = 0;
  #declare Branches =
    union{
      #while(BC < BArrC)
        object{BArr[BC]}
        #local BC = BC + 1;
      #end
      texture{BTex}
    }

  #local BC = 0;
  #declare Foliage = 
    mesh{
      #while(BC < MArrC)
        triangle{MeshArray[BC + 0],MeshArray[BC + 1],MeshArray[BC + 2]}
        #local BC = BC + 3; 
      #end
      texture{FTex}
    }

  #undef BArr
  #undef MeshArray

#end

#macro MakeBranch(BH,TH,BBL) //branchheight, Treeheight, basebranchlength

  #ifndef(BArrC)
    #declare BArr = array[2000]
    #declare BArrC = 0;
    #declare MeshArray = array[10000]
    #declare MArrC = 0;
    #declare TRand1 = seed(4357);
  #end

  #declare BYRot = 360*rand(TRand1);
  #local BHR = max(0.1,(TH-BH)/TH + (rand(TRand1)-0.5)/5);
  #local BL = BBL * BHR;
  #local STot = max(1,int(BL*4));
  #local SC = 0;
  #declare P1 = <0,0,0>;
  #declare BArr[BArrC] =
  #local DoFol = 1;
  #if(STot = 1)
    object{
  #else
    union{
  #end
  #while(SC < STot)
    #local SC = SC + 1;
    #local XShift = P1.x + (rand(TRand1)*0.2 - 0.1);
    #local YShift = P1.y + (rand(TRand1)*0.1);
    #local ZShift = P1.z + max(0.05,(rand(TRand1)*0.5));
    #declare P2 = <XShift, YShift, ZShift>;
    cylinder{P1, P2, BHR * 0.05}
    
    #if(DoFol = 1 | rand(TRand1) > 0.95)
      MakeTriangs(P1,P2, BH, BHR)
      #local DoFol = 0;
    #else
      #local DoFol = DoFol + 1;
    #end
    #declare P1 = P2;
  #end
  rotate y*BYRot
  translate y*BH
  }
  #declare BArrC = BArrC + 1;


#end

#macro MakeTriangs(P1,P2, BH, BHR)
  #local BP2 = P2-P1;

  #local MCA = array[12] 
  #local SideSwitch = 1;  
  #local Side1 = true;
  #local MVC = 0;
  #local BS = 0.25*BHR + 0.25;
  #while(Side1)
    #if(SideSwitch = -1) #local Side1 = false; #end
    #local MCA[MVC+0] = <0,0,0>;
    #local MCA[MVC+1] = <(1.25+R(0.25))*SideSwitch, -RP(1.0), -1.00+R(0.25)>*BS;
    #local MCA[MVC+2] = <(1.00+R(0.25))*SideSwitch,  RP(0.5), -0.25+R(0.25)>*BS;
    #local MCA[MVC+3] = <(1.50+R(0.25))*SideSwitch,  RP(0.5),  0.75+R(0.25)>*BS;
    #local MCA[MVC+4] = <(3.00+R(0.25))*SideSwitch, -RP(1.0),  2.00+R(0.25)>*BS;
    #local MCA[MVC+5] = <(3.00+R(0.25))*SideSwitch, -RP(1.0),  1.25+R(0.25)>*BS;
    #local MVC = MVC + 6;
    #local SideSwitch = -1;  
  #end

  #local MVC = 0;
  #while(MVC < 12)
    #local MCA[MVC] = vtransform(MCA[MVC], Reorient_Trans(<R(0.1),R(0.1),1>,BP2));
    #local MCA[MVC] = vtransform(MCA[MVC], transform{translate P1});
    #local MCA[MVC] = vtransform(MCA[MVC], transform{translate y*BH});
    #local MCA[MVC] = vtransform(MCA[MVC], transform{rotate y*BYRot});
    #local MVC = MVC + 1;
  #end    

  //MakeTriang(0,1,2,0,2,3,0,3,4,2,3,5)
  #local SideSwitch = 0;
  #while(SideSwitch <= 6)
    #declare MeshArray[MArrC] = MCA[0 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[1 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[2 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[0 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[2 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[3 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[0 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[3 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[4 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[2 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[3 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #declare MeshArray[MArrC] = MCA[5 + SideSwitch];
    #declare MArrC = MArrC + 1;

    #local SideSwitch = SideSwitch + 6;
  #end    

#end

#macro R(Range)
  #local Val = rand(TRand1)*Range - (Range/2);
//  #debug concat("R:  ",str(Val,2,2),"\n")
  Val
#end

#macro RP(Range)
  #local Val = rand(TRand1)*Range;
//  #debug concat("RP: ",str(Val,2,2),"\n")
  Val
#end