// Persistence of Vision Ray Tracer Scene Description File
// File: bowl.inc
// Vers: 3.5
// Desc: Worldbowl for the worldbowl-image IRTC 2002, Jan-Feb
// Date: 13.2.02
// Auth: Tim Nikias Wenclawiak

//Note: This include needs macros as given in "bowlmacs.inc"

/*******************  Various Parameters (dont touch!) *******************/
#declare Planar_Height = .5; //lowest level of heightfield inside the bowl
#declare Water_Height = .65; //height of water
#declare HF_Size = <5,4,5>; //scaling for the heightfield
#declare Bowl_Scale=<2,1,1>; //scaling for the bowl
#declare Light_Direction = vnormalize(<1,-1.5,0>); //Direction the lamp's light is pointing towards: needed for the lightarm

//Nodes for Cable and Lightarm
#declare Cable_Begin=vrotate(<1.1-(1.1-sqrt(1.1-pow(.5,2)))*.5,.5*.5,0>*<.99,1,1>,y*-45)*Bowl_Scale;
#declare Lightarm_End=<-1.1+(1.1-sqrt(1.1-pow(.5,2)))*.5,.5*.5,0>*<-.99,1,1>*Bowl_Scale;

//Cloud settings
#declare Cloud_Amount = 50; //Amount of discs used for simulation of volumetric clouds
#declare Cloud_Beg_Height = .5; //Initial Height in Bowl (with 0 being equator)
#declare Cloud_End_Height = .75; //End height

/*******************  Spotlight from Bowl  *******************/
#declare Light_Direction = vnormalize(<-1,-1.5,0>);
#declare Light_Bulb=sphere{0,.1 pigment{rgb 8}finish{ambient 100 diffuse 0}}

//If Light is on, we place the lightsources
#if (Light)

#declare The_Spotlight=
union{
//Spotlight pointing at bowl
light_source{<1,2.5,0> rgb 5
 spotlight point_at <0,1,0> radius 20 falloff 45 tightness .6
 fade_power 2 fade_distance .7
 #if (Spot_AreaLights>1)
  area_light x,y,Spot_AreaLights,Spot_AreaLights orient circular
 #end
 looks_like{Light_Bulb}
}
//Spotlight pointing inside lampshade
light_source{<1,2.5,0>+Light_Direction rgb 8
 spotlight point_at <1,2.5,0> radius 15 falloff 16 tightness 1
 fade_power 2 fade_distance .7
 media_interaction off
}
//"Radiosity" (shadowless) lightsource
light_source{<1,2.5,0> rgb 3*<.8,1,1>
 fade_power 2 fade_distance .2 shadowless
 media_interaction off
 }
}

#else
//If Light is off, we place a lightbulb!
#declare The_Spotlight=
//If its off, we place a very simple glass lightbulb 
 sphere{0,.1
  pigment{rgbt <0,0,0,.9>}
  interior{ior 1.64}
  finish{reflection{.2,.4 fresnel falloff 2 exponent .9} specular 1 roughness .001}
  translate <1,2.5,0>
  }
#end


/*******************  Bowlbase - Textures and Interiors...  *******************/

//The grainy wood-like material
#declare Bowlbase_Material=
 material{
  texture{
   pigment{agate poly_wave 2 color_map{[0 rgb <.3,.2,0>][1 rgb <.1,.05,0>]}scale .5 rotate x*24 rotate y*12
    }
   finish{specular 1 roughness .0001 reflection{0,.4 falloff 2 exponent .9}}
   }
  interior{}
  }
//The plastic-like material
#declare Cable_Material=
 material{
  texture{
   pigment{rgb .3}
   finish{specular .9 roughness .1}
   }
  }
//The metal material for the light's arm
#declare Lightarm_Material=
 material{
  texture{
   pigment{rgb <.7,.6,.5>}
   finish{specular 1 roughness .001 reflection{.3,.8 metallic .5 falloff 2 exponent .7}}
   }
  }

/*******************  Earth - Textures and Interiors...  *******************/
//Surfaces for the earth
#declare OceanFloor_Texture = texture{pigment{rgb .5}}
#declare Sand_Texture = texture{pigment{rgb <.6,.5,.3>}}
#declare Rock_Texture = texture{pigment{granite color_map{[0 rgb .1][.5 rgb .3][1 rgb .2]} scale .03}}
#declare Grass_Texture = texture{pigment{marble color_map{[0 rgb y*.3][.5 rgb y*.4][1 rgb y*.3]}rotate y*45 scale .05 turbulence .3}finish{specular .1 roughness .03}}
#declare Snow_Texture = texture{pigment{rgb 2}}

//Different Slopes (used for height-according slope-texturing)
#declare Earth_Surface_Tex_0=texture{slope{y,.5,1} texture_map{[0 Rock_Texture][.5 Sand_Texture][1 OceanFloor_Texture]}}
#declare Earth_Surface_Tex_1=texture{slope{y,.5,1} poly_wave 3 texture_map{[0 Rock_Texture][.3 Grass_Texture][.5 Grass_Texture][1 Sand_Texture]}}
#declare Earth_Surface_Tex_2=texture{slope{y,.5,1} texture_map{[0 Rock_Texture][.4 Rock_Texture][.5 Grass_Texture][1 Grass_Texture]}}
#declare Earth_Surface_Tex_3=texture{slope{y,.5,1} texture_map{[0 Rock_Texture][.6 Snow_Texture][1 Snow_Texture]}}

//Gradient y = height-according use of Slope-Maps
#declare Earth_Surface_Tex=
 texture{gradient y  
 texture_map{
 [0 Earth_Surface_Tex_0][.15 Earth_Surface_Tex_0]
 [.175 Earth_Surface_Tex_1][.25 Earth_Surface_Tex_1]
 [.3 Earth_Surface_Tex_2][.35 Earth_Surface_Tex_2]
 [.5 Earth_Surface_Tex_3][.9 Earth_Surface_Tex_3]
 [.91 Earth_Surface_Tex_0][1 Earth_Surface_Tex_0]
 }
 warp{turbulence .1 lambda 1.5 octaves 3 omega .2}
 scale <1,1,1> translate y*(Planar_Height-1)
 }
 
//Volume of earth
//Pigments for the volume of the earth (interior of earth seen through glassbowl)
#declare Dirt_Pig_1 = pigment{bozo color_map{[0 rgb <.3,.2,0>][.5 rgb .4][1 rgb <.1,.05,0>]}turbulence .7 octaves 8 lambda 3 scale .1}
#declare Dirt_Pig_2 = pigment{granite color_map{[0 rgb .2][1 rgb 0]}scale .1}
#declare Earth_Subsurface_Pig=pigment{gradient y pigment_map{[0 Dirt_Pig_2][.5 Dirt_Pig_1][1 Dirt_Pig_1]}}
//Texture-Wrap-Up
#declare Earth_Subsurface_Tex=texture{
 pigment{Earth_Subsurface_Pig}
 }

/*******************  Ocean - Textures and Interiors...  *******************/

//Material for the volume of the ocean
#declare Ocean_Material=
 material{
  texture{pigment{rgbt <0,0,.4,.8>}}
  interior{fade_power 3 fade_distance .1 fade_color <0,.2,.5>}
  }

//Texture for the surface of the ocean
// Needed only for turbulencing of refraction, waves-simulation
// The color is supplied from the base Ocean_Material
#declare Ocean_Texture=texture{
 pigment{rgbt <0,0,0,1>}
 normal{average normal_map{
 [1 bozo .8 
  warp{turbulence .3 lambda 3 omega .5 octaves 8}
  warp{turbulence .1 lambda 2 omega .9 octaves 8}]
 [1 bozo .6 scale .2
  warp{turbulence .3 lambda 3 omega .5 octaves 8}
  warp{turbulence .1 lambda 2 omega .9 octaves 8}]
  }scale .2}
 finish{specular 1 roughness .0005}
}


/*******************  Earth - Functions and pigments *******************/

#declare Mountain_Move = <.75,0>;   // < Right-Left , Back-Front >
#declare Mountain_Scale = <1,1,.5>; //Scales the texture for the heightfield
#declare HF_Size_X=HF_Size.x; //Predefined dot operatos, POV doesn't acept them in functions
#declare HF_Size_Z=HF_Size.z; //Predefined dot operatos, POV doesn't acept them in functions

//Pigments for the heightfield
#declare HF_Pig_1a=pigment{spherical color_map{[0 rgb 0][.2 rgb .1][1 rgb 0]}}
#declare HF_Pig_1b=pigment{bozo color_map{[0 rgb 0][.7 rgb .3][1 rgb .6]} scale .175 translate 2 warp{turbulence .3 omega .4 octaves 10 lambda 3}}
#declare HF_Pig_1=pigment{average pigment_map{[1 HF_Pig_1a][1 HF_Pig_1b]} scale <.5,1,1>}
#declare HF_Pig_2=pigment{rgb 0}

//The pigment-preparation for the funtion
#declare HF_Pigment = 
 pigment{spherical poly_wave 2 
  scale <Mountain_Scale.x,Mountain_Scale.z,1>
  translate <1,1,0>+x*Mountain_Move.u+y*Mountain_Move.v
  scale .5
   pigment_map{
    [ 0 HF_Pig_2]
    [ 1 HF_Pig_1]
    }
  } 
//The function for the heightfield
#declare HF = function{ pigment{HF_Pigment}}

/*******************  Earth - Object declaration *******************/
#declare Earth_Obj=
union{
intersection{
 height_field{
  function HF_Detail,HF_Detail{HF(x,y,z).x}
  //smooth (as found near January 15.) can result in inverse normal vectors: avoid!
  translate <-.5,0,-.5> scale HF_Size
  translate y*(Planar_Height-1)
  texture{Earth_Surface_Tex}
  }
 sphere{0,1 scale Bowl_Scale texture{Earth_Subsurface_Tex}}
 hollow
 }

disc{y*((Planar_Height-1)+.0001),<0,1,0>, sqrt(-pow((Planar_Height-1),2)+pow(1,2))
 hollow
 scale <1,0,1>*Bowl_Scale+y
 texture{Earth_Surface_Tex}
 }
}
/*******************  Ocean - Object declaration  *******************/
#declare Ocean_Obj=union{
//Ocean "Volume"
intersection{
 sphere{0,.9999 scale Bowl_Scale hollow}
 box{-Bowl_Scale,Bowl_Scale*<1,0,1>+y*(Water_Height-1) hollow}
 hollow
  material{Ocean_Material}
  }
//Ocean "Surface"
disc{y*((Water_Height-1)+.00001),<0,1,0>, sqrt(-pow((Water_Height-1),2)+pow(1,2))
 hollow
 scale <1,0,1>*Bowl_Scale+y
 texture{Ocean_Texture}
 interior{ior 1.45}
 }
}
/*******************  Bowl - Object declaration  *******************/
#declare Bowl_Obj=
difference{
 sphere{0,1.05
 }
 sphere{0,1.01}
 //The outside has reflection
 texture{
  pigment{rgbt <.5,.75,1,.93>}
  finish{specular 1 roughness .001 reflection{.03,.7 fresnel exponent .8 falloff 2}}
 }
 //The inside doesn't (saves a few tracing steps)
 interior_texture{
  pigment{rgbt <.5,.75,1,.93>}finish{specular 1 roughness .001}
  }
 scale Bowl_Scale
 //The object has one defined interior
 interior{ior 1.65 fade_distance .5 fade_power 2 fade_color <0,.1,.2>}
 //Photons on the glassbowl don't have enough effect to be worth it
 //photons{target reflection on refraction off}
 }

/*******************  Atmosphere - Object declaration  *******************/
//Not used in final version (and not likely to be used ever),
//because the effect is to low, but the glass seems to be murky
#declare Atmos_Obj=
//Media
 difference{
 sphere{0,1.005}
 box{-1.2,<1.2,(Water_Height-.99),1.2>} 
  hollow pigment{rgbt <0,0,0,1>}
  interior{media{scattering{2,<.015,.016,.02>*.75} intervals 1 samples 1,1 method 3}}
  scale Bowl_Scale
  no_reflection
  }
/*******************  Clouds - Object declaration  *******************/

//The bezier-spline for the thickening of the clouds
#declare Tiny_Clouds_Volume = array[6]
{
 <  0,.5,0>,<  0,-.25,0>, //Actual-Node, Direction
 <.35, 0,0>,<.25,   0,0>, //Actual-Node, Direction
 <  1, 1,0>,<  0,   1,0>  //Actual-Node, Direction
}

#declare Cloud_Obj=union{
 
 //A loop to place the clouds
 #declare C=0;
 #while (C<Cloud_Amount)
  //Height, preprocessed since it is needed to calculate the radius as well
  #declare Disc_Height=(Cloud_Beg_Height+(Cloud_End_Height-Cloud_Beg_Height)/Cloud_Amount*C);
  disc{y*Disc_Height,<0,1,0>, sqrt(-pow((Disc_Height),2)+pow(1,2))
   hollow //to assure that media works as expected
   scale <1,0,1>*Bowl_Scale+y
 //Texture taken from (and then adjusted for this scene) tranquil.pov, a recent image of mine
 texture{
  //For one, we lighten the overall color during steps, as well as decreasing the amount (using the y-value of the above defined bezier-spline)
  pigment{bozo color_map{
  [0 rgbt <.9,.85,.7,.8>]
  [.32-.2*Spline_Pos(Tiny_Clouds_Volume,C/Cloud_Amount).y rgbt <1,.85,.7,.9>]
  [.38-.2*Spline_Pos(Tiny_Clouds_Volume,C/Cloud_Amount).y rgbt 1]
  [1 rgbt 1]
  }
   translate 1450 //picks some random position inside the pattern
   //Double turbulence achieves nice, crinkly edges
   warp{turbulence .3 lambda 5 omega .5 octaves 4}
   warp{turbulence .3 lambda 5 omega .5 octaves 4}
   scale .25
   }
  //They also get higher ambience as if they get more sunlight
  finish{ambient 1 diffuse .9/*+2*C/Cloud_Amount*/}
  } //no_shadow
  //Only every fourth disc will be reflected
  #if (mod(C,4)!=0) no_reflection #end
  }
 #declare C=C+1;
 #end
 hollow
 }

/*******************  Bowlbase - Object declaration *******************/
#declare Bowlbase_Obj=
union{
 union{
  difference{
   union{
    cone{y*.5,sqrt(1.1-pow(.5,2)), 0,1.1 scale Bowl_Scale}
    torus{sqrt(1.1-pow(.5,2)),.05 scale Bowl_Scale translate y*.5}
    }
   sphere{0,1.051 scale Bowl_Scale translate y*1.05}
   }
  torus{1.1,.05 scale Bowl_Scale*<1,.5,1> translate y*.025}
  material{Bowlbase_Material}
  }
 sphere{0,.1 translate Cable_Begin material{Cable_Material}}
 sphere{0,.1 translate Lightarm_End material{Lightarm_Material}}
 }

/*******************  Cable - Object declaration *******************/
//Attached to bowl, difficult to handle with translation and rotation...
//#declare Cable_Spline=array[6] {Cable_Begin,<0,0,.5>, <3,.05,.5>,<0,0,-.5>, <4.5,0,-1>,<-.2,0,.40>}
#declare Cable_Spline=array[6] {<8.45,6.05,7>,<.6,0,-.5>, <9,6.05,5>,<-.2,-.2,-.5>, <9.45,0,5.1>,<-.2,0,.40>}
//Spline_Translate(Cable_Spline,<0,6,0>)
#declare Cable_Obj=union{Show_Spline(Cable_Spline,.05,200) material{Cable_Material} }

/*******************  Lightarm - Object declaration *******************/
#declare Lightarm_Begin=<1,2.5,0>-Light_Direction*.25;
#declare Lightarm_Spline=array[6] {Lightarm_Begin,-Light_Direction,<2.5,1.25,0>,<0,-1,0>, Lightarm_End,<-.5,0,0>}

#declare Lightarm_Obj=
union{
 union{Show_Spline(Lightarm_Spline,.05,500) material{Lightarm_Material} }
 union{
  cone{0,.04 z*-.3,.3 open}
  cone{0,.04 z*-.3,.26 open}
  torus{.28,.02 rotate x*90 translate z*-.3}
  Point_at(Lightarm_Begin,Lightarm_Begin+Light_Direction)
  material{Lightarm_Material}
  }
}

/*******************  Object placement  *******************/

 object{The_Spotlight rotate Bowl_Rotation translate Bowl_Position}
 #if (Earth)      object{   Earth_Obj translate y*1.05 scale <-1,1,1> rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Ocean)      object{   Ocean_Obj translate y*1.05 rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Clouds)     object{   Cloud_Obj translate y*1.05 scale <-1,1,1> rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Glass_Bowl) object{    Bowl_Obj translate y*1.05 rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Atmosphere) object{   Atmos_Obj translate y*1.05 rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Bowlbase)   object{Bowlbase_Obj rotate Bowl_Rotation translate Bowl_Position} #end
 #if (Lightarm)   object{Lightarm_Obj rotate Bowl_Rotation translate Bowl_Position} #end
 //Doesn't need the rotation and translation, since cable is just a prop, not really
 //connected to the glassbowl
 #if (Cable)      object{   Cable_Obj /*rotate Bowl_Rotation translate Bowl_Position*/} #end

