// Persistence of Vision Ray Tracer Scene Description File
// File: bowlmacs.inc
// Vers: 3.5
// Desc: Macros needed for the worldbowl-image
// Date: 27.01.01
// Last Update: 10.2.01
// Auth: Tim Nikias Wenclawiak

/**************************************  Spline-Related-Macros  **************************************/

/***********************/
/*****Spline_Translate**/
/***********************/
#macro Spline_Translate(Spline_Array,Translation)
 #local Saved_Length=dimension_size(Spline_Array,1);
  //Loop that jumps from position-node to position-node (C+2)
  #local C=0; #while (C<Saved_Length)
   #declare Spline_Array[C]=Spline_Array[C]+Translation;  
  #local C=C+2; #end
#end

/***********************/
/*****Spline_Scale******/
/***********************/
#macro Spline_Scale(Spline_Array,Scalement)
 #local Saved_Length=dimension_size(Spline_Array,1);
  //Loop that jumps from position-node to position-node (C+2)
  #local C=0; #while (C<Saved_Length)
   #declare Spline_Array[C]=Spline_Array[C]*Scalement;  
  #local C=C+1; #end
#end

/***********************/
/*****Spline_Rotate*****/
/***********************/
#macro Spline_Rotate(Spline_Array,Rotation)
 #local Saved_Length=dimension_size(Spline_Array,1);
  //Loop that jumps from position-node to position-node (C+2)
  #local C=0; #while (C<Saved_Length)
   #declare Spline_Array[C]=vrotate(Spline_Array[C],Rotation);  
  #local C=C+1; #end
#end


/***********************/
/*******Show_Spline*****/
/***********************/
#macro Show_Spline(Spline_Array,Thickness,Detail)
  //Loop running through the different nodes
  #local Slice_Val = 0;
  #while (Slice_Val <= Detail)
   #local Actual_Pos = Spline_Pos(Spline_Array,Slice_Val/Detail);
    sphere{Actual_Pos,Thickness}
    #ifdef (Former_Pos)
     #if (vlength(Former_Pos-Actual_Pos)!=0)
     cylinder{Former_Pos,Actual_Pos,Thickness}
     #end
    #end
   #local Former_Pos = Actual_Pos;
  //End of loop
  #local Slice_Val = Slice_Val+1;
 #end
#end

/***********************/
/******Spline_Pos*******/
/***********************/
#macro Spline_Pos(Spline_Array,Node_Mover)
 //Amount of interpolations
 #local Spline_Nodes = dimension_size(Spline_Array,1)/2;
 #local TooFar_Check=0;
 //Node_Mover-Corrections, keeps them in boundaries
 #if (Node_Mover > 1) #declare Node_Mover=1; #declare TooFar_Check=1; #end
 #if (Node_Mover < 0) #declare Node_Mover=0; #end
 #local Interpol_Section = 0;
 #local Interpol = Node_Mover*(Spline_Nodes-1);
 #while (Interpol > 1)
  #local Interpol_Section = Interpol_Section+2;
  #local Interpol=Interpol-1;
 #end
 #local Bezier_Pos=
  Spline_Array[Interpol_Section]*pow(1-Interpol,3)+
  3*(Spline_Array[Interpol_Section+1]+Spline_Array[Interpol_Section])*pow(1-Interpol,2)*Interpol-
  3*(Spline_Array[Interpol_Section+3]-Spline_Array[Interpol_Section+2])*(1-Interpol)*pow(Interpol,2)+
  Spline_Array[Interpol_Section+2]*pow( Interpol ,3);
 #if (TooFar_Check)
  #local Bezier_Pos=Bezier_Pos+Bezier_Node[Bezier_Nodes*2-1]*.01;
 #end
 //Return the Position-Vector
 Bezier_Pos
#end

/**************************************  Positioning-Related-Macros  **************************************/

/*Point_at Description
By invoking Point_at with a desired position and target for
an object, the macro will position the object in which the
macro was called and rotate it to point at the target, assuming
that the object is initially pointing towards -z.
*/
#macro Point_at(Position,Target)
#local Head_Vec=Target-Position;

//X-angle-calculation
#local X_Head_Vec = <1,0,1>*Head_Vec;
#if (vlength(X_Head_Vec) = 0)
 #local X_Rot_Float = 0; #else
 #local X_Rot_Float = degrees(acos( vdot(Head_Vec,X_Head_Vec) / (vlength(Head_Vec)*vlength(X_Head_Vec)))); #end

//Y-angle-calculation
#local Y_Head_Vec = <1,0,1>*Head_Vec;
#if (vlength(Y_Head_Vec) = 0)
 #local Y_Rot_Float = 0; #else
 #local Y_Rot_Float = degrees(acos( vdot(-z,Y_Head_Vec) / (vlength(-z)*vlength(Y_Head_Vec)))); #end

//Pending on Value of X, Y-Rotation is applied positive or negative
#if (Head_Vec.x > 0) #local Y_Rot_Float = -Y_Rot_Float; #end
//Pending on Value of Y, X-Rotation is applied positive or negative
#if (Head_Vec.y < 0) #local X_Rot_Float = -X_Rot_Float; #end

//Now we place it all into a useful vector!
#local Header_Rot = <X_Rot_Float, Y_Rot_Float, 0>;

//For Y-Parallel views we need specifications
#if (Head_Vec.x = 0 & Head_Vec.y < 0 & Head_Vec.z =0)
 #local Header_Rot = <-90,0,0>; #end
#if (Head_Vec.x = 0 & Head_Vec.y > 0 & Head_Vec.z =0)
 #local Header_Rot = <90,0,0>; #end

//Make the calculated adjustments...
 rotate Header_Rot
 translate Position
#end
