// Persistence of Vision Ray Tracer Scene Description File
// File: items.inc
// Vers: 3.5
// Desc: Items for the worldbowl-image IRTC 2002, Jan-Feb
// Date: 13.2.02
// Auth: Tim Nikias Wenclawiak

//Note: This include needs macros as given in "bowlmacs.inc"

/*******************  Flowers  *******************/

#declare Flower_Bend=<-40,30,0>;

//Initialize Spline for the stem
#declare Flower_Stem=array[4] {<0,0,0>,vrotate(<0,-2,0>,Flower_Bend), <0,-6,0><0,-1,0>}

//Parameters
#declare Bend_Modifier=.45;
#declare Pedal_Amount=36;
#declare Encircle_Mod=6;
#declare Vase_Material=
material{
 texture{pigment{rgb 1} finish{ambient .3 diffuse .9 brilliance 1.2 specular 1.3 roughness .01 reflection{.01,.6 falloff 2 exponent .97}}}
 }

//Clipping Object
#declare Base_Form=
prism {
    cubic_spline
    0, 1, //Height-Parameters
    7, //Control Points
    < 0, -1>,
    < 0,  0>,
    <-.75,  1.25>,
    < 0,  2>,
    < .75,  1.25>,
    < 0,  0>
    < 0, -1>
   translate z*-1 //Centers the prism
  }

//Clipped-Sphere
#declare Pedal_Obj=
sphere{0,1
 clipped_by{Base_Form scale <1,0,-1>*Bend_Modifier+<0,1.01,0> rotate x*90}
 translate y*Bend_Modifier
 translate z*-(1-Bend_Modifier/6)
 scale 1/Bend_Modifier
 hollow
 }

#declare C_Max=Pedal_Amount;
#declare Rand=seed(2);
 #declare B=0;
 #declare Sc=1/(Pedal_Amount/Encircle_Mod);

//Loop to place the leafs
#declare Flower_Top=union{
#declare C=0; #while (C<C_Max)
 #declare A=C/C_Max;
 
 #if (mod(C,Encircle_Mod)=0 & C!=0) #declare B=B+Sc; #end
 
 object{Pedal_Obj
  pigment{gradient y poly_wave 1+A
   color_map{
   [0 rgb <.8,.6,.6>]
   [1 rgb <.8,.7,.7>-<-.1,.5,.65>*A]
   } scale 2}
  normal{wrinkles .01 no_bump_scale scale .2}
  finish{specular .8 roughness .05 ambient <3,2,2> diffuse 1}

  rotate x*(40-45*B+(rand(Rand)*2-1)*6)
  scale (1-.8*B)*<1-.5*B,1,1>
  translate <0,.65*A+.05*rand(Rand),(.5-.5*A)>
  rotate y*(60*C+(rand(Rand)*2-1)*10)
  }
 
#declare C=C+1; #end
scale .5
rotate y*360*rand(Rand)
rotate Flower_Bend
translate y*6
}

//Flower's stem
#declare Flower_End=
union{
 Show_Spline(Flower_Stem,.1,50)
 pigment{rgb y}
 finish{specular .5 roughness .04 brilliance 2}
 translate y*6
 hollow
 }

//Object-Declaration
#declare Flowers_Obj=
union{
//Smaller flower
union{
 object{Flower_Top}
 object{Flower_End}
 rotate <-18,0,10>
 }
//Bigger flower
union{
 object{Flower_Top}
 object{Flower_End}
 scale <-1,1,1>*1.05
 rotate <-18,0,-10>
 rotate y*20
 }
//Vase
lathe {
    cubic_spline 7,
    <-1,0>, <0,0>, <1,0>, <1.25,2>, <.75,3>, <1,4>, <.75,4>
 material{Vase_Material}
 hollow}
//Adjust to fit scaling of worldbowl
scale .2
}

/*******************  Notebook  *******************/
/*****  Notebook-Parameters  *****/
//Splines define the curled page's sides
#declare Notes_Left_Edge=array[6]
{ <0,.05,0>,<0,.75,0>, <-.2,0,0>,<-.1,0,-1>, <-.4,0,-2>,<-.1,0,-1>}
#declare Notes_Right_Edge=array[6]
{ <0,.05,0>,<0,.3,0>, <-.2,0,0>,<0,0,-.6>, <-.5,0,-2.25>,<0,0,-1>}
//Move away from center using one of my macros
Spline_Translate(Notes_Left_Edge,<-1,0,0>)
Spline_Translate(Notes_Right_Edge,<1,0,0>)

//Detail on mesh of "flapped" page
#declare Paper_Detail=500;
//Tiny curl on written page
#declare Page_Detail=60;
#declare Curl_Amount=110;
#declare Edge_Length=.25;

//Object-Declaration and modelling
#declare Notebook_Obj=union{

mesh{
//Loop for the "flapped" page
#declare C=0;
#while (C<=Paper_Detail)
 //After first pass, we have data to be saved
 #if (C!=0)
  #declare Pos_C=Pos_A;
  #declare Pos_D=Pos_B;
 #end
 //Always move onwards on the splines
 #declare Pos_A=Spline_Pos(Notes_Left_Edge,C/Paper_Detail);
 #declare Pos_B=Spline_Pos(Notes_Right_Edge,C/Paper_Detail);
 //Place triangles only after first pass
 #if (C!=0)
  #declare Mid_Way=(Pos_A+Pos_D)/2;
  triangle{Pos_A,Pos_C,Mid_Way}
  triangle{Pos_B,Pos_D,Mid_Way} 
  triangle{Pos_A,Pos_B,Mid_Way} 
  triangle{Pos_C,Pos_D,Mid_Way} 
 #end
#declare C=C+1;
#end
pigment{rgb 1} finish{diffuse 1 ambient .2 }
}

//Main part of notebook with image_map from "Loveletters"
box{<-1,0,0><1,.05,-2.66>
 pigment{image_map{png "dearlynn.png"} rotate x*90 translate <-.5,0,1> scale <2,1,2.66>}
 finish{diffuse 1 ambient .2 }
 }

//Calculated Curl-Parameters
#declare Curl_Width=sqrt( pow(Edge_Length,2)*2 );
#declare Curl_Depth=sqrt( pow(Edge_Length,2)-pow(Curl_Width/2,2) );
#declare Curl_MidPos=vrotate(<0,0,Curl_Depth>,y*-45);
#declare Sec_Length=Curl_Depth/Page_Detail;

//The tiny curl
union{
 //A loop builds the curl...
 #declare A=0; #while (A<Page_Detail)
  #declare Act_Width=Curl_Width-Curl_Width*A/Page_Detail;
  #declare Nex_Width=Curl_Width-Curl_Width*(A+1)/Page_Detail;
  //Either union with two triangles and missing closing bracket...
  #if (A!=Page_Detail-1)
   union{
    triangle{<Act_Width/2,0,0><-Act_Width/2,0,0><Nex_Width/2,0,-Sec_Length>}
    triangle{<Nex_Width/2,0,-Sec_Length><-Nex_Width/2,0,-Sec_Length><-Act_Width/2,0,0>}
  //...or triangle-syntax with missing last bracket
  #else
   triangle{<Act_Width/2,0,0><-Act_Width/2,0,0><0,0,-Sec_Length>
  #end
  //The closing bracket is found after the forward-kinematics, for either union or triangle
  /*Forward kinematics-technique*/
   #declare B=0; #while (B<=A)
    rotate x*Curl_Amount/Page_Detail
    translate -z*Sec_Length  
   #declare B=B+1; #end
  //The above mentioned closing bracket
  } 
 #declare A=A+1; #end
 //Correct placement of curl
 rotate y*-45
 translate <1,.05,-2.66>+Curl_MidPos
 pigment{rgb 1} finish{diffuse 1 ambient .2 }
}

//Closing the union for the object-declaration
}

/*******************  Pencil  *******************/

//Calculate vectors in 3D...
#declare Pen_EdgeA=vrotate(<0,0,1>,y*60);
#declare Pen_EdgeB=vrotate(<0,0,1>,y*120);
#declare Pen_EdgeC=vrotate(<0,0,1>,y*180);
#declare Pen_EdgeD=vrotate(<0,0,1>,y*240);
#declare Pen_EdgeE=vrotate(<0,0,1>,y*300);
#declare Pen_EdgeF=vrotate(<0,0,1>,y*360);
//Conevert them to UV-Vectors...
#declare Pen_EdgeA=<Pen_EdgeA.x,Pen_EdgeA.z>;
#declare Pen_EdgeB=<Pen_EdgeB.x,Pen_EdgeB.z>;
#declare Pen_EdgeC=<Pen_EdgeC.x,Pen_EdgeC.z>;
#declare Pen_EdgeD=<Pen_EdgeD.x,Pen_EdgeD.z>;
#declare Pen_EdgeE=<Pen_EdgeE.x,Pen_EdgeE.z>;
#declare Pen_EdgeF=<Pen_EdgeF.x,Pen_EdgeF.z>;

#declare Pencil_Obj=
union{
//The sharpened part of the pencil
intersection{
 prism{ linear_spline 0,3, /*Height*/ 7,
  Pen_EdgeA,Pen_EdgeB,Pen_EdgeC,Pen_EdgeD,Pen_EdgeE,Pen_EdgeF,Pen_EdgeA
  rotate z*90 rotate y*90
  pigment{rgb <.5,.35,0>}
  finish{specular 1 roughness .05 metallic .5}
  }
 cone{0,.01 z*3.01,1 pigment{gradient z color_map{[0 rgb .01][.3 rgb .01][.3 rgb <.1,.06,0>][1 rgb <.1,.06,0>]} scale 3.1 }}
 }
//The remaining, "unharmed" part
prism{ linear_spline 3,20, 7,
  Pen_EdgeA,Pen_EdgeB,Pen_EdgeC,Pen_EdgeD,Pen_EdgeE,Pen_EdgeF,Pen_EdgeA
  rotate z*90 rotate y*90
  pigment{rgb <.5,.35,0>}
  finish{specular 1 roughness .05 metallic .5}
  }
//Centering and scaling the object
translate z*-10 scale .05
}

/*******************  Object Placement  *******************/
#if (Flowers) object{Flowers_Obj rotate y*30 translate <1.5,6.7,9.3>} #end
#if (Pencil) object{Pencil_Obj rotate y*160 translate <4,6.06,6.75>} #end
#if (Notebook) object{Notebook_Obj scale .75 rotate y*6 translate <3.8,6.0001,7.75>} #end
