// Persistence of Vision Ray Tracer Scene Description File
// File: real_sky.inc
// Vers: 3.5
// Desc: Background sky (with moon) for the worldbowl-image IRTC 2002, Jan-Feb
// Date: 13.2.02
// Auth: Tim Nikias Wenclawiak

//Note: This include needs macros as given in "bowlmacs.inc"

#declare Moon_Pig = pigment{bozo color_map{[0 rgb .9][1 rgb .5]}scale .01}
#declare Moon_Glow= pigment{rgbt <.1,.1,.1,.9>}
#declare Clear_Sky= pigment{rgbt <0,0,0,1>}

/*******************  Skysphere  *******************/
sky_sphere{
 pigment{gradient y color_map{[0 rgb 0][.5 rgb .001][.85 rgb z*.001][1 rgb z*.001]}
  scale 2 translate y*-1
  }
 pigment{gradient y pigment_map{[0 Moon_Glow][.01 Clear_Sky][1 Clear_Sky]}
  scale 2 translate y*-1 rotate z*180 rotate Moon_Rotation}
 pigment{wrinkles color_map{[0 rgb .0001 transmit 1][1 rgb .0001 transmit .9]}
  scale <1,.25,1>*.25 warp{turbulence .3 lambda 5 octaves 6 omega .29} }
 }

//Distant haze
fog{fog_type 2 fog_alt 2 distance 900 color rgb 0 transmit .1}
fog{fog_type 2 fog_alt 5 distance 700 color rgb 0 transmit .2}

/*******************  Moon  *******************/
#if (Moon)
sphere{0,1 
 //This is the 5 MB image-map
 //pigment{image_map {png "moon.png" map_type 1}rotate y*-90}
 //And this the 138 KB version, handed along with the ZIP for the IRTC
 pigment{image_map {png "moon2.png" map_type 1}rotate y*-90}
 finish{diffuse 0 ambient 120}
 scale 400 rotate x*-90 translate y*9000 rotate Moon_Rotation
 no_shadow
}

//Moon's flare (Glow)
#declare Flare_Pos=vnormalize(vrotate(<0,9000,0>,Moon_Rotation)-<-1,9,4>);
disc{0,Flare_Pos,1 hollow pigment{spherical poly_wave 2 color_map{[0 rgbt <.15,.15,.15,1>][1 rgbt <.15,.15,.15,.9>]}}
 scale .125
 translate <-1,9,4>+Flare_Pos/2
 finish{diffuse 0 ambient 100}
 no_reflection no_shadow
 }

#end

//light_group{

light_source{vrotate(<0,5000,0>,Moon_Rotation) rgb .125
 //parallel point_at vrotate(<0,-1,0>,Moon_Rotation)
 media_interaction off
 }

/*******************  Ocean - Textures and Interiors...  *******************/
//Texture for the "real" ocean
#declare Ocean_Texture=
 texture{
  pigment{rgb <.001,.001,.002>}
  normal{average normal_map{
  [1 bozo .8
   warp{turbulence .3 lambda 3 omega .5 octaves 8}
   warp{turbulence .1 lambda 2 omega .9 octaves 8}]
  [1 bozo .6 scale .2
   warp{turbulence .3 lambda 3 omega .5 octaves 8}
   warp{turbulence .1 lambda 2 omega .9 octaves 8}]
   }}
  finish{specular 0 roughness .01 reflection{.2,.7 fresnel exponent .9}}
  }

/*******************  Ocean - Object declaration  *******************/
#declare Ocean_Obj=plane{y,0 hollow texture{Ocean_Texture}}

/*******************  Clouds - Object declaration  *******************/

//The bezier-spline for the thickening of the clouds
#declare Real_Clouds_Volume = array[6]
{
 <  0,.5,0>,<  0,-.25,0>, //Actual-Node, Direction
 <.35, 0,0>,<.25,   0,0>, //Actual-Node, Direction
 <  1, 1,0>,<  0,   1,0>  //Actual-Node, Direction
}


//Amount of discs used for simulation of volumetric clouds
#declare Cloud_Amount = 30;

#declare Cloud_Obj=union{
 //A loop to place the clouds
 #declare C=0;
 #while (C<Cloud_Amount)
  //Height, preprocessed since it is needed to calculate the radius as well
  //#declare Disc_Height=(Cloud_Beg_Height+(Cloud_End_Height-Cloud_Beg_Height)/Cloud_Amount*C);
  //disc{y*Disc_Height,<0,1,0>, sqrt(-pow((Disc_Height),2)+pow(1,2))
  //sphere{y*-Ocean_Radius,Ocean_Radius+150+150/Cloud_Amount*C
  plane{-y,0 translate y*(350+150/Cloud_Amount*C)
   hollow //to assure that media works as expected
   //scale <1,0,1>*Bowl_Scale+y
 //Texture taken from (and then adjusted for this scene) tranquil.pov, a recent image of mine
 texture{
  //For one, we lighten the overall color during steps, as well as decreasing the amount (using the y-value of the above defined bezier-spline)
  pigment{bozo color_map{
  [0 rgbt <.1,.1,.1,.2>+<.3,.3,.4,.5>*C/Cloud_Amount]
  [.25-.2*Spline_Pos(Real_Clouds_Volume,C/Cloud_Amount).y rgbt <.1,.1,.1,.2>+<.3,.3,.4,.5>*C/Cloud_Amount]
  [.3-.2*Spline_Pos(Real_Clouds_Volume,C/Cloud_Amount).y rgbt <0,0,0,1>]
  [1 rgbt <0,0,0,1>]
  }
   translate 600 //picks some random position inside the pattern
   //rotate y*-1.5
   //Double turbulence achieves nice, crinkly edges
   warp{turbulence .3 lambda 5 omega .5 octaves 4}
   warp{turbulence .3 lambda 5 omega .5 octaves 4}
   scale (8000*<2,1,2>)/40
   translate x*-350
   }
  finish{ambient 0 diffuse .6}
  }
  double_illuminate
  //Only every fifth plane will be reflected (no need for that much detail in reflections)
  #if (mod(C,5)!=0) no_reflection #end
  }
 #declare C=C+1;
 #end
 }

/*******************  Object placement  *******************/

 #if (Ocean)      object{   Ocean_Obj} #end
 #if (Clouds)     object{   Cloud_Obj} #end
// global_lights off
//}
/*
light_source{vrotate(<0,5000,0>,Moon_Rotation) rgb .125
 parallel point_at vrotate(<0,-1,0>,Moon_Rotation)
 media_interaction off
 }*/
