// Persistence of Vision Ray Tracer Scene Description File
// File: room.inc
// Vers: 3.5
// Desc: Room for the worldbowl-image IRTC 2002, Jan-Feb
// Date: 13.2.02
// Auth: Tim Nikias Wenclawiak

//Note: This include needs macros as given in "bowlmacs.inc"

/*******************  Textures and Materials  *******************/
//Table - parameters
#declare Tile_Height=.5;
#declare Tile_Depth=.01;
#declare Tile_Width=.025;
//Table - textures
#declare Table_Leg_Tex = texture{pigment{rgb .5} finish{specular .9 roughness .02}}
#declare Table_Wood = 
 texture{
  pigment{agate color_map{[0 rgb <.88,.6,.2>][1 rgb <.6,.3,.2>]}
   turbulence <.2,.05,.2> octaves 12 omega .6 lambda 2.5 rotate <3,90,0>
   }
  normal{wrinkles .1 scale .2}
  finish{specular .8 roughness .02}
 }  

//The frame for the poster
#declare Poster_Frame_Tex = texture{pigment{rgb .5*<1,.6,.6>} finish{specular .9 roughness .02 reflection {.05,.2 metallic exponent .9 falloff 2}}}
//Imagemap (uses reflection to simulate a glassplate as protection)
#declare Poster_Tex=
 texture{
  //500 kb Version for my final
  //pigment{image_map{png "dusk.png"}translate -.5 scale <1.33,1,1>*2}
  //56 kb Version for the ZIP handed to the IRTC
  pigment{image_map{png "dusk2.png"}translate -.5 scale <1.33,1,1>*2}
  finish{ambient .5 diffuse .96 specular 1 roughness .001  metallic reflection{.01,.4 falloff 2 exponent .98}
   }
  }

//Window-related textures and materials
#declare Window_Pane_Tex =
 texture{
  pigment{
   granite color_map{[0 rgb .05][1 rgb .6]}
   scale .2}
  finish{specular .3 roughness .02}
  }
#declare Window_Wood_Tex =
 texture{
  pigment{rgb 1}
  finish{ambient .4 diffuse .7 specular .6 roughness .09}
  }
#declare Window_Handle_Material=
 material{
  texture{pigment{rgb .7} finish{reflection{.2,.9 exponent .8 falloff 2} specular .8 roughness .02}}
  }
//The glassparts receive this material (with IOR-Interior)
#declare Window_Material=
 material{
  texture{pigment{rgbt <1,1,1,.99>} finish{reflection{.02,.2 exponent .8 falloff 2 fresnel on}}}
  interior{ior 1.54}
  }

/*******************  The Room  *******************/

#declare Room_Obj=union{

//Room
difference{
 box{<-10,0,-10><10,20,11>}
 //"carve" it hollow
 box{<-9.5,.5,-9.5><9.5,19.5,9.5>}
 //"carve" the Window
 box{<-3,6.5,12><7,16,9>}
 pigment{rgb .9}
 normal{wrinkles .1 scale .5}
 hollow
 }

//Windowpane
superellipsoid{<.25,.25> scale <5,.1,.5> translate <2,6.6,9.5>
 texture{Window_Pane_Tex}
 }

}

#declare Window_Obj=union{
union{

 //Windowframe - Main section
 difference{ 
  box{<-3,6.5,10><7,16,10.5>}
  box{<-2.5,7.2,9.25><6.5,15.5,10.75>}
  }

 //Windowframe - Inert section
 //Simple difference-CSG
 difference{ 
  box{<-2.6,7,9.8><6.6,15.8,10.4>}
  box{<-2.3,7.4,9.7><6.3,15.4,10.5>}
  //For curving, we cut another tiny section of the inside away
  box{<-2.33,7.37,9.79><6.33,15.41,9.83>}
  }

 //Curves on the inside to smoothen the inner edge
 sphere{<-2.33,7.37,9.83>,.03}
 cylinder{<-2.33,7.37,9.83>,<6.33,7.37,9.83>,.03}
 sphere{<6.33,7.37,9.83>,.03}
 cylinder{<6.33,7.37,9.83>,<6.33,15.43,9.83>,.03}
 sphere{<6.33,15.43,9.83>,.03}
 cylinder{<6.33,15.43,9.83>,<-2.33,15.43,9.83>,.03}
 sphere{<-2.33,15.43,9.83>,.03}
 cylinder{<-2.33,15.43,9.83>,<-2.33,7.37,9.83>,.03}

 texture{Window_Wood_Tex}
 }

//Windowcross
 union{
  //Left-Right
  cylinder{<-2.5,11.25,9.9><6.5,11.25,9.9>,.1}
  box{<-2.5,11.15,9.9><6.5,11.35,10.3>}
  cylinder{<-2.5,11.25,10.3><6.5,11.25,10.3>,.1}
  //Floor-Ceiling
  cylinder{<2,7,9.9><2,15.5,9.9>,.1}
  box{<1.9,7,9.9><2.1,15.5,10.3>}
  cylinder{<2,7,10.3><2,15.5,10.3>,.1}
 texture{Window_Wood_Tex}
 }

//Glass-parts of the window
union{
 //Lower Right
 box{<6.299,7.401,10><2.099,11.149,10.1>}
 //Upper Right
 box{<6.299,15.399,10><2.099,11.351,10.1>}
 //Lower Left
 box{<-2.299,7.401,10><1.899,11.149,10.1>}
 //Upper Left
 box{<-2.299,15.399,10><1.899,11.351,10.1>}
 material{Window_Material}
}

//Handle
union{
 superellipsoid{<.05,.05> scale <.125,.4,.1> translate <6.45,11.125,9.8>}
 cylinder{<6.45,11.125,9.8>,<6.45,11.125,9.4>,.1}
 sphere{<6.45,11.125,9.4>,.1}
 cone{<6.45,11.125,9.4>,.1 <6.45,10.2,9.4>,.08}
 sphere{<6.45,10.2,9.4>,.08}
 material{Window_Handle_Material}
}

}
/*******************  Table  *******************/

#declare Tile=
mesh{
 //Back-Edge
 triangle{<-9.5,-Tile_Depth,-.25><-9.5,0,-.25+Tile_Width><9.5,-Tile_Depth,-.25>}
 triangle{<-9.5,0,-.25+Tile_Width><9.5,-Tile_Depth,-.25><9.5,0,-.25+Tile_Width>}
 //Surface area
 triangle{<-9.5,0,-.25+Tile_Width><9.5,0,-.25+Tile_Width><-9.5,0,.25-Tile_Width>}
 triangle{<9.5,0,-.25+Tile_Width><9.5,0,.25-Tile_Width><-9.5,0,.25-Tile_Width>}
 //Front-Edge
 triangle{<-9.5,-Tile_Depth,.25><-9.5,0,.25-Tile_Width><9.5,-Tile_Depth,.25>}
 triangle{<-9.5,0,.25-Tile_Width><9.5,-Tile_Depth,.25><9.5,0,.25-Tile_Width>}
 //Front-Side (though only needed on first tile to make the table thicker than 2D)
 triangle{<-9.5,-Tile_Depth,-.25><9.5,-Tile_Depth,-.25><-9.5,-Tile_Height,-.25>}
 triangle{<9.5,-Tile_Depth,-.25><9.5,-Tile_Height,-.25><-9.5,-Tile_Height,-.25>}
}

#declare Table_Leg=cylinder{0,y*5.8,.25 texture{Table_Leg_Tex}}

/*******************  Poster  *******************/

#declare Poster_Obj=
union{
 //The image
 mesh{
  triangle{<-1.33,-1,0><-1.33,1,0><1.33,1,0>}
  triangle{<1.33,-1,0><1.33,1,0><-1.33,-1,0>}
  texture{Poster_Tex}
  rotate y*90
 }
 //The frame
 union{
  sphere{<0,-1,-1.33>,.06}
  sphere{<0,1,-1.33>,.06}
  sphere{<0,-1,1.33>,.06}
  sphere{<0,1,1.33>,.06}
  cylinder{<0,-1,-1.33><0,1,-1.33>,.05}
  cylinder{<0,-1,-1.33><0,-1,1.33>,.05}
  cylinder{<0,1,-1.33><0,1,1.33>,.05}
  cylinder{<0,-1,1.33><0,1,1.33>,.05}
  texture{Poster_Frame_Tex}
 } 
}

/*******************  Object Placement  *******************/
#if (Ceiling_Light) light_source{<0,19,0> rgb 15*<1,1,.9> fade_power 2 fade_distance 1} #end
#if (Poster) object{Poster_Obj scale 1.5 translate <9.49,11,6>} #end
//These two objects are accurately placed in their declaration
#if (Room) object{Room_Obj} #end
#if (Window) object{Window_Obj} #end

//This object is only parsed when needed
#if (Table)
 //The tiles are placed in loop, their texture translated randomly to look different
 #declare Table_Rand=seed(2002);
 #declare T=0; #while (T<9)
  object{Tile
   //Texture with translation
   texture{Table_Wood translate z*rand(Table_Rand)*10}
   //Actual positioning of tile
   translate z*(9.15-.49*T) translate y*6} 
 #declare T=T+1; #end
 //The one and only visible leg is placed, the others are not needed
 object{Table_Leg translate <8.75,0,5.4>}
#end
