// Persistence of Vision Ray Tracer Scene Description File
// File: twilight.pov
// Vers: 3.1g
// Desc: Exile
// Date: 20.01.02
// Auth: Florian Kastell


global_settings{
        assumed_gamma 1.0
        ambient_light 0.01
}


/*---------------------------------------------camera & light----------------------------------------------*/
camera{location <24,8,-5>
        right x*1.33
        up y*1
       look_at <7,16,50>
       /*focal_point <10,3,20>
        aperture .7
        blur_samples 50
        confidence .8
        variance .001*/
       normal{bump_map{png "cam_bump.png" bump_size .8}translate -.5}
}

light_source{<0,10,-90> rgb .1
 fade_distance 200 fade_power 2

}
light_source{<0,50,200> rgb .8
 fade_distance 100 fade_power 2
 area_light <.5, 0, 0>, <0, .5, 0>, 4,4 adaptive 1 jitter orient circular
}


#declare Boat_Lights= on;


/*-------------------------------------------- the texture ------------------------------------------------*/

#declare P_Tex =
 texture{
  pigment{
   planar scale <1,10,1> translate y*3
   turbulence .3 omega .75 octaves 6 lambda 2
   pigment_map{
    [0.0 bozo color_map{[0.0 rgb 0][0.2 rgb <0,.1,0>][0.4 rgb <.1,0,.1>][1.0 rgb <0,.2,.1> ]} turbulence .5 lambda 3 octaves 6 omega .3]
    [1.0 rgbt <0,0,0,1>]
    }
   }    
  }

#declare Pillar_Mat=
 material{
  //Algae
  texture{
   pigment{bozo color_map{[0.0 rgb 0][0.2 rgb <0,.6,.2>][0.4 rgb <.1,.9,.1>][.6 rgb <0,.2,.1>][1.0 rgb <.2,1,.3> ]}turbulence .5 lambda 1.6 octaves 6 omega .3}
   normal{wrinkles .2 scale .3}
   finish{specular .8 roughness .01}
   }
  //Marble
  texture{P_Tex}

 }

#declare Deco_Tex =
 texture{
  pigment{
   planar scale <1,10,1> translate y*3
   turbulence .3 omega .75 octaves 6 lambda 2
   pigment_map{
    [0.0 bozo color_map{[0.0 rgb 0][0.2 rgb <0,.1,0>][0.4 rgb <.1,0,.1>][1.0 rgb <0,.2,.1> ]} turbulence .5 lambda 3 octaves 6 omega .3]
    [1.0 rgbt <0,0,0,1>]
    }
   }    
  }

#declare Decoration_Mat=
 material{
  //Algae
  texture{
   pigment{bozo color_map{[0.0 rgb 0][0.2 rgb <0,.6,.2>][0.4 rgb <.1,.9,.1>][.6 rgb <0,.2,.1>][1.0 rgb <.2,1,.3> ]}turbulence .5 lambda 1.6 octaves 6 omega .3}
   }
  //Marble
  texture{Deco_Tex}
 }

#declare Island_Tex=
 texture{pigment{gradient y color_map{[0.0 rgb <.5,.5,0>][0.2 rgb <1,1,0>][0.6 rgb <.4,1,0>][0.9 rgb <.6,.6,.6>][1.0 rgb 1]}turbulence .5}normal{bumps 0.6}finish{roughness .2}}
 
#declare Water_Tex=
 material{texture{pigment{rgb 0}normal{bozo 1 warp{turbulence .3 omega .5 octaves 9 lambda 1.5} scale 20 warp{turbulence .4 omega .6 octaves 5 lambda 2.25}
 no_bump_scale scale .05}finish{reflection{.5,1 falloff 2 exponent .98}specular 1.5 roughness 0.001 brilliance 0.01 conserve_energy}}interior{ior 1.33}}



/*---------------------------------------------- the scene ------------------------------------------------*/


//the sky
 sky_sphere{pigment{gradient y color_map{[0 rgb <0,0,.5>][0.6 rgb <0,0,.3>][1 rgb 0]} scale 2 translate -1 }}
 fog {color rgb <.6,.6,.8> distance 450 fog_type 2 fog_offset 2 fog_alt 15}
 fog {color rgb <.3,.3,.6> distance 1000 fog_type 2 fog_offset 2 fog_alt 100 }
 fog {color rgb <.01,.8,.99>*.25 distance 1000 transmit .8}
 fog {color rgb <.01,.8,.99>*.25 distance 900 transmit .7}

//The Water
#declare Water=
plane {y*1, 3}

object{Water material{Water_Tex}}


//The Islands
#declare Terrain=

 height_field{
  png "Terrain.png"
    scale <6000,2000,6000>
    texture
     {Island_Tex scale <6000,2000,6000>}
  smooth water_level .01
 }


#declare Terrain1=

 height_field{
  png "Terrain 1.png"
   scale <20,4.5,20>
    texture
     {Island_Tex scale <20,4.5,20>}
  smooth water_level .01
 }

#declare Terrain2=

 height_field{
  png "Terrain 2.png"
    scale <20,4.5,20>
    texture
     {Island_Tex scale <20,4.5,20>}
    rotate y*-45
  smooth water_level .01
 }

#declare Terrain3=

 height_field{
  png "Terrain 3.png"
   scale <30,8,30>
    texture
     {Island_Tex scale <30,8,30>}
  smooth water_level .01
 }

#declare Terrain4=

 height_field{
  png "Terrain 4.png"
   scale <20,4.5,20>
    texture
     {Island_Tex scale <20,4.5,20>}
  smooth water_level .01
 }

#declare Terrain5=

 height_field{
  png "Terrain 5.png"
   scale <40,5,40>
    texture
     {Island_Tex scale <40,4.5,40>}
  smooth water_level .01
 }

object{Terrain  translate <-3200,-60,300>}
object{Terrain1 translate <10,2.8,120>}
object{Terrain2 translate <36,2.8,30>}
object{Terrain3 translate <-10,2.9,40>}
object{Terrain4 translate <23,2.8,17>}
object{Terrain5 translate <-27,2.8,3>}


//the boat
#include "boat.inc"

#declare Waves=
 height_field{
  png "waves.png"
   scale <4,.65,9>
    material
     {Water_Tex}
  smooth water_level .01
 }

#declare Boat_set=
union{
 object {Boat rotate <0,0,0> scale <.5,.5,.5> translate <0,3.1,0>}
 object{Waves rotate y*0 translate <-2.3,2.97,-7.5>}
 rotate <0,30,0> translate <11,0,23>
}

object{Boat_set}

//The Pillars
#declare Pillar=
 union{
  sphere{<0,.5,0>,5 scale <2,1,2>}
  torus{6, 1 translate <0,5,0> scale <1.1,1,1.1>}
  
  //the decoration
  #declare Deco_Size= .8;
  
  #declare Bottom_Sphere=
   union{
    sphere{<0,0,0>,9}
  
    #declare CSG_Detail=20;
    #declare Bands=10;

    #declare A=0;
    #while (A<=1)
 
     #declare Height=-9+17.999*A;

     #declare B=0;
     #while (B<Bands)
      sphere{<0,0,0>,Deco_Size material{Decoration_Mat}
             translate x*(sqrt(pow(9,2)-pow(Height,2)))
             translate y*Height
             rotate y*90*A
             rotate y*360/Bands*B
      }
      #declare B=B+1;
     #end

     #declare A=A+1/CSG_Detail;
    #end
   }
  
 
  #declare Bottom_Cylinder=
   union{
    cylinder{<0,0,0>,<0,24,0>,3 scale <2,1,2>}
    
    #declare CSG_Detail=30;
    #declare Bands=10;

    #declare A=0;
    #while (A<=1)
 
     #declare Height=24*A;

     #declare B=0;
     #while (B<Bands)
      sphere{<0,0,0>,Deco_Size-.02*Height material{Decoration_Mat}
             translate x*6-.012*Height
             translate y*Height
             rotate y*90*A
             rotate y*360/Bands*B
       }
      #declare B=B+1;
     #end

     #declare A=A+1/CSG_Detail;
    #end
   }
   
  #declare Decorated_Bottom=
   union{object{Bottom_Sphere translate <0,9,0>}
         torus{7, 1 translate <0,15,0> material{Decoration_Mat}}
         object{Bottom_Cylinder translate <0,12,0> rotate y*25}
   }
  
  object{Decorated_Bottom}
  
  
  
  #declare Sphere_Count=0;
  #while (Sphere_Count<=40)
   sphere{<0,15,0>,4 scale <2,3,2> translate <0,4+24*Sphere_Count,0>}
   #declare Sphere_Count=Sphere_Count+1;
  #end

  #declare Cylinder_Count=0;
  #while (Cylinder_Count<=20)
   cylinder{<0,25,0>,<0,49,0>,3 scale <2,1,2> translate <0,4+24*Cylinder_Count,0>}
   #declare Cylinder_Count=Cylinder_Count+1;
  #end

  scale <1,1,1>
 }

#declare Pillar_Array=
 union{
  #declare A=0;
   #while (A<=10)
   #declare B=0;
    #while (B<=10)
     object {Pillar translate <-35+-70*B,2,10+50*A>}
     object {Pillar translate < 35+70*B,2,10+50*A>}
     #declare B=B+1;
    #end
    #declare A=A+1;
   #end

 material{Pillar_Mat}
}

object{Pillar_Array}