#declare POV35=1;

#if (POV35) 
#else
#version unofficial MegaPov 0.7;
#end  

#include "colors.inc"
#include "textures.inc "
#include "..\grass\mgrass.pov"
#include "txttree.inc"
#include "rand.inc"
#include "grasstextures.inc"

#declare GRASS=1;
#declare GRASSTEXT=1;
#declare STREETLAMPS=1;
#declare TREES=1;
	#declare QUICKTREES=0;
#declare FALLENLEAVES=1;
                          
#declare COMPLEX=1;		// Small world complicated objects
#declare SMALLWORLDONLY=0;

#declare BOUNCELOTS=1;
#declare RADIOSITYSET=0;
#declare REFRACTION=1;
#declare PHOTONS=0;
#declare NUMPHOTONS=2000000;
#declare AREALAMP=1;
#declare MEDIA=1;

#declare CAMERA=3;
#declare MORELIGHT=0;

#declare PATCHESPERSIDE=100;
#declare SCALEFACTOR=1;//500000;

#declare finalcameraposition=<526.0, 198, 406>;
#declare finalcameralookat=<0,85,0>;

//background {colour rgb .05}

global_settings {
  adc_bailout 0.003922
  ambient_light <0.05,0.05,0.05>
//  ambient_light <0.05,0.1,0.1>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64

#if (BOUNCELOTS)
  max_trace_level 30
#else
  max_trace_level 2
#end

  number_of_waves 10
#if (RADIOSITYSET) 
  radiosity {
    brightness       1.5
    count            150
    distance_maximum 15.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
#end

#if (PHOTONS)  photons{
	save_file "myfile.ph"
    count NUMPHOTONS
    autostop 0
    jitter .4
}
#end

}

#include "cameras.inc"

#declare TARMAC= texture {
    pigment {   crackle turbulence 0.5
	color_map
	{
  [  0.01  color Gray20]
  [  0.1  color Gray15]
  [  0.5  color Gray10]
  [  0.7  color Gray10]
  [  1.0  color Gray20]
	}
}
    normal {crackle turbulence 0.5}
    finish {diffuse .35
//    	brilliance .1
    	reflection .05
    	specular .03
    	roughness .05
//    	crand .1
    	}
    scale .0020
  }

#declare hfx1_h=-750;
#declare hfx2_h=750;
#declare hfz1_h=-750;
#declare hfz2_h=750;

#declare hfy1_h=-100;
#declare hfy2_h=100;

//union {			// ENTIRE SCENE UNION
#declare ground_h = height_field
{
  png
  "out from terragen with path.png"
  smooth
  scale <hfx2_h-hfx1_h,hfy2_h-hfy1_h,hfz2_h-hfz1_h>
  translate <hfx1_h,hfy1_h,hfz1_h>
  rotate <0,-90,0>
#if (GRASSTEXT) 
texture {BGtxtGrass}
#else 
texture {QuickGrass}
#end
}

#declare nearlampx_h=0.8300;
#declare nearlampz_h=0.7600;
#declare nearlamppos=trace(ground_h, <nearlampx_h*(hfx2_h-hfx1_h)+hfx1_h,hfy2_h,nearlampz_h*(hfz2_h-hfz1_h)+hfz1_h>, <0,-1,0>);

#if (!SMALLWORLDONLY)

#if (MORELIGHT)
light_source
{
  0*x // light's position (translated below)
  color White *.61// light's color
  translate <-20, 4000, -20>
}
light_source
{
  0*x // light's position (translated below)
  color White *.81// light's color
  translate <500, 300, 400>
}
#end


#declare MOONSCALE=10000;

#declare MOONPOS=<-1000, 20, -700> * MOONSCALE;


light_source
{
  0*x // light's position (translated below)
  color White *14 //* 8  // light's color
#if (AREALAMP)
  area_light
  <10*MOONSCALE, 0, 0> <0, 0, 10*MOONSCALE> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
#end
  parallel
//  fade_distance 1000*SCALEFACTOR*MOONSCALE
//  fade_power 1

  looks_like {
  	box {
  		<-100,-100,-1>*MOONSCALE
  		<100,100,1>*MOONSCALE
  		texture {
  			pigment {
  				//color White
  				// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
				image_map {
					png "moon.png" // the file to read (iff/gif/tga/png/sys)
					map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  					interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
					once
				} // image_map
  			}
  			finish {ambient 20.5}
  			scale 40*MOONSCALE
  			scale <1,.8,1>
  		}
  		rotate y*-125
  		
  	}
  }
  translate MOONPOS
  point_at <0,0,0>
}

#declare CAMERACLOSENESS=.05; //0=at camera, 1=at moon

#if (MEDIA)
sphere {
	<0,0,0>
	1
	pigment {colour rgbf <1,1,1,1>}
//	finish {ambient 50}
	interior {
		media {
//			emission .0003
//			emission .0000003  // at moon
			emission .0000045
//			scattering { 2, rgb .000015}
			intervals 1
  			samples 5
  			method 3
  			density {
  				spherical
  				density_map {
  					[0.0 White * 0.00]
  					[0.1 White * 0.01]
  					[0.2 White * 0.04]
  					[0.3 White * 0.09]
  					[0.4 White * 0.16]
  					[0.5 White * 0.25]
  					[0.6 White * 0.36]
  					[0.7 White * 0.49]
  					[0.8 White * 0.64]
  					[0.9 White * 0.81]
  					[1.0 White * 1.00]
  				}
  			}	
		}
	}
	
	hollow
	scale 100*MOONSCALE*CAMERACLOSENESS*1
	translate (CAMERACLOSENESS*(MOONPOS+<0,190000,240000>)+((1-CAMERACLOSENESS)*finalcameraposition))
//	translate <0,8,0>
}
#end

sphere {			// clouds
	<0,-2999,0>
	3000
//	double_illuminate
	inverse
	
	/*interior {
		media {
  intervals 10
  scattering { 4, rgb 1}
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
		density {
			bozo 
			turbulence 0.65
			octaves 6
			omega 0.7
			lambda 2
//			color_map {
//				[0.0 rgb 0.85]
//				[0.1 rgb 0.75]
//				[0.5 rgbt 1]
//				}
//			scale <6, 1, 6>
//			scale 1000
		}
	}
	}
	pigment {colour rgbf .8}*/
	texture {
		pigment {
			bozo
			turbulence 0.65
			octaves 6
			omega 0.7
			lambda 2
			color_map {
				[0.0 rgbt <1,1,1,.55>]
				[0.1 rgbt <1,1,1,.65>]
//				[0.0 rgbt <1,1,1,.55>]
//				[0.1 rgbt <1,1,1,.65>]
				[0.5 rgbt 1]
//				[.6 rgb .75]
				}
//			scale <6, 1, 6>
//			scale 1000
			}
		finish {
//			diffuse 12.5
			ambient 12.5
		}
		scale 10
		}
	scale 50000
	translate finalcameraposition
	no_shadow
}
	

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>


// ********************************* HILL BEHIND *************************************

#declare hillxscale=3000;
//#declare hillyscale=250;
#declare hillyscale=200;
#declare hillzscale=3000;


#declare hillxstart=200;
//#declare hillystart=-120;
#declare hillystart=-100;
#declare hillzstart=-800;

#declare hillbehind=height_field
{
  png               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "hill behind.png"     // the file name to read
//  inverse | texture {...}
  smooth        // make smoother surface
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
// translate VECTOR | rotate VECTOR | scale VECTOR
  translate <-.5,0,-.5>
  rotate y*45
  translate <.5,0,.5>
  scale <hillxscale,hillyscale,hillzscale>
  translate <hillxstart,hillystart,hillzstart>
rotate <0,180,0>
#if (GRASSTEXT) 
texture {BGtxtGrass}
#else 
texture {QuickGrass}
#end
}

#declare hillxscale=2000;
//#declare hillyscale=120;
#declare hillyscale=100;
#declare hillzscale=2000;


#declare hillxstart=-700;
#declare hillystart=-50;
#declare hillzstart=750;

// ********************************* FINAL HILL (TO LEFT) *************************************

#declare finalhill=height_field
{
  png               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "final hill.png"     // the file name to read
//  inverse | texture {...}
  smooth        // make smoother surface
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
// translate VECTOR | rotate VECTOR | scale VECTOR
  translate <-.5,0,-.5>
  rotate y*15
  translate <.5,0,.5>
  scale <hillxscale,hillyscale,hillzscale>
  translate <hillxstart,hillystart,hillzstart>
rotate <0,180,0>
#if (GRASSTEXT) 
texture {BGtxtGrass}
#else 
texture {QuickGrass}
#end
}

#declare hillxscale=16000;
//#declare hillyscale=380;
#declare hillyscale=250;
#declare hillzscale=16000;
//#declare hillxscale=4000;
//#declare hillyscale=120;
//#declare hillzscale=4000;


#declare hillxstart=-1700;
//#declare hillystart=-100;
#declare hillystart=-50;
#declare hillzstart=3400;
//#declare hillxstart=-700;
//#declare hillystart=-20;
//#declare hillzstart=1400;

// ********************************* ROLLING HILLS (BEYOND ROAD) *************************************

#declare rollinghills=height_field
{
  png               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "rollinghills.png"     // the file name to read
//  inverse | texture {...}
  smooth        // make smoother surface
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
// translate VECTOR | rotate VECTOR | scale VECTOR
/*pigment {
	#if (GRASS)
	color Green *.5
	#else
	color Green	
	#end
}
finish {
	ambient .2
}*/ 

  //rotate <0,30,0>
  translate <-.5,0,-.5>
  rotate y*15
  translate <.5,0,.5>
  scale <hillxscale,hillyscale,hillzscale>
  translate <hillxstart,hillystart,hillzstart>
rotate <0,180,0>
#if (GRASSTEXT) 
texture {BGtxtGrass}
#else 
texture {QuickGrass}
#end
}

// ********** DISC UNDERNEATH ************

#declare discbelow=object {
disc
{
  <0, 0, 0>  // center position
  y,         // normal vector
  10000.0,       // outer radius
  300
#if (GRASSTEXT) 
texture {BGtxtGrass}
#else 
texture {QuickGrass}
#end
}
/*box {
	<-450,-1,-750>
	<750,1,750>
	pigment {color rgbf 1}
}*/
}

// ***************************** PATH HEIGHT FIELD ************************

#declare pathhf_h=height_field
{
  png               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "path.png"     // the file name to read
//  inverse | texture {...}
  smooth        // make smoother surface
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
// translate VECTOR | rotate VECTOR | scale VECTOR
texture {
	TARMAC
}
  scale <hfx2_h-hfx1_h,hfy2_h-hfy1_h,hfz2_h-hfz1_h>
  translate <hfx1_h,hfy1_h,hfz1_h>
rotate <0,-90,0>
  }

// ******************* SHOVE IT ALL TOGETHER ***************************

union {
object {ground_h}
object {pathhf_h}
object {hillbehind}
object {finalhill}
object {rollinghills}
object {discbelow}
/*#if (GRASS)
object {
	objectPatch
	texture{txtGrass scale 40}
} 
#end*/
}

// ************************** FUN WITH GRASS ********************************

#if (GRASS) #include "landscapegrass.inc" #end

// ****************************** LAMPS ************************************

#declare highqualitylamp=1;

#include "..\lamppost\lamp.inc"

object {
	nearlamp_h
	translate nearlamppos
	translate <0,125,0>
  
}

#declare highqualitylamp=0;

#declare farlampx_h=0.4300;
#declare farlampz_h=0.5700;

object {
	farlamp_h
	translate trace(ground_h, <farlampx_h*(hfx2_h-hfx1_h)+hfx1_h,hfy2_h,farlampz_h*(hfz2_h-hfz1_h)+hfz1_h>, <0,-1,0>) //<farlampx_h*(hfx2_h-hfx1_h)+hfx1_h,hf_height_at(farlampx_h,farlampz_h,ground_h)*(hfy2_h-hfy1_h)+hfy1_h,farlampz_h*(hfz2_h-hfz1_h)+hfz1_h>	// translate <farlampx_h*1500-750,hf_height_at(farlampx_h,farlampz_h,ground_h)*200-100+200,farlampz_h*1500-750>
	translate <0,150,0>
  
}

#include "roadandstreetlamps.inc"
#include "treesandleaves.inc"


// *************** Small world


#end // SMALLWORLDONLY

#include "smallworld.inc"




#declare spot_distance = <0,24,-16>;
#declare tantheta=spot_distance.y/spot_distance.z;
#declare theta=atan2(tantheta,1);
#declare sintheta=sin(theta);


light_source
{
  0*x                     // light's position (translated below)
  color White * 7	// light's color
  parallel
  projected_through {
	sphere {
		<0,0,0>
		4.2
		scale <1,sintheta,1>
		rotate <-degrees(theta),0,0>

//		scale <1,.5,.5>
	}
}
  translate nearlamppos+<0,125,0>+<0,15.5,0>+spot_distance // <x y z> position of light
  point_at nearlamppos+<0,125,0>+<0,15.5,0>      // direction of spotlight

}


object {
		object {
			smallworld
		}
		rotate y*-140
		scale 4.3/10000
		translate nearlamppos+<0,125,0>+<0,15.5,0>
}	

// ******************************** Bench

#if (!SMALLWORLDONLY)
#include "bench.inc"

#declare benchpos=trace(ground_h, <-140,1000,-200>, <0,-1,0>); // #declare benchpos=trace(ground_h, <-150,0,-200>, <0,-1,0>);

/* object {
	cylinder {
		benchpos
		benchpos + <0,100,0>
		3
	}
	pigment {colour White}
}  */


object {
bench
rotate y*95
translate benchpos + <0,0,0>
}

// ********************************* Puddle

#declare PuddleCentre=<-63,2000,-90>;
#declare puddle_h = texture {
	pigment {colour rgbf<.9, .8, .6, .3>}
	finish {reflection .25
		diffuse .15
		specular .3
		roughness .0001}
	normal {
		ripples 2
		scale <15,9,15>
	}
}

object {
	cylinder {                                                                                              
		<0,-85,0>
		<0,80,0>
		100
	}
	texture {
		puddle_h
		
/*		pigment {
			colour White
		}*/
	}
	translate trace(ground_h,PuddleCentre,-y)
}


//scale SCALEFACTOR

#end // SMALLWORLDONLY

//}