// ******************************* ROAD AND STREET LAMPS *********************************

#if (STREETLAMPS)

#declare NUMSTREETLAMPS=20;
#declare firstsl=1;
#declare lastsl=3;
#declare countsl=0;
#declare Sodiumlamp=rgb<1,.6,0>;
#declare Brightness=10;
#declare LampFadeDistance=5000;
#declare LampFadePower=1;
#declare LampPostHeight=350;


#declare ROADSTARTX=-10000;
#declare ROADSTARTZ=-5000;

#declare ROADXGRADIENT=3;
#declare ROADZGRADIENT=-1;

box {
	<-1000000,0,-300>
	<1000000,5,300>
//	pigment {color White*.4}
	texture {TARMAC}
	rotate x*.1
#declare rotate_road=-degrees(atan2(ROADZGRADIENT/ROADXGRADIENT,1));
//#debug concat("Rotation angle=", str(rotate_road,2,2),"\n")
	rotate y*rotate_road

	translate <ROADSTARTX, 0, ROADSTARTZ>
	scale .4
  }


#declare STREETLAMP=union {
light_source
{
  0*x // light's position (translated below)
  color Sodiumlamp*Brightness // light's color
//  #debug concat("Streetlamp number ",str(countsl,2,2),": x=",str(myx,2,2),", z=",str(myz,2,2),"\n")
  
  looks_like {
  	cylinder {
  		<0,0,0>
  		<80,0,80>
  		12
  		pigment {color Sodiumlamp*2}
  		finish {ambient 30}
  		rotate y*rotate_road+180
  	}
  }
  spotlight               // this kind of light source
  point_at <0, -1, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness .5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 200               // intensity falloff1 radius (outer, in degrees)
  fade_distance LampFadeDistance
  fade_power LampFadePower
  translate <120*ROADZGRADIENT, LampPostHeight-5, -120*ROADXGRADIENT>
}
#if (MEDIA)
sphere {
	<0,0,0>
	1
	pigment {colour rgbf <1,1,1,1>}
	interior {
		media {
			emission Sodiumlamp*.00025
//			scattering { 2, Sodiumlamp * .000003}
			intervals 1
  			samples 5
  			method 3
  			density {
  				spherical
//  				density_map {
  			}	
		}
	}
	hollow
	scale 1000
  translate <120*ROADZGRADIENT, LampPostHeight-5, -120*ROADXGRADIENT>
}
#end
cylinder {
	<0,0,0>
	<0,LampPostHeight,0>
	6
	pigment {color rgb .9}
	finish {diffuse .4}
  translate <170*ROADZGRADIENT, 0, -170*ROADXGRADIENT>
//  translate <0, 150, 0>
}
cylinder {
	<120*ROADZGRADIENT, LampPostHeight, -120*ROADXGRADIENT>
	<170*ROADZGRADIENT, LampPostHeight, -170*ROADXGRADIENT>
	6
	pigment {color rgb .9}
	finish {diffuse .4}
  
//  translate <0, 150, 0>
}
}
	
#while (countsl<NUMSTREETLAMPS)
#if ((firstsl<=(countsl+1))&(lastsl>=(countsl+1)))
object {
	STREETLAMP
	#if(countsl/2=floor(countsl/2)) rotate y*180 #end
#declare myx=ROADSTARTX+ROADXGRADIENT*countsl*700;
#declare myz=ROADSTARTZ+ROADZGRADIENT*countsl*700;
	translate <myx,0,myz>
	scale .4
}
#end
#declare countsl=countsl+1;
#end


#end //if strretlamps statement

