
#if (COMPLEX)	
	#declare SquadColour = rgb <0.7,0.15,0.7>*.4; //RGB value of colour of squadron markings (A-Wing)
	#include "a-wing.inc"
#end

#declare swtunnel = difference {
box {
	<-5,0,-5>
	<10,10,5>
}
box {
	<-6,0,-4.5>
	<11,9,4.5>
}
	texture {
		pigment {color Gray80}
		finish {
			diffuse .2
			ambient 6
		}
	}
	scale 180
	translate <-10000,0,0>
}

#declare backoftunnel=box {
	<-6,0,-4.5>
	<6,9,4.5>
	scale 180
	translate <-10000,0,0>
}

#declare MapMaterialMap = texture {
/*		pigment {
		image_map {
			png "smallworldmap.png" 
			map_type 0 
			interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
			once           // for no repetitive tiling
		}
		translate <-.5,-.5,0>
		scale 1.01
		rotate <90,0,0>
	}*/
	material_map {
		png "smallworldmap.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
		map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
		interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
		once
		texture { 					// Road surface
			pigment {
				crackle turbulence 0.5
				color_map {
					[  0.01  color rgb .1]
					[  0.1  color rgb .05]
					[  0.5  color rgb 0]
					[  0.7  color rgb 0]
					[  1.0  color rgb 0]
				} // color_map
			}
			normal {crackle turbulence 0.5}
			finish {
				diffuse .6
				brilliance .1
				specular .1 
				roughness .5
//				crand .8
			}
			scale .00020
		}
		texture {					// Grass surface
			pigment {
				crackle turbulence 0.5
				color_map {
					[  0.0  color ForestGreen*.7]
					[  0.5  color ForestGreen*1.2*.7]
					[  0.7  color Green *.8*.7]
				} // color_map
			}
			normal {
				crackle .6 turbulence 0.5
			}
			finish {
				diffuse .6
				specular .03
				roughness .5
			}
			scale .0050
		}
		texture { 					// Dust surface
			pigment {colour <.9,.9,.5> *.7}
			normal {
				crackle .5 turbulence 0.5
			}
			finish {
				diffuse .5
				specular .1
				roughness .5
			}
			scale .001
		}
	}
	translate <-.5,-.5,0>
	scale 1.01
	rotate <90,0,0>
}

#if (TREES)

#declare colLeaf=rgb <0.5,1,0.2>; // yellow clear green
#declare txtLeaf_1=texture{pigment{colLeaf} finish{ambient 20 specular 0.3 roughness 0.01}}


#declare Leaf1= object {
	#include "gtleaf3.inc"
        texture {txtLeaf_1} // apply tree texture  regardless of the tree structure
 }

#declare worldtreetype1= union {
	object {
		#include "gttree3.inc"
	        texture {txtTree_3}
	}
	object {
		#include "gtfoliage3.inc"
	}
}

#declare colLeaf=rgb <0.4,1,0.3>; // nice green
#declare txtLeaf_0=texture{pigment{colLeaf} finish{ambient 10 specular 0.3 roughness 0.01}}

#declare Leaf2= object {
	#include "gtleaf1.inc"
        texture {txtLeaf_0} // apply tree texture  regardless of the tree structure
 }

#declare worldtreetype2= union {
	object {
		#include "gttree1.inc"
	        texture {txtTree_3}
	}
	object {
		#include "gtfoliage1.inc"
	}
}

#declare treesonworld=4;

#declare worldtreesx=array[treesonworld]
#declare worldtreesz=array[treesonworld]
#declare worldtreescale=array[treesonworld]
#declare worldtreesdef=array[treesonworld]

#declare worldtreesx[0]=4000;
#declare worldtreesz[0]=-1600;
#declare worldtreescale[0]=1;
#declare worldtreesdef[0]=1;

#declare worldtreesx[1]=-2500;
#declare worldtreesz[1]=-2500;
#declare worldtreescale[1]=2;
#declare worldtreesdef[1]=2;

#declare worldtreesx[2]=-3500;
#declare worldtreesz[2]=-3800;
#declare worldtreescale[2]=1.65;
#declare worldtreesdef[2]=2;

#declare worldtreesx[3]=-740;
#declare worldtreesz[3]=-250;
#declare worldtreescale[3]=.65;

#declare treesonworld=3;//*********************

#declare counttrees=0;

#end
// ************************* START OF WORLD DEFINITION ****************************


#debug "About to start small world...\n"

#declare smallworld=object {
	union {
#if (TREES)
#while (counttrees<treesonworld)

object {
#if (QUICKTREES)
	sphere {
		<0,0,0>
		5
	}
#else
#switch (worldtreesdef[counttrees])
#case (1)
	object {worldtreetype1}
#break
#case (2)
	object {worldtreetype2}
#break
#end
#end
	rotate y*30*counttrees
	scale 30*worldtreescale[counttrees]
	translate <worldtreesx[counttrees],0,worldtreesz[counttrees]>
}

#declare counttrees=counttrees+1;
#end

#end //Trees

#if (COMPLEX)	

#include "bungalow.inc"
#include "car.inc"

	object {
		AWing
		scale 400
		rotate <0, 60, 0> //30
		translate <-2500,200,-7500>
	}
#end


	
difference {
union {
	height_field {
		png
		"smallworldhfexp.png"
		translate <-.5,0,-.5>
		texture { MapMaterialMap }		
		scale <20000,300,20000>
	}
	object {
		swtunnel
		rotate y*-.5
	}
	object {
		swtunnel
		rotate y*155
	}
	object {
		swtunnel
		rotate y*222.5
	}

intersection {
	object {
		sphere {
			<0,0,0>
			10000
		}
		scale .999999
		inverse
	}
union {
	object {
		backoftunnel
		rotate y*-.5
	}
	object {
		backoftunnel
		rotate y*155
	}
	object {
		backoftunnel
		rotate y*222.5
	}
}	
	texture {
		pigment {
			colour rgbf <1,.2,.2,.8>
		}
		finish {
			diffuse .3
			ambient 10
		}
	}

	}
#if (COMPLEX)
	object {
		BUNGALOW
		scale 9
		rotate y*-53
		translate <1300,0,-8400>
	}
	object {
		CAR
		scale 9
		rotate y*98
		translate <-5500,0,-100>
	}
#end
	cylinder {
		<0,-200,0>
		<0,30,0>
		1500
		texture {
			Blue_Sky
			scale 800
		}
		translate <7000,0,-1000>
	}

}	//Union close
//	union {
		sphere {
			<0,0,0>
			10000
			inverse
		}
		plane {
			y,
			0
		}
//		box {
//			<-11000,-1,-11000>
//			<11000,11000,11000>
//		}

//	}
}
}
}

// ************************* END OF WORLD DEFINITION ****************************
