 
 #include "colors.inc"     
 #include "functions.inc"  
 #include "stones.inc"        
 #include "woods.inc"

/* Chris Becker aka Topher (c) 2002 */
 
camera {
 location <0,6,16> 
 look_at <0,0,0>


}

light_source {<-5.4,16,10>   White 
area_light <3, 0, 0>, <0, 0, 3>, 10, 10
  adaptive 1
    jitter 
       }    

#declare fn_wood=function{
  pigment {
  wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>*3
    rotate <5, -45, 5>
    translate -x*2
    color_map {
        [0 color rgb 0]
        [.4 color rgb 0] 
        [.6 color rgb 1]
        [1 color rgb 1]
      }
    } 
    }
    
 plane {<0,1,0>,-1.5 pigment {  

  wood  
   turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>*3
    rotate <5, -45, 5>
    translate -x*2  
  } 
            
    normal {  
     
  function{
  fn_wood(x,y,z).gray
  }

    } }
      
#declare Blob_threshold=0.01;   
  
  // solid block
 isosurface{function{
      f_rounded_box(x,y,z, .01, 1, 1, 1)-f_crackle(x+3,y+3,z+3)*.3-f_granite(x,y,z)*.03} max_gradient 4 contained_by {box{-2,2}}   

   texture{T_Grnt2 translate <4,-.4,0>}
   rotate<0,-25,0>   
   translate <4,-.3,0>
   }
  
      
  // partially cut
 isosurface{function{(1+Blob_threshold)
      -Blob_threshold^(max(f_rounded_box(x,y,z, .01, 1, 1, 1),-f_sphere(x+1,y-1,z-1,1.7)-f_agate(x,y,z)*.2)-f_crackle(x+3,y+3,z+3)*.3-f_granite(x,y,z)*.03)
      -Blob_threshold^f_sphere(x,y,z,.7)} max_gradient 4 contained_by {box{-2,2}}   

   texture{T_Grnt2 translate <0,-.4,0>} rotate<0,-25,0> translate <0,-.3,0>}
  
          
  // almost fully cut
 isosurface{function{(1+Blob_threshold)
      -Blob_threshold^(max(f_rounded_box(x,y,z, .01, 1, 1, 1),-f_sphere(x,y-1,z,2.2)-f_agate(x,y,z)*.2)-f_crackle(x+3,y+3,z+3)*.3-f_granite(x,y,z)*.03)
      -Blob_threshold^f_sphere(x,y,z,.7)-f_granite(x,y,z)*.1} max_gradient 4 contained_by {box{-2,2}}   

   texture{T_Grnt2 translate <-4,-.3,0>}rotate<0,-25,0>
    translate <-4,-.4,0>   
    }
      
         
    
    
    union {  
    union {
    intersection {
    torus  {2,.1  rotate <90,0,0>}
    box{<0,0,0>,<-3,3,3>} 
    
     
    
    }
              
    
    sphere {<-2,0,0>,.1} 
    sphere {<0,2,0>,.1}    
    texture {T_Wood1} 
    
    }
    #declare i=1;
    #while (i<30)
     
     cone {<-cos(i/30*pi/2)*1.7,sin(i/30*pi/2)*1.7,0>,0,<-cos(i/30*pi/2)*2,sin(i/30*pi/2)*2,0>,.1 pigment {Silver}}
     
     #declare i=i+1;
    #end
     translate <-3.7,-.3,0>
     }   
     
     
      
    sphere {<6,-1,4>,.7 texture{T_Grnt2 translate <6,-1,4>} }    
    
    
    
    sphere {<-3,-1,4>,.7 pigment {Blue} normal {agate .5 scale .1 } } 
    // cheap brush 
    union {
     sphere_sweep {linear_spline 2 <1.5,1.5,0>,.05,<.8,.8,0>,.025 pigment {Black} finish{phong 1.0} } 
     cone {<.8,.8,0>,.05,<.6,.6,0>,0 pigment {Blue} normal {agate .5}}
    translate <3,-1,4> 
    }
    
    sphere {<3,-1,4>,.7 pigment {Blue} normal {agate .5 scale .1 }}
    isosurface{function { f_sphere(x, y, z, .7-.07)-f_bumps(x, y, z)*.1-f_granite(x/2, y/2, z/2)*.05} accuracy 0.0001 contained_by{sphere {<0,0,0>,5} } translate<-3,-1,4> pigment {granite color_map{[0 Green][1 Brown]}}}
    
    sphere {<0,-1,4>,.7 pigment {Blue} normal {agate .5 scale .1 } }
    isosurface{function { f_sphere(x, y, z, .7-.07)-f_bumps(x, y, z)*.1-f_granite(x/2, y/2, z/2)*.05} accuracy 0.0001 contained_by{sphere {<0,0,0>,5} } translate<0,-1,4> pigment {Brown}}
    // cheap brush 
    union {
     sphere_sweep {linear_spline 2 <1.5,1.5,0>,.05,<.8,.8,0>,.025 pigment {Black} finish{phong 1.0} } 
     cone {<.8,.8,0>,.05,<.6,.6,0>,0 pigment {Brown} normal {agate .5}}
    translate <0,-1,4> 
    }
      
    isosurface{function { f_sphere(x, y, z, .7-.07)-f_bumps(x, y, z)*.1-f_granite(x/2, y/2, z/2)*.05} accuracy 0.0001 contained_by{sphere {<0,0,0>,5} } translate<-6,-1,4> pigment {granite color_map{[0 Green][1 Brown]}}}
    
    sphere {<-6,-1,4>,.7 pigment {Blue} normal {agate .5 scale .1 } }
    
    sphere {<-6,-1,4>,.75 pigment {  agate scale 2 color_map{ 
         [0 color rgbt <1,1,1,0>]
         [.5 color rgbt <1,1,1,.3>] 
         [1 color rgbt <1,1,1,1>]    }     }
         normal { function {f_agate(x/1.5,y/1.5,z/1.5)}}  }
    // cheap brush 
    union {
     sphere_sweep {linear_spline 2 <1.5,1.5,0>,.05,<.8,.8,0>,.025 pigment {Black} finish{phong 1.0} } 
     cone {<.8,.8,0>,.05,<.6,.6,0>,0 pigment {White} normal {agate .5}}
    translate <-6,-1,4> 
    }
  
 
 #declare ShakerOutside= 
lathe {
cubic_spline
 6
<0,.25>,<0,1>,<.3,1>,<.4,0>,<0,0>,<0,0>   

}



#declare Shaker=  difference{

object {ShakerOutside}

// cuts on outside
sphere {<0,.5/3,.3>,.15  scale <1,3,1>}
sphere {<0,.5/3,-.3>,.15  scale <1,3,1>}
sphere {<.3,.5/3,0>,.15 scale <1,3,1>}
sphere {<-.3,.5/3,0>,.15  scale <1,3,1>}


}


// green shaker  
union {  

object{ Shaker
 pigment {White transmit .9}
interior{ior 1.3 caustics 1.0}
finish {phong 1.0 reflection .15} 
}

object {ShakerOutside 
pigment {granite color_map{[0 Green][1 Yellow]}}
scale <.6,.8,.6>
}

// top
difference {
lathe { 
6
<.3,1>,<.2,1.1>,<.1,1.05>,<.2,1.075>,<.25,1.2>,<0,1.25>  
}


cylinder {<.06,2,.06>,<.06,-3,.06>.03} 
cylinder {<.06,2,-.06>,<.06,-3,-.06>.03} 
cylinder {<-.06,2,-.06>,<-.06,-3,-.06>.03}  
cylinder {<-.06,2,.06>,<-.06,-3,.06>.03} 
pigment {Gray} 
finish {phong 1.0 reflection .15}    
}              
scale .5
rotate <0,0,135>
translate <-2.3,.5,4>
}


 sphere {<6,-1,4>,.7 texture{T_Grnt2 translate <6,-1,4>} } 
// sander 

union { 
difference { 
intersection {
 sphere {<0,0,0>,1 }
 box {<0,0,0>,<1,1,-1> }
 pigment {White}
 normal {bumps .5 scale .5}
 }
 sphere {<0,0,0>,.8 pigment {Tan} normal {agate 1.0 scale .1}}    

 }          
 union {
 cylinder {<1,1,-1>,<.7,.7,-.7>,.1}
 sphere { <1,1,-1>,.2 }     
 texture {T_Wood1} 
 finish {phong .5}
 }
  translate <6,0,4>
 }
 
   union { 
 sphere_sweep {linear_spline 2 <0,1,0>,.3,<0,0,0>,.2 texture {T_Wood1 rotate <45,45,45>}}  
 difference {
 cylinder {<0,0,0>,<0,-.5,0>,.2 pigment {White}  finish {reflection .5}} 
 sphere {<.1*2,-.6/3,.1*2>,.2 pigment {White} scale <.5,3,.5>  finish {reflection .5}}
 sphere {<.1*2,-.6/3,-.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}
 sphere {<-.1*2,-.6/3,-.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}  
 sphere {<-.1*2,-.6/3,.1*2>,.2 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}   
 
  sphere {<.1*2,-.6/3,0>,.1 pigment {White} scale <.5,3,.5>  finish {reflection .5}}
 sphere {<-.1*2,-.6/3,0>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}
 sphere {<0,-.6/3,-.1*2>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}  
 sphere {<0,-.6/3,.1*2>,.1 pigment {White}  scale <.5,3,.5>  finish {reflection .5}}

 }   
 rotate <0,4,45>   
 translate <-1.3,2,0>
}