#include "colors.inc"
#include "leafdefs.inc"
#include "splinetree.inc"

/* Chris Becker aka Topher  (c)2002 */

camera {
 location <0,.01,0> 
 look_at <0,3,0>
}  

light_source {<0,100,0>   White }
light_source {<0,.01,0>   White shadowless}     


#declare recursionmax = 4; // Defines the complexity of the tree
#declare divisions = array[5] {5,4,3,3,2}
init_rand (10,147,2)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.4, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.003, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <0,-0.1,0>;

// Variables for leaves
#declare leafarray = array[3] {maple1,maple2,maple3}
#declare leafprob = array[3] {0.6,0.6,0.6}
#declare leafscale = array[3] {0.3,0.3,0.3}
#declare leafnoise = array[3] {1,1,1}

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <1,1,1>
	rotate <0,0,0>
	translate <0,0.3,0>
}
#declare feedback = 2;

#declare Tree=union { splinetree(0,0) }

#declare S1=seed(4820);
#declare i=-1;
#while (i<=1) 
 #declare j=-1;
 #while (j<=1)
  #if (i=0 & j=0)
   #declare j=1;
  #end // if
     object {
        Tree           
        rotate<0,rand(S1)*360,0>
        translate <2*i,0,2*j> 
        scale <1,3,1>  
        }   
   #declare j=j+1;
  #end
 #declare i=i+1;
#end // while i

// the ground ( not seen )
plane {<0,1,0>,0 pigment {Green} normal{agate}}   

// pigments for the sky
#declare Waves = pigment {bumps scale .1 color_map{[0 Green*5][1 rgb<1,0,1>*5]}}  
#declare Waves2 = pigment {bumps scale .1 color_map{[0 Orange*5][1 Pink*5]}} 
#declare Agate2 = pigment {agate color_map{[0 White*5][.5 Red*5][1 rgb<1,0,1>]}}
#declare Agate = pigment{agate pigment_map {[0 Agate2][1 Waves2]}}  
#declare Hyper=pigment{agate scale .1 pigment_map{[0 Waves2][.25 Agate2][.5 Waves][1 Agate]}}

// the sky pigment
#declare Sky=pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>*2
                   color rgb <0.75, 0.75, 0.75>*2]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>*2
                   color rgbt <0, 0, 2, 0>]
          [0.5 1.0 color rgbt <0, 0, 2, 0>
                   color rgbt <0, 0, 2, 0>]
      }
      scale <0.1, 0.3, 0.1>/2
    }

  // the sky
  cone {<0,-1,0>,100,<0,200>,0 no_shadow 
  pigment {gradient y scale 200 pigment_map{[0 Sky][.4 Sky][1 Hyper]}}
   
}
   
  
    