//World in World


// Persistence of Vision Ray Tracer Scene Description File
// File: .pov                        
// Vers: 3.5                         
// Desc:    Room Window  Mobile Baby 
// Date:                      2.2002 
// Auth:                      Julius 

#version 3.5;

#include "colors.inc"

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
 
// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!
// --- general include files ---

#include "math.inc"       // general math functions and macros
#include "skies.inc"      // Ready defined sky spheres
#include "stars.inc"      // Some star fields

// --- textures ---
#include "finish.inc"     // Some basic finishes
#include "golds.inc"      // Gold textures
#include "metals.inc"     // Metallic pigments, finishes, and textures
#include "stones.inc"     // Binding include-file for STONES1 and STONES2
#include "stones1.inc"    // Great stone-textures created by Mike Miller
#include "stones2.inc"    // More, done by Dan Farmer and Paul Novak
#include "woodmaps.inc"   // Basic wooden colormaps
#include "woods.inc"      // Great wooden textures created by Dan Farmer and Paul Novak




#declare Mond= 1; // 1= ON 0= Off     
#declare Baby= 1; // 1= ON 0= Off
#declare Mob= 1; // 1= ON 0= Off 
#declare Light= 1; // 1= ON 0= Off
#declare Plant= 1; // 1= ON 0= Off
#declare Stoff= 1; // 1= ON 0= Off  
#declare HeightF= 1; // 1= ON 0= Off



// OWN INCLUDE-FILE

#if (Mob=1)
#include "WorlDinWorlD.inc"
#end
#if (Plant=1)
#include "plant.inc"
#end
#if (Baby=1)
#include "baby_g.inc"
#end
#if (Stoff=1)
#include "Decke1.inc"
#include "Vorhang1.inc"
#end

global_settings {
  assumed_gamma 3
}


camera {
  location  <0.0, 165, 100>
  look_at   <130, 100, 1000>          
}



     


sphere {
 0,100000 
 inverse no_shadow 
 texture {Starfield1  scale 3 }
}


#if (Light=1)
                      

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb 1*<1, 0.95, 0.75>       // light's color
  area_light
  <30, 0, 15> <0,15, 15> // lights spread out across this distance (x * z)
  3, 3                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-250, 180, 270>   // <x y z> position of light
} 
#else
light_source {
  <-250, 130, 270>            
  color rgb <1, 0.95, 0.7>  
}     
#end
// ----------------------------------------
     
#if (HeightF=1)   
 
height_field {
  gif "phobos2.gif"    
  texture {T_Stone21 }
  translate <-0.5,0,0>
  scale <2,0,0>
  scale <1000,80,1200>
  translate <0,20,600>
}     
#end


light_source
{
<500,400,550>
color rgb <0.2,0.3,0.4>*0.75
}
  
disc {0,y, 2000 pigment {color Pink}}

union {        
#if (Mond=1)         


#declare fn_X1 = function(x,y,z) { x*x + y*y + z*z - 1 } 
#declare fn_Pigm=function {
    pigment {
        agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
     scale .4
    }
  } 
  
isosurface {
  function {  sqrt (x*x+y*y+z*z)-1 +0.05*fn_Pigm(x,y,z).gray*0.5 }        
  contained_by { box { -1.2, 1.2 } }  
  accuracy 0.001                     
  max_gradient 4
  texture {                     
   pigment {color Silver}
   finish {phong 0.1 roughness 0.8}
  }
scale 1300
translate <0,150,15000>

}


#else 
sphere {0,1.2 pigment {color rgb 0.5}     
scale 1300
translate <0,150,15000>
}
#end 

rotate <0,-7,0>
} 


light_source {
  <-5000, -1500, 11000>            
  color rgb <1, 1, 1.025>*2 

} 


//mobile
#if (Mob=1)
object {Mobile scale 10 translate <50,270,320>}
#else
#end


// zimmer
union { //dreht alles


difference {
 box {<-610,-20,-160>,<410,280,510> pigment {color Pink}}
 box {<-600,1,-150>,<400,270,500>pigment {color White}}
 box {<50,100,490>,<250,230,520>pigment {color White}}  
 box {<-600,1,-150>,<400,0,500> texture {Cork scale 300}}
}
  box {<50,100,505>,<250,230,506>texture  {Glass}}  
  box {<50,100,492>,<250,105,520>texture {T_Wood21}}
      // Pflanze
    
union {
 #if (Plant=1)
 object { Plants scale 0.65 translate <132,0,450>} 
 #end
 difference {
  sphere {<15,15,450>,20 }   
  cylinder {<15,10,450><15,40,450>15}
  texture { 
   pigment {color Red}
   normal { bumps 0.4 scale 0.5 }
  }
 } 
 cylinder {
  <15,10,450><15,25,450>15 
  texture {
   pigment {Brown}
   normal { bumps 0.3 scale 0.2 }
   
  }
 }
translate <50,0,0>

}
// Vorhang
union {  

#declare d_stange = 1;  
#declare dh = -3;
cylinder {<45,240+dh,495>,<255,240+dh,495>,d_stange }
sphere {<45,240+dh,495> d_stange}
sphere {<255,240+dh,495> d_stange}
cylinder {<255,240+dh,495>,<255,240+dh,500>,d_stange }
cylinder {<45,240+dh,495>,<45,240+dh,500>,d_stange }
texture { pigment {Silver} }
}
#if (Stoff=1)
object {
 Vorhang     
 texture {
  pigment  {color rgbf <1,1,1,0.3>}
  normal {bumps 0.4 scale <1,15,1>} 
 }
 scale 240/10 scale <0.25,0.5,0.2>
 translate <70,115,490>
}

object {
 Vorhang     
 texture {
  pigment  {color rgbf <1,1,1,0.3>}
  normal {bumps 0.4 scale <1,15,1>} 
 }
 scale 240/10 scale <0.3,0.5,0.2>
 translate <70,115,490>
 translate <170,0,0>
} 
#end

// bettchen
union {
 box {<200,0,400>,<400,6,500>}
 difference {
  box {<200,8,400>,<400,6,500>}
  box {<210,0,410>,<390,10,490>}
 }
 difference {
  box {<200,68,400>,<400,66,500>}
  box {<210,60,410>,<390,70,490>}
 }


#declare Count = 0;
#while (Count < 20)
  cylinder {<205,1,495> <205,67,495> 1 translate <10*Count,0,0>} 
  cylinder {<205,1,405> <205,67,405> 1 translate <10*Count,0,0>}
  #declare Count = Count+1;   // increment our counter
#end

#declare Count = 0;
#while (Count < 9)
  cylinder {<205,1,495> <205,67,495> 1 translate <0,0,-10*Count>} 
  cylinder {<395,1,495> <395,67,495> 1 translate <0,0,-10*Count>}
  #declare Count = Count+1;   // increment our counter
#end 

texture {T_Wood5}
} 


//spiegel

union {
 torus {1,0.05 texture {T_Gold_2D}}
 cylinder {
  0,y*0.01,1 
  texture {
   pigment {color rgb 0.3}
   finish {reflection 0.9} 
  }
 }
rotate <90,0,0>
rotate <0,90,0>
scale <24,30,24>
translate <399,170,340>
}




//decke
 #if (Stoff=1)
object {
 Decke
 texture {
  pigment {color rgb <0.4,0.4,0.7> } 
  normal {bumps 0.7 scale 4} 
 }
 rotate <0,0,0>  
 scale 66/8 
 rotate <0,85,0>
 translate <200,4,450>
}
 #end





#if (Baby=1)


//baby
union {
 object{ P_Figure_1 }
 object{ P_Figure_3 }
rotate  <-90,0,0>
rotate <0,180,0>
scale 400
translate <250,3,450>

} 

#else
#end




rotate <0,-8,0>
translate <-120,0,0>
}

        