// Persistence of Vision Ray Tracer Scene Description File
// File: basic.pov
// Vers: 3.1g
// Desc: Worlds within Worlds competition
// Date: 2002 01 06
// Auth: Matthias M. Giwer
//

#version 3.1 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

global_settings {assumed_gamma 2.2
		max_trace_level 20 // 70 is too busy
		max_intersections 64
}

// ----------------------------------------
//stereo pair
#declare place = <-.99,.89,-.79>; //WR
//#declare place = <-.89,.89,-.79>; //WL

camera{
//  location  <-8.0, 0.0, 0.0>
location place
//  location  <-0, 0.0, -.5>

//fisheye

  direction 1.5*z  right  16/9*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere{  pigment  { gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }}}

light_source{0*x color <1,1,1> translate place }

// ----------------------------------------

sphere{0,.07 
pigment{ image_map {tga "earth-comp.tga" map_type 1} } 
rotate 180*y translate<0.3,0.3,0.3> finish{ambient .6}}

sphere{0,.07 
pigment{image_map {png "mars.png" map_type 1 }} 
translate<0.2,-0.2,-.2> finish{ambient .7}}

sphere{0,.07
pigment{ image_map {png "jupiter.png" map_type 1} } 
translate <-0.4,0.4,0.3> finish {ambient .6}}

#declare mirrors = union {
plane { x, -1 pigment {color rgb <0,0,0>} finish{reflection 1}}

plane { x, 1 pigment {color rgb <0,0,0>} finish{reflection 1}}

plane { y, -1 pigment {color rgb <0,0,0>} finish{reflection 1}}

plane { y, 1 pigment {color rgb <0,0,0>} finish{reflection 1}}

plane { z, -1 pigment {color rgb <0,0,0>} finish{reflection 1}}

plane { z, 1 pigment {color rgb <0,0,0>} finish{reflection 1}}
}

object {mirrors rotate <0,0,0>}// rotate<23, 45, 78>}
