// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "housemacro.inc"
#include "bauble.inc"

#declare Houses=on;
#declare Quick=on;
#declare FocalBlur=on;
#declare BlurSamples=20;
#declare Photons=on;
#declare AreaLight=on;
#declare AltCam=off;

#declare Complex=on;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  #if (Photons)          // global photon block
    photons {
      spacing 0.02                 // specify the density of photons
      //count 100000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      save_file "tempphotons.photons"       // save photons to file
      //load_file "tempphotons.photons"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }

  #end
}

// ----------------------------------------

#declare HBFP1=<3,1.93,0>;
#declare HBFP=HBFP1+x*.26+y*-.1+z*.07;
#declare HBFP2=HBFP-((z+y*3.5)*.2);


#if (AltCam) 
camera {
  location  <3.0, 4.5, 4.0>
  direction .7*z
  right     x*image_width/image_height
  look_at   <3.0, 3.0,  -3.0>
}
#else
camera {
  location  <3.0, 4.5, -4.0>
  direction 2*z
  right     x*image_width/image_height
  look_at   <3.0, 0.0,  3.0>
#if (FocalBlur)
  aperture .3           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples BlurSamples        // number of rays per pixel for sampling
  focal_point HBFP2    // point that is in focus <X,Y,Z>
  confidence 0.95           // [0...1] when to move on while sampling (smaller is less accurate)
  variance 1/200            // [0...1] how precise to calculate (smaller is more accurate)
#end
}
#end

//sphere {HBFP2,.07 pigment {colour Red}}


sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.7,0.8,1.0>]
      [0.7 rgb <0.4,0.5,1.0>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color White * 6// light's color
#if (AreaLight)
	area_light
	<25,0,0>
	<0,0,25>
	3,3
	circular
	orient
#end
  translate <300, 100, -7>
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
}

// ----------------------------------------

plane {
	y, -3
	pigment { // pattern for use in texture/pigment/normal/density
		granite        // create a granite-like texture
		turbulence .2
		color_map {
			[ 0.1  colour Gray50*.9]
			[ 0.15  colour White*.9]
			[ 1.0  colour White*.9]
		}
		scale 5
	}
#if (Complex)	normal {
		granite .1
		turbulence .2
		translate <4,4,4>
	}
#end
}

#declare BranchText= texture {
	pigment {
		granite        // create a granite-like texture
		color_map {
			[ 0.1  color rgb <0.0,0.0,0.0>*2 + Gray10]
  			[ 0.3  color rgb <0.2,0.1,0.1>*2 + Gray20]
  			[ 0.5  color rgb <0.1,.05,0.0>*2 + Gray20]
  			[ 0.9  color rgb <0.2,0.1,0.0>*2 + Gray20]
  			[ 1.0  color rgb <0.0,0.0,0.0>*2 + Gray10]
		} // color_map
	}
#if (Complex)	normal {
		granite .2
}
#end
	scale .1
	scale <1,3,1>
	
}	

#declare IceText=material {
	texture {
		pigment {
			colour rgbf <.9,.9,.9,.9>
		}
#if (Complex)		normal {
//			granite .5
			granite .6
			scale .1
		}
		finish {
			diffuse .3
			reflection .1
			specular .6
			roughness .08
		}
	}
	interior {
		ior 1.33
		media {
			scattering {
				1,
				rgb 0.1
			}
		}
#end
	}
}


#declare HBBranchStream=seed(123);
#declare HBIceStream=seed(26758);

#macro HBRandomBranch(HBLength, HBRadius1, HBRadius2, HBSpheres)
#local HBcount=0;
#local HBSegmentL=HBLength/HBSpheres;
#local HBStream=HBBranchStream;
#local HBRandScale=.2;

#local HBVertices=array[HBSpheres];
#local HBRadii=array[HBSpheres];

union {
	sphere_sweep {
	linear_spline                 // linear curve
	HBSpheres,
#while (HBcount<HBSpheres)

#local HBPercent=HBcount/(HBSpheres-1);
//#debug concat("Counter=",str(HBcount,3,3),"\n")
//#debug concat("Percent=",str(HBPercent,3,3),"\n")

#local HBVertices[HBcount]=<rand(HBStream)*HBRandScale,HBSegmentL*HBcount,rand(HBStream)*HBRandScale>;
#local HBRadii[HBcount]=(1-HBPercent)*HBRadius1+HBPercent*HBRadius2;

	HBVertices[HBcount], HBRadii[HBcount]

#local HBcount=HBcount+1;
#end
	texture {BranchText}
}

#local HBcount=0;

merge {
	sphere_sweep {
	cubic_spline                // alternative spline curves
	HBSpheres+2,
	HBVertices[0], HBRadii[0]*(0.2*rand(HBIceStream)+1.2)
#while (HBcount<HBSpheres)

	HBVertices[HBcount], HBRadii[HBcount]*(.2*rand(HBIceStream)+1.2)

#local HBcount=HBcount+1;
#end
	HBVertices[HBcount-1]+(HBVertices[HBcount-1]-HBVertices[HBcount-2]), HBRadii[HBcount-1]*(.2*rand(HBIceStream)+1.2)
	translate <0,-(HBRadius1+HBRadius2)/2,0>
	}
	sphere_sweep {
	linear_spline                // alternative spline curves
	HBSpheres,

#local HBcount=0;
#while (HBcount<HBSpheres)

	HBVertices[HBcount], HBRadii[HBcount]*1.5

#local HBcount=HBcount+1;
#end
	}

	material {IceText}
	photons {  // photon block for an object
		target 1.0
		refraction on
		reflection on
	}
}
}

#end

// FOREGROUND BRANCHES

object {
	HBRandomBranch(5,.05,.03,8)
//	translate y*1
	rotate -z*65
	translate y*1.3
	translate z*-2
}


union {
#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(6,.05,.03,8)
		
		translate y*1
		rotate -z*HBcount*10
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(5,.03,.02,8)
		
		rotate -z*HBcount*20
		translate y*-1
		translate x*2
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<4)	
	object {
		HBRandomBranch(5,.01,.01,8)
		
		rotate 90-z*HBcount*40
		translate y*-1
		translate x*1
		translate z*1
	}
#local HBcount=HBcount+1;
#end

}

// BACKGROUND (RATHER MORE RANDOM)

#declare HBBackg=seed(3059);

union {
#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(6,.05,.03,8)
		
		translate y*5
		rotate -z*HBcount*10
		translate y*-5
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(5,.03,.02,8)
		
		rotate -z*HBcount*20
		translate y*-1
		translate x*2
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<4)	
	object {
		HBRandomBranch(5,.01,.01,8)
		
		rotate 90-z*HBcount*40
		translate y*-1
		translate x*1
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end
	rotate z*-45
	rotate x*-5
	translate x*-.5
	translate y*1.5
	translate z*2
}

// BACKGROUND (SECOND PASS)


union {
#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(6,.05,.03,8)
		
		translate y*5
		rotate -z*HBcount*10
		translate y*-5
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<10)	
	object {
		HBRandomBranch(5,.03,.02,8)
		
		rotate -z*HBcount*20
		translate y*-1
		translate x*2
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end

#local HBcount=0;
#while (HBcount<4)	
	object {
		HBRandomBranch(5,.01,.01,8)
		
		rotate 90-z*HBcount*40
		translate y*-1
		translate x*1
		translate <0,0,rand(HBBackg)>
	}
#local HBcount=HBcount+1;
#end
	rotate z*-90
	rotate y*10
	translate x*-1
	translate y*2.5
	translate z*3
}


// House in background

#if (Houses)
union {
#declare HBNumFloors=1;	
#declare HBRoofOrient=0;	//0 - slope is side-to-side, 1-slope is front to back
#declare HBWindowAmount=0;		// 0: none, 1: few, 2: normal, 3: lots
#declare HBRoofAngle=1;		// 0: none, 1: few, 2: normal, 3: lots

	union {
		HBMakeHouse()
		translate x*2
		translate y*-3
		translate z*.3
	}

#undef HBNumFloors
#undef HBRoofOrient
#undef HBWindowAmount
#undef HBRoofAngle

	HBMakeHouse()

	scale 3
	rotate y*215
	translate y*-3
	translate <0,0,-22>
}
union {
	HBMakeHouse()
	scale 3
	translate y*-3
	translate <16.5,0,27>
	rotate y*-3
}
#end

union {
object {
	HBBauble
	scale .2
	rotate y*-30
}
	translate HBFP
}