#macro HBWindowFrame(HBCorner1, HBCorner2, HBWidth)

#debug "\nWindow Frame Start\n"

//#debug concat("Corner one: ",str(HBCorner1.x,3,3),", ",str(HBCorner1.y,3,3),", ",str(HBCorner1.z,3,3),"\n")
//#debug concat("Corner two: ",str(HBCorner2.x,3,3),", ",str(HBCorner2.y,3,3),", ",str(HBCorner2.z,3,3),"\n")

#local HBXDiff=(HBCorner1.x-HBCorner2.x);
#local HBYDiff=(HBCorner1.y-HBCorner2.y);
#local HBZDiff=0;	// ignore z values


#ifndef (HBWindowType)
#local HBWindowType=1;// 0= no inner frame, 1= both, 2= upright only, 3=horizontal only
#debug "Using default window type\n"
#end

#ifndef (HBCrossBeamHeight)
#if (HBXDiff/HBYDiff>1.3)
#local HBCrossBeamHeight=.75;	// Height of cross beam, in fraction of total window height
#else
#local HBCrossBeamHeight=.5;
#end
#end

#local HBFrameDepth=4-HBInteriorScale*4;

union {
union {	
	// Outer Frame
		//beams
	box {
		<HBCorner1.x-HBWidth,HBCorner1.y-HBWidth, -HBWidth-HBFrameDepth>
		<HBCorner1.x-HBXDiff+HBWidth,HBCorner1.y+HBWidth, +HBWidth>
	}
	box {
		<HBCorner1.x-HBWidth,HBCorner2.y-HBWidth, -HBWidth-HBFrameDepth>
		<HBCorner1.x-HBXDiff+HBWidth,HBCorner2.y+HBWidth, +HBWidth>
	}

		// Uprights
	box {
		<HBCorner1.x-HBWidth,HBCorner1.y-HBWidth, -HBWidth-HBFrameDepth>
		<HBCorner1.x+HBWidth,HBCorner1.y-HBYDiff+HBWidth, +HBWidth>
	}
	box {
		<HBCorner2.x-HBWidth,HBCorner1.y-HBWidth, -HBWidth-HBFrameDepth>
		<HBCorner2.x+HBWidth,HBCorner1.y-HBYDiff+HBWidth, +HBWidth>
	}
	
	//Inner bit
	
#switch (HBWindowType)
#case (1)
	box {
		<HBCorner1.x-HBWidth/2,HBCorner1.y-HBYDiff*HBCrossBeamHeight-HBWidth/2, -HBWidth/2>
		<HBCorner1.x-HBXDiff+HBWidth/2,HBCorner1.y-HBYDiff*HBCrossBeamHeight+HBWidth/2, +HBWidth/2>
	}
	box {
		<HBCorner1.x-HBXDiff/2-HBWidth/2,HBCorner1.y-HBWidth/2, -HBWidth/2>
		<HBCorner1.x-HBXDiff/2+HBWidth/2,HBCorner1.y-HBYDiff+HBWidth/2, +HBWidth/2>
	}
#break
#case (2)
	box {
		<HBCorner1.x-HBXDiff/2-HBWidth/2,HBCorner1.y-HBWidth/2, -HBWidth/2>
		<HBCorner1.x-HBXDiff/2+HBWidth/2,HBCorner1.y-HBYDiff+HBWidth/2, +HBWidth/2>
	}
#break
#case (3)
	box {
		<HBCorner1.x-HBWidth/2,HBCorner1.y-HBYDiff/2-HBWidth/2, -HBWidth/2>
		<HBCorner1.x-HBXDiff+HBWidth/2,HBCorner1.y-HBYDiff/2+HBWidth/2, +HBWidth/2>
	}
#break
#end
	texture {
		HBWindowFrame1T
	}
	}

	box {
		HBCorner1-<0,0,1.1*HBFrameDepth>
		HBCorner2-<0,0,1.2*HBFrameDepth>
		texture {
			HBCurtainsT
		}
		interior {
		//	HBCurtainsI
		}
	}
	box {
		HBCorner1
		HBCorner2
		texture {
			HBGlassT
		}
		interior {
			HBGlassI
		}
	}
	translate z*(4-HBWidth/2)
	scale <1,1,-1>
}
#debug "Window Frame End\n"

#end // End window macro
