// banc public

#version unofficial megapov 0.72;

#declare IMPORT_SPATCH = on;

#declare PiedBanc1 = #include "PiedBanc.inc"
#local PBmin = min_extent(PiedBanc1);
#local PBmax = max_extent(PiedBanc1);

#local Crack=height_field{
	pattern 600,600{granite scale .005 color_map{[.3 rgb 0][1 rgb 1]}}
	rotate -x*90 translate .05*z
	scale <PBmax.x-PBmin.x,PBmax.y-PBmin.y, .1>
}


#declare PiedBanc = difference{
	intersection {
		object{PiedBanc1}
		box{PBmin-.01, PBmax+.01}
	}
	object{Crack translate <PBmin.x, PBmin.y, 6>}
	object{Crack scale <1,1,-1> translate <PBmin.x, PBmin.y, -6>}
	scale 3
	texture{
		pigment{granite scale .5 color_map{[.6 rgb 1][.9 rgb .3]}}
		normal{granite -2.5 scale .05}
	}
	texture{pigment{wrinkles scale 2 color_map{[0 rgbf 1][1 rgbf <0.443,0.380,0.259,.7>]}}}
}

#local PBmin = min_extent(PiedBanc);
#local PBmax = max_extent(PiedBanc);
#local Long=PBmax.x-PBmin.x;
#local Haut=PBmax.y-PBmin.y;

#declare Inter=array[7]
#declare Norm=array[7]

#declare Norm[0]=<0,0,0>;
#declare Inter[0] = trace(PiedBanc, <PBmax.x-.05*Long, PBmax.y,0>, -y, Norm[0]);
#declare Norm[1]=<0,0,0>;
#declare Inter[1] = trace(PiedBanc, <PBmax.x-.20*Long, PBmax.y,0>, -y, Norm[1]);
#declare Norm[2]=<0,0,0>;
#declare Inter[2] = trace(PiedBanc, <PBmax.x-.35*Long, PBmax.y,0>, -y, Norm[2]);
#declare Norm[3]=<0,0,0>;
#declare Inter[3] = trace(PiedBanc, <PBmax.x-.50*Long, PBmax.y,0>, -y, Norm[3]);

#declare Norm[4]=<0,0,0>;
#declare Inter[4] = trace(PiedBanc, <PBmax.x, PBmax.y-.10*Haut,0>, -x, Norm[4]);
#declare Norm[5]=<0,0,0>;
#declare Inter[5] = trace(PiedBanc, <PBmax.x, PBmax.y-.25*Haut,0>, -x, Norm[5]);
#declare Norm[6]=<0,0,0>;
#declare Inter[6] = trace(PiedBanc, <PBmax.x, PBmax.y-.40*Haut,0>, -x, Norm[6]);


#local PigLatte=texture{
	pigment{image_map{tga "059bois"}}
	normal{bump_map{tga "059bois"}bump_size 1.2}
	rotate x*90 rotate y*90
}

#local TexLatte=texture{
	pigment_pattern{planar scale <1,3,1> translate 2 color_map{[0 rgb 0][1 rgb 1]}}
	texture_map{
		[.0 PigLatte scale 40]
		[.1 PigLatte scale 35]
		[.2 PigLatte scale 30]
		[.3 PigLatte scale 25]
		[.4 PigLatte scale 20]
		[.5 PigLatte scale 15]
		[.6 PigLatte scale 10]
		[.7 PigLatte scale 5]
		[.8 PigLatte scale 3]
		[.9 PigLatte scale 2]
		[1. PigLatte scale 1]
	}
}

#include "reorient.mcr"

#declare Banc=union{
	object{PiedBanc}
	object{PiedBanc translate 220*z}

	#local stb=seed(1342);
	#local i=0;
	#while (i<7)
		union{
			difference{
				box{<-8,0,-30>,<8,4,250>}
				cylinder{-.1*y, 4.1*y, 2}
				cylinder{-.1*y, 4.1*y, 2 translate 220*z}
				texture{TexLatte translate <500*rand(stb), 2*rand(stb)-1, 500*rand(stb)>}
			}
			intersection{
				difference{
					sphere{0,5 translate -4*y}
					box{<-.2,.5,-2>, <.2,1.1,2> rotate y*360*rand(stb)}
				}
				cylinder{0,1.1*y,1.9}
				translate 2*y
			}
			intersection{
				difference{
					sphere{0,5 translate -4*y}
					box{<-.2,.5,-2>, <.2,1.1,2> rotate y*360*rand(stb)}
				}
				cylinder{0,1.1*y,1.9}
				translate 2*y+220*z
			}
			texture{pigment{color rgb <0.225,0.365,0.751>}finish{brilliance 2}}
			#if (vdot(y, Norm[i]) > 0)
				Reorient(y, Norm[i])
			#else
				Reorient(y, -Norm[i])
			#end
			translate Inter[i]
		}
		#local i=i+1;
	#end
}

/*
sphere{Inter1, 2 pigment{rgb x}}
sphere{Inter2, 2 pigment{rgb x}}
sphere{Inter3, 2 pigment{rgb x}}
sphere{Inter4, 2 pigment{rgb x}}
sphere{Inter5, 2 pigment{rgb x}}
sphere{Inter6, 2 pigment{rgb x}}
sphere{Inter7, 2 pigment{rgb x}}
*/

/*
background { color rgb <0, 0, 0> }

camera {
	location <56.405, 73.412, -48.412>*6
	angle 30	
	look_at <22.889, 25.000, 0.000>*3
}

light_source { < 0, 100, -200 > color rgb <0.4, 0.5, 0.4> }
light_source { < 200, 300, -60 > color rgb <1, 1, 1> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

object{Banc}
*/
