/*
POVRAY 3.5b Source File

IRTC Scene: Subject: Winter. 

A Cold Evening After the snowstorm. 

A snowstorm has hit. Everyone's inside, staying warm. The heat has melted the
ice on the roof, and icicles have formed. 

Scene File 
*/
#include "colors.inc"
#include "functions.inc"
#include "tree.inc"

// Scene Switches
#declare render_snow = on;      // Snow Heightfield
#declare use_unitcam =off;      // Special camera to use when developing objects#
#declare use_farcam = off;
#declare use_ortho = on;
#declare use_photons = on;
#declare use_fresnel = off;
#declare final_size=100; // Final size of the icecicles

global_settings {

max_trace_level 100

#if (use_photons)
    photons {
        spacing 0.01
        //count 20000
        //autostop 0    
    }
#end
    
}


#if (use_unitcam)
background {color Gray75}
camera { 
    #if (use_ortho)
        orthographic
    #end
    location <0, 0, -2>
    look_at <0, 0, 0>
}
#else
camera {
    #if (use_farcam)
    location <200, 200, -200>   
    #else
    location <10, 0, -100>   
    #end 
    look_at <-200, 20, 50>
}
#end

//sphere { <0, 0, 0>, 1 pigment {color White}}

#if (use_unitcam)
    light_source { <-20, 20, -20> color White }
#else
    light_source { <-500, 500, -500> color White }
#end


//-----------------------------------------------------------------------------       
// Texture Definitions
//-----------------------------------------------------------------------------       

// The bricks for the house. A reddish brick texture
#declare BrickTexture = pigment { 
    granite

    color_map {
        [0.0 rgb <0.8, 0.3, 0.0>]
        [1.0 rgb <0.6, 0.1, 0.0>]
    }        
}     
    

// The mortar between the bricks. Think concrete gray
#declare MortarTexture =  pigment { 
    granite
    color_map {
        [0.0 Gray75]
        [1.0 Gray50]
    }        
} 

// The shingles on the roof. 
#declare ShingleTexture = pigment {
    
    agate
    color_map {
        [0.0 Gray50]
        [1.0 Gray75]
    }
}


// The frosty window panes. 
#declare PaneTexture = texture {
    pigment { 
        //wood
        function { -f_superellipsoid(x,y,z,0.5, 0.5) }
        scale 1       
        color_map {
            [0.0 White filter 1.0]
            [0.3 White filter 1.0]
            [0.5 rgb <0.84, 0.99, 1.0> filter 0.5]
            [1.0 rgb <0.84, 0.99, 1.0> filter 0.5] 
        }
    }
    finish {
        reflection { 0.001, 0.5 fresnel use_fresnel}
        conserve_energy
    }
}

#declare IceTexture = texture {
    pigment {color rgb <0.84, 0.99, 1.0> filter 0.9}
    finish {
        reflection { 0.001, 0.5 fresnel use_fresnel}
        specular 0.5 roughness 0.001
        conserve_energy
    }
}

#declare IceTexture2 = texture {
    pigment {color rgb <0.84, 0.99, 1.0> filter 1.0}
    finish {
        reflection { 0.001, 0.5 fresnel use_fresnel}
        specular 0.5 roughness 0.001
        conserve_energy
    }
    normal { bozo 1.0 scale <0.005, 0.02, 0.02>}
}

// Refraction on such a thin object seems rediculous, but I'm using fresnel reflections. 
#declare PaneInterior = interior {    
    ior 1.5
}

#declare IceInterior = interior {
    ior 1.33
}


//-----------------------------------------------------------------------------       
// Object Definitions
//-----------------------------------------------------------------------------       
    
// A brick block, Will eventually be the house. We'll Cut out the inside and add a window and a light
#declare building = difference {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.0, 0.5>
        pigment { brick pigment{MortarTexture} pigment{BrickTexture} 
            mortar 0.5
            scale 0.01}
        
        normal { brick normal {agate 0.5 scale 0.01} normal {agate 1.0 scale 0.01}
            mortar 0.5
            scale 0.01
        }
    }
    box { -0.5, 0.5 
        pigment{ color White}
        scale <0.90, 0.90, 0.90>
    }
}

// -- The window

// Each divider between the window panes
#declare window_dividers = union {
    
    #local i = 0;
    
    #while (i < 4) 
        box {<-0.5 + i * (1/3), -0.5, -0.0011>, <0.01 + -0.5 + i * (1/3), 0.51, 0.0011>}
        box {<-0.5, -0.5 + i * (1/3), -0.0011>, <0.51, 0.01 + -0.5 + i * (1/3), 0.0011>}
        #local i = i + 1;
    #end
    
    pigment {
        color Black
    }
    
}

// Each window pane, complete with frosting.
#declare pane = box { <-0.5, -0.5, -0.001>, <0.5, 0.5, 0.001>
    texture {PaneTexture}
    interior {PaneInterior}
    photons {
        collect off
        reflection on
        refraction on
    }
}

// A collection of window panes, at 1/3 size. (The window is unit-sized for easy fit)
#declare window_panes= union {
    #local i = 0;
    
    #while (i < 3) 
        #local j = 0;
        #while(j < 3)
            
            object {pane
                translate <i - 1, j - 1, 0>
                scale <1/3, 1/3, 1>
                }
            
           
            #local j = j + 1;
        #end
        #local i = i + 1;
    #end       
}


// Put the pieces together to make a whole window. 
#declare window = union {
    object{window_dividers}
    object{window_panes}
}


// The building with a window
#declare building_with_window = union {
    
    difference {

        object { building }
        box {-0.5, 0.5
            scale <0.15, 0.25, 3>
            translate <-.25, -.25, -1.5>
            
            pigment { color White }
        
        }
    }
    object {window 
        scale <0.15, 0.25, 1>
        translate <-0.25, -0.25, -0.5>
    }
    
}


// A Block with snow on it. Will be the roof
#declare snowyshingles = union {
    
    box { <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
        pigment { brick pigment{color Black} pigment{ShingleTexture}
            mortar 0.35
            scale <0.01, 0.045, 0.01>
        }
        
        normal { brick normal {agate 0.5 scale 0.01} normal {agate 1.0 scale 0.01}
            mortar 0.35
            scale <0.01, 0.045, 0.01>
        }
    }
    
    height_field { tga "hf_roofsnow.tga" 
    translate -0.5
    scale <1.0, 0.1, 1.0>
    rotate x*90
    translate z*-0.540
    
    pigment {color rgb<0.84, 0.99, 1.0> }
    
    }
}

    
// The soffet(??) (Part of the roof, block that hangs down, just below the eaves. 
#declare soffet = union { 
    box { -0.5, 0.5 
        scale <1.1, 0.05, 0.1>
        pigment{ color White }
        normal{wood 1.0 turbulence 0.02
            scale 0.0012
            rotate 91*y
        }
    }
    
    box { -0.5, 0.5 
        scale <1.1, 0.05, 0.01>
        translate z*-0.051 
        texture {IceTexture2}
        interior {IceInterior}
        photons {
            collect off
            reflection on
            refraction on
        }
        
        //pigment { color rgb<0.84, 0.99, 1.0> transmit 1.0
    }
}


//An Icecicle, This will be the "mother of all icecicles"

#declare f_cone = function { sqrt(x^2 + z^2) + y }

#macro icecicle(p1,p2,l,w) 
isosurface { 
    
    //function { -f_superellipsoid(x,y,z,0.5,1) }
    function { f_cone(x,y,z) - f_noise3d(x,y*(2*(l*10))+p1,z*(10*1)+p2)*0.1 }
    contained_by { box {<-0.5, -0.4, -0.5>,0.5} }
    max_gradient 5
    translate 0.4*y
    scale <.5*w, 2*l, .5*w>
    translate -0.5*y
    rotate 180*z
  
}
#end

// A row of icicles, sized to fit, when the house is scalled 100*
#declare icicles = union {
    #local loc = 0;
    #local R1 = seed(0);
    #while(loc < final_size)
        
        #local p1=0 + rand(R1) * 100;
        #local p2=0 + rand(R1) * 100;
        #local l= 10 + rand(R1) * 5;
        #local w= 0.5 * l * rand(R1);
        
        object{icecicle(p1,p2,l,w) translate x*loc}
        #local loc=loc+(w*0.5);
        #debug "Created Icicle: p1="
        #debug str(p1,0,3)
        #debug ", p2="
        #debug str(p2,0,3)
        #debug ", l="
        #debug str(l,0,3)
        #debug ", w="
        #debug str(w,0,3)
        #debug "...\n"
        
    #end
    scale 1/final_size// make it unit-sized. 
    translate -0.5*x // Center it ... 
    texture {IceTexture}
    interior {IceInterior}
    photons {
        collect off
        reflection on
        refraction on
    }    
}
// The roof of the house. 
#declare roof = union{
    
    difference {
    
        object{snowyshingles rotate 45*x}
        box {<-1, -1, -1>, <1, 0.0, 1>}
        scale <1.1, 0.4, 0.85>
    } 
    object {soffet  translate <-0.00, -0.025, -0.55> }
    object {icicles scale <1.07, 1, 1> translate <0.00, -0.050, -0.58> }
}

//----------------------------------------------------------------------------/      
// Development area        

// The house, complete with a window, a roof, and some chilly, cold icecicles
union {
    object {roof }
    object {building_with_window}
    light_source {<0.0, -0.1, 0.0> color rgb <1.0, 0.5, 0.2> looks_like {sphere{ 0, 0.1 pigment {color White}}}}
    
    scale 100
}


sky_sphere {

    pigment { bozo 
        color_map {
            [0.0 color Gray25]
            [0.1 color Gray50]
            [1.0 color rgb <0.85, 0.95, 1.0>]
        }
        scale <0.2, 0.032, 1>
        
    }
    
}

//-----------------------------------------------------------------------------       
// Putting it all together, The scene!
//-----------------------------------------------------------------------------       
#if(!use_unitcam) // unitcam is used for developing objects
// The Snow
#if (render_snow)
height_field { tga "hf_snowdrifts.tga" 
    
    pigment {color rgb<0.84, 0.99, 1.0>}
    finish { specular 1.0 roughness .5 }
    normal { granite 0.1 scale 0.5 }
    
    translate -.5*x
    translate -.5*z
    translate -.5*y
    scale <1000, 20, 1000>
    translate y*-50
    translate x*-500
    
    
    
}
#end

union {
#declare i = 0;
#declare R1 = seed(R1);
#while (i < 20)
    #local TreeX = rand(R1) * 1000 - 500;
    #local TreeY = rand(R1) * 1000 - 500;
    
    object {tree translate <TreeX, -20, TreeY>}
    
    #local i = i+1;
#end
    translate y*-50
    translate x*-500
}

    

// The house, complete with a window, a roof, and some chilly, cold icecicles
union {
    object {roof }
    object {building_with_window}
    light_source {<0.0, -0.1, 0.0> color rgb <1.0, 0.5, 0.2> looks_like {sphere{ 0, 0.1 pigment {color White}}}}
    
    scale 100
}


// The depressing, gloomy sky
sky_sphere {

    pigment { bozo 
        color_map {
            [0.0 color Gray25]
            [0.1 color Gray50]
            [1.0 color rgb <0.85, 0.95, 1.0>]
        }
        scale <0.2, 0.032, 1>
        
    }
    
}

#end
