#include "colors.inc"

global_settings{
 adc_bailout .01
 ambient_light rgb <1,150/255,0>
 assumed_gamma 2.2
}
 
light_source{<0,10,-30>rgb <.75,.3,.25>*.65}
light_source{<0,10,-30>White*.07}
//test light source
//light_source{<0,10,-30>White}
camera{
 location <0,3.5,-7.5>
 look_at <0,3,0>
 angle 75 
}

//back wall
box{
 <8,10,0>
 <-8,0,1>
 pigment{
  cylindrical
  color_map{
   [0 color White]
   [.9 color Red]
   [.99 color White]
   [1 color Blue]
  }
  scale <1,100,1>
  //scale 5
 }
}
/*           
//floor          
box{
 <8,0,0>
 <-8,-1,-5>
 pigment{Green}
 finish{phong .25 specular .5 diffuse .5 crand .2 roughness 1}
} */

#declare hardwood_base=
pigment{
 wood 
 turbulence .1
 scale .05
}

#declare finishes=
finish{reflection .1 phong .2}

//hardwood floor
union{
 box{
  <7,0,0>
  <6,-1,-5>
  pigment{
   hardwood_base
  }
  finish{finishes}
 }

 box{
  <6,0,0>
  <5,-1,-5>
  pigment{
   hardwood_base
  }
  finish{finishes}
 }
 
 box{
  <5,0,0>
  <4,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <4.3,0,-.5>,.17 strength 8.5 falloff 3.2 inverse}
   warp{black_hole <4.9,0,-1.75>,.21 strength 6 falloff 1.4 inverse}
  }
  finish{finishes}
 }
 
 box{
  <4,0,0>
  <3,-1,-5>
  pigment{
   hardwood_base 
   warp{black_hole <3.5,0,-4>,.2 strength 9 falloff 6.35 inverse}
  }
  finish{finishes}
 }
 
 box{
  <3,0,0>
  <2,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <2.5,0,-3.75>,.2 strength 8 falloff 3 inverse turbulence .1 }
   warp{black_hole <2.85,0,-1.5>,.21 strength 6 falloff 2 inverse turbulence 1}
  }
  finish{finishes}
 }
 
 box{
  <2,0,0>
  <1,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <1.5,0,-4>,.2 strength 8 falloff 3 inverse turbulence 1}
   warp{black_hole <1.7,0,-2.5>,.1 strength 7 falloff 2 inverse}
   warp{black_hole <1.2,0,-1>,.15 strength 6 falloff 3 inverse}
  }
  finish{finishes}
 }
 
 box{
  <1,0,0>
  <0,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <.2,0,-1>,.16 strength 7 falloff 2.1 inverse}
   warp{black_hole <.85,0,-3.8>,.12 strength 9 falloff 3.6 inverse}
  }
  finish{finishes}
 }
 
 box{
  <0,0,0>
  <-1,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <-.3,0,-2.6>,.18 strength 4.6 falloff 1.9 inverse}
  }
  finish{finishes}
 }
 
 box{
  <-1,0,0>
  <-2,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <-1.4,0,-3>,.2 strength 4 falloff 3 inverse}
   warp{black_hole <-1.8,0,-1>,.16 strength 6 falloff 5.2 inverse}
  }
  finish{finishes}
 }
 
 box{
  <-2,0,0>
  <-3,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <-2.6,0,-1.9>,.19 strength 7 falloff 6.2 inverse} 
   warp{black_hole <-2.1,0,-3.58>,.2 strength 8 falloff 2 inverse}
  }
  finish{finishes}
 } 
 
 box{
  <-3,0,0>
  <-4,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <-3.65,0,-2.75>,.16 strength 4 falloff .8 inverse}
  }
  finish{finishes}
 }
 
 box{
  <-4,0,0>
  <-5,-1,-5>
  pigment{
   hardwood_base
   warp{black_hole <-4.3,0,-1>,.1 strength 6 falloff 2 inverse}
  }
  finish{finishes}
 }
 
 box{
  <-5,0,0>
  <-6,-1,-5>
  pigment{
   hardwood_base
  }
  finish{finishes}
 }
 
 box{
  <-6,0,0>
  <-7,-1,-5>
  pigment{
   hardwood_base
  }
  finish{finishes}
 } 
}

//picture on fireplace
union{
 box{
  <1.5,4.75,-.75>
  <-1.5,6.75,-.76>
  pigment{
   image_map{
    sys "Sunset.bmp"
   }
   scale <3,2.2,2.5>
   translate <-1.5,.15,0>
  }
 }
  //frame
 box{
  <1.5,4.75,-.75>
  <1.56,6.75,-.76>
  pigment{
   wood
   scale .08
  }
 }
 
 box{
  <1.56,6.75,-.75>
  <-1.56,6.81,-.76>
  pigment{
   wood
   scale .05
  }
 }
 
 box{
  <-1.56,6.75,-.75>
  <-1.5,4.75,-.76>
  pigment{
   wood
   scale .08
  }
 }
 
 box{
  <-1.56,4.75,-.75>
  <1.56,4.69,-.76>
  pigment{
   wood
   scale .05
  }
 }
 translate y*-.2 
 finish{ambient .3}
}
//fireplace
difference{
 box{
  <3,0,0>
  <-3,4,-1.5>
  pigment{
   brick
   scale .125
   translate y*-.1
  }
  finish{crand .2 phong .02}
 }
 
 box{
  <2.5,.01,-.1>
  <-2.5,3.5,-2.5>
  pigment{
   brick
    color White color rgb <247/255,244/255,206/255>
    scale .125
    scale <2,2,1>
    turbulence .75
  }
  finish{crand .05 phong 0}
 }
}

cylinder{
 <0,0,0>
 <0,.008,0>,2.5
 pigment{
  brick
  color rgb .75 color Black
  scale .125
  turbulence .25
 }
 finish{crand .2 phong .5}
 scale <1,1,.5>
 translate z*-1.5
}

torus{
 2.5,.004
 pigment{rgb .8}
 finish{reflection .8 phong .7}
 scale <1,1,.5>
 translate z*-1.5
}

box{
 <2,4,0>
 <-2,11,-.75>
 pigment{
  brick
  scale .125
 }
 finish{crand .2 phong .02}
}


//fireplace stuff (i.e. tools, rack for logs, etc)
 //rack for logs
 union{
  #declare base=
  difference{
   cylinder{
    <0,0,.5>
    <0,0,-.5>,.25
   }
   
   cylinder{
    <0,0,.6>
    <0,0,-.6>,.24
   }
   translate y*.25
  }
  
  #declare cut=
  difference{
   cylinder{
    <.6,0,0>
    <-.6,0,0>,1
   }
   
   cylinder{
    <.7,0,0>
    <-.7,0,0>,.25
   }
  }
  
  #declare wood_rack=
  difference{
   object{base}
   object{cut}
  }
  
  #declare mount=
  difference{
   cylinder{
    <.005,0,0>
    <-.005,0,0>,.05
   }
   
   cylinder{
    <.1,.02,0>
    <-.1,.02,0>,.01
   }
  }
  
  #declare handle=
  difference{
   torus{
    .27,.01
    rotate x*90
   }
   
   box{
    <1,0,-1>
    <-1,-1,1>
   }
  }
  //wood holder
  union{
   object{wood_rack translate y*.01}
   
   box{
    <.15,0,-.2>
    <-.15,.01,-.19>
   }
   
   box{
    <.15,0,.2>
    <-.15,.01,.19>
   }
   union{
    object{handle translate y*.27}
    sphere{<.27,.27,0>,.01}
    cylinder{
     <.27,.27,0> 
     <.23,.27,0>,.009
    }
    cylinder{
     <.23,.27,.04>
     <.23,.27,-.04>,.009
    }
    sphere{<-.27,.27,0>,.01}
    cylinder{
     <-.27,.27,0> 
     <-.23,.27,0>,.009
    }
    cylinder{
     <-.23,.27,.04>
     <-.23,.27,-.04>,.009
    }           
    translate y*-.27
    rotate x*76  
    translate y*.27
   }
   object{mount translate <.245,.25,0>}                 
   object{mount translate <-.245,.25,0>}
   pigment{rgb .2}
   finish{reflection .2 phong .2}
   translate y*-.25
   scale 2
   translate y*.5  
  } 
  //extra wood
  cylinder{
   <0,.17,.75>
   <0,.17,-.75>,.15
   pigment{
    wood
    scale .03125
    warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
    warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
   }
  }
  
  cylinder{
   <0,.17,.75>
   <0,.17,-.75>,.15
   pigment{
    wood
    scale .03125
    warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
    warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
   }
   translate <.26,.16,0>
  }
  
  cylinder{
   <0,.17,.75>
   <0,.17,-.75>,.15
   pigment{
    wood
    scale .03125
    warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
    warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
   }
   translate <-.26,.16,0>
  }
  
  cylinder{
   <0,.17,.75>
   <0,.17,-.75>,.15
   pigment{
    wood
    scale .03125
    warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
    warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
   }
   translate y*.3
  }
  rotate y*-60
  translate <-2.75,0,-2.25>
 }
 
 //tool rack
  cylinder{
   <0,0,0>
   <0,.05,0>,.3
   pigment{rgb .2}
   normal{
    bumps
    scale .01
    turbulence 1
   }
   translate <2.5,0,-2.75>
  }
  
  union{  
   torus{
    .3,.001
    scale <1,30,1>
    translate y*.03
   }            
   
   cylinder{
    <0,0,0>
    <0,1,0>,.03125
   }
   
   box{
    <.2,1,.03125>
    <-.2,1.01,-.03125>
   }
   
   box{
    <.03125,1,.2>
    <-.03125,1.01,-.2>
   } 
   
   cone{
    <0,1,0>,.01
    <0,1.075,0>,.02
   }
   
   sphere{
    <0,0,0>,.02
    scale <1,1.5,1>
    translate y*1.075
   }
   
   cone{
    <0,1.08,0>,.02
    <0,1.15,0>,.01
   }
   
   sphere{
    <0,1.15,0>,.025
   }
   #declare holder=
   difference{
    cylinder{
     <.2,1,0>
     <.2,1.01,0>,.03125
    }
    
    cylinder{
     <.205,.9,0>
     <.23,1.1,0>,.018
    }
   }
   
   object{holder}
   object{holder rotate y*90}
   object{holder rotate y*180}
   object{holder rotate y*270}
   pigment{rgb .2}
   finish{reflection .2 phong .2}
   translate <2.5,0,-2.75>
  } 
 
 //tools for fireplace 
 //shovel
 union{
  cone{
   <0,.99,0>,.01
   <0,1.065,0>,.02
  }
  
  sphere{
   <0,0,0>,.02
   scale <1,1.5,1>
   translate y*1.065
  }
  
  cone{
   <0,1.07,0>,.02
   <0,1.14,0>,.01
  }
  
  sphere{
   <0,1.14,0>,.025
  }
   
  cylinder{
   <0,.99,0>
   <0,.65,0>,.01
  }
  
   sphere{<0,.65,0>,.01}
   
  #declare main_shovel=
  union{
   cylinder{
    <0,0,0>
    <0,-.01,0>,.1
    rotate x*90
    translate y*.55
   }
   
   box{
    <-.1,.253,0>
    <.1,.55,-.01>
   }
  }
 
  #declare base_shovel=
  union{
   cylinder{
    <0,0,0>
    <0,-.01,0>,.1
    rotate x*90
    translate y*.55
   }
    
   box{
    <-.1,.253,0>
    <.1,.55,-.01>
   }
   translate y*-.253
   scale <.8,1,1.8>
   translate y*.251
  } 

  difference{
   object{main_shovel}
   object{base_shovel}
   translate z*.005
  }
 
  translate z*.22
  translate <2.5,0,-2.75>
  pigment{rgb .2}
  finish{reflection .2 phong .2}
 }
  //hook thing
  union{ 
   cone{
    <0,.99,0>,.01
    <0,1.065,0>,.02
   }
   
   sphere{
    <0,0,0>,.02
    scale <1,1.5,1>
    translate y*1.065
   }
   
   cone{
    <0,1.07,0>,.02
    <0,1.14,0>,.01
   }
   
   sphere{
    <0,1.14,0>,.025
   }
   
   cylinder{
    <0,.99,0>
    <0,.65,0>,.01
   }
   
   cone{
    <-.31,.99,0>,.01
    <-.31,1.065,0>,.02
   }
   
   sphere{
    <-.31,0,0>,.02
    scale <1,1.5,1>
    translate y*1.065
   }
   
   cone{
    <-.31,1.07,0>,.02
    <-.31,1.14,0>,.01
   }
   
   sphere{
    <-.31,1.14,0>,.025
   }
   
   cylinder{
    <-.31,.99,0>
    <-.31,.65,0>,.01
   }
   
   sphere{<0,.65,0>,.01}
   sphere{<-.31 ,.65,0>,.01}
   
   cylinder{
    <0,0,0>
    <0,-.35,0>,.01
    rotate z*-40
    translate y*.65
   }
   
   cylinder{
    <0,0,0>
    <0,-.35,0>,.01
    rotate z*40
    translate <-.31,.65,0>
   }
   
   sphere{<-.223,.385,0>,.01}
   sphere{<-.087,.385,0>,.01}
   
   difference{
    torus{
     .07,.01
     rotate x*90
     scale <1,1.5,1> 
     translate <-.155,.358,0>
    }
    
    box{
     <1,.385,1>
     <-1,10,-1>
    }
    
    box{
     <-.14,.4,1>
     <-.175,0,-1>
    }
   }
    
   rotate y*-45
   translate x*.22   
   pigment{rgb .2}
   finish{reflection .2 phong .2}
   translate <2.5,0,-2.75>
  }
  
 //glass around fireplace
  difference{
   box{
    <1,2,-.015625>
    <-1,.03125,.015625>
   }
   
   box{
    <0,2.5,-.015625>
    <1,0,-.03125>
    rotate y*-5
    translate x*.9
   }
   
   box{
    <0,2.5,-.015625>
    <-1,0,-.03125>
    rotate y*5
    translate x*-.9
   }
   
   box{
    <-2.5,0,-.015625>
    <2.5,2,-.03125>
    rotate x*5
    translate y*1.9
   }
   
   box{
    <-2.5,0,-.015625>
    <2.5,-2,-.03125>
    rotate x*-5
    translate y*.13125
   }
   pigment{rgbf <.95,.95,.95,.9>}
   interior{ior 1.33}
   translate z*-2 
  }
  
  box{
   <.8,2,-.015625>
   <-.8,.03125,.015625>
   translate <.8,0,.015625>
   rotate y*-18.2
   translate <1,0,-2>
   pigment{rgbf <.95,.95,.95,.9>}
   interior{ior 1.33} 
  }
  
  box{
   <.8,2,-.015625>
   <-.8,.03125,.015625>
   translate <-.8,0,.015625>
   rotate y*18.2
   translate <-1,0,-2>
   pigment{rgbf <.95,.95,.95,.9>}
   interior{ior 1.33} 
  }
 
  //frame for glass
  union{ 
   union{          
    cylinder{
     <0,2,0>
     <-1.6,2,0>,.03125
    }
    
    cylinder{
     <0,.03125,0>
     <-1.6,.03125,0>,.03125
    }
    
    cylinder{
     <-1.6,2,0>
     <-1.6,.03125,0>,.03125
    }
    rotate y*18.2
    translate <-1,0,-2>
   }
   
   union{          
    cylinder{
     <0,2,0>
     <1.6,2,0>,.03125
    }
    
    cylinder{
     <0,.03125,0>
     <1.6,.03125,0>,.03125
    }
    
    cylinder{
     <1.6,2,0>
     <1.6,.03125,0>,.03125
    }
    rotate y*-18.2
    translate <1,0,-2>
   }
   union{
    cylinder{
     <1,2,-2>
     <-1,2,-2>,.03125
    }
    
    sphere{<1,2,-2>,.03125}
    
    cylinder{
     <1,2,-2>
     <1,.03125,-2>,.03125
    }
    
    sphere{<1,.03125,-2>,.03125}
    
    cylinder{
     <1,.03125,-2>
     <-1,.03125,-2>,.03125
    }
    
    sphere{<-1,.03125,-2>,.03125}
    
    cylinder{
     <-1,.03125,-2>
     <-1,2,-2>,.03125
    }
    
    sphere{<-1,2,-2>,.03125}
   }
   pigment{Yellow}
   finish{reflection .7 phong .8 diffuse .5}
  }
 //fireplace rack for firewood
 union{
  box{
   <.05,0,.05>
   <-.05,.25,-.05>
   translate <.5,0,-.75>
  }
  
  box{
   <.05,0,.05>
   <-.05,.25,-.05>
   translate <-.5,0,-.75>
  }                               
   
  box{
   <.85,.25,-.8>
   <-.85,.35,-.7>
  }
  
  box{
   <.85,.25,-.6>
   <-.85,.35,-.5>
  }
  
  box{
   <.85,.25,-.4>
   <-.85,.35,-.3>
  }
  
  box{
   <.55,.25,-.7>
   <.45,.35,-.3>
  }
  
  box{
   <-.55,.25,-.7>
   <-.45,.35,-.3>
  }
  
  box{
   <.55,0,-.3>
   <.45,.25,-.25>
  }
  
  box{
   <-.55,0,-.3>
   <-.45,.25,-.25>
  }
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*-20
   translate <.5,.25,-.75>
  }
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*-20
   translate <0,.25,-.75>
  }
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*-20
   translate <-.5,.25,-.75>
  }                        
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*20
   translate <-.5,.25,-.3>
  }
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*20
   translate <0,.25,-.3>
  }        
  
  box{
   <.05,0,.05>
   <-.05,.6,-.05>
   rotate x*20
   translate <.5,.25,-.3>
  }        
  
 translate z*-.25
 pigment{Black}
 finish{phong .5 reflection .1 diffuse .5}
}

//logs for fire

union{
 cylinder{
  <.75,.55,-.55>
  <-.75,.55,-.55>,.15
  pigment{
   wood
   scale .03125
   warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
   warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
  }
 }
 
 cylinder{
  <.75,.55,-1>
  <-.75,.55,-1>,.15
  pigment{
   wood
   scale .03125
   warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
   warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
  }
 }
 
 cylinder{
  <.75,.85,0>
  <-.75,.85,0>,.15
  rotate y*20
  translate z*-.75
  pigment{
   wood
   scale .03125
   warp{black_hole <0,.55,-.55> 1 strength .75 inverse}
   warp{black_hole <1,.2,-.75> 1 strength 2 inverse}
  }
 }
}

//fire

#declare fire=
texture{     
  pigment{
   waves
   color_map{
    [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
    [ 0.08    rgbft <0.98, 1.0, 0.02, 0.08, 0.0> ]
    [ 0.29    rgbft <1.0, 0.74, 0.01, 0.4, 0.0> ]
    [ 0.53    rgbft <1.0, 0.16, 0.01, 0.67, 0.0> ]
    [ 0.79    rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
    [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
   }
   turbulence 0.2
   omega 0.8
   sine_wave
   scale  <1, .65, 1>
   //rotate z*-120          
   translate <0,7.125,0>
  }

 finish{ambient .25}
}
#declare inner_light=
interior{
 media{
  emission 1
  rgb <.75,.25,0>
 }
}

box{
 <.75,.5,-.89999>
 <-.75,1.5,-.9>
 texture{fire translate <-1,.05,0>}
  interior{
   inner_light
 }
}
#declare center=-.899999;
light_source{<0,1.35,-.899999>rgb <234/255,64/255,21/255>*.2}
//light_source{<0,1.5,center>White}