//	Persistence of Vision Ray Tracer Scene Description File
//	File: icefishing.pov
//	Date: 4.14.02 
//	Author: RJay Hansen
//global_settings { assumed_gamma 1.8 }

//#include "colors.inc"
#include "fisherman.inc"
#include "pineTree1.inc"
#include "pineTree2.inc"
#include "ls2.inc"
#include "tacklebox3.inc"
#include "splash3a.inc"
#include "skies.inc"
#include "mysaw.inc"

//background { color rgb < 0.490028, 0.736583, 1.0 > }
camera {
	perspective 
	location <9.0, 8, -16>
	look_at <0.0, 4.0, 2.0>
}

//camera {
//	perspective 
//	location <-253, 40, 330>
//	look_at <-253, 41, 365>
//}

//camera {
//	perspective 
//	location <-0, 650, 150>
//	look_at <-0, 0, 150>
//}

light_source {
	<0.10, 100, -100>
	rgb <.35, .35, .35>
	shadowless
}
light_source {
	<0, 100, -100>
	rgb <1.0, 1.0, 1.0>
	shadowless
}

light_source {
	<-2, 1000, -2800>
	rgb <1.0, 1.0, 1.0>
	area_light < 10,  0.0, 0.0 >,   < 0,  10, 0.0 >,  6,  6
}


//sky from skies.inc
sky_sphere { S_Cloud2 
						rotate y*30}
						
fog {
	fog_type 2	//ground_fog
	up <0.0, 1, 0.0>
	fog_offset 8
	fog_alt 25
	distance 395
	rgb <0.92, 0.92, 0.92>
//	turbulence 2
//	turb_depth 0.5
}

//our frozen pond with hole for fishing
difference {
	box {
		<-800, -0.5, -800>, <800, 0, 800>
		texture {
			pigment {
				rgbf <1.000000, 1.000000, 1.000000>
			}
			finish {
//				ambient rgb <.30, .30, .30>
				reflection .15
				specular .875
				roughness 0.0018
			}
		}
	}
	cylinder {
		<0.0, -2, 0.0>, <0.0, 1, 0.0>, 1.25
		texture {
			pigment {
				rgbf <1.000000, 1.000000, 1.000000>
			}
			finish {
//				ambient rgb <.35, .35, .35>
				reflection .15
				specular .875
				roughness 0.0018
				diffuse .5
			}
		}
	}
}
//dark object to color water
box {
	<-50, -5, -50>, <50, -2, 50>
		pigment { color rgb < 0.007202, 0.084977, 0.179995 > }
}

////a splash fromt he fishing line
object { mySplash 
//					rotate y*50
//					scale .012
					scale .009
					translate y*-.3
					}
			
object { fisherMan
					rotate y*30		
					translate <4.3, 5.25, 6.6> 
					}

object { tackleBox2
					rotate y*45
					translate <8, .0425, 8.75>
					}
//here's a bobber
union {
				sphere {
					<0.0, 0.0, 0.0>, 0.5
					texture {
						pigment {
							gradient <0.0, 1.0, 0.0>
							color_map {
								[ 0.0 rgb <1.000000, 0.220020, 0.259159> ]
								[ .5 rgb <1, 0.220020, 0.259159> ]
								[ .5 rgb <1.000000, 0.988968, 0.340017> ]
								[ 1 rgb <1, 0.988968, 0.340017> ]
							}
						}
						finish {
							reflection rgb <.075, .075, .075>
							specular .875
							roughness 0.0055
							diffuse .5
						}
//						scale .5
						translate y*.5
					}
				}
				cylinder {
					<0.0, -0.6, 0.0>, <0.0, 0.6, 0.0>, 0.075
					pigment { color rgb <1.000000, 0.988968, 0.340017> }
					finish {
							reflection rgb <.075, .075, .075>
							specular .875
							roughness 0.0755
							diffuse .5
						}
						
				}
				rotate z*-45
				translate <14, .4, 6.5>
				scale .5
			}
//saw for cutting the hole
object { mySaw
				rotate y*15
				translate <-6, .115, 6>
				}
					
object { landScape
					scale < 2, 2.5, 2>
					translate y*-8
				}
				
object { pineTree2
				scale .2
				translate < -8, 35, 285 >
		}
object { pineTree1
				rotate y*30
				scale .2
				translate < -40, 38, 320 >
			}
object { pineTree2
				rotate y*65
				scale .2
				translate < -110, 42, 360 >
		}

object { pineTree2
				rotate y*155
				scale .2125
				translate < -150, 36, 280 >
		}
object { pineTree1
				rotate y*110
				scale .185
				translate < 12, 33.5, 335 >		
			}
object { pineTree1
				rotate y*210
				scale .21
				translate < 42, 32, 370 >		
			}
object { pineTree1
				rotate y*230
				scale .16
				translate < -210, 27.3, 280 >		
			}
object { pineTree2
				rotate y*210
				scale .22
				translate < -170, 44, 370 >		
			}
object { pineTree2
				rotate y*190
				scale .16
				translate < -270, 27, 240 >		
			}
object { pineTree1
				rotate y*36
				scale .205
				translate < -253, 51, 365 >		
			}
object { pineTree1
				rotate y*290
				scale .217
				translate < -320, 35, 210 >		
			}