//textures

#declare f_SpiralPolar =
	function(fDist, fTheta, fFreq, fCurve) {
		pow(
			cos(
				(fTheta + (fDist*fCurve))*fFreq/2
			)
			,2
		)
	}

#declare f_Spiral =
	function(u,v, fFreq, fCurve) {
		f_SpiralPolar(sqrt(u*u+v*v), atan2(v,u), fFreq, fCurve)
	}



//base pigment
#declare pBaseColour =
	pigment {
		m_CellProbStart(5,<50,7,50>)
		pigment_map {
			m_CellProb(.2, pRedPaint)
			m_CellProb(.6, pBluePaint)
			m_CellProb(.2, pStripesBY)
		}
	}



/*
good fonts
aardv			- aardvarkbold - nascar
asimov		- asimov - diag digi
coprgtb		- Copperplate Gothic Bold - gamesworkshop
cs				- Cybertown Subterranean - digi
kabel			- kabel - v nice rounded sans serif
macropsi	- macropsia - understated digi
*/

//decals. text and symbols placed randomly over the surface.
#declare pDecal_Numbers =
	pigment {
		object {
			merge {
				m_TextBlock( "cs.ttf",	"9",	.6, 0*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "cs.ttf",	"3",	.6, 1*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "cs.ttf",	"7",	.6, 2*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
				m_TextBlock( "cs.ttf",	"2",	.6, 3*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
			}
			rgbt 1, rgb 0.04
		}
		warp { repeat x*4 }
		warp { repeat y offset 2*x }
		warp { repeat z }
	}

#declare pDecal_Symbols =
	pigment {
		object {
			merge {
				m_TextBlock( "lucon.ttf", "\n.\\",	1/2, 0*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", "\\.",		1/2, 1*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", ".\\/",		1/2, 2*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
				m_TextBlock( "lucon.ttf", "\n./",	1/2, 3*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
			}
			rgbt 1, rgb 1
		}
		warp { repeat x*4 }
		warp { repeat y offset 3*x }
		warp { repeat z }
	}

#declare pDecal_Text =
	pigment {
		object {
			merge {
				m_TextBlock(
					"kabel.ttf",
					"Garbage wurble narble\nmoo baa fishy bum\ngurgley gurgle\n\n   foobar:\n   chinky linky 17\n   pintwoul 8.2\n   pludom 4\n\nFOOBAR\n",
					<1,1,1>/16, 0,
					TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP
				)				
				m_TextBlock(
					"kabel.ttf",
					"fact facts factual\nmore facts\nimportant info\nunreadable\n\n\n",
					<1,1,1>/16, 0,
					TEXT_ALIGN_RIGHT, TEXT_ALIGN_BOTTOM
				)
				m_TextBlock(
					"ariblk.ttf",
					"WARNING!\n\nplaying with large pov\nspaceships may be\nhazardous to your\nhealth.\n",
					<1,1,1>/13, x,
					TEXT_ALIGN_CENTRE, TEXT_ALIGN_CENTRE
				)
				m_TextBlock(
					"arial.ttf",
					"some fully justified text saying\nnothing of any interest to\nanyone but me. - Tek   \n",
					<1,1,1>/13, x*2,
					TEXT_ALIGN_SCALE, TEXT_ALIGN_BOTTOM
				)
			}
			rgbt 1, rgb 1
		}
		warp { repeat x*3 }
		warp { repeat y offset 7*x }
		warp { repeat z }//offset 7*x }
	}

#declare pDecalsZm =
	pigment {
		m_CellProbStart(-1,1)
		pigment_map {
			m_CellProb(.02, pDecal_Numbers)
			m_CellProb(.12, pDecal_Symbols)
			m_CellProb(.16, pDecal_Text)
			m_CellProb(-1, rgbt 1)
		}
		translate .5
		scale 1.5+1000*z
	}

#declare pDecals =
	pigment {
		slope { x }
		pigment_map {
			[.25	pDecalsZm rotate 90*y]
			[.25	pDecalsZm]
			[.75	pDecalsZm]
			[.75	pDecalsZm rotate -90*y]
		}
	}
//cube map.

//minimise code
//create another object (rename stuff as needed).


//windows
#declare pWindows =
	pigment {
		cells
		translate .5*z
		scale <1,1,1000>
		pigment_map {
			[.9	rgbt 1]
			[.9
				function { min(abs(sin(x*pi)),abs(sin(y*pi))) }
				scale <1/5,1,1/5>
				pigment_map {
					[.5 rgbt 1]
					[.5 cells //good god not another one.
							colour_map {
								[.7	rgb <1,.8,.6>/20]
								[.7	rgb <1,.8,.6>]
							}
					]
				}
			]
		}
		scale <8,1,8>*1
	}

//full texture:
//	big numbers (outlined, e.g. red on yellow), mid sized symbols, small text. 
//	panels
//	[dirt]
//	[["texture" - maybe just noise, or brushing...]]

#declare tFullTexture =
	texture {
		pigment { pBaseColour }
		finish {
			brilliance 5
		}
		normal {
			nPanels
			scale 1.45
		}
	}
	texture {
		pigment {
			pDecals
		}
		//todo: drybrush pigment (if poss pull transmit trick to actually brighten underlying colour, i.e. multiply and add to)
		//todo: MAKE INCLUDE AND OBJECTS WITH DIFF DETAILS!
		finish {
			reflection {
				.03, .07
				//falloff
				//exponent .1
			}
			specular .7//1
			roughness .007//0.004
		}
		normal {
			nPanels
			scale 1.45
		}
	}
	texture {
		//lights (also, could rand pos rows of lights, project flat onto obj cull if norm >45 from proj dir, difference lights from obj, texture on inner face (to get lit up) but not on frame.)
		pigment {
			slope { x }
			pigment_map {
				[.25	pWindows rotate 90*y translate 70]
				[.25	pWindows translate 4*8000*z ]
				[.75	pWindows translate 4*8000*z]
				[.75	pWindows rotate -90*y translate -80]
			}
		}
		finish { diffuse .5 ambient .5 }
	}





//objects

//base object
#declare gfObjectBoundingRad = 80; //bigenough to fit base object.
#declare oBaseObject =
//	sphere { 0, 20 }
	merge {
		difference {
			merge {
				//head
				sphere { 0, 20 }
				
				//tail bit
				intersection {
					#local fAng = 40;
					#local fRad = 100;
					intersection {
						torus {
							fRad, 14
							rotate 90*z
						}
						plane { x, 12 }
						plane { -x, 12 }
						plane {
							z, 0
							rotate 2*fAng*x
						}
						translate -fRad*y
					}
					plane {
						-z, 0
					}
					rotate -fAng*x
				}//intersection
			}//merge
			
			//dents in head
			sphere { 30*x, 20 }
			sphere { -30*x, 20 }
		}//difference
		
		//bulges in dents
		sphere { 10*x, 7 }
		sphere { -10*x, 7 }

		translate -20*z
	}//merge

//detailing objects.
//all details are modelled along +z, and rotated to surface norm.
#declare nDetailsNum = 6;
#declare aoDetail = array[nDetailsNum];

//aerial
#declare aoDetail[0] =
	merge {
		//along y
		cone { 0, 0.1, y, 0.06 }
		cone { y, 0.04, 3*y, 0.04 }
		cone { 3*y, 0.02, 5*y, 0.02 }
		torus { .14,.03 translate y*2 }
		torus { .09,.02 translate y*4 }
		
		pigment { rgb .2 }
		finish {
			specular 1
			roughness 0.2
			reflection .4
		}
		
		//rotate to be along z
		rotate <90,0,0>
	}
//make this object more common than others.
#declare aoDetail[1] = aoDetail[0]
#declare aoDetail[2] = aoDetail[0]
#declare aoDetail[3] = aoDetail[0]
#declare aoDetail[4] = aoDetail[0]

//docking plug thing
#declare aoDetail[5] =
	merge {
		//along y
		cone { -y/2, 2.8, y/4, 1.8 }
		cone { y/4, 1.5, y*.4, 1.5 }
		
		texture {
			function {
				f_Spiral(x,z, 7,1)
			}
			texture_map {
				[0
					pigment { rgb 0.1 }
				]
				[.1
					tBoltGun
				]
			}
		}		

		scale .7

		//rotate to be along z
		rotate <90,0,0>
	}
	


//full object:
//	apply details to base object using CSG. [extension: do some/all as functions, apply using maths)
//		arrangement should have some regularity.
//	apply texture last, so objects that want their own texture can do so.
#declare oFullObject =
	//note: to change csg opt per obj type, do a "for obj" loop here, pick the CSG needed (and apply
	//to earlier result, i.e. redefine ofullobj), and cull all obj that don't match.
	union {
		object { oBaseObject }
	
		#local rsDetail = seed(75);
		#local rsPos = seed(79);

		//scatter loop. we may want to use regularity here		
		#local nObj = 0;
		#while ( nObj < 100 )
		
			//choose/compute position of detail
			#local vPos = <rand(rsPos),rand(rsPos),rand(rsPos)>;
			//sphere distribution
			#local vPos = vPos*<2,2,0> - <0,1,0>;
			#local vPos = pi*<vPos.x,select(vPos.y,-pow(vPos.y,2)/2,pow(vPos.y,2)/2),0>;
			#local vPos = <cos(vPos.x)*cos(vPos.y),sin(vPos.y),sin(vPos.x)*cos(vPos.y)>;
			
			//project to object
			#local vNorm = <0,0,0>;
			#local vPos = trace( oBaseObject, vPos*gfObjectBoundingRad, -vPos, vNorm );

			#if ( vNorm.x != 0 | vNorm.y != 0 | vNorm.z != 0 )
			
				//select detail to apply
				#declare nDetail = (nDetailsNum - .001) * rand(rsDetail);
				
				//apply it
				object {
					aoDetail[nDetail]

					Reorient_Trans(z, vNorm)
					translate vPos
				}
				
			#end

			#local nObj = nObj + 1; //only step on if obj created.
		#end //while ( nObj )
		
		texture { tFullTexture }
	} //union
	
