// Persistence of Vision Ray Tracer INCLUDE File
// File:	Trees.inc
// Vers:	3.01 Watcom Win32
// Desc:	Object Definition Code for Trees
// Date:	April 1, 1997
// Auth:	Sonya Roberts

#include "colors.inc"
//#debug "-Tree \n"


// ==== Default Settings ====

#ifndef (True)		#declare True=1;			#end
#ifndef (False)		#declare False=0;		#end
#ifndef (MaxSplits)	#declare MaxSplits=4;		#end	// Maximum number of forks in a section of Tree (minimum of 1)
#ifndef (MinSplits)	#declare MinSplits=3;		#end	// Minimum number of forks in a section of Tree (minimum of 1)
#ifndef (IncSplits)	#declare IncSplits=1;		#end	// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
#ifndef (BaseLen)	#declare BaseLen=1;		#end	// Base Length (length of smallest twig - determines scale of tree)
#ifndef (LengthInc)	#declare LengthInc=1.2;		#end	// Factor By Which to Increase Base Length
#ifndef (MinXDeg)	#declare MinXDeg=35;		#end	// Minimum X-rotation of forks
#ifndef (MaxXDeg)	#declare MaxXDeg=55;		#end	// Maximum X-rotation of forks
#ifndef (IncXDeg)	#declare IncXDeg=0;		#end	// Number of degrees to increment X by at each level
#ifndef (MinYDeg)	#declare MinYDeg=0;		#end	// Minimum Y-rotation of forks
#ifndef (MaxYDeg)	#declare MaxYDeg=360;		#end	// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
#ifndef (IncYDeg)	#declare IncYDeg=0;		#end	// Number of degrees to increment Y by at each level
#ifndef (MinZDeg)	#declare MinZDeg=0;		#end	// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
#ifndef (MaxZDeg)	#declare MaxZDeg=0;		#end	// Maximum Z-rotation of forks
#ifndef (IncZDeg)	#declare IncZDeg=0;		#end	// Number of degrees to increment Z by at each level
#ifndef (PlusMinus)	#declare PlusMinus=20;		#end	// Angle of change of terminal fork
#ifndef (SD1)		#declare SD1=seed(2);		#end	// Seed for random numbers - changing only this will create a different tree of the same species
#ifndef (SD2)		#declare SD2=seed(1997);		#end	// Seed for additional randum numbers - so tree shape won't change from optional code
#ifndef (SD3)		#declare SD3=seed(1);		#end	// Seed for additional randum numbers - so tree shape won't change from optional code
#ifndef (BallJoint)	#declare BallJoint=True;		#end	// Turns on and off the spheres used to smooth intersections of the branches and trunks
#ifndef (BallLevels)	#declare BallLevels=2;		#end	// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
#ifndef (LeafNum)	#declare LeafNum=3;		#end	// Number of Leaves (not counting leaf object at tip of twig)
#ifndef (LeafRosette)	#declare LeafRosette=False;	#end	// If true, leaves are arranged in rosette around twig rather than spiral up twig
#ifndef (LeafRandRot)	#declare LeafRandRot=False;	#end	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)

#ifndef (Tip)		#declare Tip=1;			#end	// Select either 0=None, 1=Leaf, 2=Fruit, or 3=Flower
#ifndef (TipPercent)	#declare TipPercent=1;		#end	// Percentage of tips that should have a tip object
#ifndef (TipOther)	#declare TipOther=1;		#end	// Tip object to use when the remaining percent of the time

#ifndef (LeafShape)	#declare LeafShape=0;		#end	// Select leaf: 0=Default Oval, 1=User (Leave), 2=Maple/Ivy, 3=Teardrop, 4=Bent Leaf, 5=Pine, 6=Oak Map, 7=Gingko Map, 8=Palmetto Map
#ifndef (LeafTexture)	#declare LeafTexture=0;		#end	// Select leaf texture: 0=Default PaleGreen, 1=User (Leaves), 2=Dark Green, 3=Lime Green, 4=YellowGreen, 5=Wheat

#ifndef (FruitShape)	#declare FruitShape=0;		#end	// Select fruit: 0=Small Sphere, 1=User (Fruits), 2=Large Sphere, 3=Lemon, 4=Banana, 5=Three Berries
#ifndef (FruitTexture)	#declare FruitTexture=0;		#end	// Select fruit texture: 0=Default Red, 1=User (Fruity), 2=Orange, 3=Blackberry, 4=Peach/Yellow, 5=White

#ifndef (BarkTexture)	#declare BarkTexture=0;		#end	// Select bark: 0=Default Brown, 1=User (Bark), 2=Birch, 3=Poplar, 4=Pine, 5=Lighter Brown

#ifndef (FlowerShape)	#declare FlowerShape=0;		#end	// Select flower: 0=Default, 1=User (Flowers), 2=Trumpet, 3=Cup, 4=Spiky, 5=Arches
#ifndef (FlowerTexture)	#declare FlowerTexture=0;	#end	// Select flower texture: 0=Default (White/Orchid Gradient), 1=User (Bloom), 2=Red & White Radial, 3=White, 4=Orange=Yellow Gradient, 5=Purple-Violet Gradient
#ifndef (mydebugging)   #declare mydebugging = false; #end

// ---- SET UP VARIABLES AND PIECES OF TREE
#declare TreeBarkTexture=
texture {
	#switch (BarkTexture)
		#case (0)							// Default Bark
			pigment {color White }
			normal {
				bumps .6
				scale <.05,.1,.05>
			}
		#break

		#case (1)							// User-defined Bark Texture
			#ifndef (Bark)
				pigment {color Tan}
				normal {
					bumps .6
					scale <.05,.1,.05>
				}
			    #else
				Bark
			#end
		#break

		#case (2)							// Birch Bark (White and Black)
			pigment {
				agate
				color_map {
					[0.00 color rgb<0.000, 0.000, 0.000>]
					[0.17 color rgb<0.000, 0.000, 0.000>]
					[0.18 color rgb<1.000, 1.000, 1.000>]
					[0.57 color rgb<1.000, 1.000, 1.000>]
					[0.58 color rgb<0.000, 0.000, 0.000>]
					[0.63 color rgb<0.000, 0.000, 0.000>]
					[0.63 color rgb<1.000, 1.000, 1.000>]
					[1.00 color rgb<1.000, 1.000, 1.000>]
				}
				rotate <0.0, 0.0, 90.0>
			}
			finish {
				ambient 0.3
			}
			scale <2.0, 0.1, 2.0>
		#break

		#case (3)							// Poplar (Greenish Tan)
			#debug " - Using poplar bark texture\n"
			pigment {
				granite
				color_map {
					[0.00 color rgb<0.608, 0.596, 0.424>]
					[0.24 color rgb<0.514, 0.588, 0.392>]
					[0.51 color rgb<0.639, 0.651, 0.451>]
					[0.52 color rgb<0.506, 0.408, 0.071>]
					[0.59 color rgb<0.498, 0.396, 0.071>]
					[0.60 color rgb<0.710, 0.698, 0.490>]
					[1.00 color rgb<0.718, 0.706, 0.490>]
				}
				rotate <0.0, 0.0, 90.0>
			}
			finish {
				ambient 0.3
			}
			scale <2.0, 0.1, 2.0>
		#break

		#case (4)							// Pine (lots of greys & a touch of green)
			#debug " - Using pine bark texture\n"
			pigment {
				bozo
				turbulence 0.43
				color_map {
					[0.00 color rgb<0.612, 0.612, 0.612>]
					[0.21 color rgb<0.859, 0.859, 0.859>]
					[0.22 color rgb<0.310, 0.310, 0.310>]
					[0.28 color rgb<0.298, 0.298, 0.298>]
					[0.29 color rgb<0.859, 0.859, 0.859>]
					[0.40 color rgb<0.612, 0.612, 0.612>]
					[0.54 color rgb<0.459, 0.620, 0.573>]
					[0.76 color rgb<0.761, 0.761, 0.761>]
					[0.80 color rgb<0.267, 0.267, 0.267>]
					[0.84 color rgb<0.659, 0.659, 0.659>]
					[1.00 color rgb<0.800, 0.800, 0.800>]
				}
			}
			normal {
				wrinkles 0.37
				turbulence 0.27
			}
			finish {
				ambient 0.28
				phong 0.16
			}
			scale <0.1, 0.2, 0.1>
		#break

		#case (5)							// Lighter Brown Bark
   pigment {
      color rgb <0.88, 0.88, 1> }
   finish {
      ambient 0.3
      diffuse 0.7
      phong 0.3
      phong_size 10
      }
   

   
   
		#break

	#end
}

#if (Tip=2 | TipOther=2)
	#if (FruitShape !=1)
		#declare TreeFruitTexture=
		texture {
			#switch (FruitTexture)
				#case (0)							// Default Red Texture
					#debug " - Using default red fruit texture\n"
					pigment {color Red}
					finish {
						ambient .5
						phong .3
					}
				#break

				#case (1)							// User defined fruit texture
					#ifndef (Fruity)
						#debug " - 'Fruity' not defined, using default fruit texture in its place\n"
						pigment {color Red}
						finish {
							ambient .5
							phong .3
						}
					    #else
						Fruity
					#end
				#break

				#case (2)							// Orange texture
					#debug " - Using orange fruit texture\n"
					pigment {color Orange}
					normal {
						dents .8
						scale <.15,.15,.15>
					}
					finish {
						ambient .3
						phong .3
						phong_size 80
					}
				#break

				#case (3)							// Blackberry texture
					#debug " - Using blackberry fruit texture\n"
					pigment {color DarkSlateBlue}
					finish {
						ambient .15
						phong .25
					}
				#break

				#case (4)							// Peach and Yellow texture
					#debug " - Using peach and yellow fruit texture\n"
					pigment {
						bozo
						color_map {
							[0 color rgb <.78,.66,.49>]
							[1 color rgb <.96,.96,.75>]
						}
					}
					finish {
						ambient .3
						phong .25
					}
					scale <.005,.005,.005>
				#break

				#case (5)							// White texture
					#debug " - Using white fruit texture\n"
					pigment {color White}
					finish {
						ambient .3
						phong .25
						phong_size 120
					}
				#break
			#end
			scale <BaseLen,BaseLen,BaseLen>
		}
	#end

	#declare Fruit=
	object {
		#switch (FruitShape)
			#case (0)							// Small Sphere
				#debug " - Using small spherical fruit object\n"
				sphere {<0,.095,0>,.1}
			#break

			#case (1)							// User Defined Fruit Shape
				#ifndef (Fruits)
					#debug " - 'Fruits' not defined, using default fruit in its place\n"
					sphere {<0,.095,0>,.1}
					pigment {color Red}
					finish {
						ambient .5
						phong .3
					}
				    #else
				        Fruits
				#end
			#break

			#case (2)							// Large Sphere
				#debug " - Using large spherical fruit object\n"
				sphere {<0,.25,0>,.25}
			#break

			#case (3)							// Lemon
				#debug " - Using lemon-shaped fruit object\n"
				union {
					cone {<0,0,0>,.05,<0,.05,0>,.1}
					sphere {
						<0,.2,0>,.2
						scale <1,1.25,1>
						translate <0,.05,0>
					}
					cone {<0,.55,0>,.1,<0,.6,0>,.03}
				}
			#break

			#case (4)							// Banana
				#debug " - Using banana-like fruit object\n"
				superellipsoid {
					<.95,.15>
					rotate x*90
					scale <.075,.5,.075>
				}
			#break

			#case (5)							// Three Berries
				#debug " - Using three berries fruit object\n"
				union {
					sphere {<0,.095,0>,.1	translate <0,0,.095>}
					sphere {<0,.095,0>,.1	translate <0,0,.095>	rotate y*120}
					sphere {<0,.095,0>,.1	translate <0,0,.095>	rotate y*-120}
				}
			#break

			#case (6)							// Pear
				#debug " - Using pear-shaped fruit object\n"
				blob {
					threshold .2
					sphere {<0,.1,0>,.245,1}
					sphere {<0,.425,0>,.375,1}
				}
			#break
		#end

		#if (FruitShape!=1)
			texture {TreeFruitTexture}
		#end
		scale <BaseLen,BaseLen,BaseLen>
	}
#end

#if (Tip=3 | TipOther=3)
	#if (FlowerShape!=1)
		#declare TreeFlowerTexture=
		texture {
			#switch (FlowerTexture)
				#case (0)
					#debug " - Using default flower texture (white & orchid gradient)\n"
					pigment {
						gradient y
						color_map {
							[0	color White]
							[.25	color White]
							[1	color Orchid]
						}
					}
					finish {
						ambient .25
					}
				#break

				#case (1)
					#ifndef (Bloom)
						#debug " - 'Bloom' not defined, using default flower texture in its place\n"
						pigment {
							gradient y
							color_map {
								[0	color White]
								[.25	color White]
								[1	color Orchid]
							}
						}
						finish {
							ambient .25
						}
					    #else
						#debug " - Using user-defined flower texture\n"
						Bloom
					#end
				#break

				#case (2)
					#debug " - Using red & white radial flower texture\n"
					pigment {
						radial
						color_map {
							[0	color White]
							[.1	color Red]
							[.2	color White]
							[.3	color Red]
							[.4	color White]
							[.5	color Red]
							[.6	color White]
							[.7	color Red]
							[.8	color White]
							[.9	color Red]
							[1	color White]
						}
					}
					finish {
						ambient .25
					}
				#break

				#case (3)
					#debug " - Using white flower texture\n"
					pigment {color White}
					finish {
						ambient .35
					}
				#break

				#case (4)
					#debug " - Using orange-yellow gradient\n"
					pigment {
						gradient y
						color_map {
							[0	color Orange]
							[1	color Yellow]
						}
					}
					finish {
						ambient .25
					}
				#break

				#case (5)
					#debug " - Using purple-violet gradient\n"
					pigment {
						gradient y
						color_map {
							[0	color Very_Light_Purple]
							[1	color VioletRed]
						}
					}
					finish {
						ambient .3
					}
				#break
			#end
			scale <BaseLen,BaseLen,BaseLen>
		}
	#end

	#declare Flower=
	object {
		#switch (FlowerShape)

			#case (0)		// Default 5-Petalled Flower
				#debug " - Using default 5-petaled flower\n"
				#declare PetalNum=5 ;

				#declare FlowerPetal=
				object {
					sphere {<0,.095,0>,.1}
					texture {TreeFlowerTexture	scale <.2,.2,.2>}
					rotate x*90
					scale <4/PetalNum,.01,1.5>
				}

				union {
					sphere {
						<0,0,0>,.075
						scale <1,.25,1>
						pigment {color Yellow}
					}
					#declare P1=1
					#while (P1<=PetalNum)
						object {
							FlowerPetal
							rotate z*25
							rotate x*-20
							translate <0,0,.04>
							rotate y*((360/PetalNum)*P1)
						}
						#declare P1=P1+1
					#end
				}
			#break

			#case (1)		// User Defined (Flowers)
				#ifndef (Flowers)
					#debug " - 'Flowers' not defined, using default flower in its place\n"
					#declare PetalNum=5;

					#declare TreeFlowerTexture=
					pigment {
						gradient y
						color_map {
							[0	color White]
							[.25	color White]
							[1	color Orchid]
						}
					}
					finish {
						ambient .25
					}

					#declare FlowerPetal=
					object {
						sphere {<0,0,.095>,.1}
						texture {TreeFlowerTexture	scale <.2,.2,.2>}
						scale <4/PetalNum,.01,1.5>
					}

					union {
						sphere {
							<0,0,0>,.075
							scale <1,.25,1>
							pigment {color Yellow}
						}
						#declare P1=1;
						#while (P1<=PetalNum)
							object {
								FlowerPetal
								rotate z*25
								rotate x*-20
								translate <0,0,.04>
								rotate y*((360/PetalNum)*P1)
							}
							#declare P1=P1+1
						#end
					}
				    #else
					#debug " - Using user-defined flower object\n"
				        Flowers
				#end
			#break

			#case (2)		// Trumpet Flower
				#debug " - Using trumpet-flower\n"
				lathe {
					quadratic_spline 7,
					<0,-.1>, <0,0>, <.1,.3>, <.3,.5>, <.5,.6>, <.8,.7>, <.9,.8>
					scale <.5,.75,.5>
				}
				texture {
					TreeFlowerTexture
					scale <.5,.75,.5>
				}
			#break
			
			#case (3)		// Cup-shaped Flower
				#debug " - Using cup-shaped flower\n"
				union {
					difference {
						sphere {<0,.2,0>,.2}
						sphere {<0,.22,0>,.2}
						box {<-.25,.02,-.01>,<.25,.41,.01>}
						box {<-.25,.02,-.01>,<.25,.41,.01>	rotate y*120}
						box {<-.25,.02,-.01>,<.25,.41,.01>	rotate y*240}
						texture {
							TreeFlowerTexture
							scale <1,.3,1>
						}
						scale <1.5,1,1.5>
					}
					sphere {
						<0,0,0>,.05
						scale <1.5,.1,1.5>
						translate <0,.02,0>
						pigment {color Yellow}
					}
				}
			#break

			#case (4)		// Spiky Flower
				#debug " - Using spiky flower\n"
				union {
					#declare CT=1
					#while (CT<=10)
						cone {
							<0,0,0>,.025,<0,.45,0>,.005
							texture {TreeFlowerTexture	scale <1,.46,1>}
							rotate x*(rand(SD3)*90)
							rotate y*(rand(SD3)*360)
						}
						#declare CT=CT+1
					#end
				}
			#break
			
			#case (5)		// Cluster of Arches Flower
				#debug " - Using arches flower\n"
				union {
					#declare CT=1
					#while (CT<=6)
						difference {
							torus {
								.25,.025
								rotate x*90
								translate <-.25,0,0>
							}
							box {
								<-.55,-.7,-.05>,<.25,0,.05>
								rotate z*20
							}
							texture {TreeFlowerTexture	scale <1,.3,1>}
							rotate y*(CT*60)
						}
						#declare CT=CT+1
					#end
				}
			#break
		#end
		scale <BaseLen,BaseLen,BaseLen>
	}
#end

#if (LeafShape!=1)
	#declare TreeLeafTexture=
	texture {
		#switch (LeafTexture)
			#case (0)									// Default Texture
				#debug " - Using default pale green leaf texture\n"
				pigment {color PaleGreen}
			#break

			#case (1)									// User Defined Texture
				#ifndef(Leaves)
					#debug " - 'Leaves' texture not defined, using default in its place\n"
					pigment {color PaleGreen}
				    #else
					Leaves
					scale <BaseLen,BaseLen,BaseLen>
				#end
			#break

			#case (2)									// Dark Shiny Green
				#debug " - Using shiny dark green leaf texture\n"
				pigment {SeaGreen}
				finish {
					ambient .15
					phong .3
					reflection .1
				}
			#break

			#case (3)									// Lime Green
				#debug " - Using lime green leaf texture\n"
				pigment {color LimeGreen}
			#break

			#case (4)									// Yellow Green
				#debug " - Using yellow green leaf texture\n"
				pigment {color YellowGreen}
			#break

			#case (5)									// Wheat
				#debug " - Using wheat leaf texture\n"
				pigment {color Wheat}
			#break
		#end
	}
#end

#declare Leaf=
object {
	#switch (LeafShape)
		#case (0)								// Default Oval
			#debug " - Using default leaf shape\n"
			sphere {<0,0,.195>,.2}
			scale <.75,.1,1.5>
			texture {TreeLeafTexture}
		#break

		#case (1)									// User Defined Leaf
			#ifndef(Leave)
				#debug " - 'Leave' shape not defined, using default leaf in its place\n"
				sphere {<0,0,.195>,.2}
				scale <.75,.1,1.5>
				pigment {color PaleGreen}
			    #else
				Leave
			#end
		#break

		#case (2) 								// "Maple" of three triangles
			#debug " - Using maple leaf shape\n"
			union {
				triangle {<0,0,0>,<0,0,.3>,<-.5,0,.3>}
				triangle {<0,0,0>,<0,0,.3>,<.5,0,.3>}
				triangle {<-.2,0,.3>,<0,0,.5>,<.2,0,.3>}
				texture {TreeLeafTexture}
			}
		#break

		#case (3)								// Teardrop
			#debug " - Using teardrop leaf shape\n"
			union {
				cone {<0,0,0>,.015,<0,0,.3>,.15}
				sphere {<0,0,.3>,.15}
				scale <1,.1,1.5>
				texture {TreeLeafTexture}
			}
		#break

		#case (4)								// Bent
			#debug " - Using bent leaf shape\n"
			union {
				cone {<0,0,0>,.015,<0,0,.35>,.15}
				sphere {<0,0,.35>,.15}
				cone {<0,0,.35>,.15,<0,-.35,.7>,.075}
				scale <1,.15,1.25>
				texture {TreeLeafTexture}
			}
		#break

		#case (5)								// Pine Needles
			#debug " - Using pine needles leaf shape\n"
			union {
				cone {<0,0,0>,.025,<0,.1,.5>,.01}
				cone {<0,0,0>,.025,<-.05,-.05,.6>,.01}
				cone {<0,0,0>,.025,<.1,.02,.4>,.01}
				cone {<0,0,0>,.025,<-.05,-.03,.5>,.01}
				cone {<0,0,0>,.025,<-.1,.05,.6>,.01}
				texture {TreeLeafTexture}
			}
		#break

		#case (6)								// Oak
			box {
			#debug " - Using oak leaf material map\n"
				<0,0,0>,<1,1,.01>
				texture {
					material_map {
						gif "oakleaf.gif"
						texture {pigment {color Clear}}
						texture {TreeLeafTexture}
					}
				}
				rotate x*90
				translate <-.5,0,0>
				scale <.4,1,.75>
			}
		#break

		#case (7)								// Gingko
			#debug " - Using gingko leaf material map\n"
			box {
				<0,0,0>,<1,1,.01>
				texture {
					material_map {
						gif "gingko.gif"
						texture {pigment {color Clear}}
						texture {TreeLeafTexture}
					}
				}
				rotate x*90
				translate <-.5,0,0>
				scale <.5,1,.5>
			}
		#break

		#case (8)								// Palmetto
			#debug " - Using palmetto leaf material map\n"
			box {
				<0,0,0>,<1,1,.01>
				texture {
					material_map {
						gif "palmetto.gif"
						texture {pigment {color Clear}}
						texture {TreeLeafTexture}
					}
				}
				rotate x*90
				translate <-.5,0,0>
				scale <.75,1,.75>
			}
		#break
	#end

	scale <BaseLen,BaseLen,BaseLen>
}

// ---- ASSEMBLE ELEMENTS OF TREE ----
union {
	cone {
		<0,0,0>,BaseLen,<0,BaseLen*(LengthInc*5),0>,BaseLen/2
		texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
	}
	#if (BallJoint=True & BallLevels>=1)
		sphere {
			<0,BaseLen*(LengthInc*5),0>,BaseLen/2
			texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
		}
	#end
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	#declare Loop1=int((rand(SD1)*((MaxSplits-MinSplits-1)+.9999999999))+MinSplits);	// How many forks?
	#declare Loop1Count=1;
	#while (Loop1Count <= Loop1)
		#if (mydebugging) #debug "1" #end
		union {
			cone {
				<0,0,0>,BaseLen/2,<0,BaseLen*(LengthInc*4),0>,BaseLen/4
				texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
			}
			#if (BallJoint=True & BallLevels>=2)
				sphere {
					<0,BaseLen*(LengthInc*4),0>,BaseLen/4
					texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
				}
			#end
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            #declare Loop2=int((rand(SD1)*(((MaxSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits);	// How many forks?
			#declare Loop2Count=1;
			#while (Loop2Count <= Loop2)
				#if (mydebugging) #debug "2"             #end
				union {
					cone {
						<0,0,0>,BaseLen/4,<0,BaseLen*(LengthInc*3),0>,BaseLen/8
						texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
					}
					#if (BallJoint=True & BallLevels>=3)
						sphere {
							<0,BaseLen*(LengthInc*3),0>,BaseLen/8
							texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
						}
					#end
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					#declare Loop3=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits);
					#declare Loop3Count=1;
					#while (Loop3Count <= Loop3)
						#if (mydebugging) #debug "3" #end
						
						
						union {
							cone {
								<0,0,0>,BaseLen/8,<0,BaseLen*(LengthInc*2),0>,BaseLen/16
								texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
							}
							#if (BallJoint=True & BallLevels>=4)
								sphere {
									<0,BaseLen*(LengthInc*2),0>,BaseLen/16
									texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
								}
							#end
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
							#declare Loop4=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits);
							#declare Loop4Count=1;
							#while (Loop4Count <= Loop4)
								#if (mydebugging) #debug "4"
								#end
								union {
									cone {
										<0,0,0>,BaseLen/16,<0,BaseLen*LengthInc,0>,BaseLen/32
										texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
									}
									#if (BallJoint=True & BallLevels>=5)
										sphere {
											<0,BaseLen*LengthInc,0>,BaseLen/32
											texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
										}
									#end
									#declare Loop5=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits);
									#declare Loop5Count=1;
									#while (Loop5Count <= Loop5)
										#if (mydebugging) #debug "5"
										#end
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//5555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
										union {
											cone {
												<0,0,0>,BaseLen/32,<0,BaseLen,0>,BaseLen/64
												texture {TreeBarkTexture scale <BaseLen,BaseLen,BaseLen>}
											}
											#if (Tip > 0)
												#if (rand(SD3)<=TipPercent)
													#switch (Tip)
														#case (1)
															object {Leaf	rotate x*-90	translate <0,BaseLen,0>}
														#break
														#case (2)
															object {Fruit	translate <0,BaseLen,0>}
														#break
														#case (3)
															object {Flower	translate <0,BaseLen,0>}
														#break
													#end
												    #else
													#switch (TipOther)
														#case (1)
															object {Leaf	rotate x*-90	translate <0,BaseLen,0>}
														#break
														#case (2)
															object {Fruit	translate <0,BaseLen,0>}
														#break
														#case (3)
															object {Flower	translate <0,BaseLen,0>}
														#break
													#end
												#end
											#end
											#declare LNum=1;
											#while (LNum<=LeafNum)
												object {
													Leaf
													rotate x*-MinXDeg
													rotate y*((MaxYDeg/LeafNum)*LNum)
													#if (LeafRosette)
														rotate y*((MaxYDeg/LeafNum)*LNum)
														translate <0,BaseLen*.6,0>
													   #else
													     	#if (LeafRandRot)
															rotate y*(rand(SD2)*360)
														   #else
															rotate y*((MaxYDeg/LeafNum)*LNum)
														#end
														translate <0,(BaseLen/(LeafNum+1))*LNum,0>
													#end
												}
												#declare LNum=LNum+1;
											#end
											#if (Loop5Count<Loop5)
												rotate x*((rand(SD1)*((MaxXDeg+(IncXDeg*4))-(MinXDeg+(IncXDeg*4))))+(MinXDeg+(IncXDeg*4)))
												rotate y*((rand(SD1)*((MaxYDeg+(IncYDeg*4))-(MinYDeg+(IncYDeg*4))))+(MinYDeg+(IncYDeg*4)))
												rotate z*((rand(SD1)*((MaxZDeg+(IncZDeg*4))-(MinZDeg+(IncZDeg*4))))+(MinZDeg+(IncZDeg*4)))
                                               #else
												rotate x*((rand(SD1)*(PlusMinus*2))-PlusMinus)
												rotate y*((rand(SD1)*(PlusMinus*2))-PlusMinus)
												rotate z*((rand(SD1)*(MinZDeg*2))-MinZDeg)

											#end
											translate <0,((BaseLen*LengthInc)*(Loop5Count/Loop5)),0>
										}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//5555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
										#declare Loop5Count = Loop5Count+1;
									#end
									#if (Loop4Count<Loop4)
										rotate x*((rand(SD1)*((MaxXDeg+(IncXDeg*3))-(MinXDeg+(IncXDeg*3))))+(MinXDeg+(IncXDeg*3)))
										rotate y*((rand(SD1)*((MaxYDeg+(IncYDeg*3))-(MinYDeg+(IncYDeg*3))))+(MinYDeg+(IncYDeg*3)))
										rotate z*((rand(SD1)*((MaxZDeg+(IncZDeg*3))-(MinZDeg+(IncZDeg*3))))+(MinZDeg+(IncZDeg*3)))
									   #else
										rotate x*((rand(SD1)*(PlusMinus*2))-PlusMinus)
										rotate y*((rand(SD1)*(PlusMinus*2))-PlusMinus)
										rotate z*((rand(SD1)*(MinZDeg*2))-MinZDeg)
									#end
									translate <0,((BaseLen*(LengthInc*2))*(Loop4Count/Loop4)),0>
								}
								
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

								#declare Loop4Count = Loop4Count+1;
							#end
							#if (Loop3Count<Loop3)
								rotate x*((rand(SD1)*((MaxXDeg+(IncXDeg*2))-(MinXDeg+(IncXDeg*2))))+(MinXDeg+(IncXDeg*2)))
								rotate y*((rand(SD1)*((MaxYDeg+(IncYDeg*2))-(MinYDeg+(IncYDeg*2))))+(MinYDeg+(IncYDeg*2)))
								rotate z*((rand(SD1)*((MaxZDeg+(IncZDeg*2))-(MinZDeg+(IncZDeg*2))))+(MinZDeg+(IncZDeg*2)))
							   #else
								rotate x*((rand(SD1)*(PlusMinus*2))-PlusMinus)
								rotate y*((rand(SD1)*(PlusMinus*2))-PlusMinus)
								rotate z*((rand(SD1)*(MinZDeg*2))-MinZDeg)
							#end
							translate <0,((BaseLen*(LengthInc*3))*(Loop3Count/Loop3)),0>
						}
						
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

						#declare Loop3Count = Loop3Count+1;
					#end
					#if (Loop2Count<Loop2)
						rotate x*((rand(SD1)*((MaxXDeg+IncXDeg)-(MinXDeg+IncXDeg)))+(MinXDeg+IncXDeg))
						rotate y*((rand(SD1)*((MaxYDeg+IncYDeg)-(MinYDeg+IncYDeg)))+(MinYDeg+IncYDeg))
						rotate z*((rand(SD1)*((MaxZDeg+IncZDeg)-(MinZDeg+IncZDeg)))+(MinZDeg+IncZDeg))
					   #else
						rotate x*((rand(SD1)*(PlusMinus*2))-PlusMinus)
						rotate y*((rand(SD1)*(PlusMinus*2))-PlusMinus)
						rotate z*((rand(SD1)*(MinZDeg*2))-MinZDeg)
					#end
					translate <0,(BaseLen*(LengthInc*4))*(Loop2Count/Loop2),0>
				}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

				#declare Loop2Count = Loop2Count+1;
			#end
			#if (Loop1Count<Loop1)
				rotate x*((rand(SD1)*(MaxXDeg-MinXDeg))+MinXDeg)
				rotate y*(rand(SD1)*360)
				rotate z*((rand(SD1)*(MaxZDeg-MinZDeg))+MinZDeg)
			   #else
				rotate x*((rand(SD1)*(PlusMinus*2))-PlusMinus)
				rotate y*((rand(SD1)*(PlusMinus*2))-PlusMinus)
				rotate z*((rand(SD1)*(MinZDeg*2))-MinZDeg)
			#end
			translate <0,(BaseLen*(LengthInc*5))*(Loop1Count/Loop1),0>
		}
	
		

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////										
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if (mydebugging) #debug "\n" #end
		#declare Loop1Count = Loop1Count+1;
	#end
}
