/* Paysage (paysage.inc)
Part of skistation.pov
Copyright (c) 2002 Cyrille Berger
http://www.cberger.net/ */

//-------------------------------------------- Sapin ----------------------------------------------------//
#declare sapin = merge {
        cone { <0,0.0,0>, .10, <0,3.0,0>, .0 pigment { Tom_Wood } }
        cone { <0,0.3,0>, 1, <0,2.9,0>, .0
                #if(usetexture)
                texture {
                        pigment {
                                gradient y frequency 10 turbulence 1
                                color_map { [0.0 pigment DarkGreen ] [1.0 pigment Black ] }
                        } }
                texture {
                        pigment {
                                bozo
                                turbulence 2
                                color_map { [0.0 White ] [1.0 rgbf <.55,.55,.55,1.0> ] }
                        }
                }
                #else
                        pigment { Green }
                #end
       }
}

//-------------------------------------------- Paysage --------------------------------------------------//
#if(sol)
        box { <-50,0,0>, <250,-2,-200> rotate <30,0,0> translate <0,0,-12> pigment { Neige } }
        #if(showarbre)
                #declare i=0;
                #declare rot=seed(10);
                #declare xpos=seed(20);
                #declare hvar=seed(3);
                #declare taille=seed(15);
                #while(i<100)
                        #if(i<20 | i>40)
                                #declare j=0;
                                #while(j<65)
                                        #declare h=(hvar-.5)/4;
                                        object { sapin
                                                scale rand(taille)/2+0.5
                                                rotate 360*rand(rot)*y
                                                translate < 2+i*2.6+(rand(xpos)-5)/4, 0.577*(j*2.6+h), -12-j*2.6-h> }//y=tan(30)*z=0.577*z
                                        #declare j=j+1;
                                #end
                        #end
                        #declare i=i+1;
                #end
                #declare i=0;
                #while(i<5)
                        #declare j=0;
                        #while(j<10)
                                object { sapin
                                       scale rand(taille)/2+0.5
                                        rotate 360*rand(rot)*y
                                        translate < -2-i*2.6+(rand(xpos)-.5)/4, 0.577*(2.6*j*h), -12-j*2.6-h> }//y=tan(30)*z=0.577*z
                                #declare j=j+1;
                        #end
                        #declare i=i+1;
                #end
        #end
#end
//------------------------------------------------ Piste ------------------------------------------------//
#declare poteaupiste = merge {
        cylinder { < 0.0,-0.1, 0.0>,< 0.0, 2.0, 0.0>, .05 }
        cylinder { < 0.0, 1.5, 0.0>,< 0.0, 1.5, .06>, 0.5 }
        torus { 0.5,.06 rotate <90,0,0> translate 1.5*y} 
        #if(usetexture)
                texture { Silver_Metal }
        #else
                pigment { Gray65 }
        #end        
}
#if(full)
        #declare i=0;
        #while(i<7)
                object { poteaupiste translate <105, i*0.577*20, -12-i*20> }//y=tan(30)*z=0.577*z
                object { poteaupiste translate < 53, i*0.577*20, -12-i*20> }
                #declare i=i+1;
        #end
#end
