// Persistence of Vision Ray Tracer Include File
// File: Claw.inc
// Vers: 3.1
// Desc: "Winter" IRTC entry--Claws for the late T. rex
// Date: 03/08/2002
// Auth: Copyright  2002 by Sherry K. Shaw

//**********************************************************
//                Declarations
//**********************************************************

//**********************************************************
// Textures for claw
//**********************************************************
#declare CLAW_TEST_TEX =
texture {
  pigment {
    color rgb < 1.0, 0.2, 0.3 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
  }
}

#declare CLAW_TEX =
texture {
  pigment {
    gradient z
    color_map {
      [ 0.00 0.33 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.5, 0.5, 0.5 > ]
      [ 0.33 0.67 color rgb < 0.5, 0.5, 0.5 > color rgb < 0.8, 0.8, 0.8 > ]
      [ 0.67 1.00 color rgb < 0.8, 0.8, 0.8 > color rgb < 1.0, 1.0, 1.0 > ]
    }
    scale 7.2
    rotate y*-45
    translate < 0, 0, 4.25 >
  }
  finish {
    ambient 0.325
    diffuse 0.625
  }
}
texture {
  pigment {
    bozo
    color_map {
      [ 0.0 0.4 color rgbf < 0.4, 0.3, 0.1, 0.5 > color rgbf < 0.4, 0.3, 0.1, 0.5 > ]
      [ 0.4 0.7 color rgbf < 0.4, 0.3, 0.1, 0.5 > color rgbf < 0.6, 0.4, 0.0, 0.6 > ]
      [ 0.7 1.0 color rgbf < 0.6, 0.4, 0.0, 0.6 > color rgbf < 0.4, 0.3, 0.1, 0.5 > ]
    }
    scale 0.2
  }
  finish {
    ambient 0.2
    diffuse 0.7
    specular 1.0
    roughness 0.01
  }
  normal {
    bumps 0.25
    scale 0.25
  }
}

//**********************************************************
// The claw object
//**********************************************************
#local Rmaj = 6 ;               // Radius of circle defining overall curve of claw
#local Rmax = 1.5 ;             // Maximum radius of claw (at base)
#local Degs = 90 ;              // Degrees of arc from base to tip of claw
#local PtsI = 16 ;              // Number of points to plot on claw curve
#local PtsC = 16 ;              // Number of points to plot around circumference of claw
#local DegInc = Degs / PtsI ;   // Increase in major radius position per point
#local Dcc = 360 / PtsC ;       // Degrees between points on circumference of claw
#local Rdec = Rmax / PtsI ;     // Decrease in claw radius per point
#local PtOff = Rmaj * 0.5 ;     // Centering offset

#local aPt = array[PtsI][PtsC]  // Array of points defining claw

// Set up array of points
//      (Note that the actual curve & cross-section of the resulting object can be modified
//      by fiddling with the trig functions used in both the inner & outer loops...)
#local tR = Rmax ;              // Starting claw radius (base)
#local Ix = 0 ;                 // Outer loop counter

#while ( Ix < ( PtsI - 1 ) )    // Save the tip for later...
  #local tDeg = Ix * DegInc ;   // Current point around major curve of claw
  #local tX = ( Rmaj * sin ( radians ( tDeg ) ) ) - PtOff ; // X pos, claw center
  #local tZ = ( Rmaj * cos ( radians ( tDeg ) ) ) - PtOff ; // Z pos, claw center
  #local tR = tR - Rdec ;
  #local Iy = 0 ;               // Inner loop counter
  #while ( Iy < PtsC )
    #local tDeg = Iy * Dcc ;
    #local tXc = ( tR * sin ( radians ( tDeg ) ) ) + tX ;
    #local tZc = ( tR * sin ( radians ( tDeg ) ) ) + tZ ;
    #local tYc = tR * cos ( radians ( tDeg ) ) ;
    #local aPt[Ix][Iy] = < tXc, tYc, tZc > ;
    #local Iy = Iy + 1 ;
  #end
  #local Ix = Ix + 1 ;
#end

#local Ix = 0 ;                                             // The tip of the claw gets plotted into
#while ( Ix < PtsC )                                        // each point in the last loop around the
  #local tX = ( Rmaj * sin ( radians ( Degs ) ) ) - PtOff ; // circumference of the claw, in order to
  #local tZ = ( Rmaj * cos ( radians ( Degs ) ) ) - PtOff ; // simplify building the mesh.
  #local aPt[PtsI - 1][Ix] = < tX, 0, tZ > ;
  #local Ix = Ix + 1 ;
#end

// Set up mesh
#declare CLAW_OBJ =
mesh {
  #local Ix = 0 ;
  #while ( Ix < ( PtsI - 1 ) )
    #local NextIx = Ix + 1 ;
    #local Iy = 0 ;
    #while ( Iy < PtsC )
      #local NextIy = Iy + 1 ;
      #if ( NextIy = PtsC )
        #local NextIy = 0 ;
      #end
      triangle { aPt[Ix][Iy],     aPt[Ix][NextIy], aPt[NextIx][Iy] }
      triangle { aPt[NextIx][Iy], aPt[Ix][NextIy], aPt[NextIx][NextIy] }
      #local Iy = Iy + 1 ;
    #end
    #local Ix = Ix + 1 ;
  #end
  texture {
    //CLAW_TEST_TEX
    CLAW_TEX
  }
}

