//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 27 materials and 135 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 04/26/2002    (26.04.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.
Comment merged from skilift.mdl:
This scene was created with Moray V3.3a For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera RealCamera
  location  <     -4.768,     -48.043,      12.599>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <     -4.571,     -28.282,       5.913>
}

//    Other cameras are commented out.
/*
camera {  //  Camera TempCamera
  location  <     -5.741,     -36.533,       8.319>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <   -292.444,     811.465,      64.462>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  translate  <589.52556, -103.517416, 623.337577>
}



//
// ********  MATERIALS  *******
//

#include "ski2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare MainPole = union {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.1, 0.2>
    translate  -0.2*z
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 16.0>
  }
  material {
    MainSkiTex
  }
}
#declare BottomBit = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.9>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.45*x
  }
  torus { // Torus001
    0.45, 0.05  rotate -x*90
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.9>
    rotate -90.0*x
    translate  -0.45*y
  }
  material {
    SilverSkiMat_1
  }
}
#declare Sphere015 = object {
  sphere { // Sphere015
    <0,0,0>,1
    scale 0.75
    translate  <-0.85, 0.0, 16.0>
  }
}
#declare PoleHandle = difference {
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 4.0>
    translate  12.5*z
  }
  object { Sphere015 }
  object { // Sphere016 -> Sphere015
    Sphere015
    translate  -1.0*z
  }
  object { // Sphere017 -> Sphere015
    Sphere015
    translate  -2.0*z
  }
  object { // Sphere018 -> Sphere015
    Sphere015
    translate  -3.0*z
  }
  material {
    MattBlack
  }
  scale <1.0, 1.0, 0.5>
  translate  7.979159*z
}
#declare SkiPole1 = union {
  object { MainPole }
  object { BottomBit }
  object { PoleHandle }
  scale 0.185009
  rotate <-12.703701, -0.0, 0.0>
  translate  <-9.220138, -35.576561, 5.868831>
}
#declare MainPole1 = union {
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.1, 0.2>
    translate  -0.2*z
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 16.0>
  }
  material {
    MainSkiTex2
  }
}
#declare BottomBit1 = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.9>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.45*x
  }
  torus { // Torus002
    0.45, 0.05  rotate -x*90
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.9>
    rotate -90.0*x
    translate  -0.45*y
  }
  material {
    SilverSkiMat_1
  }
}
#declare PoleHandle1 = difference {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 4.0>
    translate  12.5*z
  }
  sphere { // Sphere019
    <0,0,0>,1
    scale 0.75
    translate  <-0.85, 0.0, 16.0>
  }
  object { // Sphere020 -> Sphere015
    Sphere015
    translate  -1.0*z
  }
  object { // Sphere021 -> Sphere015
    Sphere015
    translate  -2.0*z
  }
  object { // Sphere022 -> Sphere015
    Sphere015
    translate  -3.0*z
  }
  material {
    MattBlack
  }
  scale <1.0, 1.0, 0.5>
  translate  7.979159*z
}
#declare SkiPole3 = union {
  object { MainPole1 }
  object { BottomBit1 }
  object { PoleHandle1 }
  scale 0.185009
  rotate <71.418343, -0.0, 6.148069>
  translate  <-0.726742, -35.420918, 5.880863>
}
#declare Brake = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      SilverSkiMat_1
    }
    scale <0.5, 0.5, 18.0>
    rotate 26.238993*x
    translate  <-13.644021, 115.251075, -5.769877>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackSkiMat_1_1
    }
    scale <0.9, 0.9, 5.700154>
    rotate 26.238993*x
    translate  <-13.644021, 115.251075, -5.769877>
  }
}
#declare Brake3 = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      SilverSkiMat_1
    }
    scale <0.5, 0.5, 18.0>
    rotate 26.238993*x
    translate  <-13.644021, 115.251075, -5.769877>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackSkiMat_1_1
    }
    scale <0.9, 0.9, 5.700154>
    rotate 26.238993*x
    translate  <-13.644021, 115.251075, -5.769877>
  }
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-3.0, -0.1>,
  <0.8, -0.1>,
  <0.920387, -0.074601>,
  <1.026491, -0.024506>,
  <1.129641, 0.040023>,
  <1.193294, 0.106736>,
  <1.193294, 0.206736>,
  <1.123098, 0.132702>,
  <1.021317, 0.067215>,
  <0.910895, 0.02565>,
  <0.8, 0.0>,
  <-3.0, 0.0>,
  <-3.0, -0.1>
  rotate -x*90
  scale <99.045258, 25.193726, 24.875233>
  rotate <90.0, 0.0, -90.0>
  translate  <12.572346, -29.980627, 0.0>
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <1.4, 1.0>,
  <1.4, -1.0>,
  <-1.4, -1.0>,
  <-1.4, 1.0>,
  <-1.3, 0.3>,
  <-1.0, -0.1>,
  <-0.6, -0.5>,
  <0.0, -0.8>,
  <0.6, -0.5>,
  <1.0, -0.1>,
  <1.3, 0.3>,
  <1.4, 1.0>
  rotate -x*90
  scale <11.7707, 39.744629, 10.168987>
  translate  <-0.483874, -115.863843, -3.889873>
}
#declare CSG004 = difference {
  object { TransSweep008 }
  object { TransSweep009 }
  material {
    MainSkiTex2
  }
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <0.0, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <0.0, 0.0>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <2.0, 2.0, 1.0>
  rotate 52.409145*x
  translate  <0.0, 81.09346, 12.320745>
}
#declare CSG005 = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.056443, 2.933091, 5.852177>
    translate  <0.0, 82.541211, 13.887154>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <6.141107, 4.446378, 8.640072>
    rotate -37.455933*x
    translate  <0.0, 78.192702, 16.955725>
  }
  sphere { // Sphere014
    <0,0,0>,1
    translate  <0.0, 83.229941, 16.475405>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <7.620974, 3.129658, 3.640746>
    rotate -43.249466*x
    translate  <0.0, 85.699234, 7.955778>
  }
  material {
    RedSkiMat
  }
}
#declare TransSweep011 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <0.6, -0.6>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.6, 0.6>,
  <0.0, 0.4>,
  <-0.6, 0.6>,
  <-1.0, 1.0>,
  <-1.0, -1.0>,
  <-0.6, -0.6>,
  <0.0, -0.4>,
  <0.6, -0.6>,
  <1.0, -1.0>,
  <1.0, 1.0>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <4.738971, 4.63531, 4.160451>
  rotate -124.942024*x
  translate  <0.0, 73.806977, 8.735903>
}
#declare TransSweep012 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  16  // control points
  <1.0, 1.0>,
  <1.1, 0.5>,
  <1.0, -0.4>,
  <0.5, -0.5>,
  <0.8, -1.0>,
  <0.0, -1.0>,
  <-0.8, -1.0>,
  <-0.5, -0.5>,
  <-1.0, -0.4>,
  <-1.1, 0.5>,
  <-1.0, 1.0>,
  <-0.5, 1.3>,
  <0.5, 1.3>,
  <1.0, 1.0>,
  <1.1, 0.5>,
  <1.0, -0.4>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <4.52385, 2.117803, 9.404516>
  rotate 90.0*x
  translate  <0.0, 86.611983, 3.844174>
}
#declare TransSweep013 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.9, -1.0>,
  <-1.9, -2.3>,
  <1.9, -2.3>,
  <1.9, -1.0>,
  <0.9, -0.4>,
  <1.2, 0.2>,
  <2.5, 5.2>,
  <-2.5, 5.2>,
  <-1.2, 0.2>,
  <-0.9, -0.4>,
  <-1.9, -1.0>
  rotate -x*90
  material {
    BlackSkiMat_1_1
  }
  scale <3.126314, 6.402141, 1.326989>
  translate  <0.0, 54.825787, 0.602715>
}
#declare TransSweep014 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <0.9, -0.5>,
  <1.0, 1.6>,
  <1.0, 3.4>,
  <-1.0, 3.4>,
  <-1.0, 1.6>,
  <-0.9, -0.5>,
  <-0.7, -2.0>,
  <-0.8, -3.2>,
  <0.8, -3.2>,
  <0.7, -2.0>,
  <0.9, -0.5>,
  <1.0, 1.6>,
  <1.0, 3.4>
  rotate -x*90
  material {
    BlueGreenSkiMat
  }
  scale <9.844362, 9.844362, 1.048686>
  translate  55.49933*y
}
#include "D:\My Documents\Rendering\bindings1.inc"

#declare Default_Object2_Ref = object {
  Default_Object1
  material {
    BlueGreenSkiMat
  }
  scale <1.0, 1.088398, 2.414361>
}
#declare Default_Object5_Ref = object {
  Default_Object3
  material {
    BlueGreenSkiMat
  }
}
#declare Default_Object6_Ref = object {
  Default_Object4
  material {
    SilverSkiMat_1
  }
}
#declare UserDefGroup2 = union {
  object { Default_Object2_Ref }
  object { Default_Object5_Ref }
  object { Default_Object6_Ref }
}
#declare Bindings1 = union {
  object { TransSweep010 }
  object { CSG005 }
  object { TransSweep011 }
  object { TransSweep012 }
  object { TransSweep013 }
  object { TransSweep014 }
  object { UserDefGroup2 }
  translate  29.571152*y
}
#declare SingleSki2 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      SilverSkiMat_1
    }
    scale <0.5, 0.5, 27.494314>
    rotate <-0.0, -90.0, 0.0>
    translate  <13.850342, 107.585777, 9.784734>
  }
  object { // Brake2 -> Brake
    Brake
    translate  27.576471*x
  }
  object { Brake3 }
  object { CSG004 }
  object { Bindings1 }
  scale 0.01
  rotate <-82.722397, 0.0, -163.407242>
  translate  <-7.171402, -34.732444, 8.395179>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-3.0, -0.1>,
  <0.8, -0.1>,
  <0.920387, -0.074601>,
  <1.026491, -0.024506>,
  <1.129641, 0.040023>,
  <1.193294, 0.106736>,
  <1.193294, 0.206736>,
  <1.123098, 0.132702>,
  <1.021317, 0.067215>,
  <0.910895, 0.02565>,
  <0.8, 0.0>,
  <-3.0, 0.0>,
  <-3.0, -0.1>
  rotate -x*90
  scale <99.045258, 25.193726, 24.875233>
  rotate <90.0, 0.0, -90.0>
  translate  <12.572346, -29.980627, 0.0>
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <1.4, 1.0>,
  <1.4, -1.0>,
  <-1.4, -1.0>,
  <-1.4, 1.0>,
  <-1.3, 0.3>,
  <-1.0, -0.1>,
  <-0.6, -0.5>,
  <0.0, -0.8>,
  <0.6, -0.5>,
  <1.0, -0.1>,
  <1.3, 0.3>,
  <1.4, 1.0>
  rotate -x*90
  scale <11.7707, 39.744629, 10.168987>
  translate  <-0.483874, -115.863843, -3.889873>
}
#declare CSG002 = difference {
  object { TransSweep006 }
  object { TransSweep007 }
  material {
    MainSkiTex
  }
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <0.0, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <0.0, 0.0>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <2.0, 2.0, 1.0>
  rotate 52.409145*x
  translate  <0.0, 81.09346, 12.320745>
}
#declare CSG001 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <3.056443, 2.933091, 5.852177>
    translate  <0.0, 82.541211, 13.887154>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <6.141107, 4.446378, 8.640072>
    rotate -37.455933*x
    translate  <0.0, 78.192702, 16.955725>
  }
  sphere { // Sphere001
    <0,0,0>,1
    translate  <0.0, 83.229941, 16.475405>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <7.620974, 3.129658, 3.640746>
    rotate -43.249466*x
    translate  <0.0, 85.699234, 7.955778>
  }
  material {
    RedSkiMat
  }
}
#declare TransSweep004 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <0.6, -0.6>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.6, 0.6>,
  <0.0, 0.4>,
  <-0.6, 0.6>,
  <-1.0, 1.0>,
  <-1.0, -1.0>,
  <-0.6, -0.6>,
  <0.0, -0.4>,
  <0.6, -0.6>,
  <1.0, -1.0>,
  <1.0, 1.0>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <4.738971, 4.63531, 4.160451>
  rotate -124.942024*x
  translate  <0.0, 73.806977, 8.735903>
}
#declare TransSweep003 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  16  // control points
  <1.0, 1.0>,
  <1.1, 0.5>,
  <1.0, -0.4>,
  <0.5, -0.5>,
  <0.8, -1.0>,
  <0.0, -1.0>,
  <-0.8, -1.0>,
  <-0.5, -0.5>,
  <-1.0, -0.4>,
  <-1.1, 0.5>,
  <-1.0, 1.0>,
  <-0.5, 1.3>,
  <0.5, 1.3>,
  <1.0, 1.0>,
  <1.1, 0.5>,
  <1.0, -0.4>
  rotate -x*90
  material {
    SilverSkiMat_1
  }
  scale <4.52385, 2.117803, 9.404516>
  rotate 90.0*x
  translate  <0.0, 86.611983, 3.844174>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.9, -1.0>,
  <-1.9, -2.3>,
  <1.9, -2.3>,
  <1.9, -1.0>,
  <0.9, -0.4>,
  <1.2, 0.2>,
  <2.5, 5.2>,
  <-2.5, 5.2>,
  <-1.2, 0.2>,
  <-0.9, -0.4>,
  <-1.9, -1.0>
  rotate -x*90
  material {
    BlackSkiMat_1_1
  }
  scale <3.126314, 6.402141, 1.326989>
  translate  <0.0, 54.825787, 0.602715>
}
#declare TransSweep001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <0.9, -0.5>,
  <1.0, 1.6>,
  <1.0, 3.4>,
  <-1.0, 3.4>,
  <-1.0, 1.6>,
  <-0.9, -0.5>,
  <-0.7, -2.0>,
  <-0.8, -3.2>,
  <0.8, -3.2>,
  <0.7, -2.0>,
  <0.9, -0.5>,
  <1.0, 1.6>,
  <1.0, 3.4>
  rotate -x*90
  material {
    RedSkiMat
  }
  scale <9.844362, 9.844362, 1.048686>
  translate  55.49933*y
}
#declare Default_Object1_Ref = object {
  Default_Object1
  material {
    RedSkiMat
  }
  scale <1.0, 1.088398, 2.414361>
}
#declare Default_Object3_Ref = object {
  Default_Object3
  material {
    RedSkiMat
  }
}
#declare Default_Object4_Ref = object {
  Default_Object4
  material {
    SilverSkiMat_1
  }
}
#declare UserDefGroup1 = union {
  object { Default_Object1_Ref }
  object { Default_Object3_Ref }
  object { Default_Object4_Ref }
}
#declare Bindings = union {
  object { TransSweep005 }
  object { CSG001 }
  object { TransSweep004 }
  object { TransSweep003 }
  object { TransSweep002 }
  object { TransSweep001 }
  object { UserDefGroup1 }
  translate  29.571152*y
}
#declare SingleSki = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      SilverSkiMat_1
    }
    scale <0.5, 0.5, 27.494314>
    rotate <-0.0, -90.0, 0.0>
    translate  <13.850342, 107.585777, 9.784734>
  }
  object { // Brake1 -> Brake
    Brake
    translate  27.576471*x
  }
  object { Brake }
  object { CSG002 }
  object { Bindings }
  scale 0.01
  rotate <-143.370087, -65.99218, 147.573257>
  translate  <-2.368633, -38.172642, 6.603946>
}


#declare TransSweep015 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  16  // control points
  <-0.976526, 0.588419>,
  <-0.869484, -0.209703>,
  <-0.747457, -0.604851>,
  <-0.445462, -0.992175>,
  <0.116968, -0.942879>,
  <0.48186, -0.837128>,
  <0.960876, -0.788732>,
  <0.945227, -0.666667>,
  <0.45903, -0.697418>,
  <0.088263, -0.788732>,
  <-0.393865, -0.825352>,
  <-0.6403, -0.491656>,
  <-0.732382, -0.125446>,
  <-0.921753, 0.968701>,
  <-1.007825, 0.934585>,
  <-0.976526, 0.588419>
  rotate -x*90
  material {
    SkiLiftMetal
  }
  // Scaling fixed
  // Rotation fixed
  scale <1.216504, 1.135687, 0.1>
  rotate <-270.0, 0.0, -90.0>
  translate  <-2.01, -1.039739, -0.185626>
}
#declare TransSweep016 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  16  // control points
  <-0.976526, 0.588419>,
  <-0.869484, -0.209703>,
  <-0.747457, -0.604851>,
  <-0.445462, -0.992175>,
  <0.116968, -0.942879>,
  <0.48186, -0.837128>,
  <0.960876, -0.788732>,
  <0.945227, -0.666667>,
  <0.45903, -0.697418>,
  <0.088263, -0.788732>,
  <-0.393865, -0.825352>,
  <-0.6403, -0.491656>,
  <-0.732382, -0.125446>,
  <-0.921753, 0.968701>,
  <-1.007825, 0.934585>,
  <-0.976526, 0.588419>
  rotate -x*90
  material {
    SkiLiftMetal
  }
  // Scaling fixed
  // Rotation fixed
  scale <1.216504, 1.135687, 0.1>
  rotate <-270.0, 0.0, -90.0>
  translate  <2.11, -1.039739, -0.185626>
}
#declare SkiChairPlasticBits = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-8.915676, 0.0, 71.508553>
    translate  <161.755296, 578.944442, -56.701828>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-3.562252, 0.0, 71.508553>
    translate  <161.679988, 578.969628, -56.131987>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-11.561841, 0.0, 71.508553>
    translate  <161.887062, 578.900376, -57.264532>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-42.334248, 0.0, 71.508553>
    translate  <162.117652, 578.82326, -57.736926>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-97.532654, 0.0, 71.508553>
    translate  <162.597955, 578.662633, -57.921975>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-102.25901, 0.0, 71.508553>
    translate  <163.105967, 578.492738, -57.814842>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.25>
    rotate <-93.716713, 0.0, 71.508553>
    translate  <163.623216, 578.319755, -57.736926>
  }
  material {
    SkiChairPlastic
  }
  rotate <0.0, -0.0, -71.508553>
  translate  <-600.356935, -30.194938, 56.715722>
}
#declare SkiChair = union {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      SkiLiftMetal
    }
    scale <0.1, 0.1, 4.0>
    rotate <-0.0, -90.0, 0.0>
    translate  <2.0, 0.270729, 0.846279>
  }
  object { TransSweep015 }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      SkiLiftMetal
    }
    scale <0.1, 0.1, 2.0>
    rotate 90.0*y
    translate  <-2.0, 0.270729, 4.736477>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      SkiLiftMetal
    }
    scale <0.1, 0.1, 4.0>
    rotate -0.0*z
    translate  <-2.0, 0.270729, 0.846279>
  }
  object { TransSweep016 }
  object { SkiChairPlasticBits }
  rotate 71.508553*z
  translate  <161.775061, 578.937832, -52.715722>
}
#declare Cylndr035 = object {
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.1>
    rotate <-0.0, -90.0, 0.0>
    translate  <-2.0, 0.298642, 7.592723>
  }
}
#declare WheelBlock = union {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
    rotate <-108.256966, -0.0, -0.0>
    translate  <-2.0, 0.272144, 7.613645>
  }
  object { // Cylndr032 -> Cylndr035
    Cylndr035
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, -0.622171, 0.049774>
  }
  object { // Cylndr033 -> Cylndr035
    Cylndr035
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, -1.070134, 0.074661>
  }
  object { // Cylndr034 -> Cylndr035
    Cylndr035
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, 0.421196, -0.122553>
  }
  object { Cylndr035 }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
    rotate <-93.432724, -0.0, -0.0>
    translate  <-2.0, -0.801721, 7.665132>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.1>
    rotate <-96.003227, -0.0, -0.0>
    translate  <-1.9, -0.573708, 7.650422>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
    rotate <180.0, 0.0, -0.0>
    translate  <-2.0, 0.0, 8.05>
  }
}
#declare Cylndr029 = object {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -1.0*x
  }
}


#declare WineGlass1 = lathe {
  cubic_spline
  7  // control points
  <0.440705, -3.029441>,
  <1.239266, -2.753347>,
  <0.306136, -2.289743>,
  <0.162317, -0.171154>,
  <0.377625, 1.358216>,
  <1.608894, 3.332024>,
  <1.85707, 3.820625>
  rotate <90,0,90>
  material {
    GoldTex
  }
  hollow
  scale 0.158804
  rotate <-13.405769, -0.0, 0.0>
  translate  <-5.703369, -37.581802, 7.945171>
}




//
// ********  OBJECTS  *******
//



union { // SkisNPoles
  object { // SkiPole2 -> SkiPole1
    SkiPole1
    rotate <-167.201035, 76.394379, -87.281013>
    translate  <-45.619638, -37.425998, -3.516495>
  }
  object { SkiPole3 }
  object { // SkiPole4 -> SkiPole3
    SkiPole3
    rotate <25.604263, -8.968488, -161.979874>
    translate  <12.220994, -71.699599, 16.641544>
  }
  object { // SingleSki3 -> SingleSki2
    SingleSki2
    rotate <-8.902827, -0.603883, 0.241496>
    translate  <-1.046427, -1.691528, -5.237289>
  }
  object { SingleSki2 }
  object { SingleSki }
  object { // SingleSki1 -> SingleSki
    SingleSki
    rotate <24.154823, -4.793149, 100.554283>
    translate  <-37.533987, -42.417449, 16.047183>
  }
  object { SkiPole1 }
}


//
// Include file contains 'ABottle'
//
#include "ski2.in1"
#declare ABottle = object {
  ABottle_Raw
  material {
    BottleTex
  }
  hollow
  scale <0.25, 0.25, 0.4>
  translate  <-4.606733, -37.458371, 8.172779>
}
//
// Include file contains 'ABottle1'
//
#include "ski2.in2"
#declare ABottle1 = object {
  ABottle1_Raw
  material {
    WineTex
  }
  hollow
  scale <0.222537, 0.222537, 0.379599>
  translate  <-4.606733, -37.458371, 8.172779>
}
union { // WineBottle
  object { ABottle }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Cork
    }
    scale <0.04944, 0.054993, 0.265644>
    translate  <-4.608322, -37.465649, 8.782014>
  }
  object { ABottle1 }
}


union { // FarBackground
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.062598, -5.000000, -0.876369>, <-4.062598, -5.000000, -0.876369>, <-3.062598, -5.000000, -0.876369>, <-2.031299, -5.000000, -0.438185>, 
      <-5.062598, -4.000000, -0.876369>, <-4.062598, -4.000000, -0.876369>, <-3.062598, -4.000000, -0.876369>, <-2.031299, -4.000000, -0.438185>, 
      <-5.000000, -3.000000, 0.000000>, <-3.874804, -3.000000, -0.625978>, <-2.874804, -3.000000, -0.625978>, <-1.937402, -3.000000, -0.312989>, 
      <-4.937402, -2.000000, 0.187793>, <-3.812207, -2.000000, 0.156495>, <-2.812207, -2.000000, 0.156495>, <-1.843505, -2.000000, 0.046948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.937402, -2.000000, 0.187793>, <-3.812207, -2.000000, 0.156495>, <-2.812207, -2.000000, 0.156495>, <-1.843505, -2.000000, 0.046948>, 
      <-4.874804, -1.000000, 0.375587>, <-3.749609, -1.000000, 0.938967>, <-2.749609, -1.000000, 0.938967>, <-1.749609, -1.000000, 0.438185>, 
      <-4.874804, 0.000000, 0.375587>, <-3.749609, 0.000000, 0.938967>, <-2.812207, 0.000000, 1.627543>, <-1.780908, 0.000000, 0.782473>, 
      <-4.937402, 1.000000, -0.281690>, <-3.874804, 1.000000, -0.000000>, <-2.906103, 1.000000, 0.845070>, <-1.890454, 1.000000, 0.172144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.937402, 1.000000, -0.281690>, <-3.874804, 1.000000, -0.000000>, <-2.906103, 1.000000, 0.845070>, <-1.890454, 1.000000, 0.172144>, 
      <-5.000000, 2.000000, -0.938967>, <-4.000000, 2.000000, -0.938967>, <-3.000000, 2.000000, 0.062598>, <-2.000000, 2.000000, -0.438185>, 
      <-5.000000, 3.000000, -2.629108>, <-4.000000, 3.000000, -2.629108>, <-3.000000, 3.000000, -2.629108>, <-2.000000, 3.000000, -2.629108>, 
      <-5.000000, 4.000000, -2.629108>, <-4.000000, 4.000000, -2.629108>, <-3.000000, 4.000000, -2.629108>, <-2.000000, 4.000000, -2.629108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.031299, -5.000000, -0.438185>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>, 
      <-2.031299, -4.000000, -0.438185>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, 
      <-1.937402, -3.000000, -0.312989>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, 
      <-1.843505, -2.000000, 0.046948>, <-0.874804, -2.000000, -0.031299>, <0.125196, -2.000000, -0.031299>, <1.140845, -2.000000, 0.093897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.843505, -2.000000, 0.046948>, <-0.874804, -2.000000, -0.031299>, <0.125196, -2.000000, -0.031299>, <1.140845, -2.000000, 0.093897>, 
      <-1.749609, -1.000000, 0.438185>, <-0.749609, -1.000000, -0.062598>, <0.250391, -1.000000, -0.062598>, <1.281690, -1.000000, 0.187793>, 
      <-1.780908, 0.000000, 0.782473>, <-0.749609, 0.000000, -0.062598>, <0.250391, 0.000000, -0.062598>, <1.281690, 0.000000, 0.187793>, 
      <-1.890454, 1.000000, 0.172144>, <-0.874804, 1.000000, -0.500782>, <0.125196, 1.000000, -0.500782>, <1.140845, 1.000000, -0.375587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.890454, 1.000000, 0.172144>, <-0.874804, 1.000000, -0.500782>, <0.125196, 1.000000, -0.500782>, <1.140845, 1.000000, -0.375587>, 
      <-2.000000, 2.000000, -0.438185>, <-1.000000, 2.000000, -0.938967>, <-0.000000, 2.000000, -0.938967>, <1.000000, 2.000000, -0.938967>, 
      <-2.000000, 3.000000, -2.629108>, <-1.000000, 3.000000, -2.629108>, <0.000000, 3.000000, -2.629108>, <1.000000, 3.000000, -2.629108>, 
      <-2.000000, 4.000000, -2.629108>, <-1.000000, 4.000000, -2.629108>, <0.000000, 4.000000, -2.629108>, <1.000000, 4.000000, -2.629108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, 
      <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, 
      <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, 
      <1.140845, -2.000000, 0.093897>, <2.156495, -2.000000, 0.219092>, <3.156495, -2.000000, 0.625978>, <4.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.140845, -2.000000, 0.093897>, <2.156495, -2.000000, 0.219092>, <3.156495, -2.000000, 0.625978>, <4.000000, -2.000000, 0.000000>, 
      <1.281690, -1.000000, 0.187793>, <2.312989, -1.000000, 0.438185>, <3.312989, -1.000000, 1.251956>, <4.000000, -1.000000, 0.000000>, 
      <1.281690, 0.000000, 0.187793>, <2.312989, 0.000000, 0.438185>, <3.312989, 0.000000, 1.251956>, <4.000000, 0.000000, 0.000000>, 
      <1.140845, 1.000000, -0.375587>, <2.156495, 1.000000, -0.250391>, <3.156495, 1.000000, 0.156495>, <4.000000, 1.000000, -0.469484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.140845, 1.000000, -0.375587>, <2.156495, 1.000000, -0.250391>, <3.156495, 1.000000, 0.156495>, <4.000000, 1.000000, -0.469484>, 
      <1.000000, 2.000000, -0.938967>, <2.000000, 2.000000, -0.938967>, <3.000000, 2.000000, -0.938967>, <4.000000, 2.000000, -0.938967>, 
      <1.000000, 3.000000, -2.629108>, <2.000000, 3.000000, -2.629108>, <3.000000, 3.000000, -2.629108>, <4.000000, 3.000000, -2.629108>, 
      <1.000000, 4.000000, -2.629108>, <2.000000, 4.000000, -2.629108>, <3.000000, 4.000000, -2.629108>, <4.000000, 4.000000, -2.629108>
    }
  }
  scale <177.456741, 254.913498, 20.0>
  translate  <53.519642, 1103.336864, -231.648688>
  material {
    HillTex
    // Transform to world space
  }
}


sphere { // BackgroundSky
  <0,0,0>,1
  material {
    SkyTex
  }
  hollow
  scale 2000.0
}


box { // Clouds
  <-1, -1, -1>, <1, 1, 1>
  material {
    High_Sky
  }
  scale <916.563293, 158.635406, 1.0>
  translate  <-13.931844, 1738.205214, -237.697744>
}


#declare CSG007 = difference {
  torus { // Torus004
    3.95, 0.05  rotate -x*90
    translate  <148.369488, 588.066485, -46.178968>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <2.759316, 5.240403, 1.0>
    rotate -26.93395*z
    translate  <150.732149, 587.294449, -46.431506>
  }
}
#declare LiftCords = union {
  object { CSG007 }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 62.0>
    rotate <-21.540054, -83.017746, 1.95871>
    translate  <207.942098, 570.742617, -53.168591>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 63.0>
    rotate <-22.284622, -83.092819, 2.211029>
    translate  <205.075507, 563.051091, -53.168591>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 62.0>
    rotate <-173.682526, 77.024933, 168.391144>
    translate  <207.942098, 570.742617, -53.168591>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 63.0>
    rotate <-171.640381, 76.769135, 168.640106>
    translate  <205.075507, 563.051091, -53.168591>
  }
  material {
    SkiCordTex
  }
}
#declare SkiLiftPole = union {
  object { // WheelBlock1 -> WheelBlock
    WheelBlock
    scale -1.0
    rotate -180.0*x
  }
  object { WheelBlock }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    rotate <-0.0, -90.0, 0.0>
    translate  <2.0, 0.0, 8.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
  }
  material {
    SkiLiftMetal
  }
  scale 2.0
  rotate -110.277573*z
  translate  <206.730869, 566.812121, -68.909476>
}
#declare WheelHoles = union {
  object { // Cylndr022 -> Cylndr029
    Cylndr029
    rotate -157.5*z
    translate  <-1.630986, -1.08979, 0.0>
  }
  object { // Cylndr023 -> Cylndr029
    Cylndr029
    rotate -135.0*z
    translate  <-0.707107, -1.707107, 0.0>
  }
  object { // Cylndr024 -> Cylndr029
    Cylndr029
    rotate -112.5*z
    translate  <0.324423, -1.630986, 0.0>
  }
  object { // Cylndr025 -> Cylndr029
    Cylndr029
    rotate -90.0*z
    translate  <1.0, -1.0, 0.0>
  }
  object { // Cylndr026 -> Cylndr029
    Cylndr029
    rotate -67.5*z
    translate  <1.08979, -0.216773, 0.0>
  }
  object { // Cylndr027 -> Cylndr029
    Cylndr029
    rotate -45.0*z
    translate  <0.707107, 0.292893, 0.0>
  }
  object { // Cylndr028 -> Cylndr029
    Cylndr029
    rotate -22.5*z
    translate  <0.216773, 0.324423, 0.0>
  }
  object { Cylndr029 }
  translate  <0.0, 10.0, 7.5>
}
#declare CSG006 = difference {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.25>
    translate  <0.0, 10.0, 7.875>
  }
  torus { // Torus003
    1.95, 0.05  rotate -x*90
    translate  <0.0, 10.0, 8.0>
  }
  object { WheelHoles }
}
#declare SkiLiftRoundabout = union {
  object { CSG006 }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  10.0*y
  }
  material {
    SkiLiftMetal
  }
  scale 2.0
  translate  <148.347898, 568.085643, -62.166384>
}
union { // SkiLiftStuff
  object { // SkiChair2 -> SkiChair
    SkiChair
    rotate -0.0*y
    translate  <49.242119, -10.507131, -6.726691>
  }
  object { // SkiChair1 -> SkiChair
    SkiChair
    rotate <-0.0, -0.0, 176.57576>
    translate  <389.827785, 1144.320539, -3.395796>
  }
  object { LiftCords }
  object { SkiChair }
  object { SkiLiftPole }
  object { SkiLiftRoundabout }
  translate  -4.0*z
}


object { // WineGlass2 -> WineGlass1
  WineGlass1
  rotate <-0.0, -0.0, 0.0>
  translate  <1.547702, -0.417087, 0.150545>
}


object { WineGlass1 }


#include "D:\My Documents\Rendering\rockbit.inc"

object {
  Default_Object1
  material {
    RockTex
  }
  scale 3.533188
  rotate <-179.035736, -197.478577, -68.461136>
  translate  <-140.634444, 462.555326, -148.685464>
}


#include "D:\My Documents\Rendering\snowheap.inc"

object {
  Default_Object1
  material {
    SnowTex_1
  }
  scale <0.340815, 0.280679, 0.201146>
  rotate -15.028181*x
  translate  <-5.124013, -36.549728, 5.931516>
}


union { // SmallSkier
  sphere { // Sphere003
    <0,0,0>,1
    material {
      SmallSkierSkinTex
    }
    scale 1.370359
    translate  <129.424725, 463.660925, -105.481364>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.815746, 1.0, 4.685087>
    rotate 12.640107*y
    translate  <128.186812, 463.679385, -111.279456>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 3.660062>
    rotate <0.0, 24.521578, -0.0>
    translate  <126.25258, 462.979704, -113.871971>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 3.660062>
    rotate <0.0, 24.521578, -0.0>
    translate  <126.664157, 464.420224, -113.871971>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 3.660062>
    rotate <-180.0, -47.017456, 180.0>
    translate  <128.783629, 462.979704, -108.68694>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 3.660062>
    rotate <-180.0, -47.017456, 180.0>
    translate  <128.824787, 464.214435, -108.68694>
  }
  material {
    SmallSkiertex
  }
  scale 0.3
  translate  <85.640448, 323.339509, -78.215044>
}


disc { // LakeWater
  <0,0,0>, <0,0,1>, 1.0
  material {
    Water
  }
  scale <183.227173, 188.384537, 1.0>
  translate  <-12.40422, 424.168762, -148.206357>
}


union { // MediumMountain
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.000000, -8.000000, 0.000000>, <-7.000000, -8.000000, 0.000000>, <-6.000000, -8.000000, 0.000000>, <-5.000000, -8.000000, 0.000000>, 
      <-8.000000, -7.000000, 0.000000>, <-7.000000, -7.000000, 0.000000>, <-6.000000, -7.000000, 0.000000>, <-5.000000, -7.000000, 0.000000>, 
      <-8.625978, -6.000000, 3.380282>, <-7.000000, -6.000000, 0.000000>, <-6.000000, -6.000000, 0.000000>, <-5.000000, -6.000000, 0.000000>, 
      <-8.594679, -5.000000, 3.724570>, <-7.782473, -5.156495, 1.877934>, <-6.093897, -5.000000, 1.251956>, <-5.046948, -5.000000, 0.625978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.594679, -5.000000, 3.724570>, <-7.782473, -5.156495, 1.877934>, <-6.093897, -5.000000, 1.251956>, <-5.046948, -5.000000, 0.625978>, 
      <-8.563380, -4.000000, 4.068858>, <-8.564945, -4.312989, 3.755869>, <-6.187793, -4.000000, 2.503912>, <-5.093897, -4.000000, 1.251956>, 
      <-8.563380, -3.000000, 4.068858>, <-8.564945, -3.312989, 3.755869>, <-6.187793, -3.000000, 2.503912>, <-5.093897, -3.000000, 1.251956>, 
      <-9.658842, -2.250391, 3.380282>, <-7.782473, -2.156495, 1.877934>, <-6.062598, -2.000000, 1.596244>, <-5.031299, -2.000000, 0.798122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.658842, -2.250391, 3.380282>, <-7.782473, -2.156495, 1.877934>, <-6.062598, -2.000000, 1.596244>, <-5.031299, -2.000000, 0.798122>, 
      <-10.754304, -1.500782, 2.691706>, <-7.000000, -1.000000, 0.000000>, <-5.937402, -1.000000, 0.688576>, <-4.968701, -1.000000, 0.344288>, 
      <-10.566510, -0.062598, 3.818466>, <-6.812207, 0.000000, 3.004695>, <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>, 
      <-10.128326, 0.812207, 4.632238>, <-6.749609, 1.000000, 3.881064>, <-5.906103, 1.000000, 2.723005>, <-4.874804, 1.000000, 1.768388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.128326, 0.812207, 4.632238>, <-6.749609, 1.000000, 3.881064>, <-5.906103, 1.000000, 2.723005>, <-4.874804, 1.000000, 1.768388>, 
      <-9.690141, 1.687011, 5.446009>, <-6.687011, 2.000000, 4.757433>, <-5.812207, 2.000000, 5.446009>, <-4.749609, 2.000000, 3.536776>, 
      <-9.877934, 2.436620, 3.693271>, <-6.687011, 3.000000, 4.757433>, <-5.874804, 3.000000, 6.009390>, <-4.906103, 3.000000, 3.912363>, 
      <-10.347418, 3.436620, 3.536776>, <-6.718310, 4.000000, 5.602504>, <-5.937402, 4.000000, 3.004695>, <-4.921753, 4.000000, 3.458529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.347418, 3.436620, 3.536776>, <-6.718310, 4.000000, 5.602504>, <-5.937402, 4.000000, 3.004695>, <-4.921753, 4.000000, 3.458529>, 
      <-10.816901, 4.436620, 3.380282>, <-6.749609, 5.000000, 6.447574>, <-6.000000, 5.000000, 0.000000>, <-4.937402, 5.000000, 3.004695>, 
      <-10.003130, 5.123631, 3.818466>, <-6.749609, 6.000000, 6.760563>, <-5.749609, 6.000000, 6.447574>, <-5.031299, 6.000000, 5.508607>, 
      <-9.877934, 7.813772, 3.380282>, <-5.497653, 7.000000, 5.007825>, <-4.497653, 7.000000, 4.569640>, <-3.873239, 7.000000, 4.882629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, -8.000000, 0.000000>, <-4.000000, -8.000000, 0.000000>, <-3.000000, -8.000000, 0.000000>, <-2.000000, -8.000000, 0.000000>, 
      <-5.000000, -7.000000, 0.000000>, <-4.000000, -7.000000, 0.000000>, <-3.000000, -7.000000, 0.000000>, <-2.000000, -7.000000, 0.000000>, 
      <-5.000000, -6.000000, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, 0.000000>, 
      <-5.046948, -5.000000, 0.625978>, <-4.000000, -5.000000, 0.000000>, <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.046948, -5.000000, 0.625978>, <-4.000000, -5.000000, 0.000000>, <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, 
      <-5.093897, -4.000000, 1.251956>, <-4.000000, -4.000000, 0.000000>, <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, 
      <-5.093897, -3.000000, 1.251956>, <-4.000000, -3.000000, 0.000000>, <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, 
      <-5.031299, -2.000000, 0.798122>, <-4.000000, -2.000000, 0.000000>, <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.031299, -2.000000, 0.798122>, <-4.000000, -2.000000, 0.000000>, <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, 
      <-4.968701, -1.000000, 0.344288>, <-4.000000, -1.000000, 0.000000>, <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, 
      <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, 
      <-4.874804, 1.000000, 1.768388>, <-3.843505, 1.000000, 0.813772>, <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.874804, 1.000000, 1.768388>, <-3.843505, 1.000000, 0.813772>, <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, 
      <-4.749609, 2.000000, 3.536776>, <-3.687011, 2.000000, 1.627543>, <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, 
      <-4.906103, 3.000000, 3.912363>, <-3.937402, 3.000000, 1.815336>, <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, 
      <-4.921753, 4.000000, 3.458529>, <-3.906103, 4.000000, 3.912363>, <-2.906103, 4.000000, 2.723005>, <-1.906103, 4.000000, 2.112676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.921753, 4.000000, 3.458529>, <-3.906103, 4.000000, 3.912363>, <-2.906103, 4.000000, 2.723005>, <-1.906103, 4.000000, 2.112676>, 
      <-4.937402, 5.000000, 3.004695>, <-3.874804, 5.000000, 6.009390>, <-2.812207, 5.000000, 5.446009>, <-1.812207, 5.000000, 4.225352>, 
      <-5.031299, 6.000000, 5.508607>, <-4.312989, 6.000000, 4.569640>, <-2.812207, 6.000000, 5.446009>, <-1.749609, 6.000000, 5.101721>, 
      <-3.873239, 7.000000, 4.882629>, <-3.248826, 7.000000, 5.195618>, <-2.374022, 7.000000, 4.757433>, <-1.342723, 7.000000, 4.475743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -8.000000, 0.000000>, <-1.000000, -8.000000, 0.000000>, <0.000000, -8.000000, 0.000000>, <1.000000, -8.000000, 0.000000>, 
      <-2.000000, -7.000000, 0.000000>, <-1.000000, -7.000000, 0.000000>, <0.000000, -7.000000, 0.000000>, <1.000000, -7.000000, 0.000000>, 
      <-2.000000, -6.000000, 0.000000>, <-1.000000, -6.000000, 0.000000>, <0.000000, -6.000000, 0.000000>, <1.000000, -6.000000, 0.000000>, 
      <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>, 
      <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, 
      <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, 
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, 
      <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, 
      <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>, <1.031299, 3.000000, 0.907668>, 
      <-1.906103, 4.000000, 2.112676>, <-0.906103, 4.000000, 1.502347>, <0.093897, 4.000000, 1.502347>, <1.062598, 4.000000, 1.205008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.906103, 4.000000, 2.112676>, <-0.906103, 4.000000, 1.502347>, <0.093897, 4.000000, 1.502347>, <1.062598, 4.000000, 1.205008>, 
      <-1.812207, 5.000000, 4.225352>, <-0.812207, 5.000000, 3.004695>, <0.187793, 5.000000, 3.004695>, <1.093897, 5.000000, 1.502347>, 
      <-1.749609, 6.000000, 5.101721>, <-0.687011, 6.000000, 4.757433>, <0.312989, 6.000000, 4.757433>, <1.250391, 6.000000, 3.881064>, 
      <-1.342723, 7.000000, 4.475743>, <-0.311424, 7.000000, 4.194053>, <0.813772, 7.000000, 3.505477>, <1.719875, 7.000000, 4.131455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -8.000000, 0.000000>, <2.000000, -8.000000, 0.000000>, <3.000000, -8.000000, 0.000000>, <4.000000, -8.000000, 0.000000>, 
      <1.000000, -7.000000, 0.000000>, <2.000000, -7.000000, 0.000000>, <3.000000, -7.000000, 0.000000>, <4.000000, -7.000000, 0.000000>, 
      <1.000000, -6.000000, 0.000000>, <2.000000, -6.000000, 0.000000>, <3.000000, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, 
      <1.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, 
      <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, 
      <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.031299, -3.000000, 0.344288>, 
      <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.031299, -2.000000, 0.625978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.031299, -2.000000, 0.625978>, 
      <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, <4.031299, -1.000000, 0.907668>, 
      <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.093897, 0.000000, 1.502347>, 
      <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.093897, 1.000000, 1.502347>, <4.172144, 1.000000, 2.456964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.093897, 1.000000, 1.502347>, <4.172144, 1.000000, 2.456964>, 
      <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.187793, 2.000000, 3.004695>, <4.250391, 2.000000, 3.411581>, 
      <1.031299, 3.000000, 0.907668>, <2.062598, 3.000000, 1.815336>, <3.187793, 3.000000, 3.004695>, <4.187793, 3.000000, 4.225352>, 
      <1.062598, 4.000000, 1.205008>, <2.031299, 4.000000, 0.907668>, <3.250391, 4.000000, 3.411581>, <4.391236, 4.125196, 4.428795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.062598, 4.000000, 1.205008>, <2.031299, 4.000000, 0.907668>, <3.250391, 4.000000, 3.411581>, <4.391236, 4.125196, 4.428795>, 
      <1.093897, 5.000000, 1.502347>, <2.000000, 5.000000, 0.000000>, <3.312989, 5.000000, 3.818466>, <4.594679, 5.250391, 4.632238>, 
      <1.250391, 6.000000, 3.881064>, <2.187793, 6.000000, 3.004695>, <3.312989, 6.000000, 3.818466>, <4.594679, 6.250391, 4.632238>, 
      <1.719875, 7.000000, 4.131455>, <2.625978, 7.000000, 4.757433>, <3.751174, 7.000000, 5.195618>, <4.813772, 7.657277, 5.258216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -8.000000, 0.000000>, <5.000000, -8.000000, 0.000000>, <7.251956, -8.500782, 0.000000>, <10.693271, -7.812207, 2.566510>, 
      <4.000000, -7.000000, 0.000000>, <5.000000, -7.000000, 0.000000>, <7.251956, -7.500782, 0.000000>, <10.693271, -6.812207, 2.566510>, 
      <4.000000, -6.000000, 0.000000>, <5.000000, -6.000000, 0.000000>, <7.251956, -6.500782, 0.000000>, <10.693271, -5.812207, 2.566510>, 
      <4.000000, -5.000000, 0.000000>, <5.000000, -5.000000, 0.000000>, <7.251956, -5.500782, 0.000000>, <10.693271, -4.812207, 2.566510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -5.000000, 0.000000>, <5.000000, -5.000000, 0.000000>, <7.251956, -5.500782, 0.000000>, <10.693271, -4.812207, 2.566510>, 
      <4.000000, -4.000000, 0.000000>, <5.000000, -4.000000, 0.000000>, <7.251956, -4.500782, 0.000000>, <10.693271, -3.812207, 2.566510>, 
      <4.031299, -3.000000, 0.344288>, <5.062598, -3.000000, 0.688576>, <7.314554, -3.500782, 0.688576>, <10.755869, -2.812207, 3.255086>, 
      <4.031299, -2.000000, 0.625978>, <5.062598, -2.000000, 1.251956>, <7.314554, -2.500782, 1.251956>, <10.787167, -1.812207, 3.192488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.031299, -2.000000, 0.625978>, <5.062598, -2.000000, 1.251956>, <7.314554, -2.500782, 1.251956>, <10.787167, -1.812207, 3.192488>, 
      <4.031299, -1.000000, 0.907668>, <5.062598, -1.000000, 1.815336>, <7.314554, -1.500782, 1.815336>, <10.818466, -0.812207, 3.129890>, 
      <4.093897, 0.000000, 1.502347>, <5.187793, 0.000000, 3.004695>, <7.439750, 0.062598, 3.004695>, <11.820031, -0.312989, 2.378717>, 
      <4.172144, 1.000000, 2.456964>, <5.250391, 1.000000, 3.411581>, <7.596244, 1.000000, 3.411581>, <11.507042, 0.843505, 3.129890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.172144, 1.000000, 2.456964>, <5.250391, 1.000000, 3.411581>, <7.596244, 1.000000, 3.411581>, <11.507042, 0.843505, 3.129890>, 
      <4.250391, 2.000000, 3.411581>, <5.312989, 2.000000, 3.818466>, <7.752739, 1.937402, 3.818466>, <11.194053, 2.000000, 3.881064>, 
      <4.187793, 3.000000, 4.225352>, <5.187793, 3.000000, 5.446009>, <7.627543, 2.937402, 5.446009>, <11.006260, 2.687011, 4.444444>, 
      <4.391236, 4.125196, 4.428795>, <5.532081, 4.250391, 5.446009>, <7.658842, 4.219092, 5.727700>, <10.974961, 3.561815, 4.788732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.391236, 4.125196, 4.428795>, <5.532081, 4.250391, 5.446009>, <7.658842, 4.219092, 5.727700>, <10.974961, 3.561815, 4.788732>, 
      <4.594679, 5.250391, 4.632238>, <5.876369, 5.500782, 5.446009>, <7.690141, 5.500782, 6.009390>, <10.943662, 4.436620, 5.133020>, 
      <4.594679, 6.250391, 4.632238>, <5.876369, 6.500782, 5.446009>, <7.815336, 6.500782, 6.760563>, <10.943662, 5.436620, 5.571205>, 
      <4.813772, 7.657277, 5.258216>, <5.876369, 8.314554, 5.320814>, <9.129890, 8.001565, 5.320814>, <12.007825, 7.625978, 3.881064>
    }
  }
  material {
    SnowTex
  }
  scale 20.0
  translate  <-5.147718, 454.861406, -172.266768>
}


union { // CloseMountain
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.000000, -8.000000, 2.441315>, <-7.000000, -8.000000, 2.065728>, <-6.187793, -8.000000, 1.126761>, <-5.093897, -8.000000, 0.907668>, 
      <-8.000000, -7.062598, 2.190923>, <-7.000000, -7.062598, 1.815336>, <-6.187793, -7.062598, 0.876369>, <-5.093897, -7.062598, 0.657277>, 
      <-8.000000, -6.000000, 2.065728>, <-7.000000, -6.000000, 1.690141>, <-6.187793, -6.000000, 0.751174>, <-5.093897, -6.000000, 0.532081>, 
      <-8.000000, -5.000000, 1.909233>, <-7.000000, -5.000000, 1.533646>, <-6.187793, -5.000000, 0.594679>, <-5.140845, -5.000000, 0.203443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.000000, -5.000000, 1.909233>, <-7.000000, -5.000000, 1.533646>, <-6.187793, -5.000000, 0.594679>, <-5.140845, -5.000000, 0.203443>, 
      <-8.000000, -4.000000, 1.752739>, <-7.000000, -4.000000, 1.377152>, <-6.187793, -4.000000, 0.438185>, <-5.187793, -4.000000, -0.125196>, 
      <-8.000000, -3.000000, 1.752739>, <-7.000000, -3.000000, 1.377152>, <-6.187793, -3.000000, 0.438185>, <-5.187793, -3.000000, -0.125196>, 
      <-8.000000, -2.000000, 1.752739>, <-7.000000, -2.000000, 1.377152>, <-6.187793, -2.000000, 0.438185>, <-5.187793, -2.000000, -0.125196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.000000, -2.000000, 1.752739>, <-7.000000, -2.000000, 1.377152>, <-6.187793, -2.000000, 0.438185>, <-5.187793, -2.000000, -0.125196>, 
      <-8.000000, -1.000000, 1.752739>, <-7.000000, -1.000000, 1.377152>, <-6.187793, -1.000000, 0.438185>, <-5.187793, -1.000000, -0.125196>, 
      <-8.000000, 0.000000, 1.752739>, <-7.000000, 0.000000, 1.377152>, <-6.187793, 0.000000, 0.438185>, <-5.187793, 0.000000, -0.125196>, 
      <-7.981607, 1.000000, 1.200947>, <-6.981607, 1.000000, 0.825360>, <-6.169400, 1.000000, -0.113607>, <-5.169400, 1.000000, -0.676988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.981607, 1.000000, 1.200947>, <-6.981607, 1.000000, 0.825360>, <-6.169400, 1.000000, -0.113607>, <-5.169400, 1.000000, -0.676988>, 
      <-7.963214, 2.000000, 0.649155>, <-6.963214, 2.000000, 0.273568>, <-6.151007, 2.000000, -0.665399>, <-5.151007, 2.000000, -1.228780>, 
      <-7.963214, 3.000000, 0.023790>, <-6.963214, 3.000000, -0.351797>, <-6.151007, 3.000000, -1.290764>, <-5.151007, 3.000000, -1.854144>, 
      <-7.926428, 4.000000, -0.546395>, <-6.926428, 4.000000, -0.921982>, <-6.114221, 4.000000, -1.860949>, <-5.067273, 4.000000, -2.252185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.926428, 4.000000, -0.546395>, <-6.926428, 4.000000, -0.921982>, <-6.114221, 4.000000, -1.860949>, <-5.067273, 4.000000, -2.252185>, 
      <-7.889642, 5.000000, -1.116580>, <-6.889642, 5.000000, -1.492167>, <-6.077435, 5.000000, -2.431134>, <-4.983538, 5.000000, -2.650226>, 
      <-7.926428, 6.062598, -1.943961>, <-6.926428, 6.062598, -2.319548>, <-6.114221, 6.062598, -3.258515>, <-5.020324, 6.062598, -3.477607>, 
      <-8.000000, 7.062598, -2.812235>, <-7.000000, 7.062598, -3.187822>, <-6.187793, 7.062598, -4.126789>, <-5.093897, 7.062598, -4.345881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.093897, -8.000000, 0.907668>, <-4.000000, -8.000000, 0.688576>, <-3.000000, -8.000000, 0.688576>, <-2.000000, -8.000000, 0.688576>, 
      <-5.093897, -7.062598, 0.657277>, <-4.000000, -7.062598, 0.438185>, <-3.000000, -7.062598, 0.438185>, <-2.000000, -7.062598, 0.438185>, 
      <-5.093897, -6.000000, 0.532081>, <-4.000000, -6.000000, 0.312989>, <-3.000000, -6.000000, 0.312989>, <-2.000000, -6.000000, 0.312989>, 
      <-5.140845, -5.000000, 0.203443>, <-4.093897, -5.000000, -0.187793>, <-3.093897, -5.000000, -0.187793>, <-2.093897, -5.000000, -0.187793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.140845, -5.000000, 0.203443>, <-4.093897, -5.000000, -0.187793>, <-3.093897, -5.000000, -0.187793>, <-2.093897, -5.000000, -0.187793>, 
      <-5.187793, -4.000000, -0.125196>, <-4.187793, -4.000000, -0.688576>, <-3.187793, -4.000000, -0.688576>, <-2.187793, -4.000000, -0.688576>, 
      <-5.187793, -3.000000, -0.125196>, <-4.187793, -3.000000, -0.688576>, <-3.187793, -3.000000, -0.688576>, <-2.187793, -3.000000, -0.688576>, 
      <-5.187793, -2.000000, -0.125196>, <-4.187793, -2.000000, -0.688576>, <-3.125196, -2.000000, -0.782473>, <-2.125196, -2.000000, -0.782473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.187793, -2.000000, -0.125196>, <-4.187793, -2.000000, -0.688576>, <-3.125196, -2.000000, -0.782473>, <-2.125196, -2.000000, -0.782473>, 
      <-5.187793, -1.000000, -0.125196>, <-4.187793, -1.000000, -0.688576>, <-3.062598, -1.000000, -0.876369>, <-2.062598, -1.000000, -0.876369>, 
      <-5.187793, 0.000000, -0.125196>, <-4.187793, 0.000000, -0.688576>, <-3.062598, 0.000000, -0.876369>, <-2.219092, 0.000000, -1.189358>, 
      <-5.169400, 1.000000, -0.676988>, <-4.169400, 1.000000, -1.240368>, <-3.044205, 1.000000, -1.428161>, <-2.200699, 1.000000, -1.741150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.169400, 1.000000, -0.676988>, <-4.169400, 1.000000, -1.240368>, <-3.044205, 1.000000, -1.428161>, <-2.200699, 1.000000, -1.741150>, 
      <-5.151007, 2.000000, -1.228780>, <-4.151007, 2.000000, -1.792160>, <-3.025812, 2.000000, -1.979953>, <-2.182306, 2.000000, -2.292942>, 
      <-5.151007, 3.000000, -1.854144>, <-4.151007, 3.000000, -2.417524>, <-3.025812, 3.000000, -2.605318>, <-2.025812, 3.000000, -2.605318>, 
      <-5.067273, 4.000000, -2.252185>, <-4.020324, 4.000000, -2.643421>, <-2.957727, 4.000000, -2.737318>, <-1.957727, 4.000000, -2.737318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.067273, 4.000000, -2.252185>, <-4.020324, 4.000000, -2.643421>, <-2.957727, 4.000000, -2.737318>, <-1.957727, 4.000000, -2.737318>, 
      <-4.983538, 5.000000, -2.650226>, <-3.889642, 5.000000, -2.869319>, <-2.889642, 5.000000, -2.869319>, <-1.889642, 5.000000, -2.869319>, 
      <-5.020324, 6.062598, -3.477607>, <-3.926428, 6.062598, -3.696700>, <-2.926428, 6.062598, -4.138133>, <-1.926428, 6.062598, -4.285278>, 
      <-5.093897, 7.062598, -4.345881>, <-4.000000, 7.062598, -4.564974>, <-3.000000, 7.062598, -5.006407>, <-2.000000, 7.062598, -5.153552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -8.000000, 0.688576>, <-1.000000, -8.000000, 0.688576>, <0.000000, -8.000000, 0.688576>, <1.000000, -8.000000, 0.688576>, 
      <-2.000000, -7.062598, 0.438185>, <-1.000000, -7.062598, 0.438185>, <0.000000, -7.062598, 0.438185>, <1.000000, -7.062598, 0.438185>, 
      <-2.000000, -6.000000, 0.312989>, <-1.000000, -6.000000, 0.312989>, <0.000000, -6.000000, 0.312989>, <1.000000, -6.000000, 0.312989>, 
      <-2.093897, -5.000000, -0.187793>, <-1.093897, -5.000000, -0.187793>, <-0.093897, -5.000000, -0.187793>, <0.906103, -5.000000, -0.187793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.093897, -5.000000, -0.187793>, <-1.093897, -5.000000, -0.187793>, <-0.093897, -5.000000, -0.187793>, <0.906103, -5.000000, -0.187793>, 
      <-2.187793, -4.000000, -0.688576>, <-1.187793, -4.000000, -0.688576>, <-0.187793, -4.000000, -0.688576>, <0.812207, -4.000000, -0.688576>, 
      <-2.187793, -3.000000, -0.688576>, <-1.187793, -3.000000, -0.688576>, <-0.187793, -3.000000, -0.688576>, <0.812207, -3.000000, -0.688576>, 
      <-2.125196, -2.000000, -0.782473>, <-1.125196, -2.000000, -0.782473>, <-0.125196, -2.000000, -0.782473>, <0.843505, -2.000000, -0.735524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.125196, -2.000000, -0.782473>, <-1.125196, -2.000000, -0.782473>, <-0.125196, -2.000000, -0.782473>, <0.843505, -2.000000, -0.735524>, 
      <-2.062598, -1.000000, -0.876369>, <-1.062598, -1.000000, -0.876369>, <-0.062598, -1.000000, -0.876369>, <0.874804, -1.000000, -0.782473>, 
      <-2.219092, 0.000000, -1.189358>, <-1.375587, 0.000000, -1.502347>, <-0.375587, 0.000000, -1.502347>, <0.718310, 0.000000, -1.095462>, 
      <-2.200699, 1.000000, -1.741150>, <-1.357194, 1.000000, -2.054139>, <-0.357194, 1.000000, -2.054139>, <0.736703, 1.000000, -1.647254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.200699, 1.000000, -1.741150>, <-1.357194, 1.000000, -2.054139>, <-0.357194, 1.000000, -2.054139>, <0.736703, 1.000000, -1.647254>, 
      <-2.182306, 2.000000, -2.292942>, <-1.338801, 2.000000, -2.605931>, <-0.338801, 2.000000, -2.605931>, <0.755096, 2.000000, -2.199046>, 
      <-2.025812, 3.000000, -2.605318>, <-1.025812, 3.000000, -2.605318>, <-0.025812, 3.000000, -2.605318>, <0.911591, 3.000000, -2.511421>, 
      <-1.957727, 4.000000, -2.737318>, <-0.957727, 4.000000, -2.737318>, <0.042273, 4.000000, -2.737318>, <1.010974, 4.000000, -2.690370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.957727, 4.000000, -2.737318>, <-0.957727, 4.000000, -2.737318>, <0.042273, 4.000000, -2.737318>, <1.010974, 4.000000, -2.690370>, 
      <-1.889642, 5.000000, -2.869319>, <-0.889642, 5.000000, -2.869319>, <0.110358, 5.000000, -2.869319>, <1.110358, 5.000000, -2.869319>, 
      <-1.926428, 6.062598, -4.285278>, <-0.926428, 6.062598, -4.432422>, <0.073572, 6.062598, -4.432422>, <1.073572, 6.062598, -4.285278>, 
      <-2.000000, 7.062598, -5.153552>, <-1.000000, 7.062598, -5.300696>, <0.000000, 7.062598, -5.300696>, <1.000000, 7.062598, -5.153552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -8.000000, 0.688576>, <2.000000, -8.000000, 0.688576>, <3.000000, -8.000000, 0.688576>, <4.000000, -8.000000, 0.813772>, 
      <1.000000, -7.062598, 0.438185>, <2.000000, -7.062598, 0.438185>, <3.000000, -7.062598, 0.438185>, <4.000000, -7.062598, 0.563380>, 
      <1.000000, -6.000000, 0.312989>, <2.000000, -6.000000, 0.312989>, <3.000000, -6.000000, 0.312989>, <4.000000, -6.000000, 0.438185>, 
      <0.906103, -5.000000, -0.187793>, <1.906103, -5.000000, -0.187793>, <3.000000, -5.000000, 0.156495>, <4.000000, -5.000000, 0.281690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.906103, -5.000000, -0.187793>, <1.906103, -5.000000, -0.187793>, <3.000000, -5.000000, 0.156495>, <4.000000, -5.000000, 0.281690>, 
      <0.812207, -4.000000, -0.688576>, <1.812207, -4.000000, -0.688576>, <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.125196>, 
      <0.812207, -3.000000, -0.688576>, <1.812207, -3.000000, -0.688576>, <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.125196>, 
      <0.843505, -2.000000, -0.735524>, <1.812207, -2.000000, -0.688576>, <3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.125196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.843505, -2.000000, -0.735524>, <1.812207, -2.000000, -0.688576>, <3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.125196>, 
      <0.874804, -1.000000, -0.782473>, <1.812207, -1.000000, -0.688576>, <3.000000, -1.000000, 0.000000>, <4.000000, -1.000000, 0.125196>, 
      <0.718310, 0.000000, -1.095462>, <1.812207, 0.000000, -0.688576>, <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.125196>, 
      <0.736703, 1.000000, -1.647254>, <1.830600, 1.000000, -1.240368>, <3.018393, 1.000000, -0.551792>, <4.018393, 1.000000, -0.426596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.736703, 1.000000, -1.647254>, <1.830600, 1.000000, -1.240368>, <3.018393, 1.000000, -0.551792>, <4.018393, 1.000000, -0.426596>, 
      <0.755096, 2.000000, -2.199046>, <1.848993, 2.000000, -1.792160>, <3.036786, 2.000000, -1.103584>, <4.036786, 2.000000, -0.978388>, 
      <0.911591, 3.000000, -2.511421>, <1.848993, 3.000000, -2.417524>, <3.036786, 3.000000, -1.728948>, <4.036786, 3.000000, -1.603753>, 
      <1.010974, 4.000000, -2.690370>, <1.979676, 4.000000, -2.643421>, <3.073572, 4.000000, -2.299133>, <4.073572, 4.000000, -2.173938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.010974, 4.000000, -2.690370>, <1.979676, 4.000000, -2.643421>, <3.073572, 4.000000, -2.299133>, <4.073572, 4.000000, -2.173938>, 
      <1.110358, 5.000000, -2.869319>, <2.110358, 5.000000, -2.869319>, <3.110358, 5.000000, -2.869319>, <4.110358, 5.000000, -2.744123>, 
      <1.073572, 6.062598, -4.285278>, <2.073572, 6.062598, -4.138133>, <3.073572, 6.062598, -3.696700>, <4.073572, 6.062598, -3.571504>, 
      <1.000000, 7.062598, -5.153552>, <2.000000, 7.062598, -5.006407>, <3.000000, 7.062598, -4.564974>, <4.000000, 7.062598, -4.439778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -8.000000, 0.813772>, <5.000000, -8.000000, 0.938967>, <6.062598, -8.000000, 1.189358>, <7.125196, -8.000000, 1.627543>, 
      <4.000000, -7.062598, 0.563380>, <5.000000, -7.062598, 0.688576>, <6.062598, -7.062598, 0.938967>, <7.125196, -7.062598, 1.377152>, 
      <4.000000, -6.000000, 0.438185>, <5.000000, -6.000000, 0.563380>, <6.062598, -6.000000, 0.813772>, <7.125196, -6.000000, 1.251956>, 
      <4.000000, -5.000000, 0.281690>, <5.000000, -5.000000, 0.406886>, <6.062598, -5.000000, 0.657277>, <7.125196, -5.000000, 1.095462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -5.000000, 0.281690>, <5.000000, -5.000000, 0.406886>, <6.062598, -5.000000, 0.657277>, <7.125196, -5.000000, 1.095462>, 
      <4.000000, -4.000000, 0.125196>, <5.000000, -4.000000, 0.250391>, <6.062598, -4.000000, 0.500782>, <7.125196, -4.000000, 0.938967>, 
      <4.000000, -3.000000, 0.125196>, <5.000000, -3.000000, 0.250391>, <6.062598, -3.000000, 0.500782>, <7.125196, -3.000000, 0.938967>, 
      <4.000000, -2.000000, 0.125196>, <5.000000, -2.000000, 0.250391>, <6.062598, -2.000000, 0.500782>, <7.125196, -2.000000, 0.938967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -2.000000, 0.125196>, <5.000000, -2.000000, 0.250391>, <6.062598, -2.000000, 0.500782>, <7.125196, -2.000000, 0.938967>, 
      <4.000000, -1.000000, 0.125196>, <5.000000, -1.000000, 0.250391>, <6.062598, -1.000000, 0.500782>, <7.125196, -1.000000, 0.938967>, 
      <4.000000, 0.000000, 0.125196>, <5.000000, 0.000000, 0.250391>, <6.062598, 0.000000, 0.500782>, <7.125196, 0.000000, 0.938967>, 
      <4.018393, 1.000000, -0.426596>, <5.018393, 1.000000, -0.301401>, <6.080991, 1.000000, -0.051010>, <7.143589, 1.000000, 0.387175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.018393, 1.000000, -0.426596>, <5.018393, 1.000000, -0.301401>, <6.080991, 1.000000, -0.051010>, <7.143589, 1.000000, 0.387175>, 
      <4.036786, 2.000000, -0.978388>, <5.036786, 2.000000, -0.853193>, <6.099384, 2.000000, -0.602802>, <7.161982, 2.000000, -0.164617>, 
      <4.036786, 3.000000, -1.603753>, <5.036786, 3.000000, -1.478557>, <6.099384, 3.000000, -1.228166>, <7.161982, 3.000000, -0.789981>, 
      <4.073572, 4.000000, -2.173938>, <5.073572, 4.000000, -2.048742>, <6.136170, 4.000000, -1.798351>, <7.198768, 4.000000, -1.360166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.073572, 4.000000, -2.173938>, <5.073572, 4.000000, -2.048742>, <6.136170, 4.000000, -1.798351>, <7.198768, 4.000000, -1.360166>, 
      <4.110358, 5.000000, -2.744123>, <5.110358, 5.000000, -2.618927>, <6.172956, 5.000000, -2.368536>, <7.235554, 5.000000, -1.930351>, 
      <4.073572, 6.062598, -3.571504>, <5.073572, 6.062598, -3.446308>, <6.136170, 6.062598, -3.195917>, <7.198768, 6.062598, -2.757733>, 
      <4.000000, 7.062598, -4.439778>, <5.000000, 7.062598, -4.314582>, <6.062598, 7.062598, -4.064191>, <7.125196, 7.062598, -3.626007>
    }
  }
  material {
    SnowTex
  }
  scale 5.0
  translate  <0.169311, 0.0, 3.453941>
}


union { // SnowBlobs
  sphere { // Sphere010
    <0,0,0>,1
    hollow
    translate  <-3.41658, 1.582142, 1.047125>
  }
  sphere { // Sphere011
    <0,0,0>,1
    hollow
    translate  <-2.433539, -0.130777, 0.288799>
  }
  sphere { // Sphere009
    <0,0,0>,1
    hollow
    translate  <-0.750877, -0.196165, -0.231039>
  }
  sphere { // Sphere008
    <0,0,0>,1
    hollow
    translate  <-1.415661, -0.326942, 0.693117>
  }
  sphere { // Sphere007
    <0,0,0>,1
    hollow
    translate  <-5.423783, 4.230134, 1.872345>
  }
  sphere { // Sphere006
    <0,0,0>,1
    hollow
    translate  <-1.042946, 1.373158, 1.617273>
  }
  sphere { // Sphere005
    <0,0,0>,1
    hollow
    translate  <-2.515483, 2.70686, 2.722158>
  }
  sphere { // Sphere004
    <0,0,0>,1
    hollow
    translate  <-2.32546, 1.569206, 1.386234>
  }
  sphere { // Sphere002
    <0,0,0>,1
    hollow
    translate  <-0.861976, 0.605865, 0.861976>
  }
  sphere { // Sphere012
    <0,0,0>,1
    hollow
    translate  <-4.294221, 2.811352, 3.026418>
  }
  sphere { // Sphere013
    <0,0,0>,1
    hollow
  }
  material {
    SnowPuff
  }
  scale 3.0
  translate  <123.435909, 463.910849, -113.502661>
}


box { // SeaWater
  <-1, -1, -1>, <1, 1, 1>
  material {
    Cloud_Water
  }
  scale <2275.013916, 547.722229, 1.0>
  translate  <-45.875763, 1617.026359, -271.018392>
}


