// Persistence of Vision Ray Tracer Scene Description File
// File: penguin_polonaise.pov
// Vers: 3.1
// Desc: Penguin polonaise
// Date: 20/12/2000
// Auth: Brigitte Van Gerven
//

#version 3.1

#include "colors.inc" 
#include "glass.inc"    
                                       
// bek van de penguin 
#declare bek=union{
smooth_triangle
{
  <  0,  0, 0> <-1,  1,0>  // <Vertex1>  <SurfaceNormal1>
  < 1.5, 0, 0> <0, 1,0>     // <Vertex2>  <SurfaceNormal2>
  <  2,   -0.5, -0.5> <0,0,-1>  // <Vertex3>  <SurfaceNormal3> 
}    
smooth_triangle
{
  <  0,  0, 0> <-1,1,0>  // <Vertex1>  <SurfaceNormal1>
  < 1.5, 0, 0> <0, 1,0>     // <Vertex2>  <SurfaceNormal2>
  <  2,   -0.5, 0.5> <0,0,1>  // <Vertex3>  <SurfaceNormal3> 
}  
smooth_triangle
{
  <  0,  0, 0> <0,-1,0>  // <Vertex1>  <SurfaceNormal1>
  < 2, -0.5, 0.5> <-1, -1,0>     // <Vertex2>  <SurfaceNormal2>
  <  2,   -0.5, -0.5> <-1,-1,0>  // <Vertex3>  <SurfaceNormal3> 
}     
scale<0.6,0.6,0.6>  
     pigment { color<0.2,0.1,0.05> } 
    finish{ ambient 0.2
    phong 2    
    phong_size 20}
}   

#declare text_peng = texture{
     pigment { Black } 
        finish{ 
        phong 2
        phong_size 20 
       // metallic on
        }   
        normal { 
                bump_map
                        { 
                        gif "feat1.gif" 
                        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                        // [use_color | use_index]
                        // [once]
                        bump_size 0.5 // 0...3   
                } // bump_map 
                }  
    scale<0.5,0.5,0.5>            
}   

#declare peng_body = union{
      difference{
        blob
        {
        // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
        threshold 0.6
        sphere { < 0.0,   0,    0>, 0.5, 3 scale<1.5,1,1> rotate<0,0,-30> translate<-0.2,0.8,0>}
        sphere { < 0.0,   0,    0>, 1, 3 scale<0.9,2,1> rotate<0,0,0> translate<0,-1,0>}      
        
        // texture modifiers voor lichaam
        //texture{ pigment {color rgb <0.1,0.1,0.1>}   
        //finish{ambient 0.2 diffuse 0.3} } 
        //normal { wrinkles 0.5 scale 0.5 }   
        
         texture{text_peng}
        }  
        
        sphere
        {
        <-0.3, 0.9, -0.3> 
        0.1      
        }   
        sphere
        {
        <-0.3, 0.9, 0.3> 
        0.1      
        }  
        }  
        
        blob
        {  
        threshold 0.4
        sphere { < 0.0,   0,    0>, 0.4, 3 scale<1,1,1.1> rotate<0,0,0> translate<-0.2,0.6,0>}
        sphere { < 0.0,   0,    0>, 0.9, 3 scale<0.9,2,1> rotate<0,0,0> translate<-0.15,-1,0>}
        texture{ pigment {color rgb <1,1,1>}   
        finish{ambient 0.4 diffuse 0.3} } 
        normal { wrinkles 0.5 scale 0.5 }  
        }

}    

#declare peng_eyes=union{ 
        difference
        {    
        sphere
        {
        <-0.3, 0.9, -0.3> 
        0.1      
        texture{T_Yellow_Glass finish{ambient 1}} interior{I_Glass}
        }  
        cylinder
        {
        0*z,  3*z,  0.05  
        translate<-0.3,0.9,-1.5>
        // open
        }      
        }    
        
        difference
        {    
        sphere
        {
        <-0.3, 0.9, 0.3> 
        0.1      
        texture{T_Yellow_Glass finish{ambient 1}} interior{I_Glass}
        }  
        cylinder
        {
        0*z,  3*z,  0.05  
        translate<-0.3,0.9,0>
        // open
        }
        }
}  

#declare peng_wings=  
sphere{<0,0,0>,1 
         
        clipped_by { cylinder
                {
                0*x,  3*x,  0.5  translate<-1,1,0> 
                } 
        }
        scale<2,2,1>   
        translate<0,-1.5,0>
        rotate<60,90,0>
        translate<0,-0.7,0> 
        
        texture{text_peng}
}  

#declare peng_wings2=  
        sphere{<0,0,0>,1    
                clipped_by{  
                torus
                {
                1.2,
                0.5   
                rotate<0,0,30>
                translate<0.4,0.8,0> 
                }
                }   

        scale<1.6,0.7,1>   
        //translate<0,-1.5,0>
        rotate<0,180,-30>
        translate<-0.8,0,0> 
        
        texture{text_peng}
}    

#declare peng_foot=union{
        union{
                cylinder
                {
                  0*x,  1*x,  0.2
                  open
                  translate<0,0,0.2> 
                  
                }  
                
                cylinder
                {
                  0*x,  1*x,  0.2 
                  open
                  translate<0,0,-0.2>
                } 
             }  
        clipped_by
        {
        plane
        {
        y, 
        -0 
        hollow on   
        }   
        plane
        {
        x, 
        0.5
        hollow on 
        rotate<0,60,0>
        }      
        plane
        {
        x, 
        0.5
        hollow on 
        rotate<0,-60,0>
        }       
        plane
        {
        -x, 
        -0.15
        hollow on 
        rotate<0,0,60>
        }  
        } 
 rotate<0,0,60,>        
 translate<0,-2.2,0>       

 pigment { color<0.2,0.1,0.05> } 
    finish{ ambient 0.2
    phong 2    
    phong_size 20}
}   


 
#declare penguin= union{ 
//      1. lichaam 
        object{peng_body}
        
//      2. bek
        object{bek translate<-1.5,1.1,0>}

//      3. ogen   
        object{peng_eyes}

//      4. vleugels
        object{peng_wings} 
                
}       

#declare penguin2 = union{
//      1. lichaam 
        object{peng_body}
        
//      2. bek
        object{bek translate<-1.5,1.1,0>}

//      3. ogen   
        object{peng_eyes}

//      4. vleugels
        object{peng_wings2}

}

     
 
 
 


    
              



   

 







       

        


 


            


