#include "laterne4.inc"
#include "snowman.inc"


#declare camera_position=<0.5 , 1.7 ,-1>;


#declare wdt=0.9;

#declare c1=
camera
{
  location  camera_position
  right x*3*wdt
  up y*1.5*wdt
  look_at   <0.6 , 2, 1>
  
}           


#declare c2=
camera
{
  orthographic
  location  <0 , 100 ,20>
  right x*3*40
  up y*1.2*40
  look_at   <0 , 0, 20>
  
} 


//#declare c3=
camera
{
  cylinder 1
  location  <0.5 , 1.7 ,-1>
  right x*1.5*wdt
  up y*1.5*wdt
  look_at   <0.6 , 2.25, 1>
  rotate y*0
} 





#declare snowtex=texture{
        pigment {
                color rgbt <2.7,2.7,2.7,0.0>
                }
        
        finish {
  	        //ior 1.3
  	        //refraction 0.3
  	        ambient 0.0 
  	        reflection 0.1
  	        phong 1
  	        phong_size 80
  	        }
  	       
        }
        
	       
	



//#declare l1=
light_source
{
  <-200, 10, 0>
  color red 1.0  green 0.9  blue 0.8
  fade_distance 200
  fade_power 2
 
}

//#declare l2=
light_source
{
  <200, 100, -200>
  color red 0.1  green 0.1  blue 0.2
  shadowless 
}       


//#declare l3=
light_source
{
  <0, 50, -200>
  color red 0.1  green 0.1  blue 0.1 
} 


#declare skytex=
pigment{gradient x
                color_map{ 
                [0.0 color rgbt <0.1,0.1,0.3,1>]
                [0.7 color rgbt <0.8,0.55,0.5,0.2>]
                [0.95 color rgb <1.2,1.1,0.9>]
                [1   color rgb <1,1,1>]
                }     
                scale x*2
                translate x
        }
                
#declare clouds=
pigment{leopard turbulence 2
                color_map{ 
                [0.0 color rgbt <1,1,1,0.8>]
                [0.2   color rgbt <1,1,1,1>]
                }
                scale <0.3,0.05,0.3>  
        }

#declare stars=
pigment{bozo 
                color_map{ 
                [0.9999 color rgb <0.1,0.1,0.3>]
                [1.0   color rgb <0.9,0.9,1>]
                }
                scale 0.002  
        }
           
           

#declare myfog=
fog
{
  fog_type   2
  distance   10
  color      rgb <0.9,0.9,0.9> 
  fog_offset 0.1
  fog_alt    0.3
  turbulence 10
  scale 1000
}



#declare myplane=
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  pigment {
        bozo turbulence 0.3 color_map{
                [0.40 color rgb<1,1,1>]
                [0.50 color rgb<0.8,0.8,0.8>]
                [0.60 color rgb<1,1,1>]
                }
                scale 1.5
        }
        
  finish {
        ambient 0.3 
        reflection 0.2
        }
}




#declare abst=1.7;


//Fensterebene1
#declare fenster=union{
	cylinder {<0,0.00,-abst*1.3> <0,0.00,abst*1.3> 0.4 translate y*1.6}
	box {<-0.4,0.8,-abst*1.3> <0.4,1.6,abst*1.3>}
	//pigment {rgb 1}
}
#declare fensterring=union{
	object {fenster rotate y*000}
	object {fenster rotate y*120}
	object {fenster rotate y*240}
	cylinder {<0,0.1,0> <0,2.9,0> abst*0.7 pigment {color rgb 1} finish {ambient 0.0}}
	
	}


#declare f_details=union{
	box {<-0.45,0.7,abst*1.1> <0.45,0.8,abst*1>}
	box {<-0.45,0.7,abst*0.9> <0.45,2,abst*0.89> 
		pigment {color rgbt <1,0.9,0.8,0.5>} 
		normal {bumps scale 0.01} 
		finish {ambient 0.3 reflection 0.3}
		}
        }
	
#declare f_detailsring=union{
	object {f_details rotate y*000}
	object {f_details rotate y*060}
	object {f_details rotate y*120}
	object {f_details rotate y*180}
	object {f_details rotate y*240}
	object {f_details rotate y*300}
}
	
	
	
	
//Sulenebene1

#declare cutring=cylinder{<0,0,0> <0,3,0> abst*1.3}

#declare sle=union{
	cylinder{<0,0,0> <0,3,0> 0.15}
	sphere{<0,0,0> 0.3  translate y* 2.8}
	sphere{<0,0.3,0> 0.3}
	sphere{<0,-0.3,0> 0.3 scale <1,1.3,0.5>}
	}
	
#declare platte=union{
	cylinder {<0,-0.15,0> <0,0.15,0> abst*1.2}
	torus {abst*1.2,0.15}
	}


#declare slen=union{
	object {sle translate x* abst rotate y*000}
	object {sle translate x* abst rotate y*030}
	object {sle translate x* abst rotate y*060}
	object {sle translate x* abst rotate y*090}
	object {sle translate x* abst rotate y*120}
	object {sle translate x* abst rotate y*150}
	object {sle translate x* abst rotate y*180}
	object {sle translate x* abst rotate y*210}
	object {sle translate x* abst rotate y*240}
	object {sle translate x* abst rotate y*270}
	object {sle translate x* abst rotate y*300}
	object {sle translate x* abst rotate y*330}
	
	object {platte}
	object {platte translate y*2.9}
	cylinder {<0,0,0> <0,3,0> 1.1 }
    //pigment {rgb 1}
	}

//no plate
#declare slen3=union{
	object {sle translate x* abst rotate y*000}
	object {sle translate x* abst rotate y*030}
	object {sle translate x* abst rotate y*060}
	object {sle translate x* abst rotate y*090}
	object {sle translate x* abst rotate y*120}
	object {sle translate x* abst rotate y*150}
	object {sle translate x* abst rotate y*180}
	object {sle translate x* abst rotate y*210}
	object {sle translate x* abst rotate y*240}
	object {sle translate x* abst rotate y*270}
	object {sle translate x* abst rotate y*300}
	object {sle translate x* abst rotate y*330}
	
	object {platte}
	cylinder {<0,0,0> <0,3,0> 1.1 }
    //pigment {rgb 1}
	}
	

//melting
#declare slenhf=
height_field
{
  tga "spitze4.tga"
  water_level 0.05
  smooth
  texture
  {
    pigment
    {
gradient y 
turbulence 0
color_map
{
  [  0  color rgb 2.5]
}
    }
  }

  translate <-0.5,-0.01,-0.5>
  scale <4,3,4>            
  rotate x*0
  texture {snowtex normal {bumps 0.3 scale <0.2,1,0.2>}}
 
}


	
#declare dach=union{
        difference{
                cylinder{<0,0,0> <0,abst*1.0,0> abst*1.3}
                torus {abst*1.3,abst*1.25 translate y*abst*1}
                scale <2.5,5,2.5>
                translate y*-0.0
                }
        sphere {<0,abst*2.5,0> 0.8}
        sphere {<0,abst*5,0> 0.3}         
        object {platte scale <1.1,1,1.1> translate y*0.15}
        }
        

#declare dach3=union{
        difference{
                cylinder{<0,0,0> <0,abst*0.5,0> abst*1.3}
                torus {abst*1.3,abst*1.25 translate y*abst*1}
                scale <2.5,5,2.5>
                translate y*-0.0
                }
        sphere {<0,abst*2.5,0> 0.6}         
        object {platte scale <1.1,1,1.1> translate y*0.15}
        }        

#declare z1= union{
        //cylinder{<abst*1.6,0,0> <abst*1.1,1.5,0> 0.07}
        sphere {<0,2.25,0> 0.35 scale x*0.5 translate x*(abst*1.1) rotate y*15}
        cylinder{<abst*1.1,1.5,0> <abst*1.1,3,0> 0.07}
        }
        
#declare dach2=union{
        torus {abst,0.1}
        object {platte translate y*1.5}
        cone {<0,0,0> abst*1.6 <0,1.5,0> abst*1.1}
        object {z1 rotate y*000}  
        object {z1 rotate y*030}
        object {z1 rotate y*060}
        object {z1 rotate y*090}
        object {z1 rotate y*120}  
        object {z1 rotate y*150}  
        object {z1 rotate y*180}
        object {z1 rotate y*210}
        object {z1 rotate y*240}  
        object {z1 rotate y*270}
        object {z1 rotate y*300}
        object {z1 rotate y*330}  
      
        object {platte scale <1.2,1,1.2> translate y*0.15}
        }       
        
#declare g_plate=union{
        box{<-4,-0.15,0> <5.5,0.15,1.5>}
        cylinder{<-4,0,1.5> <5.5,0,1.5> 0.15}
        
        }
        
#declare galerie=union{
        object {g_plate translate y*0}
        object {g_plate translate y*2.9}
        union{
                object {sle rotate y*90 translate <2.5,0,0.7>}
                object {sle rotate y*90 translate <1.5,0,0.7>}
                object {sle rotate y*90 translate <0.5,0,0.7>}
                object {sle rotate y*90 translate <-0.5,0,0.7>}
                object {sle rotate y*90 translate <-1.5,0,0.7>}
                scale <1.3,1,1.3>
                }
        
        }


        //Torbogen
        
        #declare block=box{<-0.3,-0.5,0> <0.3,0.5,-4>}
        #declare blocks=union{
                object {block translate y*0.6}
                object {block translate y*1.8}	                
                object {block translate y*3.0}
                object {block translate y*4.2}
                }
        #declare blockbow=union{
                object {block translate x*2.7 rotate z*9}
                object {block translate x*2.7 rotate z*36}
                object {block translate x*2.7 rotate z*63}
                object {block translate x*2.7 rotate z*90}
                object {block translate x*2.7 rotate z*117}
                object {block translate x*2.7 rotate z*144}
                object {block translate x*2.7 rotate z*171}
                }                
        #declare blockfund= difference{
                        union{
                                cylinder{<0,5,-0.03> <0,5,-3.97> 2.97}
                                box{<-2.97,0,-0.03><2.97,5,-3.97>}
                                } 

                        cylinder{<0,5,1> <0,5,-5> 2.43}
                        box{<-2.43,0,1><2.43,5,-5>}
                        }
                
        
        #declare bow=
        union{
	        object {sle scale y*1.67 translate x*-2.4}
	        object {sle scale y*1.67 translate x*-3.0}
	        object {sle scale y*1.67 translate x*2.4}
	        object {sle scale y*1.67 translate x*3.0}
	        difference{
	                union{
	                        torus {2.4,0.15}
	                        torus {3,0.15}
	                        rotate x*90 translate y*5
	                        }
	                box{<-4,0,-5> <4,5,2>}   //need upper half of torus
	                }
        }
                   	


// Positionen

#declare T1pos= <0.181,0,0.873>;
#declare T2pos= <0.752,0,0.869 >;
#declare T3pos= <0.490,0,0.448 >;
#declare T4pos= <0.908,0,0.490 >;
#declare T3apos= <0.337,0,0.479>;
#declare T3bpos= <0.618,0,0.554>;

#declare M1pos= <0.466,0,0.872>;
#declare M2pos= <0.838,0,0.682>;

//---------------------------------------------	
//                                 castle links
//---------------------------------------------	
#declare uh=<25,15,25>;

//Relief-Stck
#declare Rel1=intersection{
        height_field{
  		tga "hf2.tga"
  		water_level 0.01
  		smooth
  		
	        }
        union{
	        object {cutring scale <1.3,1,1.3> translate y*3}
	        scale 1/uh translate T1pos
	        }
        texture{snowtex
        normal{
                bump_map{ // uses image color or index as bumpiness
                        tga "rel1.tga" // the file to read (iff/gif/tga/png/sys)
                        map_type 2 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                        // [use_color | use_index]
                        once
                        bump_size 10 // 0...3
                        } // bump_map
                        rotate y*100
                        scale <-1,2,1>
                        
                        translate y*3
                        scale 1/uh translate T1pos
        
                }
        }
        

  	}


#declare w2=
union{
difference{
	height_field
	{
  		tga "hf2.tga"
  		water_level 0.01
  		smooth
  		
	}
	
	//Relief
	union{
	        object {cutring scale <1.3,1,1.3> translate y*3}
	        scale 1/uh translate T1pos
	        }
	
	//Tor-Loch links
	//cylinder{<0.466,0,0.872-0.04> <0.466,0,0.872+0.04> 0.1 scale y*3}         
        union{
	        cylinder{<0,5,-2> <0,5,2> 2.5}
	        box{<-2.5,0,-2> <2.5,5,2>}
	        translate y*-3
	        scale 1/uh 
	        translate M1pos
                }


	//Lcher Turm 2 (vorn)	
	union{
	        object {cutring translate y*12}
	        object {cutring translate y*9}
	        scale 1/uh translate T2pos
	        }
	        
	//Lcher Turm 3 (hinten links)	
	union{
	        object {fensterring rotate y*10 translate y*12}
	        object {cutring translate y*9}
	        scale <1.3,1,1.3>
	        scale 1/uh translate T3pos
	        }


	}  
//torus {0.1,0.005 rotate x*90 scale y*3 translate<0.466,0,0.872-0.03>}
//torus {0.1,0.005 rotate x*90 scale y*3 translate<0.466,0,0.872+0.03>}


//Torbogen
        union{	                
                
                object{blockfund}
                object {blocks translate x*2.7}
                object {blocks translate x*-2.7}
                object {blockbow translate y*5}
	        object {bow}
	        object {bow translate z*-4}
                
                translate z*0.7
	        translate y*-3
	        scale 1/uh	            
	        translate M1pos
                }

//Zinnen
union{   
        union{
                sphere {<-1,0,0> 0.2}
                sphere {<-2,0,0> 0.2}
                sphere {<-3,0,0> 0.2}
                sphere {<-4,0,0> 0.2}
                sphere {<-5,0,0> 0.2}
                sphere {<0,0,0> 0.2}
                sphere {<1,0,0> 0.2}
                sphere {<2,0,0> 0.2}
                sphere {<3,0,0> 0.2}
                sphere {<4,0,0> 0.2}
                sphere {<5,0,0> 0.2}
                scale <1,2,1>
                translate <0,6.5,0.2>
        }
        cylinder {<-5,6.0,0.32> <5,6.0,0.32> 0.1}
        cylinder {<-5,5.1,0.40> <5,5.1,0.40> 0.1}        
        scale 1/uh translate M1pos
        }
        

//Relief Turm 1
        object {Rel1}

//Turm 1 (vorn)
        union{  
                //laterne
                object {model scale 0.7 translate z*-1.85 rotate y*170 translate y*7}
                /*
                union{
                        object {platte scale y*1}
                        object {sle rotate x*-10 translate z*abst rotate y*-000}
                        object {sle rotate x*-10 translate z*abst rotate y*-030}
                        object {sle rotate x*-10 translate z*abst rotate y*-060}
                        object {sle rotate x*-10 translate z*abst rotate y*-090}                        

                        scale <0.9,1,0.9>
                        translate <0.2,8.5,0.4>
                      
                        }
                */
                object {slenhf scale <0.9,1.5,0.9> rotate y*10 translate <0.1,8.4,0.3>}
                object {platte scale <0.80,1,0.80> translate <0.1,8.5,0.3>}
                     
                scale 1/uh translate T1pos
        }

//Turm 2 (hinten rechts)
        union{
                object {dach translate y*15}
                object {slen translate y*12}
                object {slen translate y*9}
                scale 1/uh translate T2pos
        }

//Turm 3 (hinten links)
        union{
                object {dach scale <0.9,1,0.9> translate y*15}
                object {f_detailsring rotate y*10 translate y*12}
                object {slen translate y*9}
                scale <1.3,1,1.3>
                scale 1/uh translate T3pos
        }
        

  texture {snowtex}	
  
  translate <-0.5,-0.01,-0.5>
  scale uh
  rotate y*-30
}


//---------------------------------------------	
//                                 castle mitte
//---------------------------------------------
#declare uh=<25,30,25>;

#declare w1=

union{
difference{
	height_field
	{
  		tga "hf2.tga"
  		water_level 0.01
  		smooth
  		
	}
	
	//Tor-Loch rechts          
        union{
	        cylinder{<0,5,-2> <0,5,2> 2.5}
	        box{<-2.5,0,-2> <2.5,5,2>}
	        scale 1/uh 
	        rotate y*65
	        translate M2pos
                }

	//Lcher Turm 1 (rechts hinten)	
	union{                                                                   
		object {cutring scale <1.4,1,1.4> translate y*27}
	        object {cutring scale <1.4,1,1.4> translate y*21}
	        object {fensterring rotate y*30 scale <1.1,1,1.1> translate y*15}
	        scale 1/uh translate T1pos
	        }

	//Lcher Turm 2 (vorn)	
	union{   
	        object {fensterring translate y*21}
	        object {cutring scale <1.4,1,1.4> translate y*18}
	        object {fensterring translate y*15}	        
	        object {fensterring translate y*9}
	        scale 1/uh translate T2pos
	        }
	        
        //Lcher Turm 3 (mitte hinten)	
	union{   
	        object {cutring scale <1.4,1,1.4> translate y*27}
	        object {fensterring scale <1.4,1,1.4> translate y*24}
	        object {cutring scale <1.4,1,1.4> translate y*21}
	        object {fensterring scale <1.4,1,1.4> translate y*18}
	        object {fensterring scale <1.4,1,1.4> rotate y*20 translate y*3}
	        object {fensterring scale <1.4,1,1.4> rotate y*20 translate y*0}
	        scale 1/uh translate T3pos
	        }	        
	//Lcher Turm 3a
	union{   
	        object {fensterring scale <0.7,1,0.7> rotate y*20 translate y*0}
	        object {fensterring scale <0.7,1,0.7> rotate y*20 translate y*3}
	        scale 1/uh translate T3apos
	        }
	        
	//Lcher Turm 3b
	union{   
	        object {fensterring scale <0.7,1,0.7> rotate y*20 translate y*0}
	        object {fensterring scale <0.7,1,0.7> rotate y*20 translate y*3}
	        scale 1/uh translate T3bpos
	        }
	        
	//Lcher Turm 4 (hinten)	
	union{ 
	        object {cutring scale <1.4,1,1.4> translate y*27}
	        object {cutring scale <1.4,1,1.4> translate y*21}
	        object {fensterring translate y*18}
	        object {fensterring translate y*15}
	        object {fensterring translate y*9}
	        scale <1.3,1,1.3>
	        scale 1/uh translate T4pos
	        }	       


	}    
	
	//Details
        
     
        //Torbogen
        union{	                
                
                object{blockfund}
                object {blocks translate x*2.7}
                object {blocks translate x*-2.7}
                object {blockbow translate y*5}
	        object {bow}
	        object {bow translate z*-4}

                object{mylaterne scale 0.7 rotate y*30 translate <0,7.7,-2>}
                sphere{ <0,7.4,-2> 0.3 pigment {color rgb 1}}
                translate z*1.6
	        
	        scale 1/uh	        
	        rotate y*65     
	        translate M2pos
                }
                
                
        //Galerie
        union{
                object {galerie translate <0,9,0.9>}
	        scale 1/uh
	        rotate y*65
	        translate M2pos
	        }                


        //Turm 1 (rechts hinten)
        union{  
                object {dach translate y*30}
                object {slen translate y*27}
                object {platte translate y*27}
                object {dach2 translate y*24}  
                object {slen scale <1.3,1,1.3> translate y*21}
                object {platte translate y*18}
                object {platte translate y*15}
                object {f_detailsring rotate y*30 scale <1.1,1,1.1> translate y*15}
                object {dach2 translate y*12}
                object {slen rotate y*-10 translate y*9 scale <1.3,1,1.3>}
                scale 1/uh translate T1pos
                
        }
        
        //Turm 2 (vorn)
        union{
                object {platte translate y*24}
                object {f_detailsring scale <1.1,1,1.1> translate y*21}
                object {slen translate y*18}  
                object {platte translate y*15}
                object {f_detailsring scale <1.1,1,1.1> translate y*15}
                object {dach2 translate y*12}
                object {slen rotate y*-10 translate y*9 scale <1.3,1,1.3>}
                scale 1/uh translate T2pos
                
        }
       //Turm 4 (hinten)
        union{  
                object {dach translate y*30}
                object {slen translate y*27}
                object {dach2 translate y*24}
                object {slen scale <1.3,1,1.3> translate y*21}
                object {f_detailsring scale <1.1,1,1.1> translate y*18}
                object {platte translate y*18}
                object {f_detailsring scale <1.1,1,1.1> translate y*15}
                object {platte translate y*15}
                object {dach2 translate y*12}
                object {slen rotate y*10 translate y*9 scale <1.3,1,1.3>}
                scale 1/uh translate T4pos
                
        }
        
        //Turm 3b (mitte vorn)
        union{  
                object {dach scale <0.5,0.7,0.5> translate y*20}
                object {slen scale <0.5,1,0.5> translate y*17}
                object {platte scale 0.5 translate y*18.5}
                object {slen scale <0.7,1,0.7> rotate y*20 translate y*6}
                object {platte scale <0.7,1,0.7> translate y*3}                
                object {f_detailsring scale <0.6,1,0.6> rotate y*20 translate y*3}
                object {f_detailsring scale <0.6,1,0.6> rotate y*20 translate y*0}                
                scale 1/uh translate T3bpos    
        }
        
        //Turm 3a (mitte ganz hinten)
        union{  
                object {slen scale <0.7,1,0.7> translate y*6}
                object {platte scale <0.7,1,0.7> translate y*3}
                object {f_detailsring scale <0.6,1,0.6> rotate y*20 translate y*3}
                object {f_detailsring scale <0.6,1,0.6> rotate y*20 translate y*0} 
                scale 1/uh translate T3apos    
        }
        
        //Turm 3 (mitte hinten)
        union{  
                
                object {dach scale <1.3,1.3,1.3> translate y*30}
                object {slen scale <1.3,1,1.3> translate y*27}
                object {f_detailsring scale <1.4,1,1.4> translate y*24}
                object {slen scale <1.3,1,1.3> translate y*21}
                object {f_detailsring scale <1.4,1,1.4> translate y*18}
                object {slen scale <1.5,1,1.5> translate y*6}
                object {f_detailsring scale <1.5,1,1.5> rotate y*20 translate y*3}
                object {f_detailsring scale <1.5,1,1.5> rotate y*20 translate y*0}                 
                object {platte scale <1.5,1,1.5> translate y*3}
               
                scale 1/uh translate T3pos    
        }        
        
  
  texture {snowtex}
  
  translate <-0.5,-0.01,-0.5>
  scale uh
  rotate y*-30
}    



//---------------------------------------------	
//                                castle rechts
//---------------------------------------------	
#declare uh=<25,10,25>;

#declare w3=
union{
difference{
	height_field
	{
  		tga "hf2.tga"
  		water_level 0.01
  		smooth
	}
	

	        
	//Lcher Turm 3	
	union{
	        object {cutring translate y*9}
	        scale <1.3,1,1.3>
	        scale 1/uh translate T3pos
	        }


	}  




//Turm 3
        union{
                //object {dach scale <0.9,1,0.9> translate y*12}
                object {platte translate y*9}
                scale <1.3,1,1.3>
                scale 1/uh translate T3pos
        }
        

  
  texture {snowtex}
  
  translate <-0.5,-0.01,-0.5>
  scale uh
  rotate y*-30
}

#declare w3b=




//Trmmer hinten
height_field
	{
  		tga "hf2.tga"
  		water_level 0.01
  		smooth
  
  texture {snowtex}
  
  translate <-0.5,-0.01,-0.5>
  scale uh
  rotate y*-30
}


//Trmmer vorn
#declare w4=
union{

	height_field
	{
  		tga "hf4.tga"
  		water_level 0.01
  		smooth
	}
	 
  texture {snowtex normal {bumps scale <0.01,0.3,0.01>}}
  
  translate <-0.5,-0.01,-0.5>
  scale 10
}



#declare mystars= 
sphere{0,1 pigment {stars} finish {ambient 0.7} hollow scale 10004} //0.5

#declare mysky=
sphere{0,1 pigment {skytex} finish {ambient 0.8} hollow rotate z*5 rotate y*20 scale 10002} //0.6
           
#declare myclouds= 
sphere{0,1 pigment {clouds} finish {ambient 1} hollow scale 10000}           
           
           
           
           
#declare myheaven =
        union{                  
                object{mystars}
                object{myclouds}
                object{mysky}
        }
        




#declare castle=
union{
object {w2 scale x*-1 rotate y*85 translate <-6,0,20>}

object {w1 rotate y*-180 translate <17,0,27> scale y*1}

object {w3 rotate y*-220 translate <22,0,15>}

//backgrounds
object {w1 rotate y*-80 translate <60,10,40>}
object {w1 rotate y*-50 translate <50,15,70>}
object {w1 rotate y*-100 translate <5,15,70>}
object {w3b scale <1,1.5,1> rotate y*-20 translate <-32,2,40> texture {snowtex normal {bumps 0.3 scale <0.2,1,0.2>}}}

//behind camera
object {w1 rotate y*45 translate <10,0,-20>}

}       





//snowmen

#declare snowmen=union{



// left behind
object {snowman(80,70,60,70,10,0,-30,70,-50) rotate y*-10 rotate z*-0 translate <4,0,12>}
object {snowman(20,40,-25,40,0,0,-30,40,-20) rotate y*-40 rotate z*-0 translate <2.7,0,14>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate y*-60 rotate z*-0 translate <2.5,0,17>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate y*-20 rotate z*5 translate <4,0,16>}
object {snowman(-20,60,-40,-30,10,0,-30,70,-50) rotate x*-15 rotate y*-15 rotate z*-0 translate <2.5,0,9>}


// middle very behind
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-00 rotate y*80 translate <16.5,0,22>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-00 rotate y*60 translate <16.0,0,20>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-05 rotate y*40 translate <13.2,0,20>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-05 rotate y*20 translate <13.5,0,19>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-15 rotate y*05  translate <10.5,0,19>}
object {snowman(20,40,-40,40,0,0,-30,70,-50) rotate z*-05 rotate y*10  translate <10.5,0,16.5>} //holding kid
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-05 rotate y*10  translate <12,0,15>}


//kid
object {snowman(20,40,-10,40,0,0,-30,70,-50) scale 0.7 rotate z*-15 rotate y*20  translate <9.2,0,17>}


//middle behind
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-00 rotate y*-20  translate <11.5,0,14>} 
object {snowman(-40,40,60,40,20,15,-30,70,-150) rotate x*-15 rotate z*-00 rotate y*-20  translate <9,0,13>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*-00 rotate y*-10  translate <10,0,11>}    


// right
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*5 rotate y*-10  translate <7,0,8>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*5 rotate y*-10  translate <8.3,0,8>}
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate z*5 rotate y*-15  translate <9,0,7.0>}         
object {snowman(20,40,-10,40,0,30,-30,70,-50) rotate z*5 rotate y*-30  translate <12,0,7.5>}




//the front

// left front
object {snowman(80,70,60,70,10,0,-30,70,-50) rotate y*80 rotate z*-5 translate <-0.5,0,4.0>}


// right front
object {snowman2 rotate y*-10 rotate z*-10 translate <4.5,0,3.7>} //lightened
object {snowman(20,40,-25,40,0,70,-30,40,-20) rotate y*-20 rotate z*-10 translate <6,0,4>} //partner
object {snowman(20,40,-10,40,0,0,-30,70,-50) rotate y*-10 rotate z*-10 translate <4.5,0,1.6>} //very right

// two looking
object {snowman(-40,40,50,80,20,0,-30,70,-50) rotate x*20 rotate y*60  translate <6,0,12>} 
object {snowman(20,40,-40,40,20,0,-30,50,-180) rotate x*20 rotate y*30  translate <6,0,14>}

}


#declare spitze=union{
object {slen translate <0,0,0 >}
object {dach translate <0,0.14,0 >}

        
}


#declare spitze2=union{
object {spitze no_shadow scale <25,15,25> rotate x*110 rotate y*-45 translate <0,1,1.5>
pigment {gradient y
        color_map{
                [0 color rgb 0]
                [1 color rgb 1]
                }
                scale y*3
                
        }  
        finish {ambient 1}
}
 
 scale 7
}


#declare spitzehf=
height_field
{
  tga "spitze2.tga"
  water_level 0.01
  smooth
  texture
  {
    pigment
    {
gradient y 
turbulence 0
color_map
{
  [  0  color rgb 2.5]
}
    }
  }
  

  translate <-0.5,-0.01,-0.5>
  scale <6,2,6>            
  rotate x*0
  rotate y*-45
  texture {snowtex normal {bumps 0.3 scale <0.2,1,0.2>}}
  
  translate <-4.8,-0.0,5>
 
}       










#declare water1=
height_field
{
  tga "water1.tga"
  water_level 0.3
  smooth
 
  translate <-0.5,-0.3,-0.5>
  scale <6,0.1,6>            

  rotate y*15
    
  
  pigment
    { color rgbt<0,0,0.3,0.6>}
      
  normal {bumps 0.3 turbulence 0.2 scale 0.2 rotate y*90}

  finish {
  	ambient 0
  	//diffuse 0.8 
  	reflection 0.65
  	phong 1 phong_size 2
  	}
}


//THE SCENERY

myplane


// melting water
merge{
object {water1 rotate y*160 scale <2.5,1,2.5> translate <-1,0,10.5>}
object {water1 translate <-1.3,0,4>}
object {water1 translate <-9,0,9.5>}
}

//Ruins left
object{w4 scale <0.7,0.85,0.7> rotate y*45 translate <-13.0,1,13> }
object{w4 scale <1,1.2,1> rotate y*-35 translate <-3.5,0,10> }
object{spitzehf}
//object {piece rotate z*30 translate <-8,5,15>}

//Atmo
myheaven
fog {myfog}


object{castle scale y*1}

snowmen


