#version 3.5;

#declare PHOT      = 0;  // photons 0=out; 1=save photons; 2=load photons
#declare Save_Rad  = 2;  // 1=save rad; 2=load rad data; 0=no rad storing
#declare RAD       = 1;  // radiosity quality settings 0=out; 1=acceptable; 5=good
                
global_settings {
        #declare a_g = 1.3;
        assumed_gamma a_g
        max_trace_level 40
        noise_generator 2
        #if (PHOT > 0)
                photons {
                        spacing 0.05
                        autostop 0
                        jitter 1
                        #if (PHOT = 1)
                                save_file "pov.ph"
                        #else
                                load_file "pov.ph"
                        #end                        
                }
        #end  
        #if(RAD > 0)
                radiosity {
                        pretrace_start 1
                        pretrace_end   1
                        count 30*RAD                
                        nearest_count 1      
                        error_bound 0.5/RAD      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media on
                        #if (Save_Rad = 1)
                                save_file "allegory.rad"
                        #else
                                #if (Save_Rad = 2)
                                        load_file "allegory.rad" 
                                        //always_sample off
                                #end
                        #end                          
                }
        #end
}        

#declare diff = 1;

#if (RAD > 0)
        #default {finish {ambient 0 diffuse diff*0.7}}
        #declare amb = 0;
#else
        #declare amb = 1;
#end

#macro G(Color,g)
        rgb <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end 

#declare Gamma = 2.2/a_g;

sky_sphere {
        pigment {
                gradient y 
                color_map {
                        /*
                        [0.0000 color G(<212,221,239>/255,Gamma)]
                        [0.1029 color G(<219,229,244>/255,Gamma)]
                        [0.1512 color G(<233,241,250>/255,Gamma)]
                        [0.1949 color G(<223,239,252>/255,Gamma)]
                        [0.2444 color G(<201,227,252>/255,Gamma)]
                        [0.2921 color G(<180,213,250>/255,Gamma)]
                        [0.3732 color G(<144,180,239>/255,Gamma)]
                        [0.4255 color G(<137,172,235>/255,Gamma)]
                        [0.7067 color G(< 97,126,198>/255,Gamma)]
                        [0.7740 color G(< 92,119,190>/255,Gamma)]
                        [0.8275 color G(< 88,114,185>/255,Gamma)]
                        [0.8850 color G(< 85,111,180>/255,Gamma)]                        
                        [0.9425 color G(< 82,107,175>/255,Gamma)]                        
                        [1.0000 color G(< 79,103,170>/255,Gamma)]
                        */
                        [0.0000 color G(<249,249,205>/255,Gamma)]
                        [0.2500 color G(<220,240,234>/255,Gamma)]                        
                        [0.5000 color G(<138,165,189>/510+<127,126,116>/510,Gamma)]                        
                        [1.0000 color G(<113,116,160>/510+<188,162,119>/510,Gamma)]                        
                }
        }
        translate y*-0.05
}

#include "functions.inc"
#declare foo = function {0}

//_________________________________________________________________________________
/*
sky_sphere {
        pigment {
                color rgb <0,0,0.627451>
        }
        pigment {
                gradient y
                color_map {
                        [ 0.0 color rgbt <0.4666667,0.7333333,1,0> ]
                        [ 0.5 color rgbt <0.4666667,0.7333333,1,0> ]
                        [ 0.8840222215604 color rgbt <0,0,0,1> ]
                        [ 1.0 color rgbt <0,0,0,1> ]
                }
                scale 2
                translate -y
        }
}
*/
#declare Forester_RedObjects = false;
#declare Forester_Animation = false;
#declare Forester_Frame = 0;
#declare Forester_Time = (0);
#declare Forester_Season = 0;

#declare Forester_CamAngle = 84.443778497084;
#declare Forester_CamFocus = 6;
#declare Forester_CamAperture = 0.0708428582266886;
#declare Forester_CamPitch = 1.82451403141022;
#declare Forester_CamHeading = 42.1578598022461;
#declare Forester_CamRoll = 0;
#declare Forester_CamLocation = <8,27,200>;

camera {
        sky       <0,1,0>
        up        <0,1,0>
        right     <1.777778,0,0>
        angle Forester_CamAngle
        rotate -z*Forester_CamRoll
        rotate <-Forester_CamPitch, Forester_CamHeading,0>
        translate Forester_CamLocation
}
/*
camera {
        location <30.7629,25.2016,268.082>*0.5+<62.6404,25.9837,226.836>*0.5+<-10,12+60,-30>
        look_at <30.7629,25.2016,268.082>*0.5+<62.6404,25.9837,226.836>*0.5+<-10,12,-30>
}
light_source {<30.7629,25.2016,268.082>*0.5+<62.6404,25.9837,226.836>*0.5+<-10,12+80,-30> color rgb 1}
*/
light_source {
        <0,0,10000>
        color rgb <1,pow(220/256,3),pow(180/256,3)>*6
        //looks_like {  object { sphere { <0,0,0>, 300 pigment { color rgb <  1,  .8588235,  .7019608 > } finish { ambient 10 brilliance 0 } } } }
        rotate -x* 2.417
        rotate y* 208.611
        translate <544,52.4389,792>
        media_interaction on
        media_attenuation off
        area_light <600,0,0>, <0,600,0>, 9,9 adaptive 0 jitter circular orient
}

#declare Forester_TerrainPigment1 = pigment { // Base Layer
  granite
  color_map {
    [ 0.00 rgb <113,82,45>/255 ]
    [ 0.50 rgb <60,45,32>/255 ]
    [ 1.00 rgb <146,93,45>/255 ]
    }
  translate <0,500,0>
  scale 1
  }

#declare Forester_TerrainPigment0 = pigment { color rgbft <1,1,1,0,1> }

object {  
        height_field {
                png "hf"
                water_level 0
                smooth
        }
        scale <-1024,64,1024>
        translate <1024,-1,0>
        material {
                texture { // Base Layer
                        pigment { 
                                Forester_TerrainPigment1
                        }
                        normal { 
                                granite,  0.1
                                scale < 3.5, 3.5, 3.5>*0.2
                        }
                        finish { ambient 0 diffuse 0.7  }
                }
        }
        no_image
}

object { //Water Plane
        box { <0,-1,0> < 1024,  16.667,  1024> hollow }
        material {
                texture {
                        pigment {color rgbft <0.2,0.35,0.3,0.5,0.1> }
                        normal {
                                average
                                normal_map {
                                        [wrinkles 0.1 scale 50]
                                        [granite 0.025 scale 0.5]
                                        [bumps 0.35 warp {turbulence 1} scale 1]
                                        [bumps 0.25 warp {turbulence 0.5} scale 0.01]
                                }
                        }
                        finish {
                                ambient 0
                                diffuse  0.3
                                reflection {0.04,0.24 fresnel on metallic 0.5}
                                specular 5
                                roughness 0.003
                        }
                }
                interior {
                        ior 1.333
                        fade_distance 1
                        fade_power 1
                }
        }
        no_image
}

#include "grassblade.inc"
#local seeder=seed(8674);

#include "colors.inc"
#declare Green1 = rgb <110,160,100>/255*0.5;
#declare Green2 = rgb <78,100,40>/255*0.5;
#declare pigSpotted = 
pigment {
        spotted
        color_map {
                [0.0, 0.2   color Tan*0.1*0.5 color Tan*0.4*0.5]
                [0.2, 0.3   color Tan*0.4*0.5 color Green1]
                [0.3, 1.01  color Green1  color Green1*1.2]
        }
}

#declare pigEarth = 
pigment {
        spotted
        color_map {
                [0.0 color Tan*0.3*0.5]
                [0.6 color Tan*0.3*0.5]
                [0.6 color Green1*0.4]
                [1.0 color Green1*0.4]
        }
}

#declare pigGreen = pigment {Green2*1.3}

#declare txtGrass =
texture {                  
        pigment {
                granite
                turbulence 0.2
                pigment_map {                                
                        [0.0 pigEarth]
                        [0.3 pigGreen]
                        [0.9 pigSpotted]
                        [1.0 pigEarth]
                }
        }
        normal {bumps}
        finish {ambient 0 diffuse 0.6 /*specular 1 roughness 0.015*/}
        scale <0.01,1,0.01>*8//*0.1
 
}

#declare veg1 = 
object {
        blade_mesh2
        double_illuminate
        scale 0.4
        rotate y*120
}

union {
        #include "veg1g.inc"
//        box {<0,-1,0> < 1024,21,1024>}
        texture {txtGrass}
        texture {
                pigment {color rgbt <1,pow(220/256,1.5),pow(180/256,1.5),1>}
                finish {ambient 0 diffuse 0.6 specular 0.5 roughness 0.005 metallic}
        }        
}

#declare Green1 = rgb <90,160,100>/255*0.5;
#declare Green2 = rgb <58,100,40>/255*0.5;
#declare pigSpotted = 
pigment {
        spotted
        color_map {
                [0.0, 0.2   color Tan*0.1*0.5 color Tan*0.4*0.5]
                [0.2, 0.3   color Tan*0.4*0.5 color Green1]
                [0.3, 1.01  color Green1  color Green1*1.2]
        }
}

#declare pigEarth = 
pigment {
        spotted
        color_map {
                [0.0 color Tan*0.3*0.5]
                [0.6 color Tan*0.3*0.5]
                [0.6 color Green1*0.4]
                [1.0 color Green1*0.4]
        }
}

#declare pigGreen = pigment {Green2*1.3}

#declare txtGrass2 =
texture {                  
        pigment {
                granite
                turbulence 0.2
                pigment_map {                                
                        [0.0 pigEarth]
                        [0.3 pigGreen]
                        [0.9 pigSpotted]
                        [1.0 pigEarth]
                }
        }
        normal {bumps}
        finish {ambient 0 diffuse 0.6 /*specular 1 roughness 0.015*/}
        scale <0.01,1,0.01>*8//*0.1
 
}

union {
        #include "veg1c.inc"
        texture {txtGrass2}
        texture {
                pigment {color rgbt <1,pow(220/256,1.5),pow(180/256,1.5),1>}
                finish {ambient 0 diffuse 0.6 specular 0.5 roughness 0.01 metallic}
        }        
}

#include "gerbera3.inc" 
#include "veg2i.inc"

union {#include "tree_1.inc" scale 16 rotate y*251.154 rotate <3.01034,0,1.89081> translate <30.7629,25.2016,268.082>}
union {#include "tree_2.inc" scale 20 rotate y*29.3133 rotate <0.754026,0,3.94406> translate <62.6404,25.9837,226.836>}     

#include "pipeHead1.inc"
#include "foulard3.inc"