#version 3.5;

#declare PHOT      = 0;  // photons 0=out; 1=save photons; 2=load photons
#declare Save_Rad  = 0;  // 1=save rad; 2=load rad data; 0=no rad storing
#declare RAD       = 0;  // radiosity quality settings 0=out; 1=acceptable; 5=good
                
global_settings {
        #declare a_g = 1.6;
        assumed_gamma a_g
        max_trace_level 40
        noise_generator 2
        #if (PHOT > 0)
                photons {
                        spacing 0.05
                        autostop 0
                        jitter 1
                        #if (PHOT = 1)
                                save_file "pov.ph"
                        #else
                                load_file "pov.ph"
                        #end                        
                }
        #end  
        #if(RAD > 0)
                radiosity {
                        pretrace_start 1
                        pretrace_end   1
                        count 30*RAD                
                        nearest_count 1      
                        error_bound 0.5/RAD      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media on
                        #if (Save_Rad = 1)
                                save_file "pov.rad"
                        #else
                                #if (Save_Rad = 2)
                                        load_file "pov.rad" 
                                        always_sample off
                                #end
                        #end                          
                }
        #end
}        

#declare diff = 1;

#if (RAD > 0)
        #default {finish {ambient 0 diffuse diff*0.7}}
        #declare amb = 0;
#else
        #declare amb = 1;
#end

#include "functions.inc"
#declare foo = function {0}

#declare maskObj = 1;
#declare maskSha = 0;

#declare maskTex1 =
texture {
        pigment {rgb 2}
        finish {ambient 0 diffuse 1}
} 

#declare maskTex0 =
texture {
        pigment {rgb 2}
        finish {ambient 0 diffuse 1}
}

//_________________________________________________________________________________

sky_sphere {pigment {color rgb 1}}

#declare Forester_RedObjects = false;
#declare Forester_Animation = false;
#declare Forester_Frame = 0;
#declare Forester_Time =  ( 0 )  ;
#declare Forester_Season =  0;

#declare Forester_CamAngle =  84.443778497084;
#declare Forester_CamFocus =  6;
#declare Forester_CamAperture =  0.0708428582266886;
#declare Forester_CamPitch =  1.82451403141022;
#declare Forester_CamHeading =  42.1578598022461;
#declare Forester_CamRoll =  0;
#declare Forester_CamLocation = <8,27,200>;

camera {
  sky       <0,1,0>
  up        <0,1,0>
  right     <1.777778,0,0>
  angle Forester_CamAngle
  rotate -z*Forester_CamRoll
  rotate <-Forester_CamPitch, Forester_CamHeading,0>
  translate Forester_CamLocation
}

light_source {
  <0,0,10000>
  color rgb 1
  //looks_like {  object { sphere { <0,0,0>, 300 pigment { color rgb <  1,  .8588235,  .7019608 > } finish { ambient 10 brilliance 0 } } } }
  rotate -x* 2.417
  rotate y* 208.611
  translate <544,52.4389,792>
  media_interaction on
  media_attenuation off
  area_light <600,0,0>, <0,600,0>, 9,9 adaptive 0 jitter circular orient
}

object {  
        height_field {
                png "hf"
                water_level 0
                smooth
        }
        scale <-1024,64,1024>
        translate <1024,-1,0>
        texture {maskTex0}
}

object {
  box { <0,-1,0> < 1024,  16.667,  1024> hollow }
        texture {maskTex0}
}

object { //blocking unwanted shadows
        box {<-16,-9,0> <16,16,0.001> hollow}
        texture {
                pigment {color rgb 1}
                finish {ambient 1 diffuse 0}
        }
        scale 10
        rotate y*42
        translate <0.35,0,1>*300
}

