#version unofficial MegaPov 0.7;

#include "clothutil.inc"

#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempy = -l2/2 + j*nlng;
            #local tempz = ht + (-1+2*rand(st))*nlng*0.01;
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#fclose file
#end



/* write initial file */
#macro WriteInitialRideau() 

#declare scal = 5;
WriteClothFile("foucard.cth", 60*scal, 30*scal, 1/scal, 150*0.5, 0)

	#fopen file "foucard.cth" append

#local i = 0;
#while (i<41)
	#write(file, i, ", 0.0, 0.0, 0.0,\n")
	#write(file, 41+i, ", 0.3, 0.3, 1.0,\n")
	#write(file, 82+i, ", 0.6, 0.6, 1.0,\n")
	#local i=i+2;
#end

	#fclose file

#end



#declare Mat = cylinder { <-39.1, -200, 0>, <-39.1, 30, 0>, 4 }

#declare Fact = 20;


#debug concat("\nclock = ", str(clock, 4,4), "\n")

#declare Dir1 = <-0.1, 0.5, -0.2>*Fact;
#declare Dir2 = <0.5, -0.1, 0.2>*Fact;

#declare Vent = pigment {
	bozo
	scale 1
	color_map {
		[.2 color Dir1]
		[.8 color Dir2]
	}
}

WriteInitialRideau()


simcloth {
	environment Mat
	friction    0.5

	gravity     -0.6*y
	wind        { Vent }
	viscosity   0.7

	neighbors   1
	internal_collision off
	damping     0.85
	intervals   0.03
	iterations  15000

	input       "foucard.cth"
	output      "foucard.cth"
	mesh_output "foucard.msh"
	smooth_mesh on
	uv_mesh     on
}



#declare Drapeau = mesh {
	#include "foucard.msh"
	uv_mapping
	texture {
		pigment {
			gradient x
			color_map {
				[.33 rgb<.1, .2, 1>]
				[.33 rgb<1, 1, 1>]
				[.66 rgb<1, 1, 1>]
				[.66 rgb<1, .2, .1>]
			}
		}
		finish { ambient .3 diffuse .7 }
	}
}

camera {location <50, -10, -200> angle 50 look_at 0*x }

light_source { 10000*y, color rgb 1.2
	rotate -x*30
	rotate y*45
}


object { Drapeau }
union {
	object { Mat }
	sphere { <-39.1, 30, 0>, 7 }
	pigment { rgb .95 }
	finish { ambient .3 diffuse .7 }
}

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0.0 rgb <.8, .9, 1>]
			[0.2 rgb <.7, .85, 1>]
			[0.5 rgb <.6, .8, 1>]
			[0.8 rgb <.5, .7, 1>]
		}
	}
}
