global_settings {noise_generator 2}        
        
#declare ftname = "veg1g.inc"
#warning concat (ftname," veg1 file creation start\n")
#fopen filehandle ftname write

#declare amb = 0;

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#declare hfscalx = -1024;
#declare hfscaly = 64;
#declare hfscalz = 1024;

#declare hftranx = 1024+0.5*hfscalx;
#declare hftrany = -1+0.5*hfscaly;
#declare hftranz = 0+0.5*hfscalz;

//#include "grass1.inc"
#declare veg1 = sphere {<0,0.5,0> 0.5 scale <0.01,1,0.01> pigment {color rgb <1,0,0>}}

 
#declare PigTex1  = function {pigment {bumps color_map {[0 rgb 0][1 rgb 1]} scale 5}} 
#declare Pigmap0  = function {pigment {image_map {png "hf0"} rotate x*90 translate -0.5 scale <-hfscalx,hfscaly,hfscalz>}}  //hoehe
#declare Pigmap1  = function {pigment {image_map {png "hf1"} rotate x*90 translate -0.5 scale <-hfscalx,hfscaly,hfscalz>}}  //ueberhaupt
#declare Land = height_field {png "hf" smooth translate -0.5 scale <hfscalx,hfscaly,hfscalz>}                               //heightfield

#local rfac = 97698*500;
#local eR = seed(60410+rfac*3);  
#local eR2 = seed(30195+rfac*565);
#local eR3 = seed(27419+rfac*9);

#macro veg_macro (G1,G2,Gnum,Maxheight,DispObject)

#local V = 0;
union {
        #local GW = G2.x-G1.x;
        #local GD = G2.y-G1.y;
        #while(V < Gnum)
                #local X = rand(eR)*GW;
                #local Z = rand(eR)*GD;
                #local CMap = Pigmap1(X,0,Z);
                #local PMap = Pigmap0(X,0,Z);
                #local RMap = PigTex1(X,0,Z);                      
                #local Norm = <X+G1.x,0,Z+G1.y>;
                #local Start = <X+G1.x,Maxheight,Z+G1.y>;
                #local Inter = trace(DispObject,Start,Norm-Start,Norm);
                #if (Norm.x != 0|Norm.y != 0|Norm.z != 0) 
                        #if ((CMap.x*0.3333+CMap.y*0.3333+CMap.z*0.3333)*rand(eR3)*2 > 0.5)                                       // berhaupt
                                #if ((PMap.x*0.3333+PMap.y*0.3333+PMap.z*0.3333)*rand(eR2)*2 > 0.35)                              // wahrscheinliche Hhe
                                        #if ((PMap.x*0.3333+PMap.y*0.3333+PMap.z*0.3333) > 0.35)                                  // absolute Hhe                
                                                #if (pow(atan2(Norm.x,Norm.y),2)+pow(atan2(Norm.z,Norm.y),2)*rand(eR3)*2 < 0.5)   // wenn wahrscheinlich nicht zu steil
                                                        #local ab = (1+pow(rand(eR3),2))/1.25;
                                                        #local ac = 360*pow(rand(eR),2.5)+360*(RMap.x*0.3333+RMap.y*0.3333+RMap.z*0.3333);
                                                        #local ad = 0.7*30*rand(eR2)+0.3*degrees(atan2(Norm.z,Norm.y));
                                                        #local ae = 0.7*30*rand(eR2)-0.3*degrees(atan2(Norm.x,Norm.y));
                                                        #local af = X+G1.x;
                                                        #local ag = Inter.y;
                                                        #local ah = Z+G1.y;
                                                        object {veg1
                                                                scale ab
                                                                rotate y*ac
                                                                rotate z*ad
                                                                rotate x*ae
                                                                translate <af,ag,ah>
                                                                #write (filehandle,"object {veg1 scale ",ab," rotate y*",ac," rotate <",ad,",0,",ae,"> translate <",af+hftranx,",",ag+hftrany,",",ah+hftranz,"> } // ",V+1,"\n")
                                                        }
                                                #else
                                                        #local V = V-1; 
                                                #end
                                                #local V = V+1;
                                                /*
                                                #if(mod(V,1)=0)
                                                        #debug concat(str(V,0,0)," veg1 placed.\n")
                                                #end
                                                */
                                        #end
                                #end     
                        #end     
                #end  
        #end
}
#end  

veg_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,100000,hfscaly*0.5+hftrany+0.01,Land)
