#version unofficial megapov 0.72;

//===================================
//===================================
//	SETTINGS
//===================================
//===================================

#include "colors.inc"
#include "woods.inc"

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 500;
#declare Rad_error = .03;
#declare Rad_rec = 1;
#declare Rad_bright = 1.3;
#declare Rad_bo = 1/128;

#if (Use_rad)
#default { texture { finish { ambient 0.0 diffuse 1.1 } } }
#else
//#default { texture { finish { ambient 0.3 diffuse 0.8 } } }
#end

// cam settings
#declare Zoom = on;

// book
#declare Book = on;

// light settings
#declare Lum1=<.1,.2,1>*.6;
#declare Lum2=1-Lum1;

// area_light settings
#declare Area_n1 = 10;
#declare Area_n2 = 10;
#declare Area_adap = 2;

// media settings
#declare Use_media = off;
#declare Med_int = 1;
#declare Med_samp = 200;
#declare Med_thre = .05;
#declare Med_conf = .999;
#declare Med_var = .001;


// Robert
#declare Use_Robert = off;
#declare Use_drap = off;
#declare Use_isomoquette = off;

// walls settings
#declare Xw1=-400;
#declare Xw2=300;
#declare Yw1=0;
#declare Yw2=250;
#declare Yw3=10;
#declare Zw1=-400;
#declare Zw2=105;

// window settings
#declare Xfen1=Xw1+.01;
#declare Xfen2=Xw1+.01;
#declare Yfen1=100;
#declare Yfen2=200;
#declare Zfen1=Zw2-240;
#declare Zfen2=Zw2-150;



global_settings {
	max_trace_level 20
	adc_bailout 1/128
#if (Use_rad)
	ini_option "+QR"
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .01

		always_sample off
		samples{quality 6 area_light off normal off}

		low_error_factor .5
		gray_threshold 0.1
		minimum_reuse 0.015
		normal on
		media on

		max_sample 2
		adc_bailout Rad_bo
	}
#end
}

#if (Use_rad=on)
#else
light_source { <60, 80, 1>, color rgb .1 shadowless }
#end


//===========================
// CAMERA
//===========================

#if (Zoom)
/*
camera {
	location <150, 90, -100>
	right x
	up y*4/3
	angle 15
	look_at <110, 60, 30>
}
*/
camera {
	location <150, 90, -100>
	right x*60/32
	up y
	angle 15
	look_at <110, 60, 30>
}
#else

camera {
	location <150, 110, -250>
	right x
	up y*4/3
	angle 50
	look_at <80, 40, 100>
}


#end

background { color rgb <.9, .92, 1.2>*1.1 }

/*
light_source { 100000*y color rgb <1.2, 1.2, 1>*1.6
	rotate x*48
	rotate -y*34
}
*/

//===================================
//	MEDIA
//===================================


#if (Use_media)
box { <-1, -1, -1>, <401, 221, 360+50*sin(radians(25))>
	hollow
	pigment { rgbt 1 }
	interior {
		media {
			intervals Med_int
			scattering { 3, color rgb .005 extinction 0.01 }
			method 3
			samples Med_samp, Med_samp
			aa_threshold Med_thre
			aa_level 4
			variance Med_var
			confidence Med_conf
/*			density {
				planar
				rotate x*90
				scale <1,1, 150>
				translate 350*z
				color_map {
					[0 rgb 0]
					[1 rgb 1]
				}
			}
*/		}
	}
}
#end


//===========================
// MURS
//===========================

#declare T_Mur = texture {
	pigment {
		marble
		warp { turbulence .1 octaves 2 omega .3 }
		scale 2.8 
		color_map {
			[.20 color rgb <0.933,0.863,0.749>]
			[.40 color rgb <0.933,0.863,0.749>]
			[.50 color rgb <0.933,0.863,0.749>*.85]
			[.80 color rgb <0.933,0.863,0.749>*.85]
			[.90 color rgb <0.933,0.863,0.749>*.80]
		}
	}
	normal {
		marble .1
		warp { turbulence .2 octaves 3 omega .2 }
		scale 2.9
		slope_map {
			[.35 <0,0>]
			[.35 <0,1>]
			[.95 <1,0>]
		}
	}
}

#declare T_Mur2 = texture {
	pigment {
		bozo
		scale .4
		color_map {
			[0 rgb 1]
			[1 rgb <.97,.95,.95>]
		}
	}
}


box { <Xw1-1,Yw1, Zw2>, <Xw2+1, Yw2+1, Zw2+1> texture{T_Mur}}
box { <Xw1-1,Yw1, Zw2-1>, <Xw2+1, Yw3, Zw2> texture{T_Mur2}}
box { <Xw1-1,Yw1, Zw1-1>, <Xw1, Yw2+1, Zw2+1> texture{T_Mur rotate y*90}}
box { <Xw1-1,Yw1, Zw1-1>, <Xw1, Yw3, Zw2+1> texture{T_Mur2 rotate y*90}}
box { <Xw2,Yw1, Zw1-1>, <Xw2+1, Yw2+1, Zw2+1> texture{T_Mur rotate -y*90}}
box { <Xw2,Yw1, Zw1-1>, <Xw2+1, Yw3, Zw2+1> texture{T_Mur2 rotate -y*90}}
box { <Xw1-1,Yw1, Zw1>, <Xw2+1, Yw2+1, Zw1-1> texture{T_Mur}}
box { <Xw1-1,Yw1, Zw1+1>, <Xw2+1, Yw3, Zw1> texture{T_Mur2}}

box { <Xw1-1,Yw2, Zw1-1>, <Xw2+1,Yw2+1, Zw2+1> texture {T_Mur2}}

/*
light_source{
	0, color rgb Lum1
	area_light z*(Zfen2-Zfen1), y*(Yfen2-Yfen1), Area_n1, Area_n2
	jitter adaptive Area_adap
	spotlight radius -90 falloff 90 point_at x
	translate <(Zfen1+Zfen2)/2,(Yfen1+Yfen2)/2,Xw1+1>
	fade_distance sqrt((Zfen2-Zfen1)*(Yfen2-Yfen1))
	fade_power 2
}
*/


//===========================
// MOQUETTE
//===========================
#declare T_Sol = texture {
	pigment { rgb <.34, .45, .70> }
}

#declare Moquette = function {.1*sin(x*1.5) + .01*cos(z*3) + .2*noise3d(x*.5,y*.5,z*.5)}

#if (Use_isomoquette)

isosurface { 
	function {y + Moquette(x,y,z) }  
	threshold 0   
	contained_by {box{<Xw1,Yw1-1, Zw1>, <Xw2, Yw1+.01, Zw2>}}
	accuracy .001
	method 2
	eval
	pigment {color rgb <0.282,0.455,0.686>}
	scale 1
	translate y*.2
}


#else

box {<Xw1,Yw1-1, Zw1>, <Xw2, Yw1+.01, Zw2> texture{T_Sol normal{function{Moquette(x,y,z)} .3 sine_wave}}}

#end


//===========================
// LIT
//===========================
#include "roundedbox.mcr"

#declare T_Lit1 = texture {
	pigment { rgb <.97, .98, .98> }
	normal { bumps scale <4,50,4> no_bump_scale }
}
#declare T_Lit2 = texture {
	pigment {
		checker
		color rgb <0.875,0.945,0.965>, color rgb <0.761,0.867,0.898>
		warp { turbulence .9 octaves 3 lambda 5 omega .4 }
		scale 2
		warp { turbulence .6 octaves 3 lambda 5 omega .4 }
	}
}
#declare T_Lit3 = texture { T_Wood35 }


/*
#declare Housse = mesh {
	#include "housse.msh"
	rotate -y*90
	translate <0,0,98>
	texture {pigment {color rgb .95}}
}
*/

#include "housse.pov"
union {
	object {Housse double_illuminate rotate -y*90 translate <70,21,100>}
	union {
		RoundedBox(<-70, 6, -100>, <70, 21, 100>, 1)
		texture { T_Lit2 }
	}
	sphere {0, 1 scale <4, 5, 4> translate <-65, 3, -95> texture { T_Lit3 } }
	sphere {0, 1 scale <4, 5, 4> translate < 65, 3, -95> texture { T_Lit3 } }
	sphere {0, 1 scale <4, 5, 4> translate <-65, 3,  95> texture { T_Lit3 } }
	sphere {0, 1 scale <4, 5, 4> translate < 65, 3,  95> texture { T_Lit3 } }
}



//===========================
// ROBERT
//===========================
#if (Use_Robert)
#include "dormeur.inc"
object { Dormeur translate <70, 10+21+20+5, -30>}
#end


//===========================
// DRAP
//===========================
#if (Use_drap)
mesh {
	#include "drap.msh"
	uv_mapping
	texture {
		pigment {color rgb .95}
		normal { spotted scale .0003 }
		finish { specular .5 roughness .01 }
	}
	scale <1,1,1.001> translate .3*y
	translate <298, 0, 220>
}
#end


//===========================
// OREILLERS
//===========================
/*
#declare IMPORT_SPATCH = on;

object {
	#include "oreiller1.inc"
	pigment {rgb 1}
	scale 1.8
	rotate y*5
	translate <98, 36, -40>
	translate <298, 0, 220>
}

object {
	#include "oreiller2.inc"
	pigment {rgb 1}
	scale 1.8
	translate <98, 35, 28>
	translate <298, 0, 220>
}
*/


//===========================
// TABLES CHEVET
//===========================

#include "chevet.inc"

#declare Tr_Lampe1 = transform {translate <80, 0, Zw2-TCZ1-2>}

object { TableChevet
	transform { Tr_Lampe1 }
}

object { Lampe
	rotate -y*27 translate <27+PLR*1.2, TCY1+TCep, TCZ1-PLR*2>
	transform { Tr_Lampe1 }
}

light_source { 4*y color rgb <1,1,.7>*0.9
	fade_distance 150
	fade_power 2
	area_light 7*x, 7*y, Area_n1, Area_n2
	orient
	circular
	jitter
	adaptive Area_adap
	translate <27+PLR*1.2, TCY1+TCep + PLH, TCZ1-PLR*2>
	translate <80, 0, Zw2-TCZ1-2>
}


object { Reveil scale .9 rotate -y*10
	translate <-3, TCY1+TCep, 19>
	transform { Tr_Lampe1 }
}


/*
object { TableChevet
	rotate y*90 translate <369, 0, 330>
}
object { Lampe
	rotate -y*27 translate <PLR*1.2, TCY1+TCep, TCZ1-PLR*2>
	rotate y*90 translate <369, 0, 330>
}
*/


//===========================
// Livre
//===========================
#if (Book)


#declare Book_Transf=transform{rotate y*25 translate <95, TCY1+TCep+3, Zw2-TCZ1-2> }
#include "fallenbook.pov"
FallenBook(10,16,1,100,3,1,15)

#end
