#version unofficial megapov 0.72;

#declare test_chevet_inc = off;

#include "colors.inc"
#include "woods.inc"

#include "colormap.mcr"

//#default { texture { finish { ambient 0.05 diffuse 0.95 } } }
#default { texture { finish { ambient 0.2 diffuse 0.8 } } }

//==================================
// PIGMENTS BOIS
//==================================

#declare P_Bois_01 = pigment {
  wood
  color_map {ColorMapScan ("teck",240)}
  scale 1/7
  warp {turbulence .05}  //grandes ondulations
  scale 7/.05
  warp {turbulence .3} //petites ondulations
  scale .05
}

#declare P_Bois_02 = pigment {
  wood
  color_map {ColorMapScan ("bubinga",240)}
  scale 1/7
  warp {turbulence .05}  //grandes ondulations
  scale 7/.05
  warp {turbulence .3} //petites ondulations
  scale .05
}



//==================================
// TABLE
//==================================

#declare T_Chevet1 = texture { pigment {P_Bois_01} normal{pigment_pattern{P_Bois_01} bump_size .5} finish {specular .1} scale 7 }

#declare TCX1 = 40;
#declare TCZ1 = 30;
#declare TCY1 = 40;
#declare TCY2 = 10;
#declare TCY3 = 15;
#declare TCep = 2;

#declare Tiroir1 = difference {
	box { <TCep, 0, 0>, <TCX1-TCep, -TCY3, -TCep> }
	#local dec = TCep;
	cylinder { <TCep+dec, -dec, -TCep>, <TCX1-TCep-dec, -dec, -TCep>, TCep/2 }
	cylinder { <TCep+dec, -TCY3+dec, -TCep>, <TCX1-TCep-dec, -TCY3+dec, -TCep>, TCep/2 }
	cylinder { <TCep+dec, -dec, -TCep>, <TCep+dec, -TCY3+dec, -TCep>, TCep/2 }
	cylinder { <TCX1-TCep-dec, -TCY3+dec, -TCep>, <TCX1-TCep-dec, -dec, -TCep>, TCep/2 }
	sphere { <TCep+dec, -dec, -TCep>, TCep/2 }
	sphere { <TCep+dec, -TCY3+dec, -TCep>, TCep/2 }
	sphere { <TCX1-TCep-dec, -dec, -TCep>, TCep/2 }
	sphere { <TCX1-TCep-dec, -TCY3+dec, -TCep>, TCep/2 }
}

#declare Tiroir = union {
	object { Tiroir1 }
	difference {
		box { <2*TCep, 0, 0>, <TCX1-2*TCep, -TCY3, TCZ1-2*TCep> }
		box { <3*TCep, .01, -.01>, <TCX1-3*TCep, -TCY3+TCep, TCZ1-3*TCep> }
	}
	cylinder { <TCX1/2, -TCY3/2, -TCep>, <TCX1/2, -TCY3/2, -TCep-TCep/2>, TCep }
	sphere { 0, TCep scale <1.5, 1, 1/1.5> translate <TCX1/2, -TCY3/2, -TCep-TCep/2-TCep/1.5> }
	texture { T_Chevet1 rotate y*89 translate 15*z }
}

#declare TableChevet = union {
	box { <TCep, 0, 0>, <2*TCep, TCY1, TCZ1> texture { T_Chevet1 rotate y*90 } }
	box { <TCX1-TCep, 0, 0>, <TCX1-2*TCep, TCY1, TCZ1> texture { T_Chevet1 rotate y*90 } }
	box { <2*TCep, TCY2, TCep/4>, <TCX1-2*TCep, TCY2+TCep, TCZ1-TCep> texture { T_Chevet1 rotate y*3 } }
	box { <2*TCep, TCY2, TCep/2>, <TCX1-2*TCep, 0, TCep> texture { T_Chevet1 rotate x*98 } }
	box { <0, TCY1, -TCep/2>, <TCX1, TCY1+TCep, TCZ1> texture { T_Chevet1  rotate -y*4 translate 10*y } }
	box { <2*TCep, 0, TCZ1-TCep>, <TCX1-2*TCep, TCY1, TCZ1> texture { T_Chevet1 rotate x*98 } }
	object { Tiroir translate TCY1*y - 5*TCep*z }
}

//==================================
// LAMPE
//==================================

#declare T_Lampe = texture { pigment {P_Bois_02} finish {specular .2} scale 4 }

#declare PLR = 7;
#declare PLH = 20;

#declare PiedLampe = union {
	difference {
		cylinder { 0, PLH*.3*y, PLR }
		torus { PLR*1.1, PLR*.7 scale <1, PLH*.25/(PLR*.7), 1> translate PLH*.3*y }
	}
	torus { PLR*.4, PLR*.07 translate PLH*.3*y }
	sphere { 0, PLR*.6 scale <1, PLH*.14/(PLR*.6), 1> translate PLH*.4*y }
	torus { PLR*.4, PLR*.07 translate PLH*.5*y }
	sphere { 0, PLR*.45 scale <1, PLH*.18/(PLR*.45), 1> translate PLH*.6*y }
	torus { PLR*.4, PLR*.07 translate PLH*.7*y }
	sphere { 0, PLR*.5 scale <1, PLH*.14/(PLR*.5), 1> translate PLH*.8*y }
	torus { PLR*.4, PLR*.07 translate PLH*.9*y }
	cylinder { PLH*.9*y, PLH*y, PLR*.4 }
	texture { T_Lampe rotate x*88 translate 15*z }
}

#declare T_AbatJour1 = texture {
	pigment { rgb <1,1,.6> }
	normal{wrinkles .4 scale .5}
	finish { specular .6 roughness .01 brilliance 1.2 }
}

#declare AbatJour = union {
	cylinder { 0, 2*y, PLR*.41 }
	cylinder { 0, PLR*2*x, .25 }
	cylinder { <PLR*.4, 2, 0>, <PLR, PLH, 0>, .25 rotate y*60 }
	cylinder { 0, PLR*2*x, .25 rotate y*120 }
	cylinder { <PLR*.4, 2, 0>, <PLR, PLH, 0>, .25 rotate y*60 rotate y*120 }
	cylinder { 0, PLR*2*x, .25 rotate -y*120 }
	cylinder { <PLR*.4, 2, 0>, <PLR, PLH, 0>, .25 rotate y*60 rotate -y*120 }
	torus { PLR*2, .25 translate -.25*y }
	torus { PLR, .25 translate +.25*y + PLH*y }
	cone { -.5*y, (PLR*2+.25+.02), (PLH+.50)*y, (PLR+.25+.02)
		open hollow double_illuminate
		texture {
			pigment {
				wrinkles turbulence 2 lambda 6
				color_map { [.5 rgbf <1,1,.9,.3>*.9][.5 rgbf <1,.6,.3,.3>*.8] }
			}
			finish { brilliance 0.8 }
		}
	}
	texture { T_AbatJour1 }
}

#declare Lampe = union {
	object { PiedLampe }
	object { AbatJour translate PLH*y }
}


//==================================
// RADIO_REVEIL
//==================================

#declare T_Reveil1 = texture {
	pigment { rgb .10 }
	normal { dents 1.5 scale .1 warp { turbulence .1 } scale .1 }
	finish { phong .2 phong_size 1 }
}
#declare T_Reveil2 = texture {
	T_Reveil1
	finish { specular .6 roughness .01 }
}

#declare RX1 = 18;
#declare RY1 = 4;
#declare RZ1 = 12;
#declare RR1 = .5;

#declare Boitier_Reveil_1 = union {
	cylinder { <RR1, RR1, 0>, <RR1, RR1, RZ1>, RR1 }
	cylinder { <RR1, RY1-RR1, 0>, <RR1, RY1-RR1, RZ1>, RR1 }
	cylinder { <RX1-RR1, RR1, 0>, <RX1-RR1, RR1, RZ1>, RR1 }
	cylinder { <RX1-RR1, RY1-RR1, 0>, <RX1-RR1, RY1-RR1, RZ1>, RR1 }
	box { <RR1, 0, 0>, <RX1-RR1, RY1, RZ1> }
	box { <0, RR1, 0>, <RX1, RY1-RR1, RZ1> }
}

#declare Boitier_Reveil_2 = difference {
	object { Boitier_Reveil_1 }
	box { <RR1*1.1, RR1*1.1, -.001>, <RX1*.7, RY1-RR1*1.1, RZ1*.97> }
	#local i=RX1*.1;
	#while (i < RX1*.6)
		box { <i, RY1-RR1*0.5, RZ1*.3>, <i+RX1*.02, RY1+.001, RZ1*.9> }
		#local i = i + RX1*.04;
	#end
	// trou HP
	cylinder { <RX1*.35, RY1-RR1*.49>, <RX1*.35, RY1-RR1*1.11>, RX1*.25 }
	// trous boutons
	box {<RX1*.05, RY1-RR1*.6, RZ1*.05>, <RX1*.15, RY1+.001, RZ1*.15> }
	box {<RX1*.20, RY1-RR1*.6, RZ1*.05>, <RX1*.30, RY1+.001, RZ1*.15> }
	box {<RX1*.35, RY1-RR1*.6, RZ1*.05>, <RX1*.45, RY1+.001, RZ1*.15> }
	box {<RX1*.50, RY1-RR1*.6, RZ1*.05>, <RX1*.60, RY1+.001, RZ1*.15> }
	box {<RX1*.65, RY1-RR1*.6, RZ1*.05>, <RX1*.75, RY1+.001, RZ1*.15> }
	box {<RX1*.80, RY1-RR1*.6, RZ1*.05>, <RX1*.95, RY1+.001, RZ1*.15> }
	texture { T_Reveil1 }
}

#declare Boitier_Reveil_3 = union {
	object { Boitier_Reveil_2 }
	// boutons
	box {<RX1*.055, RY1-RR1*.6, RZ1*.05>, <RX1*.145, RY1+RR1*.2, RZ1*.15> }
	box {<RX1*.205, RY1-RR1*.6, RZ1*.05>, <RX1*.295, RY1+RR1*.2, RZ1*.15> }
	box {<RX1*.355, RY1-RR1*.6, RZ1*.05>, <RX1*.445, RY1+RR1*.2, RZ1*.15> }
	box {<RX1*.505, RY1-RR1*.6, RZ1*.05>, <RX1*.595, RY1+RR1*.2, RZ1*.15> }
	box {<RX1*.655, RY1-RR1*.6, RZ1*.05>, <RX1*.745, RY1+RR1*.2, RZ1*.15> }
	box {<RX1*.805, RY1-RR1*.6, RZ1*.05>, <RX1*.945, RY1+RR1*.2, RZ1*.15> }
	// boutons reglages
	union {
		cylinder { 0, RR1*.3*y, RZ1*.1 }
		cylinder { 0, 2*RR1*.3*y, RZ1*.1 - RR1*.3 }
		torus { RZ1*.1 - RR1*.3, RR1*.3 translate RR1*.3*y }
		box { <-(RZ1*.1 - RR1*.3), 0, -RR1*.1>, <(RZ1*.1 - RR1*.3), 2.5*RR1*.3, RR1*.1> }
		rotate y*15
		translate <RX1*.75, RY1*1.01, RZ1*.35>
	}
	union {
		cylinder { 0, RR1*.3*y, RZ1*.1 }
		cylinder { 0, 2*RR1*.3*y, RZ1*.1 - RR1*.3 }
		torus { RZ1*.1 - RR1*.3, RR1*.3 translate RR1*.3*y }
		box { <-(RZ1*.1 - RR1*.3), 0, -RR1*.1>, <(RZ1*.1 - RR1*.3), 2.5*RR1*.3, RR1*.1> }
		rotate -y*25
		translate <RX1*.85, RY1*1.01, RZ1*.60>
	}
	box { <RR1*1.1, RR1*1.1, RZ1*1>, <RX1*.7, RY1-RR1*1.1, RZ1*.11> }
	#include "heure.pov"
	object {
		Heure
		#local tx = (RX1*.7 - RR1*1.1)*.7;
		#local ty = (RY1-2*RR1*1.1)*.9;
		#local tz = (RZ1*.11 - 0)*.8;
		scale <tx/(maxHeure.x-minHeure.x), ty/(maxHeure.y-minHeure.y), tz>
		translate <RR1*1.1+tx*.05/.7, RR1*1.1+ty*0.05/.9, tz*01/0.8>
		texture {
			pigment { rgbt <0,0,0,1> }
		}
		interior {
			media {
				emission rgb <1, 0, 0>*1.5
				intervals 5
				samples 5,15
				confidence .9
				variance 1/150
				method 2
			}
		}
	}
	box { <RR1*1.11, RR1*1.11, RZ1*.01>, <RX1*.69, RY1-RR1*1.11, RZ1*.02>
		texture {
			pigment { rgbf <.95, .95, .95, 1> }
			finish { ambient 0 diffuse 0
				reflection_min .1 reflection_max .4
//				reflection {.1, .4}
				//conserve_energy
				specular .1 roughness .01 }
		}
	}
}



#declare Reveil = union {
	object {Boitier_Reveil_3 translate -RZ1*z rotate 3*x translate RZ1*z }
	box { <RR1*2, 0, RR1>, <RR1*8, RZ1*sin(radians(3)), RR1*2> }
	box { <RX1-RR1*2, 0, RR1>, <RX1-RR1*8, RZ1*sin(radians(3)), RR1*2> }
	texture { T_Reveil1 }
}

#if (test_chevet_inc)

#version unofficial megapov 0.6;

/*
global_settings {
	ini_option "+QR"
	radiosity {
		count 200
		nearest_count 4
		error_bound 0.05
		recursion_limit 1
		brightness 1.0
		gray_threshold .0
		pretrace_start .1
		pretrace_end .01
	}
}
*/

light_source { y*1000  color rgb .4 rotate -x*45 rotate -y*30 shadowless }

camera {
	location <TCX1, TCY1*2.4, -5*TCZ1>
	angle 10
	look_at <TCX1/2+10, TCY1*1.2, 0>
}

plane { -z, -(TCZ1+1) pigment { rgb 1 }}
plane { y, 0 pigment { rgb 1 }  normal { granite .05 scale .3 } }

sky_sphere { pigment { gradient y color_map {[0 rgb 1][1 rgb .6]} rotate x*45 rotate -y*30} }

object { TableChevet }
object { Lampe rotate -y*27 translate <PLR*1.2, TCY1+TCep, TCZ1-PLR*2> }

light_source { 4*y color rgb <1,1,.8>*1.5
	area_light 5*x, 5*y, 6, 6
	orient
	circular
	jitter
	adaptive 1
	translate <PLR*1.2, TCY1+TCep + PLH, TCZ1-PLR*2>
}


//light_source { y*1000 color rgb 1.2 rotate -x*20 rotate y*20 }

object { Reveil rotate y*12
	translate <TCX1-RX1*1.1, TCY1+TCep, 5>
}

/*
light_source { 4*y color rgb <1,1,.7>*0.4 shadowless
	translate <PLR*1.2, TCY1+TCep + PLH, TCZ1-PLR*2>
}
*/

#end
