/*
PCM File Format:

For triangle meshes:

"PCM1",  // include quotes
PointCount,
#[X,Y,Z,] // for each point
FlatTriangleCount,SmoothTriangleCount,
#[PA,PB,PC,] // for each flat triangle
#[PA,NA,PB,NB,PC,NC,] // for each smooth triangle

*/

#macro ReadPCM(FileName)

#fopen PCMFile FileName read

#ifndef(PCMFile) #error concat("File ",FileName," not found.\n") #end

#local Type=""

#read(PCMFile,Type)

#if (strcmp(Type,"PCM1")!=0)
#error concat("The SSS presently handles only type 1 PCM files.\n")
#end

#local cP=0; #local X=0; #local Y=0; #local Z=0;

#read(PCMFile,cP) // get point count

#ifdef(sssP) #undef sssP #end
#declare sssP=array[cP]

#local iI=0; #while(iI<cP)
  #read(PCMFile,X,Y,Z)
  #declare sssP[iI]=<X,Y,Z>;
#local iI=iI+1; #end

#local cTF=0; #local cTS=0;

#local D1=0; #local D2=0; #local D3=0;

#read(PCMFile,cTF,cTS)

#local cT=cTF+cTS;

#ifdef(sssT) #undef sssT #end
#declare sssT=array[cT][3]
#declare sssT[0][0]=0;

// read the flat triangle data
#local iI=0; #while(iI<cTF)
  #read(PCMFile,sssT[iI][0],sssT[iI][1],sssT[iI][2])
#local iI=iI+1; #end

// and the smooth triangle data
#while(iI<cT)
#read(PCMFile,sssT[iI][0],D1,sssT[iI][1],D2,sssT[iI][2],D3)
#local iI=iI+1; #end

#fclose PCMFile

#if(cTS>0)
  #warning "Warning!  The SSS generates its own normal vectors for smooth\n"
  #warning "triangles.  The normals specified in the file will be ignored.\n"

  #local Used=array[cP]

  #local iI=0; #while(iI<cP)
    #local Used[iI]=-1;
  #local iI=iI+1; #end


  #local iP=0;
  #local iI=0; #while (iI<cT)
    #if(Used[sssT[iI][0]]=-1)
      #local Used[sssT[iI][0]]=0;
      #local iP=iP+1;
    #end
    #if(Used[sssT[iI][1]]=-1)
      #local Used[sssT[iI][1]]=0;
      #local iP=iP+1;
    #end
    #if(Used[sssT[iI][2]]=-1)
      #local Used[sssT[iI][2]]=0;
      #local iP=iP+1;
    #end
  #local iI=iI+1; #end

  #local Indi=array[cP] // for redirection of indices
  #local Temp=array[cP] // to hold the points that get saved

  #local iJ=0;
  #local iI=0; #while(iI<cP)
    #if (Used[iI]=0)
      #local Temp[iJ]=sssP[iI];
      #local Indi[iI]=iJ;
      #local iJ=iJ+1;
    #else
      #local Indi[iI]=-1;
    #end
  #local iI=iI+1; #end

  #local iI=0; #while(iI<cT)
    #declare sssT[iI][0]=Indi[sssT[iI][0]];
    #declare sssT[iI][1]=Indi[sssT[iI][1]];
    #declare sssT[iI][2]=Indi[sssT[iI][2]];
  #local iI=iI+1; #end

  #undef sssP
  #declare sssP=array[iP]

  #local iI=0; #while(iI<iP)
    #declare sssP[iI]=Temp[iI];
  #local iI=iI+1; #end

#end // end of normal data removal

#end // end of macro

#macro WriteFlatPCM(FileName,Precision)

#fopen PCMFile FileName write

#ifndef(PCMFile)
  #error concat("The file ",FileName," could not be opened.\n")
#end

#local cP=dimension_size(sssP,1);

#write(PCMFile,"\"PCM1\",\n")  
#write(PCMFile,cP,",\n")

#local iI=0; #while(iI<cP)
  #write(PCMFile,str(sssP[iI].x,0,Precision),",")
  #write(PCMFile,str(sssP[iI].y,0,Precision),",")
  #write(PCMFile,str(sssP[iI].z,0,Precision),",")
#local iI=iI+1; #end

#local cT=dimension_size(sssT,1);

#write(PCMFile,"\n",cT,",",0,",\n")

#local iI=0; #while(iI<cT)
  #write(PCMFile,sssT[iI][0],",",sssT[iI][1],",",sssT[iI][2],",")
#local iI=iI+1; #end

#fclose PCMFile

#end // end of macro

/* and     write     smooth           *
 *     now       the        triangles */

#macro WriteSmoothPCM(FileName,Precision)

#fopen PCMFile FileName write

#ifndef(PCMFile)
  #error concat("The file ",FileName," could not be opened.\n")
#end

#local cP=dimension_size(sssP,1);
#local cT=dimension_size(sssT,1);

#local Norm=array[cP]
#local iI=0; #while(iI<cP)
  #local Norm[iI]=<0,0,0>;
#local iI=iI+1; #end

#local iI=0; #while(iI<cT)
  #local pA=sssT[iI][0];
  #local pB=sssT[iI][1];
  #local pC=sssT[iI][2];

  #local vN=vcross(sssP[pB]-sssP[pA],sssP[pC]-sssP[pA]);
  #local Norm[pA]=Norm[pA]+vN;
  #local Norm[pB]=Norm[pB]+vN;
  #local Norm[pC]=Norm[pC]+vN;
#local iI=iI+1; #end

#local iI=0; #while(iI<cP)
  #local Norm[iI]=vnormalize(Norm[iI]);
#local iI=iI+1; #end

#write(PCMFile,"\"PCM1\",\n")  
#write(PCMFile,cP+cP,",\n")

#local iI=0; #while(iI<cP)
  #write(PCMFile,str(sssP[iI].x,0,Precision),",")
  #write(PCMFile,str(sssP[iI].y,0,Precision),",")
  #write(PCMFile,str(sssP[iI].z,0,Precision),",")
#local iI=iI+1; #end
#local iI=0; #while(iI<cP)
  #write(PCMFile,str(Norm[iI].x,0,3),",")
  #write(PCMFile,str(Norm[iI].y,0,3),",")
  #write(PCMFile,str(Norm[iI].z,0,3),",")
#local iI=iI+1; #end

#write(PCMFile,"\n",0,",",cT,",\n")

#local iI=0; #while(iI<cT)
  #write(PCMFile,sssT[iI][0],",")
  #write(PCMFile,sssT[iI][0]+cP,",")
  #write(PCMFile,sssT[iI][1],",")
  #write(PCMFile,sssT[iI][1]+cP,",")
  #write(PCMFile,sssT[iI][2],",")
  #write(PCMFile,sssT[iI][2]+cP,",")
#local iI=iI+1; #end

#fclose PCMFile

#end // end of macro
 
