#macro UVWMap(pX,pY,pZ,pU,pV,pW)
//transform U,V,W to O,<1,0,0>,<0,1,0>

#local vX=pV-pU;
#local vY=pW-pU;
#local vZ=vcross(vX,vY);

#local Det=1/vdot(vX,vcross(vY,vZ));

translate -pU
matrix <
  vdot(x,vcross(vY,vZ))*Det,vdot(vX,vcross(x,vZ))*Det,vdot(vX,vcross(vY,x))*Det, 
  vdot(y,vcross(vY,vZ))*Det,vdot(vX,vcross(y,vZ))*Det,vdot(vX,vcross(vY,y))*Det, 
  vdot(z,vcross(vY,vZ))*Det,vdot(vX,vcross(z,vZ))*Det,vdot(vX,vcross(vY,z))*Det, 
  0,0,0>

//transform O,<1,0,0>,<0,1,0> to X,Y,Z
#local vX=pY-pX;
#local vY=pZ-pX;
#local vZ=vcross(vX,vY);
matrix <vX.x,vX.y,vX.z, vY.x,vY.y,vY.z, vZ.x,vZ.y,vZ.z, pX.x,pX.y,pX.z> 
#end

#macro MakeTriangles()

#local cT=dimension_size(sssT,1);
#local cD=dimension_size(sssT,2);

#local iI=0; #while(iI<cT)

#local pA=sssT[iI][0];
#local pB=sssT[iI][1];
#local pC=sssT[iI][2];

#if (cD>3)
  #local pD=sssT[iI][3];
#else
  #local pD=-1;
#end

#if (cD>4)
  #local iE=sssT[iI][4];
  #local pF=sssT[iI][5];
  #local pG=sssT[iI][6];
#else
  #local iE=-1;
  #local pF=-1;
  #local pG=-1;
#end  

triangle {
  sssP[pA],sssP[pB],sssP[pC]
#if (pD!=-1)
  texture { sssX[pD]
#if(iE!=-1)
  UVWMap(sssP[pA],sssP[pB],sssP[pC],sssM[iE],sssM[pF],sssM[pG])
#end
  }
#end
}

#local iI=iI+1; #end

#end

#macro MakeSmoothTriangles()

#local cT=dimension_size(sssT,1);
#local cD=dimension_size(sssT,2);
#local cP=dimension_size(sssP,1);

#local Norm=array[cP]

#local iI=0; #while(iI<cP)
  #local Norm[iI]=<0,0,0>;
#local iI=iI+1; #end

#local iI=0; #while(iI<cT)

  #local pA=sssT[iI][0];
  #local pB=sssT[iI][1];
  #local pC=sssT[iI][2];

  #local vN=vcross(sssP[pB]-sssP[pA],sssP[pC]-sssP[pA]);

  #local Norm[pA]=Norm[pA]+vN;
  #local Norm[pB]=Norm[pB]+vN;
  #local Norm[pC]=Norm[pC]+vN;

#local iI=iI+1; #end

#local iI=0; #while(iI<cT)

#local pA=sssT[iI][0];
#local pB=sssT[iI][1];
#local pC=sssT[iI][2];

#if (cD>3)
  #local pD=sssT[iI][3];
#else
  #local pD=-1;
#end

#if (cD>4)
  #local iE=sssT[iI][4];
  #local pF=sssT[iI][5];
  #local pG=sssT[iI][6];
#else
  #local iE=-1;
  #local pF=-1;
  #local pG=-1;
#end  

smooth_triangle {
  sssP[pA],Norm[pA],
  sssP[pB],Norm[pB],
  sssP[pC],Norm[pC]
#if (pD!=-1)
  texture { sssX[pD]
#if(iE!=-1)
  UVWMap(sssP[pA],sssP[pB],sssP[pC],sssM[iE],sssM[pF],sssM[pG])
#end
  }
#end
}

#local iI=iI+1; #end

#end

#macro RoughenMesh(N,S)

#local S0=seed(S);
#local cT=dimension_size(sssT,1);
#local cP=dimension_size(sssP,1);

#local Norm=array[cP]
#local iI=0; #while(iI<cP)
  #local Norm[iI]=<0,0,0>;
#local iI=iI+1; #end

#local Area=array[cP]
#local iI=0; #while(iI<cP)
  #local Area[iI]=0;
#local iI=iI+1; #end

#local iI=0; #while(iI<cT)

  #local pA=sssT[iI][0];
  #local pB=sssT[iI][1];
  #local pC=sssT[iI][2];

  #local vN=vcross(sssP[pB]-sssP[pA],sssP[pC]-sssP[pA]);
  #local Norm[pA]=Norm[pA]+vN;
  #local Norm[pB]=Norm[pB]+vN;
  #local Norm[pC]=Norm[pC]+vN;

  #local sA=vlength(vN)/2;
  #local Area[pA]=Area[pA]+sA;
  #local Area[pB]=Area[pB]+sA;
  #local Area[pC]=Area[pC]+sA;

#local iI=iI+1; #end

#local iI=0; #while(iI<cP)

#local sN=(N)*sqrt(Area[iI])*(rand(S0)-rand(S0));

#local vN=vnormalize(Norm[iI]);

#declare sssP[iI]=sssP[iI]+sN*vN;

#local iI=iI+1; #end

#end // end of macro call

// a macro to add stuff to the mesh
#macro AddStuff(PtArray,TriArray)

#local cXP=dimension_size(PtArray,1);
#local cXT=dimension_size(TriArray,1);

#ifdef(sssP)
  #local cP=dimension_size(sssP,1);
  #local tP=array[cP]
  #local iI=0; #while (iI<cP)
    #local tP[iI]=sssP[iI];
  #local iI=iI+1; #end
  #undef sssP
#else
  #local cP=0;
#end

#declare sssP=array[cP+cXP]  

#local iI=0; #while(iI<cP)
  #declare sssP[iI]=tP[iI];
#local iI=iI+1; #end

#local iI=0; #while(iI<cXP)
  #declare sssP[iI+cP]=PtArray[iI];
#local iI=iI+1; #end

#ifdef(sssT)
  #local cT=dimension_size(sssT,1);
  #local tT=array[cT][3]
  #local iI=0; #while (iI<cT)
    #local tT[iI][0]=sssT[iI][0];
    #local tT[iI][1]=sssT[iI][1];
    #local tT[iI][2]=sssT[iI][2];
  #local iI=iI+1; #end
  #undef sssT
#else
  #local cT=0;
#end

#declare sssT=array[cT+cXT][3]
  
#local iI=0; #while(iI<cT)
  #declare sssT[iI][0]=tT[iI][0];
  #declare sssT[iI][1]=tT[iI][1];
  #declare sssT[iI][2]=tT[iI][2];
#local iI=iI+1; #end

#local iI=0; #while(iI<cXT)
  #declare sssT[iI+cT][0]=TriArray[iI][0]+cP;
  #declare sssT[iI+cT][1]=TriArray[iI][1]+cP;
  #declare sssT[iI+cT][2]=TriArray[iI][2]+cP;
#local iI=iI+1; #end

#end // end of macro

#macro Add20Sider(vX,vY,vZ,vL)

#local sA=(sqrt(5)+1)/4;
#local sB=.5;

#local PArray=array[12] {
  vX*sA+vY*sB+vL,  vY*sA+vZ*sB+vL,  vZ*sA+vX*sB+vL,
 -vX*sA+vY*sB+vL, -vY*sA+vZ*sB+vL, -vZ*sA+vX*sB+vL,
  vX*sA-vY*sB+vL,  vY*sA-vZ*sB+vL,  vZ*sA-vX*sB+vL,
 -vX*sA-vY*sB+vL, -vY*sA-vZ*sB+vL, -vZ*sA-vX*sB+vL
}

#local TArray=array[20][3] {
{0, 1, 2},{0, 7, 1},{0, 5, 7},{0, 6, 5},{0, 2, 6},
{1, 8, 2},{1, 3, 8},{1, 7, 3},{2, 4, 6},{2, 8, 4},
{6, 4,10},{6,10, 5},{4, 8, 9},{4, 9,10},{5,10,11},
{5,11, 7},{3, 7,11},{3, 9, 8},{3,11, 9},{9,11,10}
}

AddStuff(PArray,TArray)
#end

#macro Add8Sider(vX,vY,vZ,vL)

#local PArray=array[6] {
  vX+vL,vY+vL,vZ+vL,vL-vX,vL-vY,vL-vZ
}

#local TArray=array[8][3] {
  {0, 1, 2},{3, 1, 2},{0, 4, 2},{3, 4, 2},
  {0, 1, 5},{3, 1, 5},{0, 4, 5},{3, 4, 5}
}

AddStuff(PArray,TArray)
#end

#macro AddTetrahedron(pA,pB,pC,pD)

#local PArray=array[4] { pA,pB,pC,pD }

#local TArray=array[4][3] { {0,1,2},{0,3,1},{0,2,3},{1,3,2} }

AddStuff(PArray,TArray)
#end

#macro ScaleMesh(ScaleVector)
  #local vS=<0,0,0>+ScaleVector;

  #if (vS.x=0)
    #warning "Components of scale vector must be non-zero; 1 subsituted.\n"
  #local vS=<1,vS.y,vS.z>;
  #end
  #if (vS.y=0)
    #warning "Components of scale vector must be non-zero; 1 subsituted.\n"
  #local vS=<vS.x,1,vS.z>;
  #end
  #if (vS.z=0)
    #warning "Components of scale vector must be non-zero; 1 subsituted.\n"
  #local vS=<vS.x,vS.y,1>;
  #end

  #local cP=dimension_size(sssP,1);
  #local iI=0; #while (iI<cP)
    #declare sssP[iI]=sssP[iI]*vS;
  #local iI=iI+1; #end
#end

#macro RotateMesh(RotateVector)
  #local cP=dimension_size(sssP,1);
  #local iI=0; #while (iI<cP)
    #declare sssP[iI]=vrotate(sssP[iI],RotateVector);
  #local iI=iI+1; #end
#end

#macro TranslateMesh(TranslateVector)
  #local cP=dimension_size(sssP,1);
  #local iI=0; #while (iI<cP)
    #declare sssP[iI]=sssP[iI]+TranslateVector;
  #local iI=iI+1; #end
#end

#macro MatrixMesh(vX,vY,vZ,vL)
  #local cP=dimension_size(sssP,1);
  #local iI=0; #while (iI<cP)
    #declare sssP[iI]=sssP[iI].x*vX + sssP[iI].y*vY + sssP[iI].z*vZ + vL;
  #local iI=iI+1; #end
#end

#macro UserTransformMesh()
  #local cP=dimension_size(sssP,1);
  #local iI=0; #while(iI<cP)
    #declare sssP[iI]=UserTransform(sssP[iI]);
  #local iI=iI+1; #end
#end

#macro AddBicubicSheet(Array)

#end
