// .inc file to prepare a mesh for the Loop method of mesh subdivision
// this need only be done to the original mesh; the subdivider creates
// all of the info needed to complete the job.

// This preparation needs only to be done for later use by the
// subdivider, and then only before the first subudivision.

// the user does have to supply two arrays:
// sssP[] contains the <x,y,z> coordinates of each point.
// sssT[][3/4/7] contains indexes of the sssP at the corners of the
// sssT:
//    sssT[][0] contains the index of the first point
//    sssT[][1] contains the index of the second point
//    sssT[][2] contains the index of the third point
//    sssT[][3] contains the index of the triangle's texture
//    sssT[][4] contains the texture mapping index of the 1st point
//    sssT[][5] contains the texture mapping index of the 2nd point
//    sssT[][6] contains the texture mapping index of the 3rd point
// The user can supply the first three values and get triangles that
// are textured by the mesh that contains them.  The user can supply
// a fourth value and get individual texturing, or supply all seven
// values and get UVW-mapping of the resulting object (which must
// then be a union of triangles, hogging up lots of extra memory).
//
// I did things this way because some triangles in the defining hull
// might share one or more points that aren't intended to cause a
// connection.  The only way to tell is to explicitly declare the
// points and triangles.

#macro PrepMesh()

#ifdef(sssE) #undef sssE #end

#local cT=dimension_size(sssT,1);

// sssT[][] will be expanded to sssT[][10], if it isn't
// already that size.

#local tS=dimension_size(sssT,2);

#if (tS!=10)
  #local Temp=array[cT][tS]

  #local iI=0; #while(iI<cT)
  #local iJ=0; #while(iJ<tS)
    #local Temp[iI][iJ]=sssT[iI][iJ];
  #local iJ=iJ+1; #end
  #local iI=iI+1; #end

  #undef sssT
  #declare sssT=array[cT][10]

  #local iI=0; #while(iI<cT)
    #local iJ=0; #while(iJ<tS)
      #declare sssT[iI][iJ]=Temp[iI][iJ];
    #local iJ=iJ+1; #end
    #if (tS<4)
      #declare sssT[iI][3]=-1;
    #end
    #if (tS<7)
      #declare sssT[iI][4]=-1;
      #declare sssT[iI][5]=-1;
      #declare sssT[iI][6]=-1;
    #end
  #local iI=iI+1; #end

  #undef Temp
#end

// Now we need to find where all of the edges are.
// This involves constructing an edge for every side of every triangle,
// and then sorting through to find duplicates.

#local cE=cT*3; // there probably will be only half this many, but we
// won't know which to eliminate just yet.

#local TempEdge=array[cE][3] // just the start and end for now, plus a
// matchmaker

#local iE=0;
#local iI=0; #while (iI<cT)
  #local pA=sssT[iI][0];
  #local pB=sssT[iI][1];
  #local pC=sssT[iI][2];
  
  #if(pA<pB)
    #local TempEdge[iE][0]=pA;
    #local TempEdge[iE][1]=pB;
  #else
    #local TempEdge[iE][0]=pB;
    #local TempEdge[iE][1]=pA;
  #end  
  #declare sssT[iI][7]=iE;
  #local TempEdge[iE][2]=iE;
  #local iE=iE+1;

  #if(pB<pC)
    #local TempEdge[iE][0]=pB;
    #local TempEdge[iE][1]=pC;
  #else
    #local TempEdge[iE][0]=pC;
    #local TempEdge[iE][1]=pB;
  #end  
  #declare sssT[iI][8]=iE;
  #local TempEdge[iE][2]=iE;
  #local iE=iE+1;

  #if(pA<pC)
    #local TempEdge[iE][0]=pA;
    #local TempEdge[iE][1]=pC;
  #else
    #local TempEdge[iE][0]=pC;
    #local TempEdge[iE][1]=pA;
  #end  
  #declare sssT[iI][9]=iE;
  #local TempEdge[iE][2]=iE;
  #local iE=iE+1;

#local iI=iI+1; #end

// Now to eliminate duplicates we have to compare each edge to
// every other edge.

#local Final=iE;

#local iI=0; #while (iI<iE-1)
  #if (TempEdge[iI][0]>-1)
    #local iJ=iI+1; #while(iJ<iE)
      #if (TempEdge[iI][0]=TempEdge[iJ][0])
        #if (TempEdge[iI][1]=TempEdge[iJ][1])
          // we have a duplicate
          #local TempEdge[iJ][0]=-1;
          #local TempEdge[iJ][2]=iI; // refer back
          #local Final=Final-1;
          #local iJ=iE; // no need to check the remaining sssE
        #end
      #end
    #local iJ=iJ+1; #end
  #end
#local iI=iI+1; #end

// now we set the triangles to refer solely to the non-duplicates
#local iI=0; #while(iI<cT)
  #declare sssT[iI][7]=TempEdge[sssT[iI][7]][2];
  #declare sssT[iI][8]=TempEdge[sssT[iI][8]][2];
  #declare sssT[iI][9]=TempEdge[sssT[iI][9]][2];
#local iI=iI+1; #end

// now we boil down the sssE
#declare sssE=array[Final][4]

#local iJ=0;
#local iI=0; #while(iI<iE)
  #if (TempEdge[iI][0]>-1)
    #declare sssE[iJ][0]=TempEdge[iI][0];
    #declare sssE[iJ][1]=TempEdge[iI][1];
    #local TempEdge[iI][2]=iJ;
    #local iJ=iJ+1;
  #end
#local iI=iI+1; #end

// now we set the sssT to refer to the final edge numbers
#local iI=0; #while(iI<cT)
  #declare sssT[iI][7]=TempEdge[sssT[iI][7]][2];
  #declare sssT[iI][8]=TempEdge[sssT[iI][8]][2];
  #declare sssT[iI][9]=TempEdge[sssT[iI][9]][2];
#local iI=iI+1; #end

#local iI=0; #while(iI<Final)
  #declare sssE[iI][2]=-1;
  #declare sssE[iI][3]=-1;
#local iI=iI+1; #end

#local iI=0; #while(iI<cT)
  #local jE=sssT[iI][7];
  #if (sssE[jE][2]=-1)
    #declare sssE[jE][2]=iI;
  #else
    #declare sssE[jE][3]=iI;
  #end
  #local jE=sssT[iI][8];
  #if (sssE[jE][2]=-1)
    #declare sssE[jE][2]=iI;
  #else
    #declare sssE[jE][3]=iI;
  #end
  #local jE=sssT[iI][9];
  #if (sssE[jE][2]=-1)
    #declare sssE[jE][2]=iI;
  #else
    #declare sssE[jE][3]=iI;
  #end
#local iI=iI+1; #end

// And now for the last step.  The sssT are all massaged so that
// they all have the same handedness, meaning that the corners all go
// either clockwise or counter-clockwise when viewed from the "outside"
// of the mesh.  This is needed for the normal smoothing, mainly.

// Basically, all sssT are marked as undone.  Then the first
// undone one is pushed onto the stack.  Then the one on top of
// the stack is pulled, marked done, and if it borders on any undone
// ones, they are pushed onto the stack and checked, and if their points
// go in the wrong direction, they are turned around.  When the stack
// is empty, the array is checked for any undone ones, and if this is
// so, the whole stack process repeats.

#local Stack=array[cT]
#local iP=0;

#local Done=array[cT]
#local iI=0; #while(iI<cT)
  #local Done[iI]=0;
#local iI=iI+1; #end

#local Loop=1;
#while (Loop=1)
#local Loop=0;

#local iI=0; #while(iI<cT & Loop=0)
  #if (Done[iI]=0)
    #local Loop=1;
    #local Stack[0]=iI;
    #local iP=1;
  #end
#local iI=iI+1; #end    

#while(iP>0)
  #local iP=iP-1;
  #local iI=Stack[iP];
  #local Done[iI]=1;
  #local pA=sssT[iI][0];
  #local pB=sssT[iI][1];
  #local pC=sssT[iI][2];

  #local iS=7; #while(iS<10)
    #local iE=sssT[iI][iS];
    #local iJ=sssE[iE][2];
    #if (iJ=iI) #local iJ=sssE[iE][3]; #end
    #if (iJ>=0)
      #if (Done[iJ]=0)
        #local Stack[iP]=iJ;
        #local iP=iP+1;
        #local pD=sssT[iJ][0];
        #local jE=sssT[iJ][1];
        #local pF=sssT[iJ][2];
    
        #local FlipFlag=0;
        #if(pA=pD & pB=jE) #local FlipFlag=1; #end
        #if(pA=pD & pC=pF) #local FlipFlag=1; #end
        #if(pA=jE & pB=pF) #local FlipFlag=1; #end
        #if(pA=jE & pC=pD) #local FlipFlag=1; #end
        #if(pA=pF & pB=pD) #local FlipFlag=1; #end
        #if(pA=pF & pC=jE) #local FlipFlag=1; #end
        #if(pB=pD & pC=jE) #local FlipFlag=1; #end
        #if(pB=jE & pC=pF) #local FlipFlag=1; #end
        #if(pB=pF & pC=pD) #local FlipFlag=1; #end
      
        #if (FlipFlag=1)
// the 2nd and 3rd points get switched
          #local iTemp=sssT[iJ][1];
          #declare sssT[iJ][1]=sssT[iJ][2];
          #declare sssT[iJ][2]=iTemp;

// this requires switching the UVW mapping for the 2nd and third points
          #local iTemp=sssT[iJ][5];
          #declare sssT[iJ][5]=sssT[iJ][6];
          #declare sssT[iJ][6]=iTemp;

// and the 1st and 3rd edges (the 2nd edge connects the swapped points
// and consequently is not affected).
          #local iTemp=sssT[iJ][7];
          #declare sssT[iJ][7]=sssT[iJ][9];
          #declare sssT[iJ][9]=iTemp;
        #end
      #end
    #end
  #local iS=iS+1; #end
#end

#end

#end // end of macro call
