#include "tekstury.inc"

#declare IMPORT_SPATCH = 1;

#macro pile (v1,v2,r)
 sphere { v1,r }
 sphere { v2,r }
 cylinder { v1,v2,r }
#end

#declare bot1_body = merge {
 object {
  #include "bot1.torso.inc"
  translate <-0.2,-.7,.5>
  texture { obudowa1}
 }
 union {
  #declare step = (2 * pi / 16);
  #declare promien = .36;
  #declare zmienna = 0;
  #while (zmienna < ( 2 * pi ))
   #declare zmiennax = promien * sin (zmienna);
   #declare zmiennaz = promien * cos (zmienna);
   sphere { <zmiennax 0 zmiennaz > .02 translate <0,.09,0>}
   #declare zmienna = zmienna + step;
  #end
  #declare step = (2 * pi / 16);
  #declare promien = .12;
  #declare zmienna = 0;
  #while (zmienna < ( 2 * pi ))
   #declare zmiennax = promien * sin (zmienna);
   #declare zmiennaz = promien * cos (zmienna);
   sphere { <zmiennax 0 zmiennaz > .01 translate <.1,.45,.1>}
   #declare zmienna = zmienna + step;
  #end
  texture { metal}
 }
 union {
  superellipsoid { <1, .3> rotate x*90 scale <.4,.1,.4>}
  superellipsoid { <1, .3> rotate x*90 scale <.32,.2,.32> translate <0,.25,0>}
  cylinder { 0, y*.1, .15 translate <.1,.35,.1> }
  cylinder { 0, y*.1, .08 translate <.1,.40,.1> } texture { obudowa1} }
  cylinder {    0, y*2.20, .025 translate <.1,.40,.1> texture { metal}}
  cylinder {y*2.2, y*2.25, .03 translate <.1,.40,.1> texture { pigment {color Green*2} finish {ambient Green*2 diffuse 1 }}
 }
}

#declare bot2_body = merge {
 object {
  #include "bot1.torso.inc"
  translate <-0.2,-.7,.5>
  texture { obudowa1}
 }
 union {
  #declare step = (2 * pi / 16);
  #declare promien = .36;
  #declare zmienna = 0;
  #while (zmienna < ( 2 * pi ))
   #declare zmiennax = promien * sin (zmienna);
   #declare zmiennaz = promien * cos (zmienna);
   sphere { <zmiennax 0 zmiennaz > .02 translate <0,.09,0>}
   #declare zmienna = zmienna + step;
  #end
  texture { metal}
 }
 union {
  superellipsoid { <1, .3> rotate x*90 scale <.4,.1,.4>}
  superellipsoid { <1, .3> rotate x*90 scale <.32,.2,.32> translate <0,.25,0>}
  cylinder { 0, y*.1, .15 translate <.1,.35,.1> }
  texture { obudowa1}
 }
}

#declare ramie =  union {
 #local grubosc = .2;
 #local wysokosc = 1;
 union {
  cylinder { 0, -z*grubosc, .18 }
  cylinder { 0, -z*grubosc, .12 translate y*wysokosc}
  prism {
   linear_sweep
   linear_spline
   0, grubosc, 4
   <-.18,0>,
   < .18,0>,
   < .12,wysokosc>,
   <-.12,wysokosc>
   rotate -x*90
  }
  texture { obudowa1}
 }
 superellipsoid { <1, .3> scale <.07,.07,.05> translate <0,0,-grubosc*.9> texture { metal_mat} }
 superellipsoid { <1, .3> scale <.1,.1,.05> translate <0,wysokosc,-grubosc*.9> texture{guma}}
 torus { .17, .01 rotate x*90 translate <0,0,-grubosc> texture{guma}}
 union {
  #declare step = (2 * pi / 10);
  #declare promien = .12;
  #declare zmienna = 0;
  #while (zmienna < ( 2 * pi ))
   #declare zmiennax = promien * sin (zmienna);
   #declare zmiennaz = promien * cos (zmienna);
   sphere { <zmiennax, zmiennaz, 0> .02 scale <1,1,.5> translate <0,0,-grubosc>}
   #declare zmienna = zmienna + step;
  #end
  texture { metal}
 }
 scale <1.5,1.5,1>
}

#declare eyeshield = object {
 #include "eyeshield.inc"
 rotate y*180
}

#declare eye = merge {
 cylinder { 0,2*x , .3 texture { plastik } }
 union {
  box { -1,1 scale <.3,.03,.3> rotate z*45 translate <.2,-.3,0>}
  box { -1,1 scale <.3,.03,.3> rotate z*45 translate <.2,-.3,0> rotate x*90 }
  box { -1,1 scale <.3,.03,.3> rotate z*45 translate <.2,-.3,0> rotate x*180 }
  box { -1,1 scale <.3,.03,.3> rotate z*45 translate <.2,-.3,0> rotate -x*90}
  texture{guma pigment { color rgb .4} }
 }
 torus { .3, .1 rotate z*90 translate x*.1 texture { plastik }}
 torus { .18, .1 rotate z*90 translate x*.05 scale <.3,1,1> texture { metal_mat}}
 sphere {0,.1 scale <.5,1,1> texture { soczewka }}
}

#declare eyes = union {
 object {eye }
 object {eye translate z*1.2}
 object {eyeshield scale <1,1,1.5> translate <1.1,-.4,-.5>
  texture { obudowa1 }
 }
 union {
  difference {
   torus { 1,.5 }
   plane {y,0}
   scale .5 translate -y*.05 texture { metal}
  }
  sphere { 0,.3 texture{guma pigment { color rgb .4} } }
  cylinder {0,1.5*y,.025 texture { metal}}
  cylinder {1.5*y,1.6*y,.03 texture { pigment {color Red*2} finish {ambient Red*2 diffuse 1}}}
  translate <1,.5,.5>
 }
 union {
  cylinder { 0,y,.5}
  sphere { 0,.5 }
  scale .5
  translate <1.5,-.5,.6>
  texture { metal_mat }
 }
 translate <-1.5,.5,-.6>
}

#macro oczy(ALPHA,GAMMA)
union {
 #local lewo = 2;
 #local prawo = 4;
 union {
  cylinder {-prawo*x,lewo*x,.1 translate <0, .2,0> }
  cylinder {-prawo*x,lewo*x,.1 translate <0,-.2,0> }
  texture { metal}
 }
 union {
  superellipsoid { <0.1, .4> scale <.2,.5,.2> translate <lewo,0,0>}
  superellipsoid { <0.1, .4> scale <.2,.5,.2> translate <-prawo,0,0>}
  superellipsoid { <1, .3> scale <.4,.4,.05> translate <0,0,-0.2>}
  superellipsoid { <0.1, .4> scale <.6,.5,.2> translate <0,0,0>}
  texture { obudowa1}
 }
 union {
  torus { .1, .05 rotate z*90 translate <.6,.2,0>}
  torus { .1, .05 rotate z*90 translate <.6,-.2,0>}
  torus { .1, .05 rotate z*90 translate <-.6,.2,0>}
  torus { .1, .05 rotate z*90 translate <-.6,-.2,0>}
  torus { .1, .05 rotate z*90 translate <lewo-.2,.2,0>}
  torus { .1, .05 rotate z*90 translate <lewo-.2,-.2,0>}
  torus { .1, .05 rotate z*90 translate <-prawo+.2,.2,0>}
  torus { .1, .05 rotate z*90 translate <-prawo+.2,-.2,0>}
  texture{guma}
 }
 object {eyes rotate y*ALPHA rotate z*GAMMA translate <-prawo,.6,0>}
 scale .5
}
#end

#declare finger = object {
 #include "finger.inc"
 rotate z*120
 scale .2
 texture{guma pigment { color rgb .7} }
}

#declare reka = union {
 #local lewo = 2;
 #local prawo = 4;
 difference {
  box { <lewo, -.3,-.1>,<-prawo,.3,.1> }
  box { <lewo, -.3,-.1>*.8,<-prawo,.3,.1>*.8 translate -z*.15 }
  texture { metal_jasny}
 }
 union {
  box {<lewo, -.3,-.1>*.7,<-prawo,.3,.1>*.7 scale <1,.7,1> translate <-.2,0,-.03> }
  box {-1,1 scale <.2,.4,.12> translate <lewo-.1,0,0> }
  box {-1,1 scale <.2,.4,.12> translate <-prawo+.1,0,0> }
  box {-1,1 scale <.7,.4,.12> }
  texture{guma}
 }
 union {
  superellipsoid { <0.1, .4> scale <.2,.5,.2> translate <lewo,0,0>}
  superellipsoid { <0.1, .4> scale <.2,.5,.2> translate <-prawo,0,0>}
  superellipsoid { <0.1, .4> scale <.6,.5,.2> translate <0,0,0>}
  texture { obudowa1}
 }
 union {
  cylinder { <-prawo-.5,0,0>, <-prawo,0,0>, .2 }
  sphere {<-prawo-.5,0,0>, .2 }
  texture { metal_mat }
 }
 union {
  pile (<lewo,0,0>,<lewo+.5,0,0>.2)
  pile (<lewo+.5,0,0>,<lewo+.7,.7,0>,.2)
  texture { metal_mat }
 }
// object { gun rotate y*10 translate <lewo+.7,.8,0> }
 object { finger translate <-prawo*1.3,.45,0>}
 object { finger translate <-prawo*1.3,.45,0> rotate x*120}
 object { finger translate <-prawo*1.3,.45,0> rotate -x*120}
 scale .5
}

#local dlugosc = 2.8;
#local grubosc = .3;
#local srednica = .5;
#declare oponki = union {
 cylinder { <-dlugosc/2, 0,-grubosc/2>, <-dlugosc/2,0,grubosc/2>, srednica }
 cylinder { < dlugosc/2, 0,-grubosc/2>, < dlugosc/2,0,grubosc/2>, srednica }
 box { <-dlugosc/2,-srednica,-grubosc/2> , <dlugosc/2, srednica, grubosc/2 > }
 texture{ guma pigment { color rgb .6 } }
}

#declare gasienica = difference {
 object { oponki }
 object { oponki scale <.98,.9,2>}
}

#declare kolko = union {
 union {
  torus {srednica, srednica * .2 rotate x*90}
  torus { .35, .03 rotate x*90 translate -z*.07}
  superellipsoid { <1, .4> scale <.25,.25,.1>}
  texture{guma}
 }
 cylinder { -z*grubosc/4, z*grubosc/4, srednica*.98 texture { metal_mat} }
}

#declare naped = union {
 object { gasienica }
 object { kolko scale .8 translate -x*dlugosc/2}
 object { kolko scale .8 translate  x*dlugosc/2}
 object { kolko scale .3 translate  <dlugosc/5.4,-srednica/1.8,0>}
 object { kolko scale .3 translate  <-dlugosc/5.4,-srednica/1.8,0>}
 object { kolko scale .3 translate  <0,-srednica/2,0>}
}

#declare swiatlo = union {
 superellipsoid { <1, .4> texture { plastik_bialy }}
 union {
  box {-1,1 translate x*.5}
  box {<1,1,1>,<-1.5,1.1,-1> translate x*.5}
  texture { obudowa1}
 }
 scale .2
 rotate -z*35
}

#declare bot1 = union {
 object { bot1_body }
 object { ramie }
 object { ramie  rotate y*180 rotate -z*75 translate <0,.4,.3> }
 object { oczy(55,0) translate <0,1.5,.2> }
 object { reka rotate z*5 translate <1.45,0.9,.2> }
 object { naped translate <-.7,-1.25, .6>}
 object { naped translate <-.7,-1.25,-.6>}
// object { swiatlo translate <-2,-.7,-.6>}
// object { swiatlo translate <-2,-.7, .6>}
}

#declare bot2 = union {

// object { bot2_body }
 object { ramie rotate -z*10 translate <0,.4,-.3>}
 object { ramie rotate y*180 rotate -z*75 translate <0,.4,.3> }
 object { reka  rotate z*5 translate <1.45,0.9,.2> }
 object { oczy(-79,0)  translate <.28,1.9,-.2> }
// object { naped translate <-.7,-1.25, .6>}
// object { naped translate <-.7,-1.25,-.6>}
// object { swiatlo translate <-2,-.7,-.6>}
// object { swiatlo translate <-2,-.7, .6>}

}
#declare bot3 = union {
// object { bot2_body }
 object { ramie rotate -z*20 translate <0,.4,-.3>}
 object { ramie rotate y*180 rotate -z*75 translate <0,.4,.3> }
 object { reka  rotate -z*15 translate <1.45,0.9,.2> }
 object { oczy(-55,20)  rotate -z*20 translate <.28,1.9,-.2> }
// object { naped translate <-.7,-1.25, .6>}
// object { naped translate <-.7,-1.25,-.6>}
// object { swiatlo translate <-2,-.7,-.6>}
// object { swiatlo translate <-2,-.7, .6>}

}

#declare bot4 = union {
// object { bot2_body }
 object { ramie rotate -z*20 translate <0,.4,-.3>}
 object { ramie rotate y*180 rotate -z*75 translate <0,.4,.3> }
 object { reka  rotate -z*7 translate <1.45,0.9,.2> }
 object { oczy(70,10)  rotate -z*10 translate <.28,1.9,-.2> }
// object { naped translate <-.7,-1.25, .6>}
// object { naped translate <-.7,-1.25,-.6>}
// object { swiatlo translate <-2,-.7,-.6>}
// object { swiatlo translate <-2,-.7, .6>}

}

