#include "math.inc"
#include "colors.inc"
#include "glass.inc"
#include "textures.inc"
#include "metals.inc"
 
#declare MINOR = .03;
#declare MAJOR = .4;    
 
#macro pile (V1,V2,R)
 sphere { V1,R }
 sphere { V2,R }
 cylinder { V1,V2,R }
#end
           
#declare white_plastic =
texture {
  pigment { color rgb <1, 1, 1> }
  finish {ambient 0.1 diffuse 0.9 phong 0.5 phong_size 100 }
}
#declare gray_plastic =
texture {
  pigment { color rgb <1, 1, 1>*.8 }
  finish {ambient 0.1 diffuse 0.8 phong 0.5 phong_size 100 }
}

#declare tank0 = merge {
 sphere {0,.4 translate -x}
 sphere {0,.4 translate  x}
 cylinder { -x, x, .4 }
} 

#declare girl = object {
 #include "hologirl.inc"
 rotate y*90
 scale .0133
} 

#macro VR_TANK0(ON)
union {
 #if(ON)
 #local VRLIGHT=.1; 
 light_group {
  light_source { 0, VRLIGHT translate <-.9,0, .3>}
  light_source { 0, VRLIGHT translate <-.9,0,-.3>}
  light_source { 0, VRLIGHT translate <  0,0, .3>}
  light_source { 0, VRLIGHT translate <  0,0,-.3>}
  light_source { 0, VRLIGHT translate < .7,0, .3>}
  light_source { 0, VRLIGHT translate < .7,0,-.3>}
 #end
  object { tank0 scale .999 texture {NBglass pigment { rgbf <0.85, 0.88, 0.95, 0.7> } } interior {Glass_Interior ior 1.32 } photons { target reflection on refraction on}}
  box { -1,1 scale <1,.02,.3> translate -y*.2 }
  cylinder { -z,z,.1 scale <1,1,.3> translate <-.9,-.15,0> }
  cylinder { -x,x,.07  translate <0,-.15,-.32> } 
  cylinder { -x,x,.07  translate <0,-.15, .32> } 
  sphere { 0,.3 scale <.5,1,1> translate -x*1.01 }
 #if(ON) 
  object{girl rotate z*90 translate <.8,-.5,0>}
 }
 #end 

 difference {
  object { tank0 }
  box { <-.6,0,-.8>,<1.1,.5,.8>}
  object { tank0 scale .95 }
  object { cylinder {-z,z,.4 translate <-.6,.4,0> }}
 }
 torus { MAJOR, MINOR scale <1,.2/MINOR,1> rotate z*90 translate x*.9}
 torus { MAJOR, MINOR scale <1,.1/MINOR,1> rotate z*90 translate x*.5}
 torus { MAJOR, MINOR scale <1,.2/MINOR,1> rotate z*90 translate -x*1.1}
 superellipsoid { <0.1, .4>  scale <MAJOR*.3, MAJOR*.3, MAJOR*.1> translate < 0.9,0,-MAJOR>} 
 superellipsoid { <0.1, .4>  scale <MAJOR*.3, MAJOR*.3, MAJOR*.1> translate < 0.9,0, MAJOR>} 
 sphere_sweep { cubic_spline 6, <  2.00,  0, -.4>, .02 <  1.00,  0, -.4>, .02 < -0.73,  0, -.4>, .02 < -0.82, .05, -.38>, .02 < -0.90, .15, -.36>, .02 < -1.00, .20, -.34>, .02 }
 sphere_sweep { cubic_spline 6, <  2.00,  0, .4>, .02 <  1.00,  0, .4>, .02 < -0.73,  0, .4>, .02 < -0.82, .05, .38>, .02 < -0.90, .15, .36>, .02 < -1.00, .20, .34>, .02}
 texture { white_plastic }
}
#end 

#declare VR_TANK2 = union {
  intersection {
   torus { MAJOR, MINOR scale <1,.2/MINOR,1> }
   cylinder { -z,z,MAJOR/2 }
  } 
  torus { MAJOR, MINOR scale <1,.2/MINOR,1> clipped_by { plane {x,0}}}
  rotate z*90 scale <.5,1.2,1.2> translate -x*1.1
  texture { gray_plastic }
}

#declare VR_TANK1 = union {
  #local LUK = intersection {
   torus { .3,.05 }
   box {0,1 translate -.5*y}
   rotate <-90,90,0>
  }
  union {
   object { LUK translate <.9,-.3,-.42>}
   object { LUK rotate y*180 translate <.9,-.3,.42>}
   sphere { 0,.09 translate <.9,0,-.42>}
   sphere { 0,.09 translate <.9,0,.42>}
   texture {Aluminum}
   photons { target reflection on refraction off}
  } 
  union {
   cylinder { 0,-y*.5,.05 translate <.9,-.3,-.72> }
   cylinder { 0,-y*.5,.05 translate <.9,-.3,.72> }
   box { -1,1 scale <.21,.1,.7> translate <.9,-.65,0>}
   box { -1,1 scale <.5,.1,.7> translate <.65,-.65,0>}
   cylinder {0,y,1 scale <.21,.1,.21> translate <.9,-.65,.72> } 
   cylinder {0,y,1 scale <.21,.1,.21> translate <.9,-.65,-.72> } 
   superellipsoid { <1, 0.3> rotate x*90 scale .1 translate <.9,-.55,-.72> }
   superellipsoid { <1, 0.3> rotate x*90 scale .1 translate <.9,-.55, .72> }
//   texture{ Brushed_Aluminum scale .5}
   texture{ white_plastic}
  }
  sphere { 0,.09 translate <0,-.55,0> }  
}


#macro VR_TANK(ALPHA,ON)
union {
 object { VR_TANK0(ON) translate -x*.9 rotate -z*ALPHA }
 
 object { VR_TANK1 translate -x*.9 }
 object { VR_TANK2 translate -x*.9 rotate -z*ALPHA }
 #local X = -2*cosd(ALPHA);
 #local Y =  2*sind(ALPHA);
 // ramiona
 union { 
  pile (<-.9,-.55,-.5>,<X,Y,-.5>,.05)
  pile (<-.9,-.55, .5>,<X,Y, .5>,.05)
  texture { Aluminum }
  photons { target reflection on refraction off}
 } 
 superellipsoid { <1, 0.3>  scale .1 translate <X,Y,-.5> }
 superellipsoid { <1, 0.3>  scale .1 translate <X,Y, .5> }
 //siownik
 superellipsoid { <1, 0.3>  scale .5 translate <-.9,-.55, 0> }
 superellipsoid { <1, 0.3>  scale <.3,.3,.7> translate <-.9,-.55, 0>  texture {Aluminum} photons { target reflection on refraction off}}
// pile (<-5,0,2>,<5,0,2>,.005)
// pile (<0,-5,2>,<0,5,2>,.006)
 translate y*.56
 texture { white_plastic }
} 
#end

