// Submitted IRTC scene file
// "gradient.obj.inc"
// (C) 2002 Peter Hertel http://hertel.no/peter
// Feel free to use this scene file to learn, copy only referring to me as author.

// Topic : Dreaming
// Image : gradient.jpg
// Title : Gradient - Alien invasion

// Files included in this zip file:
// gradient.pov - scene control and camera
// gradient.obj.inc - object file
// gradient_paper.png - paper image map (small version)
// gradient.txt - included IRTC text file

// Files not included:
// hand_flat.inc hand_write.inc hand_mat.inc (hand meshes)

// Hope you enjoy!

// Most variables are #declared in gradient.pov

//***************************************************************************************************************************
#if(Light_Type=0)
    #macro Light(Loc) light_source{Loc rgb 1} #end
#else
    #if(Light_Type=1)
        #macro Light(Loc) light_source{Loc rgb 1 fade_distance 25 fade_power 10} #end
    #else
        #macro Light(Loc)
        light_source {Loc rgb 1 area_light <8, 0, 0> <0, 0, 8>
        #if(Light_Type=2) 4,4 adaptive 0 #end
        #if(Light_Type=3) 5,5 adaptive 1 #end
        #if(Light_Type=4) 9,9 adaptive 2 #end
        circular orient fade_distance 25 fade_power 10}
        #end
    #end
#end

#macro Lights(L1,L2,L3)
    #if(L1)Light(<-50,10,0>)#end
    #if(L2)Light(< 0,10,0>)#end
    #if(L3)Light(< 50,10,0>)#end
#end
//***************************************************************************************************************************
    //I wouldn't change these..didn't use them while modelling the last part of the scene :)
    #declare RW = 50;//Room_Width
    #declare RD = 25;//Room_Depth
//***************************************************************************************************************************
    //Finishes
    #declare Metal = //from textures.inc
    finish {
        metallic
        ambient 0.2
        diffuse 0.7
        brilliance 6
        reflection 0.25
        phong 0.75
        phong_size 80
    }
    //TEXTURES
    #declare T1 =
        texture {
            pigment {rgb <0.2,0.5,1>}
            normal {bumps 1 scale 0.5 turbulence 0.5}
            //#if(F)finish {ambient 0.5 reflection 0.2}#end
            #if(F)finish {reflection 0.2}#end
        }
    #declare T2 =
        texture {
            pigment {checker rgb 1 rgb <1,0,0>} scale 0.05
            #if(F)finish {reflection 0.1 specular 0.2 metallic}#end
        }
    //#declare T2 = texture {DMFWood6}//textures.inc
    /*
    #include "woods.inc"
    #declare T2 =
        texture { pigment { P_WoodGrain18A color_map { M_Wood18A }} rotate 10}
        texture { pigment { P_WoodGrain12A color_map { M_Wood18B }} rotate 10}
        texture {
            pigment { P_WoodGrain12B color_map { M_Wood18B }}
            finish { reflection 0.25 }
             rotate 10
        }
    */
    #declare T3 =
        texture {
            pigment {checker rgb 0.5 rgb <1,1,0>} scale 0.1
            #if(F)finish {reflection 0.1}#end
        }
    //Water texture same as T_RF1 but with filter and no normal
    #if(ISO_Water_Detail)
        #declare W1 =
        texture {
            pigment {rgbf <1,1,1,1>}
            #if(F)finish {ambient 0.3 reflection 0.2}#end
        }
        #declare T_W = texture {W1 scale RW translate x*RW/2}
    #else
        #declare T_W = texture {pigment {rgb <0.2,0.5,1>}}
    #end
    
    #declare T_RF1 =
        texture {
            gradient x
                texture_map{
                    [0 T1]
                    [0.8 T1]
                    [1 T2]
                }
        scale RW
        translate x*RW/2
        }
    #declare T_RF2 =
        texture {T2 scale RW translate x*RW/2}
    #declare T_RF3 =
        texture {
            gradient x
                texture_map{
                    [0 T2]
                    [0.2 T3]
                    [1 T3]
                }
        scale RW
        translate x*(RW/2+0.00000001)
        }
//***************************************************************************************************************************
    #local H = 4.5;
    #local D = 6.5;
    #if(First_Room)
        //first room
        box {<-RW-RW/2+1,-1,-RD*D>,<-RW-RW/2,RD*H,RD> texture {T_RF1}}//side wall
        box {<-RW-RW/2,-1,-RD*D>,<-RW/2,0,RD> texture {T_RF1}}//floor
        box {<-RW-RW/2,-1,RD>,<-RW/2,RD*H,RD+1> texture {T_RF1}}//back wall
        box {<-RW-RW/2,-1,-RD*D>,<-RW/2,RD*H,-RD*D-1> texture {T_RF1}}//front wall
        box {<-RW-RW/2,RD*H,-RD*D>,<-RW/2,RD*H+1,RD> texture {T_RF1}}//roof
    #end
    #if(Middle_Room)
        //middle room
        box {<-RW/2,-1,-RD*D>,<RW/2,0,RD> texture {T_RF2}}//floor
        box {<-RW/2,RD*H,-RD*D>,<RW/2,RD*H+1,RD> texture {T_RF2}}//roof
        box {<-RW/2,-1,RD>,<RW/2,RD*H,RD+1> texture {T_RF2}}//back wall
        box {<-RW/2,-1,-RD*D>,<RW/2,RD*H,-RD*D-1> texture {T_RF2}}//front wall
    #end
    #if(Last_Room)
        //last room
        box {<RW+RW/2+1,-1,-RD*D>,<RW+RW/2,RD*H,RD> texture {T_RF3}}//side wall
        box {<RW/2,-1,-RD*D>,<RW+RW/2,0,RD> texture {T_RF3}}//floor
        box {<RW/2,RD*H,-RD*D>,<RW+RW/2,RD*H+1,RD> texture {T_RF3}}//roof
        box {<RW/2,-1,RD>,<RW+RW/2,RD*H,RD+1> texture {T_RF3}}//back wall
        box {<RW/2,-1,-RD*D>,<RW+RW/2,RD*H,-RD*D-1> texture {T_RF3}}//side wall
    #end
//***************************************************************************************************************************
#macro Alien(Rotate,Location)
    #declare T_AB  = texture {pigment {rgb 0.7}           #if(F)finish {Metal}#end}//Alien Body
    #declare T_AH  = texture {pigment {rgb <0.5,0.5,0.6>} #if(F)finish {Metal}#end}//Alien Helmet
    #declare T_AAK = texture {pigment {rgb <1,1,1>}       #if(F)finish {Metal}#end}//Alien Antenna Knob
    union{
        union{
            sphere {y*3,1 texture {T_AH}}
            //Antennas
            union{
                cylinder {y*0,y*2,0.1 texture {T_AH}}
                sphere {y*2,0.2 texture {T_AAK}}
            rotate z*30 translate y*3
            }
            union{
                cylinder {y*0,y*2,0.1 texture {T_AH}}
                sphere {y*2,0.2 texture {T_AAK}}
            rotate z*-30 translate y*3
            }
            cylinder {y*0,y*2,0.25}
        scale 0.8
        rotate Rotate
        scale 1.25
        }
        sphere {0,0.5 scale <1.5,0.5,1.5>}
    scale 0.8
    translate Location
    texture {T_AB}
    }
#end
#macro Boat(Pigment)
    #declare T_Boat1 = texture {pigment {rgb Pigment} #if(F)finish {Metal}#end}//Hull
    #declare T_Boat2 = texture {pigment {rgb Pigment+0.4} #if(F)finish {Metal}#end}//Hull
    #declare T_BoatW = T_Boat1//Poles
    #declare T_BoatF = //Floaters
        texture {
            pigment {rgb 1}
            normal {bumps 0.5 scale 2}
            #if(F)finish {reflection 0.2 phong 0.5 phong_size 80}#end
        }
    #declare T_BoatS = T_BoatF//Seat
        union{
        #macro Boat_P1(Sca,Tra,Top)
            intersection{
                sphere {z*1,3}
                sphere {z*-1,3}
                box {<0,-10,-10>,<10,#if(Top)10#else 1#end,10>}
            scale <3,1,1>
            scale Sca
            translate Tra
            }
        #end
        #local Boat_Shell=
        union{
            Boat_P1(1,x*2.99,1)
            intersection{
                cylinder {<-3,  0, 1 >,<3,0, 1 >,3}
                cylinder {<-3,  0,-1 >,<3,0,-1 >,3}
                box      {<-3,-10,-10>,<3,10, 10>}
            }
            Boat_P1(<-1,1,1>,x*-2.99,0)
        }
        difference{
            object {Boat_Shell translate y*-1 texture {T_Boat1}}
            object {Boat_Shell translate y*-1 scale 0.9 translate y*0.00001 texture {T_Boat2}}
        translate y*3
        }
        //cylinder {y*0.5,y*15,0.2 texture {T_BoatW}}
        #local BFL = 6;
        #local Boat_Float=
            union{
                sphere {0,1 scale <1,0.5,1> translate <4.5,1.5,0> texture {T_BoatS}}
                union{
                    cylinder {<4.5,1.5,-BFL>,<4.5,1.5,BFL>,0.3}
                    cylinder {<2,1.5,-BFL>,<7,1.5,-BFL>,0.3}
                    cylinder {<2,1.5, BFL>,<7,1.5, BFL>,0.3}
                    sphere {<2,1.5,-BFL>,0.3}
                    sphere {<7,1.5,-BFL>,0.3}
                    sphere {<2,1.5, BFL>,0.3}
                    sphere {<7,1.5, BFL>,0.3}
                    torus {1,0.3 rotate z*90 translate <6,0.5,-BFL>}
                    torus {1,0.3 rotate z*90 translate <3,0.5,-BFL>}
                    torus {1,0.3 rotate z*90 translate <6,0.5, BFL>}
                    torus {1,0.3 rotate z*90 translate <3,0.5, BFL>}
                texture {T_BoatW}
                }
                union{
                    sphere   {<2,0.5,-BFL>,1}
                    cylinder {<2,0.5,-BFL>,<7,0.5,-BFL>,1}
                    sphere   {<7,0.5,-BFL>,1}
                    sphere   {<2,0.5, BFL>,1}
                    cylinder {<2,0.5, BFL>,<7,0.5, BFL>,1}
                    sphere   {<7,0.5, BFL>,1}
                texture {T_BoatF}
                }
            }
        object {Boat_Float}
        object {Boat_Float translate x*-10}
    }
#end//End boat macro
//***************************************************************************************************************************
#if(Stuff_First_Room)
    object {Boat(0.5) scale 0.75 rotate <1,20,-7> translate <-RW-10,2,10>}
    object {Alien(y*90,<-4.5,1.5,0>) rotate <1,20,-4> translate <-RW-10,2,10>}
#end
//new water
#if(ISO_Water)
    #declare fn_Pigm=function {
        pigment {
          wrinkles
          color_map {
            [0 color rgb 0]
            [1 color rgb 1]
          }
        }
      }
    isosurface {
        //function { y+f_noise3d(x, 0, z) }
        function { y-fn_Pigm(x/2, 0, z/2).gray*0.8}//[.gray*0.25]

            max_gradient 1
            accuracy 0.04
            contained_by { box { <-26/2,-4,-26/2>, 25/2 }}
        rotate z*-7
        scale <3,2,3> translate <-RW,1.35,0>
        interior {ior 1.33}
        texture {T_W}
    }
#end
/*
//Old water
#if(ISO_Water)
    isosurface {
        function { y+f_noise3d(x, 0, z) }
            max_gradient 1
            accuracy 0.04
            contained_by { box { <-26/2,-4,-26/2>, 25/2 }}
        rotate z*-5
        scale <2,2,2> translate <-RW,3,0>
        interior {ior 1.33}
        texture {T_W}
    }
#end
*/
//***************************************************************************************************************************
#declare Pen =
    #declare F_Pen =
        finish {
            ambient 0.2
            //diffuse 0.7
            brilliance 2
            reflection 0.1
            phong 0.75
            phong_size 50
        }
    union{
        //pen
        cone {-y*0.01,0,y*0.0005,0.007 pigment {rgb <1,1,0>} #if(F)finish {F_Pen}#end}//tip
        cone {0,0.007,y*0.1,0.015}
        cylinder {y*0.1,y*0.2,0.015}
            sphere {y*0.2,0.015}
        cylinder {y*0.2,y*0.5,0.015 pigment {rgbf <1,1,1,0.5>} #if(F)finish {F_Pen}#end}
        cylinder {y*0.1,y*0.6,0.004 pigment {rgb 0}}
            sphere {y*0.5,0.015}
        cylinder {y*0.5,y*0.7,0.015}
            sphere {y*0.7,0.015}
        //object {Alien(0,0) scale 0.025 translate y*0.7 #if(F)finish {F_Pen}#end}
        
        #local T_AB = texture {pigment {rgb 0.7} #if(F)finish {F_Pen}#end}//Alien Body
        #local T_AH = texture {pigment {rgb <0.5,0.5,0.6>} #if(F)finish {F_Pen}#end}//Alien Helmet
        #local T_AAK = texture {pigment {rgb <1,1,1>} #if(F)finish {F_Pen}#end}//Alien Antenna Knob
        union{
            sphere {y*3,1 texture {T_AH #if(F)finish {F_Pen metallic reflection 0.25}#end}}
            //Antennas
            union{
                cylinder {y*0,y*2,0.1 texture {T_AH}}
                sphere {y*2,0.2 texture {T_AAK}}
            rotate z*30 translate y*3
            }
            union{
                cylinder {y*0,y*2,0.1 texture {T_AH}}
                sphere {y*2,0.2 texture {T_AAK}}
            rotate z*-30 translate y*3
            }
            cylinder {y*0,y*2,0.25 texture {T_AB}}
        rotate y*-30
        scale 0.025
        translate y*0.7
        }
    #if(F)finish {F_Pen}#end
    scale 30
    }
#if(Stuff_Middle_Room)
    #declare CUP =
    union{
        difference{
            sphere {0,5}
            sphere {0,4.5}
            box {<-10,3,-10>,10}
        scale <1,1.5,1>
        translate y*12
        }
        difference{
            sphere {0,5}
            sphere {0,4.5}
            box {-10,<10,0,10>}
        scale <1,0.45,1> translate y*2.5
        }
        torus {(3.35420+4)/2,(4-3.35420)/2 scale <1,0.5,1> translate y*16.5}
    pigment {rgb 0.5}
    #if(F)finish {Metal}#else finish {ambient 0.5}#end
    }
    #local T_OBJ=
    union{
        box {<-RW/2,-1,-RD*6.5>,<RW/2,0,RD> texture {T_RF2}}//floor
        object {CUP rotate x*-90 translate y*5}
    }
    #local Cup_Rotate = 50;
    #local Cup_Translate = <-3,0,12>;
    object {CUP rotate <-90,Cup_Rotate,0> translate <Cup_Translate.x,5,Cup_Translate.z>}// pigment {rgb 1 transmit 0.75}}
    #macro TR(X_Offset)
        trace(T_OBJ,<0,5,X_Offset>,-y)+y*0.25
    #end
    #macro TBlob(Locat,Radius,Threshold)
        sphere {<0,0,0>,Radius,Threshold scale <1,0.5,1> translate Locat}
    #end
    blob{threshold 0.5
        TBlob(TR(-12),3,0.25)
        TBlob(TR(-13),3,0.25)
        TBlob(TR(-14),3,0.25)
        TBlob(TR(-15),3,0.25)
        TBlob(TR(-16),3,0.25)
        TBlob(TR(-16),3,0.25)
        TBlob(z*-17,3,0.55)
        TBlob(<-2,0,-19>,4,0.45)
        TBlob(< 2,0,-20>,3,0.45)
    rotate <0,Cup_Rotate,0> translate <Cup_Translate.x,0.2,Cup_Translate.z>
    texture {T_W}
    }
    //water drops outside cup
    #local S = seed(1014);
    blob{threshold 0.5
        #local Q = -5;
        #while (Q < 5)
            sphere {
                <rand(S)*Q,0,-20-rand(S)*10>,
                2,0.8-rand(S)*0.15
                scale <1,0.5,1>
                translate y*-0.2
                }
        #local Q = Q+1;
        #end
    rotate <0,Cup_Rotate,0> translate <Cup_Translate.x-1,0.25,Cup_Translate.z>
    interior {ior 1.33}
    texture {T_W}
    }
    #declare Paper =
        bicubic_patch {
          type 1 flatness 0.1
          u_steps 3 v_steps 3
            <0,0.1,4> <1,0,4> <2,0,4> <3,0.05,4>
            <0,0,3> <1,0,3> <2,0,3> <3,0.02,3>
            <0,0,2> <1,0,2> <2,0,2> <3,0.01,2>
            <0,0.01,0> <1,0,0> <2,0,0> <3,0.01,0>
        scale 7
        rotate y*14
        translate <-15,0.01,-20>
    uv_mapping pigment {image_map{png "gradient_paper.png"} rotate x*180}
    }
    #local T_Obj2 =
    union{
        object {Paper}
        plane {y,0}
    }
    object {Boat(0.5) scale 0.75 rotate <0,10,1> translate <-30,0.1,-12>}
    //aliens on line, traced onto paper
        #local S = seed(61904367);
        #local Q = 7;
        #while (Q < 50)
            object {Alien(y*(30+60*rand(S)),<-25+Q+rand(S)*0.5,0,-8+Q*0.25-1+3*rand(S)>)
            translate y*trace(T_Obj2,<-25+Q+rand(S)*0.5,50,-8+Q*0.25-1+3*rand(S)>,-y).y
            }
        #local Q = Q+2;
        #end
    object {Paper}
        //Penholder
            //Alternate test textures
                //texture {T_Wood25 rotate 5 scale 2.5 finish {reflection 0.25}}
                /*
                #declare Pig_transp =
                pigment {rgbf 1}
                
                #declare Pig_clrful =
                pigment {
                gradient y
                color_map{
                    [0, rgb <0.5,0.5,1>]
                    [0.33, rgb <1,1,0.5>]
                    [0.66, rgb <1,0.5,0.5>]
                    [1, rgb <0.5,0.5,1>]
                }
                scale <1,15*1/2,1>
                }
                
                #declare Pig_clrful =
                pigment {rgb 1}
                
                texture {
                pigment {
                bozo
                pigment_map{
                    [0.0 Pig_transp]
                    [0.1 Pig_transp]
                    [0.2 Pig_clrful]
                    [0.6 Pig_clrful]
                    [0.7 Pig_transp]
                    [1.0 Pig_transp]
                }
                scale 2
                turbulence 2
                }
                finish {specular 0 phong 0.1 phong_size 80 reflection 0}
                }
                */
                /*
                texture {
                    pigment {
                        bozo
                        color_map{
                            [0.0 rgbf <0.5,0.5,0.5,1>]
                            [0.1 rgbf <0.5,0.5,0.5,1>]
                            [0.2 rgb 0.5]
                            [0.5 rgb 0.5]
                            [0.6 rgbf <0.5,0.5,0.5,1>]
                            [1.0 rgbf <0.5,0.5,0.5,1>]
                            }
                        scale 2
                        turbulence 0.5
                        }
                    finish {specular 0.15 phong 0.2 phong_size 80 reflection 0}
                    }
                */
        #local PHR1 = 3;
        #local PHR2 = 4;
        #local PHH = 15;
        #local PHH2 = 8;
        #declare Ring = 
        union{
            union{//top
                cylinder {x*PHR1,x*(PHR1+2),0.25}
                cylinder {<PHR1+2,-3,0>,<PHR1+2,3,0>,0.25}
                sphere {<PHR1+2, 3,0>,0.25}
                sphere {<PHR1+2,-3,0>,0.25}
                torus {1,0.25 translate <PHR1+3, 2,0>}
                torus {1,0.25 translate <PHR1+3,-2,0>}
            translate y*(PHH-3.25)
            }//bottom
            difference{
                box {z*-1,<PHR1+4,2,1>}
                cylinder {x*(PHR1+3),<PHR1+3,5,0>,0.5}
            }
            torus {0.5,0.1 translate <PHR1+3,2-0.1,0>}
        }
        #declare Penholder =
        union{
            intersection{
                cone{y*PHH,PHR1,y*(PHH+PHR1),0}
                union{
                        box {y*PHH,<-PHR2,PHH+PHR1,-PHR2>}
                        box {y*PHH,< PHR2,PHH+PHR1, PHR2>}
                }
            }
        
        triangle{<0,PHH,-PHR1>,<PHR1,PHH,-PHR1>,<0,PHH+PHR1,0>}
        triangle{<0,PHH+PHR1,0>,<PHR1,PHH,-PHR1>,<PHR1,PHH,0>}
        triangle{<0,PHH,-PHR1>,<PHR1,PHH,-PHR1>,<0,PHH+PHR1,0> scale <-1,1,-1>}
        triangle{<0,PHH+PHR1,0>,<PHR1,PHH,-PHR1>,<PHR1,PHH,0> scale <-1,1,-1>}
            
            cylinder {y*PHH2,y*PHH,PHR1}//round top
            intersection{//round corners
                cone {y*PHR2,PHR2,y*PHH2,PHR1}
                union{
                    box {y*PHR2,<-PHR2,PHH2,-PHR2>}
                    box {y*PHR2,< PHR2,PHH2, PHR2>}
                }
            }
            box {     0,<PHR2,PHR2,-PHR2>}//square top
            box {y*PHR2,<PHR1,PHH ,-PHR1>}
            //square middle
                triangle {<   0,PHR2,-PHR2>,<PHR2,PHR2,-PHR2>,<   0,PHH2,-PHR1>}
                triangle {<PHR2,PHR2,-PHR2>,<PHR2,PHR2,    0>,<PHR1,PHH2,    0>}
                triangle {<PHR2,PHR2,-PHR2>,<   0,PHH2,-PHR1>,<PHR1,PHH2,    0>}
                triangle {<   0,PHR2,-PHR2>,<PHR2,PHR2,-PHR2>,<   0,PHH2,-PHR1> scale <-1,1,-1>}
                triangle {<PHR2,PHR2,-PHR2>,<PHR2,PHR2,    0>,<PHR1,PHH2,    0> scale <-1,1,-1>}
                triangle {<PHR2,PHR2,-PHR2>,<   0,PHH2,-PHR1>,<PHR1,PHH2,    0> scale <-1,1,-1>}
            cylinder {0,y*PHR2,PHR2}//round bottom
            box {0,<-PHR2,PHR2,PHR2>}//square bottom
            box {y*PHR2,<-PHR1,PHH,PHR1>}
            object {Ring translate z*-PHR1/2}
            object {Ring rotate y*90 translate x*PHR1/2}
            object {Ring rotate y*-90 translate x*-PHR1/2}
            object {Ring rotate y*180 translate z*PHR1/2}
            object {Pen pigment {rgb <1,0,0>} rotate x*1.85 rotate y*40 translate <PHR1+3,0.5,0> translate z*-PHR1/2}
            object {Pen pigment {rgb <1,1,0>} rotate x*1.85 rotate y*-20 translate <PHR1+3,0.5,0> rotate y*90 translate x*PHR1/2}
            object {Pen pigment {rgb <0,0,1>} rotate x*-1.85 rotate y*240 translate <PHR1+3,0.5,0> rotate y*-90 translate x*-PHR1/2}
            //object {Pen pigment {rgb <1,1,1>} rotate x*1.85 rotate y*140 translate <PHR1+3,0.5,0> rotate y*180 translate z*PHR1/2}
            //pigment {rgb <1,1,0>}
        pigment {rgb 0.5}
        #if(F)finish {Metal}#end
        }
        #declare Dice =
        difference{
            object {Round_Box(<-1,-1,-1>,<1,1,1>,0.25,0)}
            union{
                //6
                sphere {<-0.5,1,0.5>,0.2}
                sphere {<-0.5,1,0>,0.2}
                sphere {<-0.5,1,-0.5>,0.2}
                sphere {<0.5,1,0.5>,0.2}
                sphere {<0.5,1,0>,0.2}
                sphere {<0.5,1,-0.5>,0.2}
                //5
                union{
                    sphere {<-0.5,1,0.5>,0.2}
                    sphere {<-0.5,1,-0.5>,0.2}
                    sphere {<0.5,1,0.5>,0.2}
                    sphere {<0.5,1,-0.5>,0.2}
                    sphere {y*1,0.2}
                rotate x*90
                }
                //4
                union{
                    sphere {<-0.5,1,0.5>,0.2}
                    sphere {<-0.5,1,-0.5>,0.2}
                    sphere {<0.5,1,0.5>,0.2}
                    sphere {<0.5,1,-0.5>,0.2}
                rotate <90,90,0>
                }
                //3
                union{
                    sphere {<-0.5,1,-0.5>,0.2}
                    sphere {y*1,0.2}
                    sphere {<0.5,1,0.5>,0.2}
                rotate <90,-90,0>
                }
                //2
                union{
                    sphere {<-0.5,1,-0.5>,0.2}
                    sphere {<0.5,1,0.5>,0.2}
                rotate x*-90
                }
                //1
                sphere {y*-1,0.2}
            }
        translate 0.5
        scale 2.5*0.5
        }
        /*
        lathe{//a game brick - not used
            cubic_spline
            7
            <-0.25,1.5>,
            <0,1.9>,
            <0.25,1.5>,
            <0.1,1>,
            <0.4,0.1>,
            <0,0>,
            <-0.4,0.1>
            texture {T_Wood25 scale 2}
            texture {pigment {rgbt <1,1,0,0.7>}}
        }
        */
        #declare S = seed(18301);
        #macro Dice2(Texture_Translate,Layer_Color)
        object {Dice
        #if(F)
        //texture {T_Wood25 rotate 5 scale 2.5 finish {reflection 0.25} translate Texture_Translate}
        texture {pigment {rgb 0.5} finish {reflection 0.25}}
        texture {
            pigment {
                bozo
                color_map{
                    [0 rgbt 1]
                    [0.1 rgbt 1]
                    [0.2 rgbt Layer_Color]
                    [0.4 rgbt Layer_Color]
                    [0.5 rgbt 1]
                    [1 rgbt 1]
                    }
                scale 2
                turbulence 0.5
                }
            finish {specular 0.5 phong 0.2 reflection 0.3}
            translate Texture_Translate
            }
        #else
        pigment {rgb 1}
        #end
        }
        #end
        object {Penholder
        scale 1/30
        scale 25
        rotate y*-15
        translate <12,0,15>
        }
        union{
        object {Dice2(x*2 ,<1,1,0,0>)}
        object {Dice2(y*10,<1,1,0,0>) rotate <90,0,90> rotate y*10 translate x*-3}
        object {Dice2(z*3,<1,1,0,0>) rotate <-90,0,-90> rotate y*-40 translate <-2,0,3>}
        object {Dice2(y*5,<1,1,0,0>) rotate <90,0,-180> rotate y*-50 translate <0,2.5,2>}
        rotate y*12.2
        translate <22,2.5*0.5,10>
        }
#end//stuff middle room
//Hand meshes not included!
/*
#if(Hand)
    #include "hand_flat.inc"
        object{hand_flat
        scale 30
        translate <-10,0,-22>
    }
    union{
        #include "hand_write.inc"
        object{hand_write scale<1,1,1> rotate<0,90,0> translate<0,0,0>}
        object {Pen    
        scale 1/30
        rotate <-65,-32,0> translate <-0.1,0.125,0.544>
        pigment {rgb 1}
        #if(F)finish {F_Pen}#end
        }
    scale 30
    rotate <0,-10,15>
    translate <15,0,-22>
    }
#end//hand
*/
//***************************************************************************************************************************
#if(Stuff_Last_Room)
    //stuff last room
    #local Boxes = union{
        #local S = seed(10);
        
        #local Q = 25;
        #while (Q < 75)
                #local Rand1 = rand(S)*6;
                #switch(Rand1)
                    #range(0,1)#local Rand1 = 0;#break
                    #range(1,2)#local Rand1 = 1;#break
                    #range(2,3)#local Rand1 = 2;#break
                    #range(3,4)#local Rand1 = 3;#break
                    #range(4,5)#local Rand1 = 4;#break
                    #range(5,6)#local Rand1 = 5;#break
                #end
                #local Rand2 = rand(S)*3;
                #switch(Rand2)
                    #range(0,1)#local Rand2 = 0;#break
                    #range(1,2)#local Rand2 = 1;#break
                    #range(2,3)#local Rand2 = 2;#break
                #end
    
                box {0,1 scale 5
                    translate <Q,Rand2*5,-15+Rand1*5>
                texture {T_RF3}
                }
            //#debug concat(str(Rand1,0,5)," | ")
        #local Q = Q+5;
        #end
    }//boxes end
    object {Boxes}
    #local T_Obj =
        union{
            object {Boxes}
            plane {y,0}
        }
    #local S = seed(12524);
    #local Q = 0;
    #while (Q < 1)
        #local DOIT = rand(S)+Q;
        #if(DOIT>0.5)
            #local DOIT = 1;
        #else
            #local DOIT = 0;
        #end
            #local Z =  0;
            #while (Z < 36)
                #if(DOIT)
                    #local RDAN = <-2+rand(S)*4,0,5+Q*20+rand(S)>;
                    #local TDAN = y*(Z*10+rand(S)*10);
                    
                        object {Alien(0,0) translate RDAN rotate TDAN translate x*50
                        translate y*trace(T_Obj,vrotate(RDAN,TDAN)+x*50+y*50,-y).y
                        }
                #end
            #local Z = Z+1;
            #end
    #local Q = Q+0.1;
    #end
#end//end #if stuff last room