camera {
  up<0,1.33,0> 
  right<1,0,0>
  location <-6,2,5>
  look_at <-3,4,-5>
}

light_source { <500,3000,-500> rgb 1 }
light_source { <500,3000,-500> rgb 1 rotate y*180 }

sky_sphere { pigment { rgb <.3,.1,.8> } }

#local Pavement = pigment { brick <.3,.3,.4>*.2, <.3,.3,.4> mortar .1 scale .1 rotate x*90 scale z*2.5  }


#local Lamp_post = union {
  cone { 0,.08,<0,5,0>,.05 }
  torus { .3,.05 rotate x*90 clipped_by { box { <0,0,-.05>,<-.35,.35,.05> } } translate <.3,5,0> }
  cylinder { <.30,5.3,0>,<1,5.3,0>,.05 }
  box { <1,5.3,-.1>,<1.5,5.4,.1> }
  box { <1,5.3,-.1>,<1.5,5.2,.1> pigment { transmit .8 } }
  pigment { color rgb .8 } 
  finish { ambient .5 metallic }
}

#local Street = union {
  plane { y, 0 pigment { rgb <.3,.25,.2> } normal { bumps .5 scale 2 } } //straat
  box { <-5,0,0>,<-8,.1,-100> pigment { Pavement } }
  object { Lamp_post translate <-5.5,0,-2> }
  object { Lamp_post translate <-5.5,0,-15> }
  object { Lamp_post translate <-5.5,0,-30> }
  object { Lamp_post translate <-5.5,0,-45> }
  object { Lamp_post translate <-5.5,0,-60> }
} 

#local Car = union {
  #local Wheel = torus { .20,.05 rotate z*90 pigment { rgb 0 } }
  object { Wheel translate <-1,.25,1.5> }
  object { Wheel translate <-1,.25,-1.5> }
  object { Wheel translate <1,.25,1.5> }
  object { Wheel translate <1,.25,-1.5> }
  box { <-.9,.15,-2>,<.9,1,2> }
  box { <-.9,1.6,-1>,<.9,1.65,2> }
  box { <-.9,1.6,-1>,<.9,1,2> pigment { rgbt <1,1,1,.8> } }
  //cheapest Pov-car *ever* I suppose... 
}

#local Buildings = union {
  //links
  box { <15,0,0>,<40,40,-30> pigment { rgb <.7,.6,.3> } } 
  box { <15.4,0,-32>,<40,80,-60> pigment { rgb <1,.9,.6> } } 
  box { <15,0,-70>,<40,25,-100> pigment { rgb <.71,.53,.38> } }
  //rechts
  box { <-8,0,-50>,<-30,40,-80> pigment { rgb <1,.8,.6> } }
}

#declare Bird = box {
  <0,0,0>,<1,1,0.001> pigment { image_map { tga "veugel.tga" } }
}


#declare theIIbird = union {
  object { Street }
  object { Buildings }
  object { Car pigment { rgb <1,0,0> } finish { ambient .5 } translate <-3,0,-5> }
  object { Car pigment { rgb <0,0,1> } finish { ambient .5 } translate <-3,0,-12> }
  object { Bird translate <-5,5,-2> }
}

object { theIIbird }



