//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 19 materials and 152 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 06/04/2002    (04.06.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

#declare VHighQuality=on;


#declare WriteFroth=off;

#declare RADIOSITY=on;
#declare PHOTONS=on;

#declare BEER=on;
#declare FROTH=on;
#declare BENCHES=on;
#declare THEREST=on;

#declare LINEARBEER=off;
#declare REFRACTION=on;
#declare AREALIGHT=on;

#declare DIRECTIONALLIGHT=off;

#declare FocalBlur=on;

default {
  texture {
    pigment { rgb <1,0,0> }
  }
  finish {
  	ambient 0
  }
}

//
// ********  MATERIALS  *******
//

#include "pintglassandbeer.inc"


/* // Scene Comment

This scene was created with Moray V3.3 For Windows.
Comment merged from chair.mdl:
This scene was created with Moray V3.3a For Windows.
Comment merged from tv.mdl:
This scene was created with Moray V3.3a For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  #if (PHOTONS)  
  photons {
  #if (VHighQuality)
    spacing .01                 // specify the density of photons
  #else 
    spacing .05
  #end
    //save_file "whatthefuck.photons"       // save photons to file
    //load_file "whatthefuck.photons"
    //load_file "highquality.photons"
    //load_file "quickneasy.photons"
  }
  #end
#if (RADIOSITY)
  radiosity {
    brightness       2
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
  #end
}

background { color <0.733,0.890,1.000> }

camera {  //  Camera Final_Camera
  location  <     25.742,     -50.057,      24.314>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     12.777,     -12.310,      12.507>

#if (FocalBlur)
  aperture .80           // [0...N] larger is narrower depth of field (blurrier)
  #if (VHighQuality)
  blur_samples 25        // number of rays per pixel for sampling
  #else
  blur_samples 10        // number of rays per pixel for sampling
  #end
  focal_point <     12.777,     -12.310,      12.507>    // point that is in focus <X,Y,Z>
  confidence 0.95           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/200            // [0...1] how precise to calculate (smaller is more accurate)
#end
}

//    Other cameras are commented out.
/*
camera {  //  Camera BirdQs_Eye
  location  <    627.164,   -1306.767,     623.113>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.45776,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         81.14295    // Vertical      60.857
  look_at   <    615.606,      62.386,      22.472>
}

*/

/*
camera {  //  Camera Experimental
  location  <    337.787,    -167.930,     110.528>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.000,       0.000,       1.000>
}

*/

/*
camera {  //  Camera View_from_Outside
  location  <     84.134,    -198.811,     118.291>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35231,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         35.06253    // Vertical      26.297
  look_at   <     -5.541,       5.487,      39.031>
}

*/

/*
camera {  //  Camera Door_View
  location  <    -55.973,     505.539,      29.464>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.37404,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         50.19579    // Vertical      37.647
  look_at   <    -60.570,     690.770,     -23.215>
}

*/

/*
camera {  //  Camera Camera01
  location  <   -298.200,     504.200,       5.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34196,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         23.90000    // Vertical      17.925
  look_at   <    -10.489,     602.856,      24.178>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Arealight Second Sun
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*4.2236
#if (DIRECTIONALLIGHT)  
  parallel
#end
#if (AREALIGHT)
  area_light <40.000, 0.000, 0.000>, <0.000, 40.000, 0.000>, 3, 3
  adaptive 1
  jitter
  circular
  orient
#end

  //translate  <1721.655, -175.48721, 400.0>
  translate  <1721.655, -175.48721, 400.0>
#if (DIRECTIONALLIGHT)
  point_at <0, 0, 0>
#end
  // photon block for a light source
  photons {
    refraction on
    reflection on
   area_light
  }

}


#declare glass = lathe {
  #if (LINEARBEER)
  linear_spline
  #else
  cubic_spline
  #end
  53  // control points
  <-0.774254, 0.017007>,
  <0.0, 0.017285>,
  <0.698002, 0.011853>,
  <1.340221, 0.006402>,
  <1.767441, 0.020836>,
  <2.177695, 0.026595>,
  <2.584744, 0.009402>,
  <3.031799, 0.007609>,
  <3.374128, 0.052224>,
  <3.459289, 0.126455>,
  <3.540525, 0.524646>,
  <3.576373, 1.894197>,
  <3.608409, 3.089088>,
  <3.639068, 4.707132>,
  <3.733584, 6.689024>,
  <3.828693, 8.321042>,
  <3.916701, 10.112321>,
  <4.224255, 10.93847>,
  <4.208023, 11.693559>,
  <4.003551, 12.482276>,
  <4.106976, 13.444623>,
  <4.179103, 14.023651>,
  <4.2056, 14.285375>,
  <4.2537, 14.352064>,
  <4.280425, 14.416465>,
  <4.267062, 14.475701>,
  <4.182558, 14.507429>,
  <4.099787, 14.494755>,
  <4.063384, 14.428104>,
  <4.090227, 14.358164>,
  <4.092554, 14.28467>,
  <4.053158, 14.003881>,
  <4.004275, 13.593823>,
  <3.916415, 12.488524>,
  <4.113476, 11.675702>,
  <4.121508, 10.962589>,
  <3.796229, 10.110131>,
  <3.687546, 8.301116>,
  <3.608863, 6.680143>,
  <3.508698, 4.697115>,
  <3.476571, 3.087676>,
  <3.432327, 1.916781>,
  <3.410373, 1.068946>,
  <3.352855, 0.511306>,
  <3.045575, 0.4689>,
  <2.581542, 0.440299>,
  <2.183513, 0.43691>,
  <1.705158, 0.438978>,
  <1.25128, 0.429321>,
  <0.663099, 0.459962>,
  <0.314131, 0.461773>,
  <0.009654, 0.453741>,
  <-1.361893, 0.278278>
  rotate <90,0,90>
  photons{
    target 1.0          // spacing multiplier for photons hitting the object
    refraction on
    reflection on
    //collect off       // ignore photons
    //pass_through      // do not influence photons
  }
  material {
    NBglass
  }
}


#declare beer = lathe {
  #if (LINEARBEER)
  linear_spline
  #else
  cubic_spline
  #end
  28  // control points
  <-0.3, 13.5>,
  <0.0, 13.5>,
  <3.3, 13.5>,
  <3.7, 13.5>,
  <3.87417, 13.517019>,
  <3.935705, 13.580267>,
  <4.004275, 13.593823>,
  <3.916415, 12.488524>,
  <4.113476, 11.675702>,
  <4.146298, 11.389966>,
  <4.121508, 10.962589>,
  <3.796229, 10.110131>,
  <3.661046, 8.301116>,
  <3.582363, 6.680143>,
  <3.482197, 4.697115>,
  <3.450071, 3.087676>,
  <3.405827, 1.916781>,
  <3.383873, 1.068946>,
  <3.326355, 0.511306>,
  <3.045575, 0.4689>,
  <2.581542, 0.440299>,
  <2.183513, 0.43691>,
  <1.705158, 0.438978>,
  <1.25128, 0.429321>,
  <0.663099, 0.459962>,
  <0.314131, 0.461773>,
  <0.009654, 0.453741>,
  <-1.361893, 0.278278>
  rotate <90,0,90>
  photons{
    target 1.0          // spacing multiplier for photons hitting the object
    refraction on
    reflection on
    //collect off       // ignore photons
    //pass_through      // do not influence photons
  }
  material {
    Beer
  }
}


/*light_source {   // Arealight Second Sun
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*.2
#if (DIRECTIONALLIGHT)  
  parallel
#end
//#if (AREALIGHT)
  //area_light <40.000, 0.000, 0.000>, <0.000, 40.000, 0.000>, 3, 3
  //adaptive 1
  //jitter
  //circular
  //orient
//#end

  //translate  <1721.655, -175.48721, 400.0>
  translate  <1721.655, -175.48721, 500.0>
#if (DIRECTIONALLIGHT)
  point_at <0, 0, 0>
#end
  // photon block for a light source
  
  #local DistanceAway=0.01;
  
  projected_through { object { glass   scale 1-DistanceAway translate  <25.0+1721.655*DistanceAway, -13.5-175.48721*DistanceAway, 0.0+500*DistanceAway>} }

  photons {
    refraction on
//    reflection on
    area_light
  }

}*/


#declare Light004 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.802>
  fade_distance  75.0
  fade_power 2.0
  media_interaction off
  translate  <0.0, -0.334189, -0.15>
}

#declare Light003 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.802>
  media_interaction off
  translate  -0.15*z
}


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#if (THEREST)

#declare RndDisc008 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs4 = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare Round_Table1 = union {
  object { RndDisc008 }
  object { ChairLegs4 }
  scale 1.2
  rotate -10.0*z
  translate  <-308.764063, 317.563317, -75.738567>
}
#declare RndDisc011 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs6 = union {
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare RndDisc012 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  material {
    T_Wood10
    rotate <-90.0, -2.0, -75.0>
    translate <-0.000000, 0.030104, 0.053081>
  }
  scale <20.0, 15.0, 1.5>
  rotate 80.0*x
  translate  <0.0, 20.10598, 77.023995>
}
#declare Chair4 = union {
  object { RndDisc011 }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <-15.0, 16.0, 40.0>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <15.0, 16.0, 40.0>
  }
  object { ChairLegs6 }
  object { RndDisc012 }
  rotate -60.0*z
  translate  <-349.927889, 409.313324, -73.330598>
}
#declare RndDisc013 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs7 = union {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare RndDisc014 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  material {
    T_Wood10
    rotate <-90.0, -2.0, -75.0>
    translate <-0.000000, 0.030104, 0.053081>
  }
  scale <20.0, 15.0, 1.5>
  rotate 80.0*x
  translate  <0.0, 20.10598, 77.023995>
}
#declare Chair5 = union {
  object { RndDisc013 }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <-15.0, 16.0, 40.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <15.0, 16.0, 40.0>
  }
  object { ChairLegs7 }
  object { RndDisc014 }
  rotate -160.0*z
  translate  <-348.668072, 327.441283, -75.738567>
}
#declare all_chairs1 = union {
  object { Chair4 }
  object { Chair5 }
  scale 0.8
  translate  -15.666613*z
}
union { // Round_table_and_chairs1
  object { Round_Table1 }
  object { all_chairs1 }
  rotate -50.0*z
  translate  <-0.0, -0.0, 0.0>
  rotate -95.0*z
  translate  <-792.9, 532.8, 0.0>
  photons{
	collect off       // ignore photons
  }

}


#declare RndDisc007 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs3 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare Round_Table = union {
  object { RndDisc007 }
  object { ChairLegs3 }
  scale 1.2
  rotate -10.0*z
  translate  <-308.764063, 317.563317, -75.738567>
}
#declare RndDisc005 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs2 = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare RndDisc006 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  material {
    T_Wood10
    rotate <-90.0, -2.0, -75.0>
    translate <-0.000000, 0.030104, 0.053081>
  }
  scale <20.0, 15.0, 1.5>
  rotate 80.0*x
  translate  <0.0, 20.10598, 77.023995>
}
#declare Chair2 = union {
  object { RndDisc005 }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <-15.0, 16.0, 40.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <15.0, 16.0, 40.0>
  }
  object { ChairLegs2 }
  object { RndDisc006 }
  rotate <0.0, -180.0, 30.0>
  translate  <-398.301917, 414.936811, 27.456607>
}
#declare RndDisc003 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs1 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare RndDisc004 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  material {
    T_Wood10
    rotate <-90.0, -2.0, -75.0>
    translate <-0.000000, 0.030104, 0.053081>
  }
  scale <20.0, 15.0, 1.5>
  rotate 80.0*x
  translate  <0.0, 20.10598, 77.023995>
}
#declare Chair1 = union {
  object { RndDisc003 }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <-15.0, 16.0, 40.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <15.0, 16.0, 40.0>
  }
  object { ChairLegs1 }
  object { RndDisc004 }
  rotate -60.0*z
  translate  <-349.927889, 409.313324, -73.330598>
}
#declare RndDisc001 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3500, 0.3500, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1500, 0.1500, 1.0200> translate -0.1900*z }
  }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-0.5540, -0.5540, 0.5960>, <0.5540, 0.5540, 1.0040> } } }
  torus { 0.3500, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-0.3540, -0.3540, -0.0040>, <0.3540, 0.3540, 0.2040> } } }
  material {
    T_Wood10
    rotate <-91.0, -2.0, -30.0>
  }
  scale <27.0, 27.0, 1.5>
  translate  39.5*z
}
#declare ChairLegs = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 0.0>
    translate  <20.0, 20.0, 0.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 180.0>
    translate  <-20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, -90.0>
    translate  <20.0, -20.0, 0.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 40.0>
    rotate <5.0, -5.0, 90.0>
    translate  <-20.0, 20.0, 0.0>
  }
  material {
    Brushed_Aluminum
  }
}
#declare RndDisc002 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.6000> translate 0.2000*z }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.8000*z bounded_by { box { <-1.0040, -1.0040, 0.5960>, <1.0040, 1.0040, 1.0040> } } }
  torus { 0.8000, 0.2000  rotate -x*90 translate  0.2000*z bounded_by { box { <-1.0040, -1.0040, -0.0040>, <1.0040, 1.0040, 0.4040> } } }
  material {
    T_Wood10
    rotate <-90.0, -2.0, -75.0>
    translate <-0.000000, 0.030104, 0.053081>
  }
  scale <20.0, 15.0, 1.5>
  rotate 80.0*x
  translate  <0.0, 20.10598, 77.023995>
}
#declare Chair = union {
  object { RndDisc001 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <-15.0, 16.0, 40.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 40.0>
    rotate -8.0*x
    translate  <15.0, 16.0, 40.0>
  }
  object { ChairLegs }
  object { RndDisc002 }
  rotate -160.0*z
  translate  <-348.668072, 327.441283, -75.738567>
}
#declare all_chairs = union {
  object { Chair2 }
  object { Chair1 }
  object { Chair }
  scale 0.8
  translate  -15.666613*z
}
union { // Round_table_and_chairs
  object { Round_Table }
  object { all_chairs }
  photons{
	collect off       // ignore photons
  }
}




#declare CSG003 = difference {
  box { // MachineBase
    <-1, -1, -1>, <1, 1, 1>
    material {
      MachineTexture
    }
    scale <-9.364592, -6.051343, -25.163811>
    rotate <-180.0, 0.0, -180.0>
    translate  <-372.261866, 656.779291, 0.0>
  }
  box { // Opening
    <-1, -1, -1>, <1, 1, 1>
    material {
      Walls
    }
    scale 3.719635
    translate  <-375.098599, 653.211911, -16.771082>
  }
  material {
    MachineTexture
  }
}
union { // Machine
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      Brushed_Aluminum
    }
    scale <-1.164765, -1.0, -2.460074>
    rotate -180.0*z
    translate  <-366.062393, 651.362276, 19.277558>
  }
  box { // Picture_on_Machine
    <-1, -1, -1>, <1, 1, 1>
    material {
      MachinePic
      scale 1.981252
      rotate 90.0*x
      translate <-0.989107, 0.000000, -0.993623>
    }
    scale <7.5, 0.966302, 7.5>
    translate  <-372.365901, 651.337408, 1.81309>
  }
  object { CSG003 }
  translate  4.283902*z
  photons{
	collect off       // ignore photons
  }
}


box { // Poster_A_Box
  <-1, -1, -1>, <1, 1, 1>
  material {
    Poster_A
    scale 2.0
    rotate -90.0*x
    translate <-1.005403, 0.000000, 1.000401>
  }
  scale <50.0, 0.5, 33.5>
  rotate <0.0, -180.0, -180.0>
  translate  <-487.464202, 657.0988, 3.366103>
  photons{
	collect off       // ignore photons
  }
}


#declare Window_Strut3 = union {
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -7.074353, 30.660211>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -10.041665, 30.660211>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 3.0, 35.0>
    translate  <51.464321, -8.566029, 30.660211>
  }
  translate  -200.0*y
}
#declare Window_Strut2 = union {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -7.074353, 30.660211>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -10.041665, 30.660211>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 3.0, 35.0>
    translate  <51.464321, -8.566029, 30.660211>
  }
  translate  400.0*y
}
#declare Window_Strut1 = union {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -7.074353, 30.660211>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -10.041665, 30.660211>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 3.0, 35.0>
    translate  <51.464321, -8.566029, 30.660211>
  }
  translate  200.0*y
}
#declare Window_Strut = union {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -7.074353, 30.660211>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -10.041665, 30.660211>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 3.0, 35.0>
    translate  <51.464321, -8.566029, 30.660211>
  }
}
#declare Window_Strut4 = union {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -7.074353, 30.660211>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 35.0>
    translate  <51.464321, -10.041665, 30.660211>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 3.0, 35.0>
    translate  <51.464321, -8.566029, 30.660211>
  }
  translate  600.0*y
}
#declare Window_Frames = union {
  object { Window_Strut3 }
  object { Window_Strut2 }
  object { Window_Strut1 }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 500.0, 1.0>
    translate  <51.459161, 171.036956, 58.867959>
  }
  object { Window_Strut }
  object { Window_Strut4 }
  material {
    WindowFrame
  }
  translate  4*y
}
#declare Windows = union {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <5.0, 500.0, 50.0>
    rotate 5.0*y
    translate  <48.081595, 166.326655, -51.41554>
  }
  object { Window_Frames }
  box { // Window_Glass
    <-1, -1, -1>, <1, 1, 1>
    material {
      GlassNoRefract
    }
    no_shadow
    scale <0.05, 500.0, 35.0>
    translate  <51.459161, 176.966582, 33.431656>
  photons{
    pass_through      // do not influence photons
  }

  }
}
#declare Far_Wall = difference {
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      Walls
    }
    scale <500.0, 10.0, 100.0>
    translate  <-448.438106, 672.76277, 1.809482>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 20.0, 70.0>
    translate  <-69.481833, 672.458971, -36.489118>
  }
  material {
    Walls
  }
}
#declare Door_Frame = union {
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 50.0>
    rotate -90.0*y
    translate  <-70.615426, 674.473747, 35.661703>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 100.0>
    translate  <-19.91858, 674.473747, -61.832231>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 100.0>
    translate  <-119.362393, 674.473747, -61.832231>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 100.0>
    translate  <-67.107766, 674.473747, -61.832231>
  }
  material {
    WindowFrame
  }
}
#declare Door = union {
  object { Door_Frame }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      GlassNoRefract
    }
    scale <50.0, 0.5, 100.0>
    translate  <-68.895713, 674.468577, -64.190337>
  }
}
union { // Wallsc_Floor_and_Ceiling
  object { Windows }
  box { // Left_Wall
    <-1, -1, -1>, <1, 1, 1>
    material {
      Walls
    }
    scale <500.0, 10.0, 100.0>
    rotate -90.0*z
    translate  <-650.548838, 174.933029, 1.809482>
  }
  object { Far_Wall }
  box { // Ceiling
    <-1, -1, -1>, <1, 1, 1>
    material {
      CeilingTexture
    }
    scale <350.0, 500.0, 1.0>
    translate  <-301.229297, 167.0, 60.0>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      CheckeredFloor
    }
    scale <350.0, 500.0, 1.0>
    translate  <-304.182839, 164.562235, -78.863577>
  }
  object { Door }
  photons{
	collect off       // ignore photons
  }
}


#declare Clip_for_Back_Light = union {
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    material {
      Brushed_Aluminum
    }
    scale <10.0, 10.0, 5.0>
    translate  <-296.562394, 641.872399, 28.247482>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 4.5
    translate  <-296.562394, 641.872399, 23.247482>
  }
  scale 0.2
  translate  <59.312479, -128.37448, -4.649496>
}
#declare CSG002 = difference {
  sphere { // Sphere002
    <0,0,0>,1
  }
  object { Clip_for_Back_Light }
  material {
    Brushed_Aluminum
  }
}
union { // Back_Wall_Light
  object { Light004 }
  object { CSG002 }
  material {
    Aluminium_with_Reflection
  }
  scale 5.0
  translate  <-296.562394, 661.096573, 23.247482>
  photons{
	collect off       // ignore photons
  }
}


#declare Clip_for_left_light = union {
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 5.0>
    translate  <-630.894697, 412.60676, 28.247482>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 4.5
    translate  <-630.894697, 412.60676, 23.247482>
  }
  scale 0.2
  rotate -0.0*z
  translate  <126.178939, -82.521352, -4.649496>
}
#declare CSG001 = difference {
  sphere { // Sphere001
    <0,0,0>,1
  }
  object { Clip_for_left_light }
  material {
    Brushed_Aluminum
  }
}
union { // Left_Wall_Light
  object { Light003 }
  object { CSG001 }
  scale 5.0
  translate  <-640.578609, 412.60676, 23.247482>
  photons{
	collect off       // ignore photons
  }
}


#declare HgtFld002 = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Henry\My Documents\Povray scenes\The bar\hf.bmp"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Grass
  }
  scale <1000.0, 1000.0, 20.0>
  rotate 2.0*x
  translate  <726.307862, 2577.21835, -52.55754>
}
#declare HgtFld001 = object { 
  height_field {
    sys /*unknown extension [BMP]*/ "C:\Documents and Settings\Henry\My Documents\Povray scenes\The bar\hf.bmp"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Grass
  }
  scale <1000.0, 1000.0, 10.0>
  rotate 1.0*y
  translate  <1051.085709, 622.772019, -100.0>
}
union { // landscape
  object { HgtFld002 }
  object { HgtFld001 }
  scale 1.5
  translate  <-730.750155, 230.050975, 0.0>
  photons{
	collect off       // ignore photons
  }
}


/* union { // all_tables
  box { // table3
    <-1, -1, -1>, <1, 1, 1>
    scale <45.0, 20.0, 2.0>
    translate  <-24.0, 325.0, -20.0>
  }
  box { // table2
    <-1, -1, -1>, <1, 1, 1>
    scale <45.0, 20.0, 2.0>
    translate  <-24.0, 195.0, -20.0>
  }
  box { // table1
    <-1, -1, -1>, <1, 1, 1>
    scale <45.0, 20.0, 2.0>
    translate  <-24.0, 65.0, -20.0>
  }
  box { // table
    <-1, -1, -1>, <1, 1, 1>
    scale <45.0, 20.0, 2.0>
    translate  <-24.0, -65.0, -20.0>
  }
  box { // table4
    <-1, -1, -1>, <1, 1, 1>
    scale <45.0, 20.0, 2.0>
    translate  <-24.0, 455.0, -30.0>
  }
  material {
    Brushed_Aluminum
  }
  translate  10.0*z
}
*/

#end // THEREST


#if (BENCHES)

#declare seat_backside3 = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside3 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
}
#declare double_seat3 = union {
  object { seat_backside3 }
  object { seat_frontside3 }
  box { // seat_top3
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
  translate  260.0*y
}
#declare seat_backside1 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside1 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
}
#declare double_seat1 = union {
  object { seat_backside1 }
  object { seat_frontside1 }
  box { // seat_top1
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
  translate  -130.0*y
}
#declare seat_backside2 = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside2 = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
      translate <-0.444356, -0.502150, 11.037169>
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  material {
    T_Wood7
    // Transform to world space
    translate  -130.0*y
    translate  <-0.2, 13.52, 0.0>
  }
}
#declare double_seat2 = union {
  object { seat_backside2 }
  object { seat_frontside2 }
  box { // seat_top2
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
  translate  130.0*y
}

#declare seat_backside = union {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
}
#declare double_seat = union {
  object { seat_backside }
  object { seat_frontside }
  box { // seat_top
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
}

#declare seat_backside4 = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside4 = union {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
}
#declare double_seat4 = union {
  object { seat_backside4 }
  object { seat_frontside4 }
  box { // seat_top4
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
  translate  390.0*y
}
#declare seat_backside5 = union {
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
  rotate 180.0*z
  translate  <0.0, 27.776023, -0.026324>
}
#declare seat_frontside5 = union {
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  -1.0*z
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 20.0, 1.0>
    rotate 70.0*x
    translate  <0.0, -9.863903, -19.766912>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 8.0, 1.0>
    rotate 70.0*x
    translate  <0.0, 7.0, 5.0>
  }
}
#declare double_seat5 = union {
  object { seat_backside5 }
  object { seat_frontside5 }
  box { // seat_top5
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood7
    }
    scale <50.0, 5.0, 1.0>
    translate  <0.0, 14.0, 11.5>
  }
  translate  520.0*y
}

union { // all_seats
  object { double_seat3 }
  object { double_seat1 }
  object { double_seat2 }
  object { double_seat }
  object { double_seat4 }
  object { double_seat5 }
  translate  <0.2, -13.52, 0.0>
}
#end // BENCHES

#if (THEREST)


#declare Cable = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.110350, -0.000397, 0.013433>, <0.110350, -0.006172, 0.013433>, <0.114648, -0.010896, 0.013433>, <0.119901, -0.010896, 0.013433>, 
      <0.135959, -0.064530, 0.861378>, <0.135959, -0.070305, 0.861378>, <0.140257, -0.075030, 0.861378>, <0.145510, -0.075030, 0.861378>, 
      <0.023462, -0.124210, 1.709324>, <0.023462, -0.129985, 1.709324>, <0.027760, -0.134709, 1.709324>, <0.033013, -0.134709, 1.709324>, 
      <-0.043304, -0.119756, 2.557269>, <-0.043304, -0.125531, 2.557269>, <-0.039006, -0.130256, 2.557269>, <-0.033753, -0.130256, 2.557269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.119901, -0.010896, 0.013433>, <0.125154, -0.010896, 0.013433>, <0.129451, -0.006172, 0.013433>, <0.129451, -0.000397, 0.013433>, 
      <0.145510, -0.075030, 0.861378>, <0.150763, -0.075030, 0.861378>, <0.155060, -0.070305, 0.861378>, <0.155060, -0.064530, 0.861378>, 
      <0.033013, -0.134709, 1.709324>, <0.038266, -0.134709, 1.709324>, <0.042564, -0.129985, 1.709324>, <0.042564, -0.124210, 1.709324>, 
      <-0.033753, -0.130256, 2.557269>, <-0.028500, -0.130256, 2.557269>, <-0.024202, -0.125531, 2.557269>, <-0.024202, -0.119756, 2.557269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.129451, -0.000397, 0.013433>, <0.129451, 0.005377, 0.013433>, <0.125154, 0.010102, 0.013433>, <0.119901, 0.010102, 0.013433>, 
      <0.155060, -0.064530, 0.861378>, <0.155060, -0.058756, 0.861378>, <0.150763, -0.054031, 0.861378>, <0.145510, -0.054031, 0.861378>, 
      <0.042564, -0.124210, 1.709324>, <0.042564, -0.118436, 1.709324>, <0.038266, -0.113711, 1.709324>, <0.033013, -0.113711, 1.709324>, 
      <-0.024202, -0.119756, 2.557269>, <-0.024202, -0.113982, 2.557269>, <-0.028500, -0.109257, 2.557269>, <-0.033753, -0.109257, 2.557269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.119901, 0.010102, 0.013433>, <0.114648, 0.010102, 0.013433>, <0.110350, 0.005377, 0.013433>, <0.110350, -0.000397, 0.013433>, 
      <0.145510, -0.054031, 0.861378>, <0.140257, -0.054031, 0.861378>, <0.135959, -0.058756, 0.861378>, <0.135959, -0.064530, 0.861378>, 
      <0.033013, -0.113711, 1.709324>, <0.027760, -0.113711, 1.709324>, <0.023462, -0.118436, 1.709324>, <0.023462, -0.124210, 1.709324>, 
      <-0.033753, -0.109257, 2.557269>, <-0.039006, -0.109257, 2.557269>, <-0.043304, -0.113982, 2.557269>, <-0.043304, -0.119756, 2.557269>
    }
  }
  material {
    Cable_Texture
  }
  translate  1.2*z
}
#declare RndCube001 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <2.9, 1.8, 2.3>
}
#declare Main_Body = difference {
  object { RndCube001 }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.846154, 0.846154>
    translate  -0.4*y
  }
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <1.0, 1.0, 2.7>
  rotate 90.0*x
  translate  3.4*y
}
#declare Tube_Stick_out_bit = difference {
  object { TaperSweep001 }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    translate  2.9*y
  }
}
#declare Plastic_Bits = union {
  object { Main_Body }
  object { Tube_Stick_out_bit }
  material {
    Tele_texture
  }
}
#declare Screen = intersection {
  sphere { // Sphere005
    <0,0,0>,1
    scale 2.8
    translate  1.7*y
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.846154, 0.846154>
    translate  -0.4*y
  }
  material {
    temp_screen
    scale 2.2
    rotate <-90.0, -180.0, -180.0>
    translate <-1.000000, -0.900000, -1.000000>
  }
}
union { // TV
  object { Cable }
  cylinder { // Holding_up_Post
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Metal_Text
    }
    scale <0.1, 0.1, 2.0>
    translate  1.2*z
  }
  box { // Bit_on_top
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Metal_Text
    }
    scale <0.5, 0.5, 0.1>
    translate  1.2*z
  }
  object { Plastic_Bits }
  object { Screen }
  scale 15.0
  rotate -30.0*z
  translate  <-45.0, 582.6, 30.3>
  photons{
	collect off       // ignore photons
  }
}



box { // Skirting_Board
  <-1, -1, -1>, <1, 1, 1>
  material {
    WindowFrameDark
  }
  scale <500.0, 10.0, 10.0>
  translate  <-448.438106, 668.1, -73.6>
  photons{
	collect off       // ignore photons
  }
}

#end //THEREST

#if (BEER)

union { // glass_and_beer
  object { glass }
  object { beer scale 1}
  translate  <25.0, -13.5, 0.0>
    split_union on

}

#end

#if (FROTH)
#include "froth.inc"
#end
