//Gilles_Tran faster_Clouds
#include "rand.inc"
#ifndef (fcloud_count) #declare fcloud_count = 100; #end //cloud count 
#ifndef (fcloud_min_xtnt) #declare fcloud_min_xtnt = <-10,0,-10>; #end //min vect of box 
#ifndef (fcloud_max_xtnt) #declare fcloud_max_xtnt = < 10,10,10>; #end //max vect of box 
#ifndef (fcloud_scale_min) #declare fcloud_scale_min = 1; #end //lower cloud scale
#ifndef (fcloud_scale_max) #declare fcloud_scale_max = 4; #end //upper cloud scale  
#ifndef (fcloud_turb) #declare fcloud_turb = .1; #end //cloud turbulence  
#ifndef (fcloud_lambda) #declare fcloud_lambda = .1; #end //lower is smoother
#ifndef (fcloud_highlight_angle) #declare fcloud_highlight_angle = -20; #end //lower is smoother
#ifndef (fcloud_rotate) #declare fcloud_rotate = 0;#end //individual cloud rotation
#ifndef (fcloud_color) #declare fcloud_color = <1,1,1>;#end


#declare SkyBlue=rgb <135,142,238>/255;
//#declare SkyBlue=rgb <135,172,238>/255;

#macro colCloud(Color,P,S,T)
    rgbf <pow(Color.x,P)*S,pow(Color.y,P)*S,pow(Color.z,P)*S,T>
#end

#declare colCloud1=colCloud(SkyBlue,0.3,0.6,0.8); // shadow
#declare colCloud2=colCloud(SkyBlue,0.3,0.8,0.5);
#declare colCloud3=colCloud(SkyBlue,0.2,1,0.3);
#declare colCloud4=colCloud(SkyBlue,0.1,1.2,0.1); // white

#declare colBack=Clear;
// the clouds pigment
// because it's based on the cylindrical pattern, translating the pattern
//along the z axis changes the shape of the cloud
#macro mPigCloud(S1,S2) // S1 and S2 are the cloud length and height
    #local Turb=0.35+rand(rd)*fcloud_turb;
    #local Lambda=3+rand(rd)*fcloud_lambda;  //cloud smoothness
    pigment{
        pigment_pattern{
           cylindrical  
            scale <S1,1,S2>
           warp{turbulence Turb lambda Lambda octaves 4}
            rotate -x*90 
            
        }
        pigment_map{
            [0.4 color colBack]
            [0.5
                pigment_pattern{
                    function{min(1,max(0,y))}
                    warp{turbulence Turb lambda Lambda}
                    rotate -z*fcloud_highlight_angle // tilts the higlights to the right
                }
                pigment_map{
                    [0

                        pigment_pattern{
                            cylindrical 
                            scale <S1,1,S2>
                            warp{turbulence Turb lambda Lambda}
                            rotate x*-90
                        }
                        pigment_map{
                            [0 color Clear]
                            [0.7 colCloud1]
                            [1 color colCloud2]
                        }

                    ]
                    [0.7 colCloud4]
                }
            ]
        }
    } 
    
    finish{ambient fcloud_color diffuse 0 brilliance 100}

#end 

#declare rd=seed(1);

#declare Nuage0=union{ // basic cloud square
    triangle{0,y,x+y}
    triangle{0,x,x+y}
    hollow
    translate -x*0.5-y*.5
    scale 5
    no_shadow
} 
        

       
#declare j=0;
  
#declare Nuage=union{
   #while (j<fcloud_count)   
   #debug concat(str(j,0,0)," , ")
          object{Nuage0 rotate fcloud_rotate
                 texture{mPigCloud(2+rand(rd),0.5+rand(rd))translate z*100*rand(rd)}
                    #declare SN2=0.4+rand(rd)*.3;
                    scale SN2*RRand(fcloud_scale_min,fcloud_scale_max,RdmB)
                    translate VRand_In_Box(fcloud_min_xtnt,fcloud_max_xtnt,RdmA)
                }

  #declare j=j+1; 
  #end  
  #debug "\n"
  }

//=======================================================================================
// end of .inc file
//=======================================================================================

