#include "colors.inc"

background{color Gray}

camera{
  location <125,110,-200>
  look_at <0,50,0>
}

light_source{<10,75,-200> color White}
light_source{<110,120,-75> color Gray15}
light_source{<110,79,-75> color White fade_distance 20 fade_power 2}

#declare PipeTexture = texture{
  pigment{
    wrinkles color_map{
      [0.0 Green]
      [0.6 SeaGreen]
      [0.9 Red]
      [1.0 Black]
    }
    scale 3
  }
  normal{
    granite 5
    scale 3
  }
}

#declare HexnutTexture = texture{
  pigment{
    wrinkles color_map{
    [0.0 Gray95]
    [0.5 Gray85]
    [1.0 Red]    
   }
   scale 1
  }
  finish{metallic}
  normal{
    crackle 1
    scale 0.5
  }
}

/*  
// temporary rendering textures
#declare PipeTexture=texture{
  pigment{color Green}
}

#declare HexnutTexture=texture{
  pigment{color Silver}
}  
// end of temporary textures 
*/
  
//need r>4 by design
#macro Pipe(L,r)
  difference{
    merge{
      cylinder{<0,0,0>,<0,L,0>,r-3}
      cylinder{<0,0,0>,<0,1.5,0>,r}
      cylinder{<0,L-1.5,0>,<0,L,0>,r}
    }
    cylinder{<0,-0.1,0>,<0,L+0.1,0>,r-4}
    texture{PipeTexture}
  }
  #declare i=0;
  #while(i<=7)
    prism{
      linear_sweep
      linear_spline
      0,1,
      7,
      <1,0>,<0.5,0.866>,<-0.5,0.866>,<-1,0>,<-0.5,-0.866>,<0.5,-0.866>,<1,0>
      translate<r-1.5,1.5,0>
      rotate<0,i*45,0> 
      texture{HexnutTexture}
    }
    prism{
      linear_sweep
      linear_spline
      0,1,
      7,
      <1,0>,<0.5,0.866>,<-0.5,0.866>,<-1,0>,<-0.5,-0.866>,<0.5,-0.866>,<1,0>
      translate<r-1.5,L-2.5,0>
      rotate<0,i*45,0> 
      texture{HexnutTexture}
    }    
    #declare i=i+1;
  #end
#end  

//designed for r near 10
#macro XYelbow(X,Y,r)
  difference{
    merge{
      blob{
        threshold 0.5
        cylinder{<0,0,0>,<0,Y,0>,1.2*r,1}
        cylinder{<0,Y,0>,<X,Y,0>,1.2*r,1}
        sphere{<0,Y,0>,-1.2*r,-1}
      }
      cylinder{<0,-0.1,0>,<0,1.5,0>,r}
      cylinder{<X-1.5,Y,0>,<X+0.1,Y,0>,r}
    }
    cylinder{<0,0,0>,<0,-r,0>,r}
    cylinder{<0,-0.1,0>,<0,Y,0>,r-4}
    cylinder{<X,Y,0>,<X+r,Y,0>,r}
    cylinder{<X+0.1,Y,0>,<r,Y,0>,r-4}
    texture{PipeTexture}
  }
  #declare i=0;
  #while(i<=7)
    prism{
      linear_sweep
      linear_spline
      0,1,
      7,
      <1,0>,<0.5,0.866>,<-0.5,0.866>,<-1,0>,<-0.5,-0.866>,<0.5,-0.866>,<1,0>
      translate<r-1.5,1.5,0>
      rotate<0,i*45,0> 
      texture{HexnutTexture}
    }
    
    prism{
      linear_sweep
      linear_spline
      0,1,
      7,
      <1,0>,<0.5,0.866>,<-0.5,0.866>,<-1,0>,<-0.5,-0.866>,<0.5,-0.866>,<1,0>
      translate<r-1.5,1.5,0>
      rotate<0,i*45,90>
      translate<X,Y,0>       
      texture{HexnutTexture}
    }
        
    #declare i=i+1;
  #end              
#end

//crumble effect where pipes go through a wall
#declare CrumbleTexture=texture{
  pigment{
    crackle color_map{
      [0.0 Clear]
      [0.2 Gray95]
      [1.0 Gray50]
    }
    scale 1.1
  }
  normal{
    crackle 5
    turbulence 1
    scale 1.5
  }
  finish{
    ambient 0.5
    diffuse 0.2 
  }
}

//Key pipe section
merge{Pipe(50,8)       rotate<0,0,-90>   translate<25,45,-75>}
merge{XYelbow(20,20,8)                   translate<5,25,-75>}
merge{XYelbow(20,20,8) rotate<180,90,0>  translate<5,25,-75>}
merge{XYelbow(20,20,8) rotate<180,-90,0> translate<5,25,-115>}
merge{Pipe(40,8)                         translate<5,25,-115>}
merge{XYelbow(20,20,8) rotate<0,180,0>   translate<5,65,-115>}
merge{XYelbow(20,20,8) rotate<-90,0,0>   translate<-35,85,-95>}
merge{Pipe(125,8)      rotate<90,0,0>    translate<-35,85,-95>}
merge{XYelbow(20,20,8) rotate<90,0,90>   translate<-35,85,30>}
merge{Pipe(100,8)                        translate<-35,105,50>}
cylinder{<-35,150.5,50> <-35,149.5,50> 7 texture{CrumbleTexture}}

//extra pipe #1 (big)
cylinder{<30,150.5,30> <30,149.5,30> 10 texture{CrumbleTexture}}
merge{Pipe(90,11)                         translate<30,90,30>}
merge{Pipe(50,11)                         translate<30,40,30>}
merge{XYelbow(25,25,11) rotate<180,90,0>  translate<30,40,30>}
merge{Pipe(70,11)       rotate<90,0,0>    translate<30,15,-65>}
merge{XYelbow(25,25,11) rotate<180,-90,0> translate<30,40,-90>}
merge{XYelbow(25,25,11) rotate<0,180,0>   translate<30,40,-90>}
merge{Pipe(120,11)      rotate<0,0,90>    translate<5,65,-90>}
cylinder{<-101,65,-90> <-99,65,-90> 10 texture{CrumbleTexture}}

//extra pipe #2 (small)
cylinder{<90,90,100.5> <90,90,99.5> 5 texture{CrumbleTexture}}
merge{Pipe(50,6)       rotate<90,0,0>    translate<90,90,70>}
merge{Pipe(50,6)       rotate<90,0,0>    translate<90,90,20>}
merge{XYelbow(15,15,6) rotate<-90,0,180> translate<90,90,20>}
merge{Pipe(50,6)       rotate<0,0,90>    translate<75,90,5>}
merge{XYelbow(15,15,6)                   translate<10,75,5>}
merge{Pipe(30,6)                         translate<10,45,5>}                                       
merge{XYelbow(15,15,6) rotate<180,180,0> translate<10,45,5>}
merge{Pipe(100,6)      rotate<0,0,90>    translate<-5,30,5>}
cylinder{<-100.5,30,5> <-99.5,30,5> 5 texture{CrumbleTexture}}

//extra pipe #3 (huge)
merge{Pipe (150,19) rotate<0,0,-90> translate<0,-40,70>}
merge{Pipe(150,19)  rotate<0,0,90>  translate<0,-40,70>}
cylinder{<-100.5,-40,70> <-99.5,-40,70> 18 texture{CrumbleTexture}}

//path of sludge
cylinder{
  <75,41,-75>,<75,-100,-75>,1
  pigment{rgb<0.4,0.25,0.2>}
  normal{
    bumps 5
    scale 1
  }
}

//water on the floor
polygon{5,<200,-75,100>,<-100,-75,100>,<-100,-75,-150>,<200,-75,-150>,<200,-75,100>
  texture{
    pigment{rgb <0.4,0.25,0.2>}
    finish{
      reflection 0.4
      ambient 0.15
      diffuse 0.6
      phong 1 phong_size 80
    }
    normal{
      ripples 1
      frequency 0.12
      translate <75,0,-75>
    }
  }   
}

//walls
#declare WallTexture=texture{
  brick
    texture{
      pigment{Grey}
      normal{
        crackle 5
        scale 1
        turbulence 0.5
      }      
    },
    texture{
      pigment{Red}
      normal{
        crackle 5
        scale 2
        turbulence 0.5
      }
    }
  scale 5
} 

polygon{5,<-100,150,100>,<-100,150,-150>,<-100,-100,-150>,<-100,-100,100>,<-100,150,100>
  texture{WallTexture}
}

polygon{5,<200,150,100>,<200,-100,100>,<-100,-100,100>,<-100,150,100>,<200,150,100>
  texture{WallTexture rotate<0,90,0>}
}

//ceiling
polygon{5,<200,150,100>,<-100,150,100>,<-100,150,-150>,<200,150,-150>,<200,150,100>
  pigment{Gray}
  normal{
    crackle 10
    scale 2
    turbulence 0.5
  }
}

//dream bubbles
#declare BubbleTexture=texture{
  pigment{rgbf<0.99,0.99,0.99,0.93>}
  finish{
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    specular 0.15
    roughness 0.005
  }
}

sphere{<80,50,-75>,2
  texture{BubbleTexture}
  interior{ior 1.5}
}

sphere{<87,53,-75>,4
  texture{BubbleTexture}
  interior{ior 1.5}
}

difference{
 sphere{<110,80,-75>,30}
 sphere{<110,80,-75>,29}
 texture{BubbleTexture}
 interior{ior 1.5}
}

//fountain
#declare FountainTexture=texture{
  pigment{
    marble
    color_map{
      [0.0 White]
      [0.1 Gold]
      [0.2 White]
      [0.75 Gray95]
      [1.0 Black]
    }
    turbulence 1
    scale 5
  }
  finish{
    ambient 0.2
    diffuse 0.8
  }
}

merge{
  difference{
   cone{<110,75,-75>,23,<110,80,-75>,18}
   sphere{<110,80,-75>,15}
  }
  cylinder{<110,75,-75>,<110,73,-75>,23}
  cylinder{<110,73,-75>,<110,71,-75>,25}
  cylinder{<110,71,-75>,<110,69,-75>,27}
  texture{FountainTexture}
}

//fountain pool
polygon{7,<130,78,-75>,<120,78,-58>,<100,78,-58>,<90,78,-75>,<100,78,-92>,<120,78,-92>,<130,78,-75>
  texture{
    pigment{SkyBlue}
    finish{
      reflection 0.4
      ambient 0.15
      diffuse 0.6
      phong 1 phong_size 80
    }    
    normal{
      ripples 15
      frequency 15
      translate <115,78,-85>
    }
  }
}

//fountain water
#declare Stream = 
difference{
  quadric{<1,0,1>,<0,0,0>,<0,5,0>,0}
  quadric{<1,0,0.2>,<0,0,0>,<0,5,0>,3}
  plane{<0,1,0>,-20}
  scale <1,2.5,0.2>
 
}

merge{
  #declare i=0;
  #while(i<=30)
    object{Stream translate<15,0,0> rotate<0,12*i,0>}
    #declare i=i+1;  
  #end
  scale 0.5
  translate <110,100,-75>
  pigment{rgbf <0.9,0.9,1,0.1>}
  normal{
   ripples 1
   frequency 0.5
   translate <110,100,-75>
  }
  interior{ior 1.3} 
}  
