// Flowers.inc - called by grass.inc to create flowers

#declare Stems = MinStems + ((MaxStems-MinStems)*rand(R1));
#declare StemI = 0;
#while (StemI < Stems)
          #declare StemAngle = MinStemAngle + ((MaxStemAngle-MinStemAngle)*rand(R1));
          #declare StemHeight = MeanStemHeight*(1+((rand(R1)-0.5)*StemHeightVar*2));
          #declare StemWidth = MeanStemWidth*(1+((rand(R1)-0.5)*StemWidthVar*2));
          #declare StemBearing = rand(R1)*360;
          #declare StemCurve = MinStemCurve + ((MaxStemCurve-MinStemCurve)*rand(R1));
          #declare StemSegs = MinStemSegs + ((MaxStemSegs-MinStemSegs)*rand(R1));
          #declare StemWidthStep = (StemWidth*(1-StemTaper))/StemSegs;
          #declare CurvePerSeg = StemCurve/StemSegs;
          #declare SegCurve = CurvePerSeg;
          #declare PBot = <XOff, YOff, ZT0>;
          #declare SegLen = StemHeight * (pow((1/StemCurvePower),StemSegs-1)/(pow((1/StemCurvePower),StemSegs)-1)) *((1/StemCurvePower)-1);
          #declare PTop = PBot + vrotate(<0,0,SegLen>,<StemAngle,0,StemBearing>);
          #declare NBot0 = vnormalize(vrotate(<0,1,0>, <StemAngle/2,0,StemBearing>));
          #declare NBot1 = vnormalize(vrotate(<0.866,-0.5,0>, <StemAngle/2,0,StemBearing>));
          #declare NBot2 = vnormalize(vrotate(<-0.866,-0.5,0>, <StemAngle/2,0,StemBearing>));
          #declare NTop0 = vnormalize(vrotate(<0,1,0>, <StemAngle/2,0,StemBearing>));
          #declare NTop1 = vnormalize(vrotate(<0.866,-0.5,0>, <(StemAngle+SegCurve)/2,0,StemBearing>));
          #declare NTop2 = vnormalize(vrotate(<-0.866,-0.5,0>, <(StemAngle+SegCurve)/2,0,StemBearing>));
          #declare StemSeg = 0;
          #while (StemSeg<StemSegs)
                 smooth_triangle{
                   PBot+(NBot0*(StemWidth/2)), NBot0,
                   PBot+(NBot1*(StemWidth/2)), NBot1,
                   PTop+(NTop0*((StemWidth-StemWidthStep)/2)), NTop0
                   texture{ Grass_Text}
                 }
                 smooth_triangle{
                   PTop+(NTop1*((StemWidth-StemWidthStep)/2)), NTop1,
                   PTop+(NTop0*((StemWidth-StemWidthStep)/2)), NTop0,
                   PBot+(NBot1*(StemWidth/2)), NBot1
                   texture{ Grass_Text}
                 }
                smooth_triangle{
                   PBot+(NBot1*(StemWidth/2)), NBot1,
                   PBot+(NBot2*(StemWidth/2)), NBot2,
                   PTop+(NTop1*((StemWidth-StemWidthStep)/2)), NTop1
                   texture{ Grass_Text}
                 }
                 smooth_triangle{
                   PTop+(NTop2*((StemWidth-StemWidthStep)/2)), NTop2,
                   PTop+(NTop1*((StemWidth-StemWidthStep)/2)), NTop1,
                   PBot+(NBot2*(StemWidth/2)), NBot2
                   texture{ Grass_Text}
                 }
                smooth_triangle{
                   PBot+(NBot2*(StemWidth/2)), NBot2,
                   PBot+(NBot0*(StemWidth/2)), NBot0,
                   PTop+(NTop2*((StemWidth-StemWidthStep)/2)), NTop2
                   texture{ Grass_Text}
                 }
                 smooth_triangle{
                   PTop+(NTop0*((StemWidth-StemWidthStep)/2)), NTop0,
                   PTop+(NTop2*((StemWidth-StemWidthStep)/2)), NTop2,
                   PBot+(NBot0*(StemWidth/2)), NBot0
                   texture{ Grass_Text}
                 }
                 #declare SegLen = SegLen * StemCurvePower;
                 #declare PBot = PTop;
                 #declare PTop = PBot + vrotate(vrotate(<0,0,SegLen>, <SegCurve,0,0>), <StemAngle,0,StemBearing>);
                 #declare NBot0 = NTop0;
                 #declare NBot1 = NTop1;
                 #declare NBot2 = NTop2;
                 #declare NTop0= vrotate(
                                  vrotate(
                                    vrotate(NTop0
                                           ,<0,0,StemBearing*-1>
                                          )
                                        ,<CurvePerSeg,0,0>
                                        )
                                      ,<0,0,StemBearing>
                                       );
                 #declare NTop1= vrotate(
                                  vrotate(
                                    vrotate(NTop1
                                           ,<0,0,StemBearing*-1>
                                           )
                                         ,<CurvePerSeg,0,0>
                                         )
                                       ,<0,0,StemBearing>
                                       );
                 #declare NTop2= vrotate(
                                  vrotate(
                                    vrotate(NTop2
                                           ,<0,0,StemBearing*-1>
                                           )
                                         ,<CurvePerSeg,0,0>
                                         )
                                       ,<0,0,StemBearing>
                                       );
                 #declare SegCurve = SegCurve + CurvePerSeg;
                 #declare StemWidth = StemWidth - StemWidthStep;
                 #declare StemSeg = StemSeg + 1;
                 #declare NumTri = NumTri + 6;
          #end
          #declare PetSize = 1.0 + ((rand(R1)*2*FlowerSizeVar)-FlowerSizeVar);
          #declare FlowerAxis = vnormalize(vcross(NBot0,NBot1));
          #declare PBot = PBot + (FlowerAxis*SepalHght*-0.75);
          #declare PetCentP0 = PBot + (FlowerAxis*PetCentHght*-1);
          #declare SepP0 = PBot + (FlowerAxis*SepalHght);
          #declare PetRow = 0;
          #while (PetRow < PetRows)
             #declare PetBase = PBot - (FlowerAxis*(PetRow*PetRowOff));
             #declare PetSize = PetSize * PetRowScale;
             #declare PetI = 0;
             #while (PetI<PetNum)
                 #declare PetSideVect = vnormalize(vaxis_rotate(vnormalize(vcross(NBot0,FlowerAxis)),FlowerAxis,((PetI/PetNum)*360)+(PetRowRot*PetRow)));
                 #declare PetVBase = vnormalize(vaxis_rotate(FlowerAxis,PetSideVect,90-(PetAng+(PetRowAngOff*PetRow))));
                 #declare PetAxis = vnormalize(vcross(PetSideVect,PetVBase));
                 #declare PetSideVect = vnormalize(vaxis_rotate(PetSideVect, PetAxis, PetTwist));
                 #declare PetVBase = vnormalize(vaxis_rotate(PetVBase, PetAxis, PetTwist));
                 #declare PetP0 = PetBase + (PetSideVect*PetWidB*PetSize*0.5);
                 #declare PetP1 = PetBase + (PetSideVect*PetWidB*PetSize*-0.5);
                 #declare PetP2 = ((PetP0+PetP1)/2)
                                + (PetAxis*PetBendLen*PetSize)
                                + (vnormalize(vaxis_rotate(PetSideVect,PetAxis,PetArch))*PetWidL*PetSize);
                 #declare PetP3 = ((PetP0+PetP1)/2)
                                + (PetAxis*PetBendLen*PetSize);
                 #declare PetP4 = ((PetP0+PetP1)/2)
                                + (PetAxis*PetBendLen*PetSize)
                                + (vnormalize(vaxis_rotate(PetSideVect,PetAxis,PetArch*-1))*PetWidR*PetSize*-1);
                 #declare PetP5 = PetP3
                                + (vnormalize(vaxis_rotate(PetAxis,PetSideVect,PetKink*-1))*(PetLen-PetBendLen)*PetSize)
                                + (PetSideVect*PetWidT*PetSize*0.5);
                 #declare PetP6 = PetP3
                                + (vnormalize(vaxis_rotate(PetAxis,PetSideVect,PetKink*-1))*(PetLen-PetBendLen)*PetSize)
                                + (PetSideVect*PetWidT*PetSize*-0.5);
                 #declare PetP7 = ((PetP5+PetP6)/2)
                                + (vnormalize(vaxis_rotate(PetAxis,PetSideVect,(PetKink+PetTipKink)*-1))*(PetTipLen)*PetSize);
                 #declare PetN0 = vaxis_rotate(PetVBase,PetAxis,PetArch);
                 #declare PetN1 = vaxis_rotate(PetVBase,PetAxis,PetArch*-1);
                 #declare PetN2 = vaxis_rotate(PetN0,PetSideVect,PetKink/-2);
                 #declare PetN3 = vaxis_rotate(PetVBase,PetSideVect,PetKink/-2);
                 #declare PetN4 = vaxis_rotate(PetN3,PetSideVect,PetKink/-2);
                 #declare PetN5 = vaxis_rotate(PetN2,PetSideVect,PetKink/-2);
                 #declare PetN6 = vaxis_rotate(PetN4,PetSideVect,PetKink/-2);
                 #declare PetN7 = vaxis_rotate(PetN3,PetSideVect,PetTipKink/-2);
                 smooth_triangle {
                                 PetP0, PetN0,
                                 PetP3, PetN3,
                                 PetP1, PetN1
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP0, PetN0,
                                 PetP2, PetN2,
                                 PetP3, PetN3
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP1, PetN1,
                                 PetP3, PetN3,
                                 PetP4, PetN4
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP2, PetN2,
                                 PetP3, PetN3,
                                 PetP5, PetN5
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP3, PetN3,
                                 PetP5, PetN5,
                                 PetP6, PetN6
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP3, PetN3,
                                 PetP6, PetN6,
                                 PetP4, PetN4
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 smooth_triangle {
                                 PetP5, PetN5,
                                 PetP6, PetN6,
                                 PetP7, PetN7
                                 texture{ #if(PetRow=0) PetalText0 #else PetalText1 #end }
                                 }
                 #if (PetRow = 0)
                     #declare PetCentP1 = PBot + vaxis_rotate((PetSideVect*PetCentRad),FlowerAxis,90-(180/PetNum));
                     #declare PetCentP2 = PBot + vaxis_rotate((PetSideVect*PetCentRad),FlowerAxis,90+(180/PetNum));
                     #declare SepP1 = PBot + vaxis_rotate((PetSideVect*SepalRad),FlowerAxis,90-(180/PetNum));
                     #declare SepP2 = PBot + vaxis_rotate((PetSideVect*SepalRad),FlowerAxis,90+(180/PetNum));
                     triangle {
                          PetCentP0, PetCentP1, PetCentP2
                          texture{ PetCentreText }
                          }
                     triangle {
                          SepP0, SepP1, SepP2
                          texture{ SepalText }
                          }
                     #declare NumTri = NumTri + 2;
                 #end

                 #declare PetI = PetI + 1;
                 #declare NumTri = NumTri + 7;
             #end
             #declare PetRow = PetRow + 1;
          #end
          #declare StemI = StemI + 1;
#end
