default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }


/************************/
/*  CAMERA AND LIGHTS   */
/************************/

camera {  //  Camera StdCam
  sky       <0.0, 0.0, 1.0> // Use right handed-system 
  up        <0.0, 0.0, 1.0> // Where Z is up
  right     <1.41837, 0.0, 0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         69.48445    // Vertical      52.113

  location  <24.329, -4.308, 6.5> //submitted setting
  look_at   <-1.127, -0.997, 10>  //submitted setting

//   location <-12,-5,40> // aerial view
//   look_at <-12,-5,4> // aerial view

// Additional parameters for different views:

// location <8,2.85,20> // aerial view of owl
// look_at  <8,2.85,4>  // aerial view of owl

//location <8.5,2.85,10> // look from below owl
//look_at <8.5,2.85,14>  // look from below owl

//  location <15,1,14.25>  // look directly at owl
//  look_at <8.1,2.85,14.25> // look directly at owl

}

light_source {
  <0,0,0>
  color <0.15, 0.15, 0.15>
  translate <200, 0, 300>
}


/************************/
/*    INCLUDE FILES     */
/************************/

#include "colors.inc"
//#include "txttree.inc"
#include "pond.inc" // texture include file
#include "objects\flowers_trees\bush_like_plant.inc"
#include "objects\flowers_trees\coreopsis.inc"

/************************/
/*     THE BRIDGE       */
/************************/

// /*
#include "objects\bridge.inc"

#declare Part1 = object { Default_Object1
  material { T_Wood33 }
}

#declare Part2 = object { Default_Object2
  material { T_Wood33 }
}

#declare Part3 = object { Default_Object3
  material { DMFDarkOak }
}

#declare Part4 = object { Default_Object4
  material { Rosewood }
}

#declare Part5 = object { Default_Object7
  material { Rosewood }
}

#declare Part6 = object { Default_Object8
  material { Rosewood }
}

#declare Bridge = union {
  object { Part1 }
  object { Part2 }
  object { Part3 }
  object { Part4 }
  object { Part5 }
  object { Part6 }
  scale 0.165
  rotate -35.0*z
  translate  <-11.40, 0.9, 6.125>
}// */

   
/************************/
/*     HEIGHTFIELDS     */
/************************/

object { // Mountains
  height_field { tga "mountain_hf" water_level 0 }
  scale     <  750, 800,750>
  translate < -1,-1,-1> // Center around origin
  material { Mnt_Texture }
  rotate 90.0*x
  rotate 90*z
  translate  <-1100, -250, -8>
}

#declare Water = object { // Water htfield
  height_field { tga "lake_htfield.tga" water_level 0.0 }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1> // Center around origin
  material { Lake_Water }
  no_shadow
  scale <20.0, 15.0, 2.0>
  rotate 55.0*z
  translate  <-6.0, -2.0, 1.5>
}

#declare Pond = object { // shape of pond htfield
  height_field { tga "grass_field.tga" water_level 0.0 }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-.98,-1> // Center around origin
  material { Soil }
  scale <30.0, 26.299999, 4.0>
  rotate 55.0*z
  translate  <-6.0, -1.9, 0.05>
}

union {
  object { Bridge }
  object { Water }
  object { Pond }
  translate  <-0.2, -2.6, 0>
}

plane { // Continuous ground
  z,4.7
  material { Soil }
  translate  -4.5*z
}


/************************/
/*        TREES         */
/************************/

//1st tree -- red bark tree
// /*
#declare txtTree1=texture{txtTree_5}
#declare txtLeaf1=texture{txtLeaf_5}
#declare Leaf=object{#include "objects\flowers_trees\gtleaf7.inc"} // declares the Leaf object
#declare Tree1=object{#include "objects\flowers_trees\gttree7.inc"
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "objects\flowers_trees\gtfoliage7.inc"
  texture{txtLeaf1} 
}
                                                     
union{
  object{Tree1}
  object{Foliage1}
  translate <-125,6,45>
  rotate <90,0,0>
  scale .2
}

//2nd tree -- in the middle of the image

#declare txtTree=texture{txtTree_0}
#declare txtLeaf=texture{txtLeaf_5}
#declare Leaf=object{#include "objects\flowers_trees\gtleaf3.inc"} // declares the Leaf object
#declare Tree3=object{#include "objects\flowers_trees\gttree3.inc"
}                        
// remove the following for leafless tree or for test
#declare Foliage3=object{#include "objects\flowers_trees\gtfoliage3.inc"
  texture{txtLeaf} 
}
                                                     
union{
  object{Tree3}
  object{Foliage3}
  scale .2
  rotate <90,0,0>
  translate <-15.5,4,5>
}// */

//tree 3 -- tree on right view
// /*
#declare txtTree=texture{txtTree_3} // red bark tree?
#declare txtLeaf=texture{txtLeaf_5}
#declare Leaf=object{#include "objects\flowers_trees\gtleaf2.inc"} // declares the Leaf object
#declare Tree2=object{#include "objects\flowers_trees\gttree2.inc"
}                        
// remove the following for leafless tree or for test

#declare Foliage2=object{#include "objects\flowers_trees\gtfoliage2.inc"
  texture{txtLeaf} 
}
                                                     
union{
  object{Tree2}
  object{Foliage2}
  scale .35
  rotate <90,0,25> // positive z is ccw (toward you on the right)
  translate <9,9.3,2.2>

}// */
 
                                         
//tree 4 -- tree on left view
// /*
#declare txtTree=texture{txtTree_3}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "objects\flowers_trees\gtleaf2.inc"} // declares the Leaf object
#declare Tree4=object{#include "objects\flowers_trees\gttree2.inc"
}                        
// remove the following for leafless tree or for test
#declare Foliage4=object{#include "objects\flowers_trees\gtfoliage2.inc"
  texture{txtLeaf} 
}
                                                     
union{
  object{Tree4}
  object{Foliage4}
  scale .17
  rotate <90,0,-10>
  translate <15,-10,2>
}// */ 

/************************/
/*      SKY & SUN       */
/************************/

#declare cam_loc = <24.329,-4.308,6.5>;
#declare lookat = <-1.127,-0.997,10>;
#declare light_loc = <-1000,635, 150>;
#declare sky_vect = <0,1,0>;
#declare flare_type = "sunset1"
#declare flare_size = .8;
#declare flare_brightness = .7

light_source { light_loc color rgb<1,1,1> }
#include "nkflare.inc"

sky_sphere { // to make setting sun effect      
  pigment { gradient x
    color_map {
      [0.001 0.01  color rgb <1, 0.4, 0.3>
                   color rgb <0.85, 0.3, 0.2>]
//      [0.05  0.8   color rgb <0.8, 0.15, 0.2>
//                   color rgb <0, 0, 0>]
      [0.05  0.4   color rgb <0.65, 0.15, 0.2>
                   color rgb <.25, .25, .5>]

      }
    scale 1
    translate -1
    rotate 6.5*y
    rotate -31.25*z
  }
  pigment { // to make clouds
    bozo turbulence 0.50/*.35*/ octaves 6 omega 0.7 lambda 2
    color_map {
      [0.0 0.1 color rgb <0.85, 0.85, 1>
               color rgb <0.75, 0.75, 0.95>]
      [0.1 0.5 color rgb <0.75, 0.75, 0.9>
               color rgbt <.85, .85, 1, .85 /*1*/>]
      [0.5 1.0 color rgbt <.85, .85, 1, .85 /*1*/>
               color rgbt <.85, .85, 1, .85 /*1*/>]
      }
    scale <0.2, 0.5, 0.2>
    rotate -10*z
  }
}


/************************/
/*        MOON          */
/************************/

disc { // Disc002
  <0,0,0>, <0,0,1>, 1.0
  material { moon }
  no_shadow
  scale 35
  rotate 90*y
  rotate 90*x
  translate <-900,-400,300>
}

disc { // Disc001
  <0,0,0>, <0,0,1>, 1.0
  material { Halo }
  no_shadow
  scale 55
  rotate 90*y
  translate <-899,-400,300>
}


/************************/
/*        VENUS         */
/************************/

#declare light_loc = <-900,50, 450>;
#declare sky_vect = <0,1,0>;
//#declare flare_type = "bigstar"
#declare flare_type = "smlstar"
#declare flare_size = .2;
#declare flare_brightness = 1;

light_source { light_loc color rgb<1,1,1> shadowless}
#include "nkflare.inc"

  
/************************/
/*        PLANTS        */
/************************/

// /*
#declare bush_plant=object{ allPlants_bush_like_plant }
object {bush_plant
  scale .025
  rotate <90,0,180>
  translate <18,1,5>
}

#declare plant1=object{ coreopsis }
object {plant1
  scale .015
  rotate <90,0,0>
  translate <17.5,0,4>
}// */


/**************************/
/* PICNIC TABLE & LILLIES */
/**************************/

#include "table_lily.pov"


/************************/
/*        GRASS         */
/************************/

#include "flowers.pov"


/***********************/
/*         OWL         */
/***********************/

// /*
#include "objects\whiteowl.inc"

#declare Head = object { Default_Object1
  material { Material1 }
}
#declare Body = object { Default_Object2
  material { Material1 }
}
#declare Wings = object { Default_Object3
  material { Material1 }
}
#declare Claws_Right = object { Default_Object4
  material { Beak_Claws_Tex }
}
#declare Foot_Right = object { Default_Object5
  material { Feet_Tex }
}
#declare Leg_Right = object { Default_Object6
  material { Material1 }
}
#declare Leg_Left = object { Default_Object7
  material { Material1 }
}
#declare Eye_Left = object { Default_Object8
  material { Eye_Tex }
}
#declare Eye_Right = object { Default_Object9
  material { Eye_Tex }
}
#declare Beak = object { Default_Object10
  material { Beak_Claws_Tex }
}
#declare Claws_Left = object { Default_Object11
  material { Beak_Claws_Tex }
}
#declare Feet_Left = object { Default_Object12
  material { Feet_Tex }
}
union { // UserDefGroup1
  object { Head }
  object { Body }
  object { Wings }
  object { Claws_Right }
  object { Foot_Right }
  object { Leg_Right }
  object { Leg_Left }
  object { Eye_Left }
  object { Eye_Right }
  object { Beak }
  object { Claws_Left }
  object { Feet_Left }
  scale 4.5
  rotate <0,0,-107>
  translate <8.1,2.85,14.1>
}// */